using GLib;
using GSSDP;

public class TestBrowser : ResourceBrowser {

    private void on_resource_available (TestBrowser       browser,
                                        string            usn,
                                        GLib.List<string> locations) {
        GLib.print ("Resource available:\n  USN: %s\n", usn);
        for (weak List<string> l = locations; l != null; l = l.next) {
            GLib.print ("  Location: %s\n", l.data);
        }
    }

    private void on_resource_unavailable (TestBrowser browser,
                                          string      usn) {
        GLib.print ("Resource unavailable:\n  USN: %s\n", usn);
    }

    construct {
        this.resource_available += this.on_resource_available;
        this.resource_unavailable += this.on_resource_unavailable;
    }

    public TestBrowser() {
        this.client = new Client (null);
        this.target = GSSDP.ALL_RESOURCES;
    }

    public static int main (string[] args) {
        TestBrowser browser = new TestBrowser ();

        browser.active = true;

        GLib.MainLoop loop = new MainLoop (null, false);
        loop.run();

        return 0;
    }

}

