// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_ACTIONGROUP_H
#define _GIOMM_ACTIONGROUP_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GActionGroupInterface GActionGroupInterface;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GActionGroup GActionGroup;
typedef struct _GActionGroupClass GActionGroupClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class ActionGroup_Class; } // namespace Gio
namespace Gio
{

/** ActionGroup - a group of actions.
 * ActionGroup represents a group of actions.
 *
 * Each action in the group has a unique name (which is a string). All method
 * calls, except list_actions() take the name of an action as an argument.
 *
 * The GActionGroup API is meant to be the 'public' API to the action group.
 * The calls here are exactly the interaction that 'external forces' (eg: UI,
 * incoming D-Bus messages, etc.) are supposed to have with actions.
 * 'Internal' APIs (ie: ones meant only to be accessed by the action group
 * implementation) are found on subclasses. This is why you will find -- for
 * example -- get_action_enabled() but not an equivalent @c set() call.
 *
 * Signals are emitted on the action group in response to state changes on
 * individual actions.
 */

class ActionGroup : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef ActionGroup CppObjectType;
  typedef ActionGroup_Class CppClassType;
  typedef GActionGroup BaseObjectType;
  typedef GActionGroupInterface BaseClassType;

private:
  friend class ActionGroup_Class;
  static CppClassType actiongroup_class_;

  // noncopyable
  ActionGroup(const ActionGroup&);
  ActionGroup& operator=(const ActionGroup&);

protected:
  ActionGroup(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit ActionGroup(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit ActionGroup(GActionGroup* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~ActionGroup();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GActionGroup*       gobj()       { return reinterpret_cast<GActionGroup*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GActionGroup* gobj() const { return reinterpret_cast<GActionGroup*>(gobject_); }

private:


public:
  
  bool has_action(const Glib::ustring& action_name) const;

  //TODO: Use a vector instead, for this new API, before we free glibmm 2.28.
 

  Glib::StringArrayHandle list_actions() const;

  
  bool get_action_enabled(const Glib::ustring& action_name) const;

/* TODO:
  _WRAP_METHOD(const GVariantType* get_action_parameter_type(const Glib::ustring& action_name), g_action_group_get_action_parameter_type)
  GVariantType* get_action_state_type(const Glib::ustring& action_name), g_action_group_get_action_state_type)
  _WRAP_METHOD(GVariant* get_action_state_hint(const Glib::ustring& action_name), g_action_group_get_action_state_hint)
  _WRAP_METHOD(GVariant* get_action_state(GActionGroup* action_group, const gchar* action_name), g_action_group_get_action_state)
*/

  
  void change_action_state(const Glib::ustring& action_name, const Glib::VariantBase& value);
  
  void activate_action(const Glib::ustring& action_name, const Glib::VariantBase& parameter);
  
  void action_added(const Glib::ustring& action_name);
  
  void action_removed(const Glib::ustring& action_name);
  
  void action_enabled_changed(const Glib::ustring& action_name, bool enabled);
  
  void action_state_changed (const Glib::ustring& action_name, const Glib::VariantBase& state);

  
  /**
   * @par Prototype:
   * <tt>void on_my_%action_added(const Glib::ustring& action_name)</tt>
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_action_added();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%action_enabled_changed(const Glib::ustring& action_name, bool enabled)</tt>
   */

  Glib::SignalProxy2< void,const Glib::ustring&,bool > signal_action_enabled_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%action_removed(const Glib::ustring& action_name)</tt>
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_action_removed();


  /**
   * @par Prototype:
   * <tt>void on_my_%action_state_changed(const Glib::ustring& action_name, const Glib::VariantBase& value)</tt>
   */

  Glib::SignalProxy2< void,const Glib::ustring&,const Glib::VariantBase& > signal_action_state_changed();


//TODO: Wrap virtual functions.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  virtual void on_action_added(const Glib::ustring& action_name);
  virtual void on_action_enabled_changed(const Glib::ustring& action_name, bool enabled);
  virtual void on_action_removed(const Glib::ustring& action_name);
  virtual void on_action_state_changed(const Glib::ustring& action_name, const Glib::VariantBase& value);


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::ActionGroup
   */
  Glib::RefPtr<Gio::ActionGroup> wrap(GActionGroup* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_ACTIONGROUP_H */

