// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSINTROSPECTION_H
#define _GIOMM_DBUSINTROSPECTION_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gio/gio.h>


namespace Gio
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 * @par Bitwise operators:
 * <tt>%DBusPropertyInfoFlags operator|(DBusPropertyInfoFlags, DBusPropertyInfoFlags)</tt><br>
 * <tt>%DBusPropertyInfoFlags operator&(DBusPropertyInfoFlags, DBusPropertyInfoFlags)</tt><br>
 * <tt>%DBusPropertyInfoFlags operator^(DBusPropertyInfoFlags, DBusPropertyInfoFlags)</tt><br>
 * <tt>%DBusPropertyInfoFlags operator~(DBusPropertyInfoFlags)</tt><br>
 * <tt>%DBusPropertyInfoFlags& operator|=(DBusPropertyInfoFlags&, DBusPropertyInfoFlags)</tt><br>
 * <tt>%DBusPropertyInfoFlags& operator&=(DBusPropertyInfoFlags&, DBusPropertyInfoFlags)</tt><br>
 * <tt>%DBusPropertyInfoFlags& operator^=(DBusPropertyInfoFlags&, DBusPropertyInfoFlags)</tt><br>
 */
enum DBusPropertyInfoFlags
{
  DBUS_PROPERTY_INFO_FLAGS_NONE = 0x0,
  DBUS_PROPERTY_INFO_FLAGS_READABLE = (1<<0),
  DBUS_PROPERTY_INFO_FLAGS_WRITABLE = (1<<1)
};

/** @ingroup giommEnums */
inline DBusPropertyInfoFlags operator|(DBusPropertyInfoFlags lhs, DBusPropertyInfoFlags rhs)
  { return static_cast<DBusPropertyInfoFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusPropertyInfoFlags operator&(DBusPropertyInfoFlags lhs, DBusPropertyInfoFlags rhs)
  { return static_cast<DBusPropertyInfoFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusPropertyInfoFlags operator^(DBusPropertyInfoFlags lhs, DBusPropertyInfoFlags rhs)
  { return static_cast<DBusPropertyInfoFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup giommEnums */
inline DBusPropertyInfoFlags operator~(DBusPropertyInfoFlags flags)
  { return static_cast<DBusPropertyInfoFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup giommEnums */
inline DBusPropertyInfoFlags& operator|=(DBusPropertyInfoFlags& lhs, DBusPropertyInfoFlags rhs)
  { return (lhs = static_cast<DBusPropertyInfoFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusPropertyInfoFlags& operator&=(DBusPropertyInfoFlags& lhs, DBusPropertyInfoFlags rhs)
  { return (lhs = static_cast<DBusPropertyInfoFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup giommEnums */
inline DBusPropertyInfoFlags& operator^=(DBusPropertyInfoFlags& lhs, DBusPropertyInfoFlags rhs)
  { return (lhs = static_cast<DBusPropertyInfoFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }


/** DBusAnnotationInfo - Stores information about an annotation.
 *
 * @newin{2,28}
 */
class DBusAnnotationInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DBusAnnotationInfo CppObjectType;
  typedef GDBusAnnotationInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusAnnotationInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusAnnotationInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusAnnotationInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBusAnnotationInfo can neither be constructed nor deleted.
  DBusAnnotationInfo();
  void operator delete(void*, size_t);

private:
  // noncopyable
  DBusAnnotationInfo(const DBusAnnotationInfo&);
  DBusAnnotationInfo& operator=(const DBusAnnotationInfo&);


public:
 

  /** Looks up the value of an annotation.
   * 
   * This cost of this function is O(n) in number of annotations.
   * 
   * @newin{2,26}
   * @param annotations A <tt>0</tt>-terminated array of annotations or <tt>0</tt>.
   * @param name The name of the annotation to look up.
   * @return The value or <tt>0</tt> if not found. Do not free, it is owned by @a annotations.
   */
  static Glib::ustring info_lookup(const Glib::ArrayHandle< Glib::RefPtr<DBusAnnotationInfo> >& annotations, const Glib::ustring& name);


};

/** DBusArgInfo - Stores information about an argument for a method or a
 * signal.
 *
 * @newin{2,28}
 */
class DBusArgInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DBusArgInfo CppObjectType;
  typedef GDBusArgInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusArgInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusArgInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusArgInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBusArgInfo can neither be constructed nor deleted.
  DBusArgInfo();
  void operator delete(void*, size_t);

private:
  // noncopyable
  DBusArgInfo(const DBusArgInfo&);
  DBusArgInfo& operator=(const DBusArgInfo&);


public:


};

/** DBusMethodInfo - Stores information about a method on an D-Bus interface.
 *
 * @newin{2,28}
 */
class DBusMethodInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DBusMethodInfo CppObjectType;
  typedef GDBusMethodInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusMethodInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusMethodInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusMethodInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBusMethodInfo can neither be constructed nor deleted.
  DBusMethodInfo();
  void operator delete(void*, size_t);

private:
  // noncopyable
  DBusMethodInfo(const DBusMethodInfo&);
  DBusMethodInfo& operator=(const DBusMethodInfo&);


public:


};

/** Stores information about a signal on a D-Bus interface.
 *
 * @newin{2,28}
 */
class DBusSignalInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DBusSignalInfo CppObjectType;
  typedef GDBusSignalInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusSignalInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusSignalInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusSignalInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBusSignalInfo can neither be constructed nor deleted.
  DBusSignalInfo();
  void operator delete(void*, size_t);

private:
  // noncopyable
  DBusSignalInfo(const DBusSignalInfo&);
  DBusSignalInfo& operator=(const DBusSignalInfo&);


public:


};

/**
 *
 * @newin{2,28}
 */
class DBusPropertyInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DBusPropertyInfo CppObjectType;
  typedef GDBusPropertyInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusPropertyInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusPropertyInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusPropertyInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBusPropertyInfo can neither be constructed nor deleted.
  DBusPropertyInfo();
  void operator delete(void*, size_t);

private:
  // noncopyable
  DBusPropertyInfo(const DBusPropertyInfo&);
  DBusPropertyInfo& operator=(const DBusPropertyInfo&);


public:


};

/** DBusInterfaceInfo - Stores information about a D-Bus interface.
 *
 * @newin{2,28}
 */
class DBusInterfaceInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DBusInterfaceInfo CppObjectType;
  typedef GDBusInterfaceInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusInterfaceInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusInterfaceInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusInterfaceInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBusInterfaceInfo can neither be constructed nor deleted.
  DBusInterfaceInfo();
  void operator delete(void*, size_t);

private:
  // noncopyable
  DBusInterfaceInfo(const DBusInterfaceInfo&);
  DBusInterfaceInfo& operator=(const DBusInterfaceInfo&);


public:
  
  /** Looks up information about a method.
   * 
   * This cost of this function is O(n) in number of methods.
   * 
   * @newin{2,26}
   * @param name A D-Bus method name (typically in CamelCase).
   * @return A DBusMethodInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<DBusMethodInfo> lookup_method(const Glib::ustring& name);
  
  /** Looks up information about a method.
   * 
   * This cost of this function is O(n) in number of methods.
   * 
   * @newin{2,26}
   * @param name A D-Bus method name (typically in CamelCase).
   * @return A DBusMethodInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<const DBusMethodInfo> lookup_method(const Glib::ustring& name) const;

  
  /** Looks up information about a signal.
   * 
   * This cost of this function is O(n) in number of signals.
   * 
   * @newin{2,26}
   * @param name A D-Bus signal name (typically in CamelCase).
   * @return A DBusSignalInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<DBusSignalInfo> lookup_signal(const Glib::ustring& name);
  
  /** Looks up information about a signal.
   * 
   * This cost of this function is O(n) in number of signals.
   * 
   * @newin{2,26}
   * @param name A D-Bus signal name (typically in CamelCase).
   * @return A DBusSignalInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<const DBusSignalInfo> lookup_signal(const Glib::ustring& name) const;

  
  /** Looks up information about a property.
   * 
   * This cost of this function is O(n) in number of properties.
   * 
   * @newin{2,26}
   * @param name A D-Bus property name (typically in CamelCase).
   * @return A DBusPropertyInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<DBusPropertyInfo> lookup_property(const Glib::ustring& name);
  
  /** Looks up information about a property.
   * 
   * This cost of this function is O(n) in number of properties.
   * 
   * @newin{2,26}
   * @param name A D-Bus property name (typically in CamelCase).
   * @return A DBusPropertyInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<const DBusPropertyInfo> lookup_property(const Glib::ustring& name) const;

  //TODO: _WRAP_METHOD(void generate_xml(guint indent, GString* string_builder), g_dbus_interface_info_generate_xml)


};

/** DBusNodeInfo - Stores information about nodes in a remote object
 * hierarchy.
 *
 * @newin{2,28}
 */
class DBusNodeInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef DBusNodeInfo CppObjectType;
  typedef GDBusNodeInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GDBusNodeInfo*       gobj();

  ///Provides access to the underlying C instance.
  const GDBusNodeInfo* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusNodeInfo* gobj_copy() const;

protected:
  // Do not derive this.  Gio::DBusNodeInfo can neither be constructed nor deleted.
  DBusNodeInfo();
  void operator delete(void*, size_t);

private:
  // noncopyable
  DBusNodeInfo(const DBusNodeInfo&);
  DBusNodeInfo& operator=(const DBusNodeInfo&);


public:
  
  /** @throw Glib::Error.
   */
  static Glib::RefPtr<DBusNodeInfo> new_for_xml(const Glib::ustring& xml_data);

  
  /** Looks up information about an interface.
   * 
   * This cost of this function is O(n) in number of interfaces.
   * 
   * @newin{2,26}
   * @param name A D-Bus interface name.
   * @return A DBusInterfaceInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<DBusInterfaceInfo> lookup_interface(const Glib::ustring& name);
  
  /** Looks up information about an interface.
   * 
   * This cost of this function is O(n) in number of interfaces.
   * 
   * @newin{2,26}
   * @param name A D-Bus interface name.
   * @return A DBusInterfaceInfo or <tt>0</tt> if not found. Do not free, it is owned by @a info.
   */
  Glib::RefPtr<const DBusInterfaceInfo> lookup_interface(const Glib::ustring& name) const;

  //TODO: _WRAP_METHOD(void generate_xml(guint indent, GString* string_builder), g_dbus_node_info_generate_xml)


};

} // namespace Gio


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusAnnotationInfo
   */
  Glib::RefPtr<Gio::DBusAnnotationInfo> wrap(GDBusAnnotationInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusArgInfo
   */
  Glib::RefPtr<Gio::DBusArgInfo> wrap(GDBusArgInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusMethodInfo
   */
  Glib::RefPtr<Gio::DBusMethodInfo> wrap(GDBusMethodInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusSignalInfo
   */
  Glib::RefPtr<Gio::DBusSignalInfo> wrap(GDBusSignalInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusPropertyInfo
   */
  Glib::RefPtr<Gio::DBusPropertyInfo> wrap(GDBusPropertyInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusInterfaceInfo
   */
  Glib::RefPtr<Gio::DBusInterfaceInfo> wrap(GDBusInterfaceInfo* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusNodeInfo
   */
  Glib::RefPtr<Gio::DBusNodeInfo> wrap(GDBusNodeInfo* object, bool take_copy = false);

} // namespace Glib


#endif /* _GIOMM_DBUSINTROSPECTION_H */

