// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSERROR_H
#define _GIOMM_DBUSERROR_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gio
{

namespace DBus
{

namespace Error
{

/** @addtogroup giommEnums giomm Enums and Flags */

/**
 * @ingroup giommEnums
 */
enum DBusError
{
  DBUS_ERROR_FAILED,
  DBUS_ERROR_NO_MEMORY,
  DBUS_ERROR_SERVICE_UNKNOWN,
  DBUS_ERROR_NAME_HAS_NO_OWNER,
  DBUS_ERROR_NO_REPLY,
  DBUS_ERROR_IO_ERROR,
  DBUS_ERROR_BAD_ADDRESS,
  DBUS_ERROR_NOT_SUPPORTED,
  DBUS_ERROR_LIMITS_EXCEEDED,
  DBUS_ERROR_ACCESS_DENIED,
  DBUS_ERROR_AUTH_FAILED,
  DBUS_ERROR_NO_SERVER,
  DBUS_ERROR_TIMEOUT,
  DBUS_ERROR_NO_NETWORK,
  DBUS_ERROR_ADDRESS_IN_USE,
  DBUS_ERROR_DISCONNECTED,
  DBUS_ERROR_INVALID_ARGS,
  DBUS_ERROR_FILE_NOT_FOUND,
  DBUS_ERROR_FILE_EXISTS,
  DBUS_ERROR_UNKNOWN_METHOD,
  DBUS_ERROR_TIMED_OUT,
  DBUS_ERROR_MATCH_RULE_NOT_FOUND,
  DBUS_ERROR_MATCH_RULE_INVALID,
  DBUS_ERROR_SPAWN_EXEC_FAILED,
  DBUS_ERROR_SPAWN_FORK_FAILED,
  DBUS_ERROR_SPAWN_CHILD_EXITED,
  DBUS_ERROR_SPAWN_CHILD_SIGNALED,
  DBUS_ERROR_SPAWN_FAILED,
  DBUS_ERROR_SPAWN_SETUP_FAILED,
  DBUS_ERROR_SPAWN_CONFIG_INVALID,
  DBUS_ERROR_SPAWN_SERVICE_INVALID,
  DBUS_ERROR_SPAWN_SERVICE_NOT_FOUND,
  DBUS_ERROR_SPAWN_PERMISSIONS_INVALID,
  DBUS_ERROR_SPAWN_FILE_INVALID,
  DBUS_ERROR_SPAWN_NO_MEMORY,
  DBUS_ERROR_UNIX_PROCESS_ID_UNKNOWN,
  DBUS_ERROR_INVALID_SIGNATURE,
  DBUS_ERROR_INVALID_FILE_CONTENT,
  DBUS_ERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN,
  DBUS_ERROR_ADT_AUDIT_DATA_UNKNOWN,
  DBUS_ERROR_OBJECT_PATH_IN_USE
};


/** Checks if @a error represents an error received via D-Bus from a remote
 * peer.  If so, use get_remote_error() to get the name of the error.
 *
 * @param error A Glib::Error.  
 * @return <tt>true</tt> if error represents an error from a remote peer,
 * <tt>false</tt> otherwise. 
 * @newin{2,28}
 * @ingroup DBus
 */
bool is_remote_error(const Glib::Error& error);

/** Gets the D-Bus error name used for @a error, if any.
 *
 * This function is guaranteed to return a D-Bus error name for all
 * Glib::Error instances returned from functions handling remote method calls
 * (e.g. Gio::DBusConnection::call_finish()) unless strip_remote_error() has
 * been used on @a error.
 *
 * @param error A Glib::Error.
 * @return An allocated string or <tt>0</tt> if the D-Bus error name could not
 * be found.
 * @newin{2,28}
 * @ingroup DBus
 */
Glib::ustring get_remote_error(const Glib::Error& error);

/** Looks for extra information in the error message used to recover the D-Bus
 * error name and strips it if found. If stripped, the message field in @a
 * error will correspond exactly to what was received on the wire.
 *
 * This is typically used when presenting errors to the end user.
 *
 * @param error A Glib::Error.  
 * @return <tt>true</tt> if information was stripped, <tt>false</tt>
 * otherwise. 
 * @newin{2,28}
 * @ingroup DBus
 */
bool strip_remote_error(Glib::Error& error);

} // namespace Error

} // namespace DBus

} // namespace Gio


#endif /* _GIOMM_DBUSERROR_H */

