<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>glibmm Reference Manual</title>
    <filename>index</filename>
    <docanchor file="index">features</docanchor>
    <docanchor file="index">basics</docanchor>
    <docanchor file="index">description</docanchor>
  </compound>
  <compound kind="group">
    <name>CharsetConv</name>
    <title>Character Set Conversion</title>
    <filename>group__CharsetConv.html</filename>
    <class kind="class">Glib::ConvertError</class>
    <class kind="class">Glib::IConv</class>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabf5fac564c47a7a9ad6037044c3909f4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga88965337df48a173a6b013e8243e4631</anchor>
      <arglist>(std::string &amp;charset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga58f7e4556c436a96c64b186bbc8f7f4c</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga40b5aa172fabd1f3dbf50a962d0d351f</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaf1b091e4397a7637e884148484b1f71e</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset, const Glib::ustring &amp;fallback)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga4517b17f2aad4cd5c0e0640de212d928</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>locale_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gacc062729285890a7e9b22bece6fb987c</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga6cf95dc00505401594260a360d70c17b</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga2bd94064ad97b43324a7854b62f0835b</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gada23cd7f7dc8eb25e99b867a55551763</anchor>
      <arglist>(const Glib::ustring &amp;uri, Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gab1cb94f4a4a70bad06b715fb14a252d9</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gae1b2f056bde3fbab578c602fe42e3de9</anchor>
      <arglist>(const std::string &amp;filename, const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaaf69aec83665229cc06596cf627d9d5a</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_basename</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga05dd67157ad35da4401263247b6f4d81</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_name</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabc1b404cc965f3da6beecddfe2623afc</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>FileUtils</name>
    <title>File Utilities</title>
    <filename>group__FileUtils.html</filename>
    <class kind="class">Glib::FileError</class>
    <class kind="class">Glib::DirIterator</class>
    <class kind="class">Glib::Dir</class>
    <member kind="function">
      <type>bool</type>
      <name>file_test</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga0b2fce78896a9a84f7ea3a5646cc7d36</anchor>
      <arglist>(const std::string &amp;filename, FileTest test)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mkstemp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae4c8d716bd109b6b8e1420a8c20b3507</anchor>
      <arglist>(std::string &amp;filename_template)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae91f239f1cf0123399374deed54fbf3a</anchor>
      <arglist>(std::string &amp;name_used, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga682379de4ea119540b4bdc1759e93e1d</anchor>
      <arglist>(std::string &amp;name_used)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>file_get_contents</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga835da54212fe78e833ac55b49150b989</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Markup</name>
    <title>Simple XML Subset Parser</title>
    <filename>group__Markup.html</filename>
    <class kind="class">Glib::MarkupError</class>
    <class kind="class">Glib::Markup::AttributeKeyLess</class>
    <class kind="class">Glib::Markup::Parser</class>
    <class kind="class">Glib::Markup::ParseContext</class>
    <member kind="typedef">
      <type>Glib::MarkupError</type>
      <name>Error</name>
      <anchorfile>group__Markup.html</anchorfile>
      <anchor>ga7d0403c76601e7d3ba4641737e094e77</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>escape_text</name>
      <anchorfile>group__Markup.html</anchorfile>
      <anchor>gac95c5843d8dada8449f90f2fd635feb1</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ShellUtils</name>
    <title>Shell-related Utilities</title>
    <filename>group__ShellUtils.html</filename>
    <class kind="class">Glib::ShellError</class>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>shell_parse_argv</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>gabc52fcb14cfc7a5ba37ca821cc837818</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_quote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga55ebfb935f2131b2ae40d339568f568c</anchor>
      <arglist>(const std::string &amp;unquoted_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_unquote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga449dc37c6ea7e7563740df86e31c263c</anchor>
      <arglist>(const std::string &amp;quoted_string)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Spawn</name>
    <title>Spawning Processes</title>
    <filename>group__Spawn.html</filename>
    <class kind="class">Glib::SpawnError</class>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0a530eed9f6343ea1d51cb8ec8051ce7</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga36b7c1d110d10f86f3ef5d6e10db206f</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga5d42ba801678215f3820382388df32b0</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0c4e1708989b50fb34266504cc038ee6</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gad4fbf31fdb5536b104f4f75bf58c60e1</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gacc157258907be90b58184baeebc9c740</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga648167a4af607f87763f1334fe5a472f</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga713bdb79396eda85ad186cb2db89564f</anchor>
      <arglist>(const std::string &amp;command_line, std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_close_pid</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gaaea8f41c7a08af3b2919ce64fd0c27e5</anchor>
      <arglist>(Pid pid)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Threads</name>
    <title>Threads</title>
    <filename>group__Threads.html</filename>
    <class kind="class">Glib::ThreadError</class>
    <class kind="class">Glib::Thread</class>
    <class kind="class">Glib::Thread::Exit</class>
    <class kind="struct">Glib::StaticMutex</class>
    <class kind="class">Glib::Mutex</class>
    <class kind="class">Glib::Mutex::Lock</class>
    <class kind="struct">Glib::StaticRecMutex</class>
    <class kind="class">Glib::RecMutex</class>
    <class kind="class">Glib::RecMutex::Lock</class>
    <class kind="struct">Glib::StaticRWLock</class>
    <class kind="class">Glib::RWLock</class>
    <class kind="class">Glib::RWLock::ReaderLock</class>
    <class kind="class">Glib::RWLock::WriterLock</class>
    <class kind="class">Glib::Cond</class>
    <class kind="struct">Glib::StaticPrivate</class>
    <class kind="class">Glib::Private</class>
    <class kind="class">Glib::Dispatcher</class>
    <member kind="enumeration">
      <name>NotLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga2dd111336e3b057b51ca5871795fffa4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga2dd111336e3b057b51ca5871795fffa4a9681fb4e85e62ba64e39a12526eaa840</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TryLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga7441a36336ea4cdb35c0fddbf3f97b19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRY_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga7441a36336ea4cdb35c0fddbf3f97b19adf6b2565785992ff637cbc453988841d</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>thread_init</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gab26d01c776801f1fff00753e97af4fc7</anchor>
      <arglist>(GThreadFunctions *vtable=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>thread_supported</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gad59d126f6197035e6f6a31e7f4d87818</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Thread *</type>
      <name>wrap</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga6bfbb3119eaac9fa8cb725aa1e82f61e</anchor>
      <arglist>(GThread *gobject)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Unicode</name>
    <title>Unicode Manipulation</title>
    <filename>group__Unicode.html</filename>
    <namespace>Glib::Unicode</namespace>
    <namespace>Glib::Ascii</namespace>
  </compound>
  <compound kind="group">
    <name>UriUtils</name>
    <title>URI Utilities</title>
    <filename>group__UriUtils.html</filename>
    <member kind="function">
      <type>std::string</type>
      <name>uri_unescape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0c070cac984dc463fd60ccbdb4237e25</anchor>
      <arglist>(const std::string &amp;escaped_string, const std::string &amp;illegal_characters=std::string())</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_parse_scheme</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0cc4270d6796b2166964f08a5cb746b3</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_escape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>gad902095ab5049111caa9207770b0a437</anchor>
      <arglist>(const std::string &amp;unescaped, const std::string &amp;reserved_chars_allowed=std::string(), bool allow_utf8=true)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>glibmmVariant</name>
    <title>Variant Datatype</title>
    <filename>group__glibmmVariant.html</filename>
    <class kind="class">Glib::VariantBase</class>
    <class kind="class">Glib::Variant</class>
    <class kind="class">Glib::Variant&lt; VariantBase &gt;</class>
    <class kind="class">Glib::Variant&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::VariantType</class>
    <class kind="class">Glib::Variant&lt; bool &gt;</class>
    <class kind="class">Glib::Variant&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Variant&lt; gint16 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint16 &gt;</class>
    <class kind="class">Glib::Variant&lt; gint32 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint32 &gt;</class>
    <class kind="class">Glib::Variant&lt; gint64 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint64 &gt;</class>
    <class kind="class">Glib::Variant&lt; double &gt;</class>
  </compound>
  <compound kind="group">
    <name>ContHandles</name>
    <title>Generic container converters</title>
    <filename>group__ContHandles.html</filename>
    <class kind="class">Glib::ArrayHandle</class>
    <class kind="class">Glib::Sequence</class>
    <class kind="class">Glib::ListHandle</class>
    <class kind="class">Glib::SListHandle</class>
    <subgroup>ContHelpers</subgroup>
    <member kind="typedef">
      <type>ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>StringArrayHandle</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga8e243b697be740f5f7d4b578ae50db41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OwnershipType</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga64c27560b41710ccf64a3679a3ba3f20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_NONE</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a7d594cffcc2d2d6c4313ddb4d6613c79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_SHALLOW</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a448c598cdc37e2de8a162e1020001715</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_DEEP</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a2a6d6bfadc36f9eda31af79d32928c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Sequence&lt; Iterator &gt;</type>
      <name>sequence</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga33e5a3a70ef5f7bed112046726ff8b04</anchor>
      <arglist>(Iterator pbegin, Iterator pend)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ContHelpers</name>
    <title>Helper classes</title>
    <filename>group__ContHelpers.html</filename>
    <class kind="class">Glib::Container_Helpers::ArrayHandleIterator</class>
    <class kind="struct">Glib::Container_Helpers::TypeTraits</class>
    <class kind="class">Glib::Container_Helpers::ListHandleIterator</class>
    <class kind="class">Glib::Container_Helpers::SListHandleIterator</class>
  </compound>
  <compound kind="group">
    <name>MainLoop</name>
    <title>The Main Event Loop</title>
    <filename>group__MainLoop.html</filename>
    <class kind="class">Glib::PollFD</class>
    <class kind="class">Glib::SignalTimeout</class>
    <class kind="class">Glib::SignalIdle</class>
    <class kind="class">Glib::SignalIO</class>
    <class kind="class">Glib::SignalChildWatch</class>
    <class kind="class">Glib::MainContext</class>
    <class kind="class">Glib::MainLoop</class>
    <class kind="class">Glib::Source</class>
    <class kind="class">Glib::TimeoutSource</class>
    <class kind="class">Glib::IdleSource</class>
    <class kind="class">Glib::IOSource</class>
    <member kind="enumeration">
      <name>IOCondition</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_IN</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918af244f3e8c1c9525762f3630befd76336</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_OUT</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a60f61c8f26f2bb61afd3ad8afd673099</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_PRI</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a36bb5411dda1131e5c23e17a8619c820</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERR</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a2e402c9fd5879c49ef5359fa4189acd3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_HUP</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ab5dcc0e24c236c027b041d362dcff35b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_NVAL</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ad37b5d6ba6a0c1ad98510f352ac2f885</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator|</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gab5937e9164f36f75ba87fd67903348d5</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator&amp;</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga12928ddba0f38406f19d55547bac552b</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator^</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga6416bbf923045261beb85241fff8ef0d</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator~</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga85461947d24f306cefd2fe17999deb97</anchor>
      <arglist>(IOCondition flags)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga8269a01826f8737d98ab0d345a0004f4</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11f46ad6051058eeeb34d5963a4f7c44</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga995d6d5d01db67af62661bcd5dfd1ad6</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalTimeout</type>
      <name>signal_timeout</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaadb206fcc112f086f9d47c016b1f2175</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIdle</type>
      <name>signal_idle</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga76792522d9680a05e232d3519a25f98d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIO</type>
      <name>signal_io</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaf391654b755a32169d18be4835677376</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalChildWatch</type>
      <name>signal_child_watch</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11ee7db80cc44ece02056a38bb049e3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainContext &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga043c5714afbad2745b27301dd58470a4</anchor>
      <arglist>(GMainContext *gobject, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainLoop &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga22ea72cda4ef327ca03fb72d6a3bea89</anchor>
      <arglist>(GMainLoop *gobject, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>MiscUtils</name>
    <title>Miscellaneous Utility Functions</title>
    <filename>group__MiscUtils.html</filename>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9c2f67828083d74925b23c59ab868698</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga40e45835b7b461cba0f7a10fbb63c0d3</anchor>
      <arglist>(const Glib::ustring &amp;application_name)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga391655dededb496010eee2e92d0f1fdf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga7d5c429822c09048892c4dee9c8e08c1</anchor>
      <arglist>(const std::string &amp;prgname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga5e186fdb08835342a5866b11fe787ebb</anchor>
      <arglist>(const std::string &amp;variable, bool &amp;found)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga8e2c8f250aa7f059956737851ace08f6</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga862657f21e5a930541d048a920204f59</anchor>
      <arglist>(const std::string &amp;variable, const std::string &amp;value, bool overwrite=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unsetenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6fb89001630714ec9ee5244cab56343e</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>listenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga350a5f6f1ae631f748c89d8dbe7557df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga52964bfd712e8c9e688f668da51f3ed9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_real_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga30692e3263e66868878f535e0b7c9722</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_home_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9412ea70c7fea058c03211dac318f8e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_tmp_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gac42272146fd9320958132f1591d28991</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_current_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga06d93c95572d6a382b8cc4e09dd5a339</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_special_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gabc928a4e477df53f90e221a854cc73cb</anchor>
      <arglist>(GUserDirectory directory)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_data_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga821b704b5ede1583e4057990976d394b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_config_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae517b931f4753abcd48adb2769a8fc48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_cache_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa68121f26e82df1c293c82b89c8998e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>path_is_absolute</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gad82525f39f7408f97f2c096c4f721b3b</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_skip_root</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga306eee64abc3d28993895b826f4dd533</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_basename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga20ebf2917a7fce5d1901568017b95a35</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_dirname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae03457226c4239a74b83486739521434</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4a70bf050b3f318f87049ed30206a9a</anchor>
      <arglist>(const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gada06023cc39be3a44eb68e38d6cbea6c</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6afc89d45cc34f3cfce4a55f3f5e7afa</anchor>
      <arglist>(const std::string &amp;separator, const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>find_program_in_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4c4ecb9a3eb803ae6d9dee51e1e5b14</anchor>
      <arglist>(const std::string &amp;program)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>PatternMatching</name>
    <title>Glob-style Pattern Matching</title>
    <filename>group__PatternMatching.html</filename>
    <class kind="class">Glib::PatternSpec</class>
  </compound>
  <compound kind="group">
    <name>Random</name>
    <title>Random Numbers</title>
    <filename>group__Random.html</filename>
    <class kind="class">Glib::Rand</class>
  </compound>
  <compound kind="group">
    <name>StringUtils</name>
    <title>String Utility Functions</title>
    <filename>group__StringUtils.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>str_has_prefix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6b7e8354049756e92a97554a107618ac</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>str_has_suffix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga5c4e380ffc6617ac61ca92e203e45630</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;suffix)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>strtod</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gaa44aba9faa6575d4881b1fe779464f6b</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>strtod</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6465a8320d790115c41a2c76d1d3233c</anchor>
      <arglist>(const std::string &amp;str, std::string::size_type &amp;end_index, std::string::size_type start_index=0)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>dtostr</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gac740e6c99bca5896ccbfc12b621491ac</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga35e288b5ce34cb15eeec907421d2b77c</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gad24f3547c8d6b3ec56d7f5805a11d6ab</anchor>
      <arglist>(const std::string &amp;source, const std::string &amp;exceptions)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strcompress</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga85cd83bd40baf0119aac3ff0a9a5e7b2</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strerror</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga1eb869894996c91c0f69dbff96714c71</anchor>
      <arglist>(int errnum)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strsignal</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga44ce9f689aff8abe1e3073b209f360d3</anchor>
      <arglist>(int signum)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ThreadPools</name>
    <title>Thread Pools</title>
    <filename>group__ThreadPools.html</filename>
    <class kind="class">Glib::ThreadPool</class>
  </compound>
  <compound kind="group">
    <name>glibmmValue</name>
    <title>Generic Values</title>
    <filename>group__glibmmValue.html</filename>
    <class kind="class">Glib::Value&lt; bool &gt;</class>
    <class kind="class">Glib::Value&lt; char &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Value&lt; int &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned int &gt;</class>
    <class kind="class">Glib::Value&lt; long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long &gt;</class>
    <class kind="class">Glib::Value&lt; long long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long long &gt;</class>
    <class kind="class">Glib::Value&lt; float &gt;</class>
    <class kind="class">Glib::Value&lt; double &gt;</class>
    <class kind="class">Glib::Value&lt; void * &gt;</class>
    <class kind="class">Glib::ValueBase</class>
    <class kind="class">Glib::ValueBase_Boxed</class>
    <class kind="class">Glib::ValueBase_Object</class>
    <class kind="class">Glib::ValueBase_Enum</class>
    <class kind="class">Glib::ValueBase_Flags</class>
    <class kind="class">Glib::ValueBase_String</class>
    <class kind="class">Glib::Value_Boxed</class>
    <class kind="class">Glib::Value&lt; std::string &gt;</class>
    <class kind="class">Glib::Value&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::Value_Enum</class>
    <class kind="class">Glib::Value_Flags</class>
    <class kind="class">Glib::Value_Pointer</class>
    <class kind="class">Glib::Value</class>
    <class kind="class">Glib::Value&lt; T * &gt;</class>
    <class kind="class">Glib::Value&lt; const T * &gt;</class>
  </compound>
  <compound kind="group">
    <name>Streams</name>
    <title>Stream Classes</title>
    <filename>group__Streams.html</filename>
    <class kind="class">Gio::BufferedInputStream</class>
    <class kind="class">Gio::BufferedOutputStream</class>
    <class kind="class">Gio::DataInputStream</class>
    <class kind="class">Gio::DataOutputStream</class>
    <class kind="class">Gio::FileInputStream</class>
    <class kind="class">Gio::FileIOStream</class>
    <class kind="class">Gio::FileOutputStream</class>
    <class kind="class">Gio::FilterInputStream</class>
    <class kind="class">Gio::FilterOutputStream</class>
    <class kind="class">Gio::InputStream</class>
    <class kind="class">Gio::IOStream</class>
    <class kind="class">Gio::MemoryInputStream</class>
    <class kind="class">Gio::MemoryOutputStream</class>
    <class kind="class">Gio::Mount</class>
    <class kind="class">Gio::OutputStream</class>
    <class kind="class">Gio::Seekable</class>
    <class kind="class">Gio::UnixInputStream</class>
    <class kind="class">Gio::UnixOutputStream</class>
  </compound>
  <compound kind="group">
    <name>NetworkIO</name>
    <title>Portable Network I/O Functionality</title>
    <filename>group__NetworkIO.html</filename>
    <class kind="class">Gio::InetAddress</class>
    <class kind="class">Gio::InetSocketAddress</class>
    <class kind="class">Gio::NetworkAddress</class>
    <class kind="class">Gio::NetworkService</class>
    <class kind="class">Gio::Resolver</class>
    <class kind="class">Gio::Socket</class>
    <class kind="class">Gio::SocketAddress</class>
    <class kind="class">Gio::SocketAddressEnumerator</class>
    <class kind="class">Gio::SocketClient</class>
    <class kind="class">Gio::SocketConnectable</class>
    <class kind="class">Gio::SocketConnection</class>
    <class kind="class">Gio::SocketListener</class>
    <class kind="class">Gio::SocketService</class>
    <class kind="class">Gio::SrvTarget</class>
    <class kind="class">Gio::TcpConnection</class>
    <class kind="class">Gio::ThreadedSocketService</class>
    <class kind="class">Gio::UnixConnection</class>
  </compound>
  <compound kind="group">
    <name>glibmmEnums</name>
    <title>glibmm Enums and Flags</title>
    <filename>group__glibmmEnums.html</filename>
    <class kind="class">ChecksumType</class>
    <member kind="enumeration">
      <name>Month</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_MONTH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa3c180cbd1a72ac6c1193374f07478043</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JANUARY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fadcae78391f0081dd887dbd5c62ce9e18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FEBRUARY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fafbb90abf68464b8e14a764cef1ced1e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MARCH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faaf1909bbb4cbf9a02db828ab35e52ce3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APRIL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa879774f2eee3f8807bbd8e3c25e3c5b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa9da639bcfe895324daded17f4600116b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JUNE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faaab22ac997e15a34995118694f8cbd2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JULY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fae6d2bfb5bd12aace37808b1f5fe53afb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AUGUST</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa846063b97ea9c5dd82cae8718bb75df1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEPTEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faa7e563e8689c07fac8f60f9f68f6cebb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OCTOBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa3c5a2a9a7bfcc9b7cbd57b89856c4989</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOVEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fac21038623ac787c4c94010d2334f6c8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DECEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa2aed3776c7cb74418206e52677f394c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Weekday</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_WEEKDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1a0b852cafa7e3b36f3b87c8acd796be89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MONDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac75c38cdbe0d1a25346de7d5a1919f12</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TUESDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1a3f573dae7a781f9f380b0adecdc068fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WEDNESDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ab91831a000325a1ad3dd881f0db708e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THURSDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac2be9a407f81cac5ef82ec308aa23cc9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FRIDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ad86f5fb6fa5f0f99e8f6980d5d78ceae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SATURDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1aa8703e1dd1d78272012d603e8ded6807</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUNDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac0ae61753cd0be03a4cee4ff0b209fb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DMY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac803072d86bbc2ce1f7d558c94f41ae1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a340ad04532a2d66518f8eefdf1ac1b27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MONTH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a9da8611c47d68fe95d9026cf162bb350</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>YEAR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a8eec7a614a99a9640e578862c13b5682</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileTest</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_REGULAR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a3181e2e655e765b00dfdb1e1ea443f62</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_SYMLINK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a86cda9ff0bf25358070a9bc8b4a186d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_DIR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad3679641c18e5e4d4578c2122492cea4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_EXECUTABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad9ab64f07fd4fc2105b53b7379265535</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_EXISTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a37c8f223bda6b6ce2875490351989ddd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SeekType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa3767731311bdba4ef42dc99215e5cda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_CUR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa48f0a394042c3a8e117b2ae64af33960</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_SET</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa1e0d3b4a03e5dd32f135acc89982889f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_END</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaafa5ff5cdf7e6623866c717fe49cfbaec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOStatus</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_ERROR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea121996c81c45593110cd714bb81bc349</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5eaf249c5b8e984c37db0847258aeeae86a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_EOF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ead42ae91b402716ab4faaec9b0f3823fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_AGAIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea5a33609d7ff07e1d711185c0765cf5de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_APPEND</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a121e65986f06397730c4c36d09fb4dc7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_NONBLOCK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a3724a778574d25ba0bd83139a80b2c0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_READABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a162bfe5ccb18465d0f11e954cc4a89d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_WRITEABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7af9738e0234ae1d1f15c4512d6edb16db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_SEEKABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7ac1373a306084710994199b3de0137cfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a290937753007a9d182326eb334438a6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_GET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a9431cd6fcef2a716b7d313bd9cde85b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_SET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a1d4db9b335a96f503cd491973b162105</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KeyFileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5866be36312563d91e5a7be27348459b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_NONE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba06a606cb7b5f244a0f3ad4f5e67b30bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_COMMENTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba00058fa3d8e271d9ff5e1469dc39dc69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_TRANSLATIONS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba7ff723c84c930b978dccd6732eebe985</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ParseFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa4fcaf917b6eb2aa085817e83b0a4108</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DO_NOT_USE_THIS_UNSUPPORTED_FLAG</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa4fcaf917b6eb2aa085817e83b0a4108a3f48cb56dd56d529c9379ae244441e90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TREAT_CDATA_AS_TEXT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa4fcaf917b6eb2aa085817e83b0a4108a7da76e9b36f7599e3791e9cc87a2ff72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PREFIX_ERROR_POSITION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa4fcaf917b6eb2aa085817e83b0a4108a4bd16878d9226c7ce4c5fbf023a67e94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ModuleFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga502283ffbe523adf38c69905ec8640f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LAZY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3acd94d05ef9ba97ceb6f3904b87f5bbfc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LOCAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a8e5768a91ee8dbf459785dee8b664b72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a9cbf95b359863e9296457cbb0f193169</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TraverseType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae3a70fa1e451da068323419e8c98e9a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_IN_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9aa7f260b474a886df2bf1aefcfc0f14b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_PRE_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9abed8efe71581ccb087323f38b6807661</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_POST_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a0af70e322b94dfbbfc98b100d21cef4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_LEVEL_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a16cd819f4ab8175453f6287aeefad870</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TraverseFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad11179d39a4991e5b09f145d594a450e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea7da8793fdd0c433870a5e6c2e3152898</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_NON_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6473ae1f054172ae349d01003fabf37f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea1be75d605b0c93ca7932110467536670</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6832c7b45443db4eed6f4cfbd3c04b69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexCompileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_CASELESS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0f604aee4eae77ce7bca901c8b3de37d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MULTILINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daee58700869ae67ad0823d10a7c51cb9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOTALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da7ec3013d10b6360c921d67f23ff585fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_EXTENDED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da4ef80551354a8a16bcefaf9b35f55a17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da67404d06bba595dec28fb4e6e05da427</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOLLAR_ENDONLY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0d7cf52858b215b55ff10ccae9732dd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_UNGREEDY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daf9c564d8191b7220f0f072b3b694f8ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_RAW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3acb6bdd173741b57cf267be3a3c7f75</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NO_AUTO_CAPTURE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dac6ccf906840973453a55625b2edf2f25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_OPTIMIZE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da581257f414998f8ea0e0f55adf0844f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DUPNAMES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da895a8a3fb7141b91a1890ee0bdb1a6b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3cab374f897aaac10d71c5437f9d77f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dabbbc306156a05aa67fde8d86d6d3b3c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da8a419c54023c5dbedbd8960c9367d68a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexMatchFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac387b5b0e77b1726553e5d77e77191d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746afcdffce16a01e99f25f52bfe3deafd80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a70b70be752f4874a262c15b99b3ee75f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEMPTY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a58bc907f6f6e19c30456c895d18ea655</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_PARTIAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aaa4d21e1c7f7ab1df117d433cafc5ad6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aed663630c5623dc65f0ea23a04cf2979</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746af5656ccd40cd632e00bc71b08834386e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a4b76b13cfd30f891108f491a58dbb2a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_ANY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac76fe84aa6df3f8e6af74504ff5e7ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SpawnFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_LEAVE_DESCRIPTORS_OPEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26ddaa2a457be3bdc07bbd0d32e1a63264d90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_DO_NOT_REAP_CHILD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda0ad30b49d46750083ddd1e0643635e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_SEARCH_PATH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda341e5cb2803eb06a0f2f0431d6305e04</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDOUT_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda450919630c2ce753374d1d05760bb205</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDERR_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda5ae7fa0d4f6a0bdfc37adeb578634491</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_CHILD_INHERITS_STDIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda9fb3c6cfddb2ef201f7b11829da8b5d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_FILE_AND_ARGV_ZERO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda55dc12133953441059847e8633227a84</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ThreadPriority</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_LOW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a035a7bdc6a5b5eae6f644ed2605e8a37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a6216bb25baaaca32642841ade911a92e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_HIGH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448aef77081535e90116b203ce3b3b0fe523</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_URGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a5b79355bbd59c508995af57e0ed39a94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONTROL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac280382585f1014b43ed228760e7c558</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FORMAT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaaedc3e279c1c7e01f1bec907bbe313ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UNASSIGNED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eafc32abac3afbe8380d54790f178fd3de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PRIVATE_USE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5ca14907043380b1e9d725671bc71a56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea0b99b4f93ef273ea4c49fb82970f5e54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LOWERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eadb83c3e23724b6ef15888c6527a063bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae6e48ddd5b4eacb4cbf67fa902743458</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea57ced328464824fe23113e7b98a4ae61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_TITLECASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab72e09c06a5aeffccdd94d5695dfcbc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UPPERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea8f344db3f8e39ed99bc2c9665ab96c89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_COMBINING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5d22c0c4d39d68b815dccd52bb5ff01c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_ENCLOSING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea4508b84626068a2dbf23a69b96475e6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_NON_SPACING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea857864a5d1c145cc3ff8ccba54834f19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DECIMAL_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae75e5f353bc068ec3d8bf2555c540995</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LETTER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea19811baedb3dbc8afddde43d00eb3cd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea45a259cec90b0ada120fe7116be422b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONNECT_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea649c83b23fb3d9bd7bf1803858cc5afe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DASH_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaa1169c4e20b3a47f597005f84f9fa7fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea1ffaf2aac92ca1e818cf3e26b8301b90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FINAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab549f212a3f340bd660a962b298409ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_INITIAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab247e5e7480ecbf382b2128c600b8720</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5c9416f9219bf9282c49b7ca831f0c9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea806e11a7f8d1a0b0688a0237ad1fa190</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CURRENCY_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea40b40c2bb5d39acee2b81327e2efb905</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b693a82d2e497a2b13cae8d5668097c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MATH_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea28100e9fa5a262bbd32b973303746490</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea298582645a73c91d191b7e1dc61d214f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LINE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ead7650a40ddf3741e87a1039eba56b1a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PARAGRAPH_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b3c71c265af11b331d0ec4240af1c8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SPACE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac2eafb967dc62399aeb5ff27c8896b0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeBreakType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_MANDATORY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37c762c3c7b080f5795ed6f828231923</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CARRIAGE_RETURN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa6b7c9d7a0ac78d14cf06b18bfeb2ccf9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_LINE_FEED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7839936b879938c5056bdb55eb0b6b7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMBINING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa014f326eb07effe48f1b771459caa7c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa032b712c48700209c7cc414ca88cda34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ZERO_WIDTH_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaadb5ff8a11c4e596677d161903c732c56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INSEPARABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa38f51c8283586493a3ebd45fa3b0113e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_BREAKING_GLUE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa47784c7e2cd80f6ac179de7f7a3f54e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CONTINGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae80d6fef8acf765da47c8235e39f4896</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab37a6597dbf2e248b610769be7e5cb3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaada4027a9bfc5ffdf90e3be612adad7aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab1efcdcd3d6ecb55dff58a2e2ee1b9e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE_AND_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaafce05d8590e1b40ec427f8f78cf15ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HYPHEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7e6dd69fc00fdc42ab091a2916426dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_STARTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaabe412d94a1f7d9e92cc5a20f0b549626</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa52ebd39d1b02dfd368992a2ef8e7fa7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaad1284afc0511ab69aa18554b8306fbca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_QUOTATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa8fe57a799eacc3299fd256285dd1246d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_EXCLAMATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaf628849c1e5b531c022e12695c1f6f5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_IDEOGRAPHIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa22047a88734e9fe1e9e0fef994cfb20b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NUMERIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa50a61c3c53da7558d08c1fcbcfc3b138</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INFIX_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa07f3d0d76db141033eff38ee7577ffd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaafc02ec4862f016b6c2da35592f6cd62b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ALPHABETIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaea27a8970e74f93f485d45f6a1684586</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_PREFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa580794ffc9992e65666adce0611eecb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_POSTFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ca3941d5dea03a5c824ae55212db01a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMPLEX_CONTEXT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa3a96b8e59ba5815700d33c1f6006a339</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AMBIGUOUS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae79244811e61b30eb68ee02dc45f1c09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_UNKNOWN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaeb94f98b2233fae0afb38bf115b4b42d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NEXT_LINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ffad3080f483a6b97680db786836ced</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_WORD_JOINER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa9a74e7d947f75ef93d4e3aacebdb898b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_L_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab3449fb99a5694c3f6debd9d1a887a1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_V_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa156946aa6aec4f4e0f8e69d352f31f90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_T_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37082de3ccd45cca392c6dee935d7cc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LV_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7a11c61184436fe2fb6e74d0ea916f86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LVT_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa44dec475bcc1d26dc3ad905c302efc87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AsciiType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2e5a690ed07dfaa6f9ad9f1c57acd787</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALNUM</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787af7d63a99479102b5391b44f631b5f009</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALPHA</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ac87947c729ac3c3f9f58b0ca28460152</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_CNTRL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2e19c57ce5a6eac38d911a86cc44a2fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_DIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9acd9a82d0670a3eb0377db782f48853</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_GRAPH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2ecdbe5137af423fce73ff2bbb34d625</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_LOWER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a875d3cb7494e1548db0d37ab44d4057e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PRINT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9b1775043a8043d994c0c0ab890e86c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PUNCT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad3416d8662560db626259013ff72c58f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a7d7a68814efba3cf3d294475123413ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_UPPER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a5ae30681069b2ab88eed13e358c08090</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_XDIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad78490a35d65839f2f06449e7e472337</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>NormalizeMode</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848acbaee513b23e0066962df2e540cd4c99</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a169a0ae0910535038d8d403f874f0b5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848ad9fb4be6b95958030771b4e8cba4144c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a20e4b8b42b12a7972ca4f6c84030978d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa1cf5911572000f5273dc46fe2c5b270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a995775ef324bbd76a91a74c7f2686867</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a7c98a2300648a33ca0ebc87fed999ca5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa7f62ac84c5ed8a8868cbb49a889dd98</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e018d8609ba17b0f6955505a8363bf7</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae652f47e7b61603b9a6b86b7251d5526</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6c089f23d6bfd92e083edc75519db75e</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga948edadd8ee7442b83d37dc3c325f890</anchor>
      <arglist>(FileTest flags)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9a6f5470f667596e897f5bfbd1068283</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga112ada474a7aad83af2bd49403abf41e</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2219c78993a5196ca2a435a18e0fc3a7</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga0dd0a8800b6311ee8f3867eb27a72ae5</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7662618e73d046d4df5eb7cce3e487f8</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad61c57b0678c703e8a14230d18bacff7</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga548c1cb09208fef57e5d0b3c992d71b9</anchor>
      <arglist>(IOFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac3539f6df5e0c0658726f4f0573146f9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae84d9361a6154e6b0e8d099705ad6cad</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2180a5c566ced37bbeb37050d9632da9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabac5e1493392116b118e4d1048e3fef0</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1827ef58fe5e85d65ff8166e51b33556</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacc28b21831114895abfdbae6c1908114</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab99ff1d7c6d96da2ddfcfd1c4954e9b6</anchor>
      <arglist>(KeyFileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7096a34594825c90d7b6257935a62eb1</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga80dd56fcaea8bc3f0a5f21b9d3049877</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac90869f74a743e2f99f55708c28a585d</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga330303c9d78eb78547012d549d4bb018</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga421021254296cdba48ec178a54fe93d9</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab059cb7acda2b29eb2066958fc71951a</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1fb97b62ae844c056b400e2813a21ee2</anchor>
      <arglist>(ParseFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6b24d718f166cb352be94ee6e4090296</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2a7b1137fa0d9495cdb5f46ec564a2ba</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf59b9479390c508dff23dba221177bcc</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gade862759d091b90329ba8f85aa2fd010</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaacd06c8457fa8f31c1483f96c4933ddf</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga333d93ef372c08c322d27ac05bda0e18</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaa723a5b4d33e54167f7adbb18746004</anchor>
      <arglist>(ModuleFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae9df767ea1ec74b0d9d9acce426a07a8</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab903aa5397125ce37c66a259c4b1a5f5</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e73a634c6441630eddf8805b22dd163</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5c44b3a4eee7eefbb1f2d1d8f22642ca</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4ae748a01d312275d2ca4e15c5df5826</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69068f48bbea92cdd3cc7d69fdc017e1</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacb650222b1a3f6a44e72df95d815a7f8</anchor>
      <arglist>(RegexCompileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae6fd65d5a674d2e2e453793d86fa64cd</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaeefcf05c20e07dde23268b83a1ff1c45</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1425051a4ffed939a1bff1e0543c9498</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab63da3a959cbd5f00f4fa535e35eda08</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga29b80a6c4482fae8e19f9328ec0c3147</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga06c395f619dffca3f0fc483fab302122</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf192ce556cbd7ddb416e8078bdb09523</anchor>
      <arglist>(RegexMatchFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f30deab298559a873d7beca40279ead</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga283a3e82cd9d3da8746edbe13a6f616a</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga402d81f594d95305aa6e275aa74126ae</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaba6cac919da111ebf69667bf9f8006ff</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2d10b36fdc1ceb9fea2ffcd58406f3e2</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga84449a9a461b381f88f65435ef8389ec</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga065f45ca68d1397febf331293e4cc4de</anchor>
      <arglist>(SpawnFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabbe289c910b34a158f8dc22bb0b0095f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga93f15ab009ea244c1d8b069e27ec193f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga40166fcca8eb8ec5b148c82444553927</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5bc1518eb5547dbb8af77b944ccaa048</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4c340e00aeb13a9124081f383283eed0</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga682a545ca2e86b3e162305e4f14fa8d5</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad7ea47582094c6d092a8f485e1e709c6</anchor>
      <arglist>(AsciiType flags)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69bba23f4c9a83c268d0599f241b8ebe</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f4b46bf548b21ef21a568ecc18a5871</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac1b0239e539cf250333fe0adc04dbb41</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>giommEnums</name>
    <title>giomm Enums and Flags</title>
    <filename>group__giommEnums.html</filename>
    <member kind="enumeration">
      <name>AppInfoCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344af71f654bb54f7e68263da28fc5eccacd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NEEDS_TERMINAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344a01421973a2522b9e2ac7672c03468e8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_URIS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aef4faf5deef3c2e3eec96cefd9feeafc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aaa40bd96592a90dffd60f0f969604ea0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>CredentialsType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8dde</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddeab7616d5b52056cc29a2ef7bf3fb80353</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_LINUX_UCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddea8e05457bf2bf4d7c5e59bf36b66fc54d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_FREEBSD_CMSGCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddeaed40e68e3fd14be8ed83203f8c1a0f11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga23dcd37a16709d66dc7b4a437abf65fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_STARTER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga23dcd37a16709d66dc7b4a437abf65fba03c09bb52e7aefe379e3f6bda395dae3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga23dcd37a16709d66dc7b4a437abf65fba1609c4bd9d329b8922575974fad96b87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_SYSTEM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga23dcd37a16709d66dc7b4a437abf65fba49ae1414696bdbbf16986efa444c827b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga23dcd37a16709d66dc7b4a437abf65fba787d8f85206186f3c28f3b05488af4fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusConnectionFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga56cc88c85dffb62f3958d1f355056ff3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3a1c7eafba707bf1cc8ff3145b35fd3cf5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3a1c2585436cce421ca9e1b2aa3cb3859c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3aa7bf4366d4b15c0ff673ffa1a3a5c4ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3ad81c6cc4add016992678f09d597b0abe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3a0ffd64dde974865fd1a4d8c550da924c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3a82f95fc26045347532b60fe2b0be1bff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusSendMessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd0957f1136064d34097c428f9e1a4c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SEND_MESSAGE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafd0957f1136064d34097c428f9e1a4c7af9201b32562b6e09d2c10ebe132022c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafd0957f1136064d34097c428f9e1a4c7adc62b629ecc75747eaf377f323268dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusError</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1b341a5947f8025ec1b38a8b4dbfcbb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a8a6252fa73d350e87f6135090958e4e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NO_MEMORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a3ad98e2aee167d4e7c133f7d8e7fcd0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SERVICE_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9fe839d46dbf157fe52e9dc0a5c29fcf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NAME_HAS_NO_OWNER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a073550042a52f04d435bf4fb1d63b17d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NO_REPLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a4e63b7adf8bb001ec8cf2ac39bc5e074</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_IO_ERROR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a6fea0e79b52b625ff387afab049c851d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_BAD_ADDRESS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a46b057da0025ef4c766baaa0263c372e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NOT_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9f27417f751ea54009a297bd9ab8bf99</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_LIMITS_EXCEEDED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a902d800a60a8a6953e8540ff433e1a9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_ACCESS_DENIED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3adbe1ea11a15ad6f820b861b3fcb97d60</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_AUTH_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a8f6d73b15e1b23f5b7c6c973274c3553</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NO_SERVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ae5c0a4db40d3232fc1d4befaadc93ef7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_TIMEOUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3af76f4836f259d393ea62c2f5acb5c381</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NO_NETWORK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a03f49b1ec1889c78049242a4dc9e8bba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_ADDRESS_IN_USE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3aab4f81aed041923c5b17b025b44a5ac4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_DISCONNECTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a1870fca6b3958d2f8fba286f91f860e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_INVALID_ARGS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a710eaef39a468e36cb6bec55f9844f54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_FILE_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a31ff1fde8c7672b8ebeef5811700410b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_FILE_EXISTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3aa8d5ff2f84ce5a5584c8349c384b0ee1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_UNKNOWN_METHOD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a93f182d8f2956fd030d6f2b45fe1e99e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_TIMED_OUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3aef80f58c0063ba7e4c607295cb8bc96f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_MATCH_RULE_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a33a5262d710bf333fe59d6174ea4b8cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_MATCH_RULE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3abe506d68d5ca39e730352fd23b09df86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_EXEC_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a61e5f3e83b131d2cccb0fd754a460ea8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_FORK_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a624d8259d9421be5650f48db8db45c0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_CHILD_EXITED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a3362b9054c5acaa404deafac62271da6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_CHILD_SIGNALED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9ee2a496856b47f0e65b642877d3212e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ab0dd1356d58f1544688800ee58660962</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_SETUP_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a1a4499045a2a1a2aabd4f57784719792</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_CONFIG_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a2535f7c79af7e9dc8274f090d8559daf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_SERVICE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3add87fd73e1e2fa8d55f7a16bf9d8cb66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_SERVICE_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ac6d7496162930a544dc48b367af11f0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_PERMISSIONS_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a64665dbb2768d0a40590ee666da9150d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_FILE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a4ebf25ee0f21c1ef1de73e1702a66079</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_NO_MEMORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ae5a909b07125508ae4559726d1d8f8a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_UNIX_PROCESS_ID_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ae027768e6ac9d77a95bccc7bb3b65860</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_INVALID_SIGNATURE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a511626827492429e879a3e30b2ef082d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_INVALID_FILE_CONTENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a7f350b45750a7a1e61b88a677d6be451</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a0e2cf606b00964895d155450f4932aef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_ADT_AUDIT_DATA_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9c04490292009753f508472c359eb944</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_OBJECT_PATH_IN_USE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9e3df4e0addf2527b03617ca2d1ac6df</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusPropertyInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad6b3184f35d4713671611d47cc41d488</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROPERTY_INFO_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggad6b3184f35d4713671611d47cc41d488a222988e4894e4f986d525407caabc3fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROPERTY_INFO_FLAGS_READABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggad6b3184f35d4713671611d47cc41d488a533dd72504c0f3f80782e4192376c38c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROPERTY_INFO_FLAGS_WRITABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggad6b3184f35d4713671611d47cc41d488ac6f9e2d95e3e37b71b6e50aa5a309540</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusMessageType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1b3d10c6a453c6e6e443fe81787a1486</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486aab42b76388f657f9edcc0896329dd4e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_METHOD_CALL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486a12b687a13e76cce5805ed960f8e7e8c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_METHOD_RETURN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486aab46de50eec8351d66b98e6899053d6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_ERROR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486ad5e55cf62995db0a251c2be5ca214b07</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_SIGNAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486a7d8cfb5693777ed95fe77cdc18955c31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusMessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4492dcbc011b9dc8b01ea454f446ba06</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4492dcbc011b9dc8b01ea454f446ba06a9f4167c2292248170898137a5308789b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4492dcbc011b9dc8b01ea454f446ba06a3ccdd9c6d903c816427d0390ec7e4d2f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_FLAGS_NO_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4492dcbc011b9dc8b01ea454f446ba06a77b832bee2b29b64647022f49e55b7d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusMessageHeaderField</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga895c97f538a2c1638f94b3e6cd0f209a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aaeccf8acd5bb3aed66aa167a7133bea88</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_PATH</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aacb4213794a2a3401cdf8cdf20c4a6470</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_INTERFACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aa3a0228bcfefcb703202239c7ed1e4c46</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_MEMBER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aaeef4b6ce589bb57451e5d50d4f7391f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aa395bb28dc49af18839b67d6d39d20908</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aab88c619b3195d866ccf9529dee1dd2ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aaec8f4505d173500bd2cfa5a65053448b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_SENDER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aaba58aec2ecd46ff47a57136ce0dcd947</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_SIGNATURE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aa4b5c674daab06e750c02125c776b938c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aa0b63471a3c69cf0c5d7fc10d56982644</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusCapabilityFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacbc63efe16e6ed04a6f228d42a4b90b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CAPABILITY_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggacbc63efe16e6ed04a6f228d42a4b90b9aff62b203d7087a9777e91a5734cdb205</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CAPABILITY_FLAGS_UNIX_FD_PASSING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggacbc63efe16e6ed04a6f228d42a4b90b9aab1e9ceda547fbf097a01df6235fcd39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusNameOwnerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90e13b67fdf97528695baa4a6a18b051</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051a6f6a351717c214f7504c32d91bb1ce8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051ac35f459d321c52977e12b1cfb97e7a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_REPLACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051aac4ada47441dcb1ac4e24fc78155c7fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusProxyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga713b81b65694a2a3705780a94c0dddd8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROXY_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga713b81b65694a2a3705780a94c0dddd8ae5bdb6378bee5024e79bd6f48cc7c27c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga713b81b65694a2a3705780a94c0dddd8ac253a83e9fb2b742fc96241fe7a251f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga713b81b65694a2a3705780a94c0dddd8a0dfa76b396d70cbecc178b84afd06ef8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROXY_FLAGS_DO_NOT_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga713b81b65694a2a3705780a94c0dddd8a2ea1ae91f2a9752ba05bc7944252ff39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusServerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf1ae4aa65eb44b426ca7a46022743ad3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SERVER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf1ae4aa65eb44b426ca7a46022743ad3a9dde3244e0f6ff2b7cb4050e3518d417</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SERVER_FLAGS_RUN_IN_THREAD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf1ae4aa65eb44b426ca7a46022743ad3aaa31578021d155097425375800a04a27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SERVER_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf1ae4aa65eb44b426ca7a46022743ad3a422bbf92819bee6229734f429fa9efe1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusNameWatcherFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga724a510e53ed4df47411bcdbaf680c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_WATCHER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga724a510e53ed4df47411bcdbaf680c85a01d4229ebcfb078416d859d7f242504a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_WATCHER_FLAGS_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga724a510e53ed4df47411bcdbaf680c85a08efa890043aa8a8930a0c7b79b9872c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab628e70b1d028b3bc9b02b0d3b8acf2da6a46299fc0a721de0bed46063ba484de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartStopType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da01961d00b61f87fb25ba3001a042db5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_SHUTDOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da59acd7106146af052b9bc164ac85d1d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_NETWORK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da24f499a4eee0fb59870d42089fc8cc38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_MULTIDISK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da7f6a48659447fa2b3b0c1c9d0520e2ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2daf1a4c886e6d77d3a1f3d8b864a536da5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>EmblemOrigin</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8f8b573b5755138f1da852121c33027d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_DEVICE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a6bcc4f7fda6aee37062db66a6abe66c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_LIVEMETADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a746b49f22653188190760d6724f00c03</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_TAG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8ca854f52478785f462472c706aefa2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamByteOrder</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_BIG_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea18117d3d82013605e0200837278b61ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ead7d652c4c3be181175e6b3ce0b8a6b6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_HOST_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea4ee0fe7768cdcaa1bfe30a866e597fe5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamNewlineType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a2984664a935bd2803f9f8efb525ab1ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a684a76a8c6470952cf17935c0e6d4c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a668ad4c9993ae7201cad988ccb9f9265</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_ANY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a07aa934ff2e202ae347600466895d634</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketFamily</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a287dfaac297cc0158f78d7d62949ccaa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_UNIX</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a853383527365f9b02a474b76b96e2bb6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV4</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48aa4f0f6d511f5e4969c7fa77b7780c91e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV6</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a8077081b5558ee5a35497749c4f4901c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileQueryInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a25937649b891bc6e25fd3b102e961fa0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a111136a309875440d7b9a065e9d413fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa91626c845b45a4432c5c5be9f62db63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_PRIVATE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601a561d151d8be5524e68d0316baa6b3346</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_REPLACE_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa1edf0c05c6e4c84340200dcb4b981bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCopyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea2de95276b80f5261e9de761e98987273</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_OVERWRITE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeaa739f5a86205d73bc68ef06e59943b0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_BACKUP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeae4bdca31f92ed16bc4fbdcfed03f51d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea28d4e03c13c33cc8ee846dd74720b8c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_ALL_METADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea1a0416eaa1df264399127dcfc8787cb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NO_FALLBACK_FOR_MOVE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea8ba81fce89dc9733ef050a366cbc36ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_TARGET_DEFAULT_PERMS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea7c03196a0667919cbbbb692058351d80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649ab14b94920f9dd257f04b8d2089ee7f41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_WATCH_MOUNTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a125f456ecc2055488ae714ae03cafb9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_SEND_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a4c5d097f39bf10d159e87432e41e0051</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8e0404fb81075c7cb1947d391710df6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a42aaefaf1350bc75f0c59232f5427a00</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BYTE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1b5ce4388a50031998a766297c6809b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4ee1a4a4232372cc3ee901c60b04252b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1e05d09eec38684188623c5d66c80adc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8610920b627048811f8c83ff68815726</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a6146f4603d261931c170501119ecdf10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4420e14e2d76c78878480484b4824178</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_OBJECT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2abf2a03fdfe8fab868b52e7e2e31681cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRINGV</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a137ca5ab57718ba53c1425d8adb529ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a4cfd632fc68ef8907454ebf50e25ddea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WITH_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a1f079dce29168aefc78ffb19913a2f56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a31dfc4cee76aa4982b2f0b59df32d8ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeStatus</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_UNSET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a7d19f425a83dab27da6d3ad11622a0d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a163950d9d163bc80175e3fa34e917c71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_ERROR_SETTING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a146c1891a87c49ee9be95e76a92c3e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_NOT_KNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac879cd353f56a22f65c3267801953e30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_REGULAR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac07760305b8906edfcf52dbd6f7910d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca681e4e1f442347d50c9b0cd8ca03bb2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SYMBOLIC_LINK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca08dca91a6a47ea3a139b0c6afb0954c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SPECIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca5fad9f1f4585f8114f830eedea41e7ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SHORTCUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cab853c5774004a86eab09106b60046106</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_MOUNTABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824caa7c0c584a463721afb2f2bb57b27c2ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a2fa81d8cdfbb69372e2167267cc6bde8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGES_DONE_HINT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81af04e689b125341be3cc8425bed360fb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_DELETED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81aa99e4d03a648a9b43d43885b76b4db82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CREATED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a946dcf9aeeb8d22fb9631a912aeac751</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0b265fec915bf4d5ce4547c8645d4b8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_PRE_UNMOUNT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a9a904f978d9e725f84e12cc276faddae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_UNMOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a4e75e84f300f88c83e4a1b301e146a86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0466268ddfa83be0291871084ddfb31a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountUnmountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44a30cece3099822da07d5d74cc97fa4ad4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_FORCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44af26cca6f4bb36f76811bfe7d057459b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountMountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_MOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5484bace25c932fd4c7354259e138814a4fa5bb6630552f216d543dc14bdce93f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AskPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad72247e662c964b1f34673a2a9dac864</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_USERNAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6eca9176d669bd3832b47af7938ef2ab97da</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_DOMAIN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecaae4ff232f33015b669577b05c275ac64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_SAVING_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad9bf425560cd436e897cbdd1a7326673</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_ANONYMOUS_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecab54fea4ff83c960b28733ed9576b9ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PasswordSave</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_NEVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fae6580664da5e48500434f40e24bcd77d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_FOR_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9d5e5d263f2bfcdce02dfb8f25efb411</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_PERMANENTLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9f15426c23241e58661b559b12276323</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountOperationResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_HANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ad8feb3f3ff8deb01bb211593ea0c4f92</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_ABORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ab5edd0f1001b94ee66b725fb6425e7c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_UNHANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076a2c4507658069f86a1ef208a0967c9aa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OutputStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a876a19654c7cb1019edd78cffe3afe7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_SOURCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74abd49ddb3a5960d177ae417c5d12271e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_TARGET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a9db82f2020730fac9daa9acb5e7b57ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SettingsBindFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a41372eebf93040ac104d262c6a3b8c13</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_GET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a484abc3c0c33806a268658ce29bebf0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a6172535d7b8251c2d9a71349009c7c30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_NO_SENSITIVITY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a6c4e629d64904ff9d28b2759dfa4c5b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_GET_NO_CHANGES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a382cd16f79bcbb69f07fdefe495fda3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_INVERT_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61abc19c1dfe8b0580fa94f1d9953281dcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310af00948af66fed3af5d79f488132ec25f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_STREAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a449568cb50c6f759abbbccb633bbb266</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_DATAGRAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a7993070a3b3641e7da05c984ee08c8c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_SEQPACKET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a0395a0a66018835d7b4e07d68c731002</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketProtocol</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a91f25c6679ad3343806e22be00be76d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a1d6e5ce50037a49690304ba884287172</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_TCP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a369c33c8920f267e70d3e3a52022267e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UDP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a5b2d9d1efcdedddf53020cc15646b82f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_SCTP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16ae91b17d6dc2e813157474586fd2cc697</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketMsgFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea42d10ab5264669fd457d89aec658534b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_OOB</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eadabfe2785d08635e7a452b5ed9a0ad90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_PEEK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eafc3b9cd1274817ab778671fef134998e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_DONTROUTE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea19c8b9aa25981e200a297b25bf7d8e05</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac2ae439cef63de06f97ed8454b67ec32</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1f0f1235c25f5552c8a1467697bd66d3</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f582e5773b615c406ceb28b695b7015</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga302df8457f421e75eaea25a67cb63c19</anchor>
      <arglist>(AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaccda1b3df9583689a62a3add6715f640</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga179d7c2a3d709c7a8e4a0796a8b5e833</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5dac484830e37250c0942325fb4b85a3</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5eba3903f43d93e67bd20c5275f6d855</anchor>
      <arglist>(DBusConnectionFlags lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaca4bc258036fd4916f4c6292272679fb</anchor>
      <arglist>(DBusConnectionFlags lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga32e76725183cd54c74b95b92f29cdb86</anchor>
      <arglist>(DBusConnectionFlags lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5949a75e8d96639afdfe69ad10b8a93b</anchor>
      <arglist>(DBusConnectionFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga157c3a6eec4f34c0a62b94e27ecc00e6</anchor>
      <arglist>(DBusConnectionFlags &amp;lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabcc32f8924ad4cbb17c6e13d993987f6</anchor>
      <arglist>(DBusConnectionFlags &amp;lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5446d244747b18d10c5649ab4dc93be7</anchor>
      <arglist>(DBusConnectionFlags &amp;lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga329fff1d4fab3cda682916c5e16a3358</anchor>
      <arglist>(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3b08bdbd477a293e04ff33c222218bb0</anchor>
      <arglist>(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3b8891a357577c7a08df8e42de857b27</anchor>
      <arglist>(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga58335899d0fcbbbedfa74eae52c88e43</anchor>
      <arglist>(DBusSendMessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaee91db43b6b22f5c00e6cfda24081bb0</anchor>
      <arglist>(DBusSendMessageFlags &amp;lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8056b66cc8e0e94ba84a7faa0f9f2da7</anchor>
      <arglist>(DBusSendMessageFlags &amp;lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69ee0f13ac020e9dc26b415a7efd0b68</anchor>
      <arglist>(DBusSendMessageFlags &amp;lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga631edb593b9cd1098b889d4a4eb11289</anchor>
      <arglist>(DBusPropertyInfoFlags lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e2662bf4403c41f2abeed49db493deb</anchor>
      <arglist>(DBusPropertyInfoFlags lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga28a839120d12891746a3b8c05bcf20ba</anchor>
      <arglist>(DBusPropertyInfoFlags lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafe9a96a366e424774ef8da1508d63bb5</anchor>
      <arglist>(DBusPropertyInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae4c2c9de55aaeda257760868ea29e728</anchor>
      <arglist>(DBusPropertyInfoFlags &amp;lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab33e51821bf4884ad5e34f2aed886c7b</anchor>
      <arglist>(DBusPropertyInfoFlags &amp;lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8c5a160120a72c4418fdb0b69c22f26f</anchor>
      <arglist>(DBusPropertyInfoFlags &amp;lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa67a84a61f426bdafe242b809244d4a1</anchor>
      <arglist>(DBusMessageFlags lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad50204238b980db05b6005b72e5e70ef</anchor>
      <arglist>(DBusMessageFlags lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3e3144567f30a2cf2d4605b7540c126c</anchor>
      <arglist>(DBusMessageFlags lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2a9e045b170a186633a849ab106e369c</anchor>
      <arglist>(DBusMessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae6a1c65174accf6d5ba1227b2309a681</anchor>
      <arglist>(DBusMessageFlags &amp;lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga095b4425dc2bfb3f2e7aa50a1b364210</anchor>
      <arglist>(DBusMessageFlags &amp;lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga759162970018b8b7455090318516a6b1</anchor>
      <arglist>(DBusMessageFlags &amp;lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga95426620c93621f8e88ce7705394dff5</anchor>
      <arglist>(DBusCapabilityFlags lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae9060bbe2c14537b41c5c821b31d3ac1</anchor>
      <arglist>(DBusCapabilityFlags lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae88b49fdf7e1f1a54955da01b7cd6c90</anchor>
      <arglist>(DBusCapabilityFlags lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabe8a766c084f886c143ecfd74383a96b</anchor>
      <arglist>(DBusCapabilityFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga25a0aa5f29fdcbe78c5e3c9cf10c6f20</anchor>
      <arglist>(DBusCapabilityFlags &amp;lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0f5ac7e2a475fb699af73661dcba016</anchor>
      <arglist>(DBusCapabilityFlags &amp;lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd528855cfd67766b5b5fdaa012e8027</anchor>
      <arglist>(DBusCapabilityFlags &amp;lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6ee165e164ee5ac76fcae97d149b0096</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae95dbcb5c39a041199a14ef692ff190e</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga66e5ff30c50eda68a6e9c9856ff24929</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76ae3c19edb95730bbf26a8bd2fe41fc</anchor>
      <arglist>(BusNameOwnerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1082185ea5b919ef8e797f5a4a2cbd84</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3b00479dfbf4a7ead540cf77612f13</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8256822b508991b36784f8633f5a2a41</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4fc2c81c0e038049f4f51c4ef3163ca8</anchor>
      <arglist>(DBusProxyFlags lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb4cc22e8ba4ff6db8944d13e4c9229f</anchor>
      <arglist>(DBusProxyFlags lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga131ca414b9d12271ba0b08cf8c82034b</anchor>
      <arglist>(DBusProxyFlags lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c51f3f90c89a5d1e75d680d5fcb890e</anchor>
      <arglist>(DBusProxyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga10d1d6f0ab4e41ba367517c6725feb34</anchor>
      <arglist>(DBusProxyFlags &amp;lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga219142bdd4b1084a05462a23731dc793</anchor>
      <arglist>(DBusProxyFlags &amp;lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga99ba38b86d9ee4b94efda586124b3349</anchor>
      <arglist>(DBusProxyFlags &amp;lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac91fc8667d810f80561cc861b8ffcc8b</anchor>
      <arglist>(DBusServerFlags lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1490086b8907a3963e6d1a54ec3b0601</anchor>
      <arglist>(DBusServerFlags lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad9593a470cadfa893d4146ee88122185</anchor>
      <arglist>(DBusServerFlags lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa1158079bf9b20933c5eccaf9b2c0b9b</anchor>
      <arglist>(DBusServerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e68a7a859802fb3afc0aae41f7e9fcc</anchor>
      <arglist>(DBusServerFlags &amp;lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd79bb3053c56e974bcc8f762d794288</anchor>
      <arglist>(DBusServerFlags &amp;lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadfd31cd06a92b5a3bd5db3683c1d9245</anchor>
      <arglist>(DBusServerFlags &amp;lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11d69d7cecb05e6a1ab2e29802001c0d</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e9cd27579fc08b486bf6963e0e48828</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3c6767c920f33ef0acf5273d87d44191</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f09a804dfb04f4a256cfb22cac05378</anchor>
      <arglist>(BusNameWatcherFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3cde961e2c29d55871ad3cb2b4d0f7b1</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a9b2721d1528e637f826498f93486be</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga606fa2da2a5a44a01e084c959fd1cca2</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga38b31de13d1949c2acb9255bdc858767</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c4f37b1ef92224ac50016d49c95bf00</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae75239258d148626dc4b0048b55a4c44</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf625621abb6c686d449c3f3c43aee02c</anchor>
      <arglist>(DriveStartFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga994648faf5be7fd03bc1929554044dac</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga77b3f8597aac448c2dd860f204e32b8f</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1c0e50bc08aaf61dc1fbbe786c5e6b33</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba7574ea0b336541af125d4eb9423088</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd57fe410ba970bb3cb78eb1c9942aeb</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacae77e10133f304081534efa76be4a52</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42422c40ea08ec4f0ad74c8e2a657eb5</anchor>
      <arglist>(FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac59d6f3b6a2adca24d2763ba2af99a02</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga203c5d02679e3aa4c78080fb9269b1f9</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga55adc6ecb3a15cb850b30bafb7eb9248</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga431f17ab67ccea562ea556c10df6bd27</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4a52dbf7b71137a0d00ef49c0eb163a6</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab4d3e010c78b9f5ca2673210269b999d</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga703109997bbde3b6a686dd36ec9d35ad</anchor>
      <arglist>(FileCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4f6ed1c3e6f2a3a7d394b62f3166df7a</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43d71b19c0e673331de89e1b1d84679b</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga045123aaa65f69e2a76a488d1024e34d</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0b841b27ceceb381f08e1bc5cf929eb1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb1d7757198076b221ba038b1d3ae841</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga29b016e93e7a6dfdebc4f9f6e4fbf1c1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70312f36423a73fbf663c64824631dc8</anchor>
      <arglist>(FileCopyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb9c03e9bbf1ef698696dc08b0d36371</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2f22009032ff6f0975c5a5701ca061d</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga514b3929469585c9cfc222ef2daf4fea</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3fab04e51aeff08aaf235f038e50d72</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf801bc2b57ef5136eba961cdcd68e2e6</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga81b5df359bd6a61df867af8274d182ae</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga501c69e3e5101b66d2e5fb8181229b2c</anchor>
      <arglist>(FileMonitorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8af51d7b4e7b78d3f0153090674470aa</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae45bc889f678f9f87ff04596b0de7d1a</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffa032f65b2c0270e12fe6bafa5c36bf</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3779f0623bf9380fb656028b9bc88323</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga31f3ea9c0f0f3b94b829cff51a483da3</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gade49ce26dfa73eb2eb9fc56534ac1319</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9150f4358ab779fd1267151c4ee84a46</anchor>
      <arglist>(FileAttributeInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadebdfefd85c32a1b626bce9ae251138b</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d263feb91a513421902169e234bb8c3</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8c86d142fcb81426bc429d51da4f7d9</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42e2925c2e192eb3e9b71b727e676644</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9ab823e8ba96b485774da1e93c7e576f</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76909c76363248e860a94b20dad18ad9</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace7018ee540582a709530dce1dd9191a</anchor>
      <arglist>(MountUnmountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2d1ab6ef14833802a3615e54b8115aa8</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae1e6af7ffa613a35d110daedd6671389</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6a939c0dc5f5b25dbad5cdb7a1848184</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1248f40d35ae4fb70d74c5df295cb4ae</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa459981a578b6e5ee443681687f9a777</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga02952bdc6c064b144e6667e326618c2d</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga74223d1de9c9db1c53429a6d23671d4f</anchor>
      <arglist>(MountMountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab40e5b0bc75d3308e8cb78606c4eb18</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga24a69ca68eff0e99a80c1c73f32c304e</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad941eb418369c3f95f0b5c046e7d868d</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab444ed2fbe1877464f469a64d9107e36</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a45caccd402223c595e5a160f15f030</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0b37f457e38844832549486982ed1d8</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga993dba04647b8f34ad72e86cbc88ba34</anchor>
      <arglist>(AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01e87fab2e1906ac5eafa153747ceae9</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90dc37e16010e611eed712a21ee0a787</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3411a2fa7d7f016953b5f84dbad4c1</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaef500d088ea9d123dc514f71c4c67b1d</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39f9583f05c94f16ce6228b52663e4e4</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga14a79b6dee4f711a22b52bf259539e34</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafcded381df7535fe7c41bb8f8c21c169</anchor>
      <arglist>(OutputStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5602d53794a62a9e823005e6f9aed428</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab363845e9d7769f38c78dc7cc55d9db6</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01f192f0f1b9f66047d603780c458e6e</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8cd5ffb873f77345b515bf4ec2522ad7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf9c3bdce8aa4209b368419a8a4f374a7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabe81d29f028b8bfb85c189c2471a290d</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3faf22f64ae075a5465b7827001101d2</anchor>
      <arglist>(SettingsBindFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0299f50197606d69c0f306224760fcdb</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga93c66617507b97c4ce9d5e7b99bd0c04</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3f4f0e3823c4d8ce3470b656913fb4e0</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa085ca077592487a87d8339ce3324166</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7483601181aa5da2467e986408d0136a</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaadfaf5e3a456218e23ca0ee13ac3db3d</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf31952f93c501b25194ad46df8994752</anchor>
      <arglist>(SocketMsgFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga62b41279cd63908c0736e96f868e832e</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43e4984d2489a21f44a4ab961bf98541</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab892045d6e9cf73dc96593ead692145b</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ChecksumType</name>
    <filename>classChecksumType.html</filename>
  </compound>
  <compound kind="namespace">
    <name>Gio</name>
    <filename>namespaceGio.html</filename>
    <namespace>Gio::DBus</namespace>
    <class kind="class">Gio::AppLaunchContext</class>
    <class kind="class">Gio::AppInfo</class>
    <class kind="class">Gio::Application</class>
    <class kind="class">Gio::AsyncInitable</class>
    <class kind="class">Gio::AsyncResult</class>
    <class kind="class">Gio::BufferedInputStream</class>
    <class kind="class">Gio::BufferedOutputStream</class>
    <class kind="class">Gio::Cancellable</class>
    <class kind="class">Gio::Credentials</class>
    <class kind="class">Gio::DataInputStream</class>
    <class kind="class">Gio::DataOutputStream</class>
    <class kind="class">Gio::DBusAuthObserver</class>
    <class kind="class">Gio::DBusConnection</class>
    <class kind="class">Gio::DBusAnnotationInfo</class>
    <class kind="class">Gio::DBusArgInfo</class>
    <class kind="class">Gio::DBusMethodInfo</class>
    <class kind="class">Gio::DBusSignalInfo</class>
    <class kind="class">Gio::DBusPropertyInfo</class>
    <class kind="class">Gio::DBusInterfaceInfo</class>
    <class kind="class">Gio::DBusNodeInfo</class>
    <class kind="class">Gio::DBusMessage</class>
    <class kind="class">Gio::DBusMethodInvocation</class>
    <class kind="class">Gio::DBusProxy</class>
    <class kind="class">Gio::DBusServer</class>
    <class kind="class">Gio::Drive</class>
    <class kind="class">Gio::Emblem</class>
    <class kind="class">Gio::EmblemedIcon</class>
    <class kind="class">Gio::Error</class>
    <class kind="class">Gio::ResolverError</class>
    <class kind="class">Gio::File</class>
    <class kind="class">Gio::FileAttributeInfo</class>
    <class kind="class">Gio::FileAttributeInfoList</class>
    <class kind="class">Gio::FileEnumerator</class>
    <class kind="class">Gio::FileIcon</class>
    <class kind="class">Gio::FileAttributeMatcher</class>
    <class kind="class">Gio::FileInfo</class>
    <class kind="class">Gio::FileInputStream</class>
    <class kind="class">Gio::FileIOStream</class>
    <class kind="class">Gio::FileMonitor</class>
    <class kind="class">Gio::FilenameCompleter</class>
    <class kind="class">Gio::FileOutputStream</class>
    <class kind="class">Gio::FilterInputStream</class>
    <class kind="class">Gio::FilterOutputStream</class>
    <class kind="class">Gio::Icon</class>
    <class kind="class">Gio::InetAddress</class>
    <class kind="class">Gio::InetSocketAddress</class>
    <class kind="class">Gio::Initable</class>
    <class kind="class">Gio::InputStream</class>
    <class kind="class">Gio::IOStream</class>
    <class kind="class">Gio::LoadableIcon</class>
    <class kind="class">Gio::MemoryInputStream</class>
    <class kind="class">Gio::MemoryOutputStream</class>
    <class kind="class">Gio::Mount</class>
    <class kind="class">Gio::MountOperation</class>
    <class kind="class">Gio::NetworkAddress</class>
    <class kind="class">Gio::NetworkService</class>
    <class kind="class">Gio::OutputStream</class>
    <class kind="class">Gio::Proxy</class>
    <class kind="class">Gio::ProxyAddress</class>
    <class kind="class">Gio::ProxyResolver</class>
    <class kind="class">Gio::Resolver</class>
    <class kind="class">Gio::Seekable</class>
    <class kind="class">Gio::Settings</class>
    <class kind="class">Gio::SettingsBackend</class>
    <class kind="class">Gio::Socket</class>
    <class kind="class">Gio::SocketAddress</class>
    <class kind="class">Gio::SocketAddressEnumerator</class>
    <class kind="class">Gio::SocketClient</class>
    <class kind="class">Gio::SocketConnectable</class>
    <class kind="class">Gio::SocketConnection</class>
    <class kind="class">Gio::SocketControlMessage</class>
    <class kind="class">Gio::SocketListener</class>
    <class kind="class">Gio::SocketService</class>
    <class kind="class">Gio::SrvTarget</class>
    <class kind="class">Gio::TcpConnection</class>
    <class kind="class">Gio::ThreadedSocketService</class>
    <class kind="class">Gio::ThemedIcon</class>
    <class kind="class">Gio::Volume</class>
    <class kind="class">Gio::VolumeMonitor</class>
    <class kind="class">Gio::DesktopAppInfo</class>
    <class kind="class">Gio::UnixConnection</class>
    <class kind="class">Gio::UnixCredentialsMessage</class>
    <class kind="class">Gio::UnixFDList</class>
    <class kind="class">Gio::UnixFDMessage</class>
    <class kind="class">Gio::UnixInputStream</class>
    <class kind="class">Gio::UnixOutputStream</class>
    <member kind="typedef">
      <type>sigc::slot&lt; void, Glib::RefPtr&lt; AsyncResult &gt; &amp; &gt;</type>
      <name>SlotAsyncReady</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aecaa02709f9ab83fa2b36d2571665cbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::ListHandle&lt; Gio::SrvTarget, SrvTargetListTraits &gt;</type>
      <name>ListHandle_SrvTarget</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a1b4ed5afd24e359d3ba6bde02c9e90be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AppInfoCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344af71f654bb54f7e68263da28fc5eccacd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NEEDS_TERMINAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344a01421973a2522b9e2ac7672c03468e8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_URIS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aef4faf5deef3c2e3eec96cefd9feeafc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aaa40bd96592a90dffd60f0f969604ea0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>CredentialsType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8dde</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddeab7616d5b52056cc29a2ef7bf3fb80353</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_LINUX_UCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddea8e05457bf2bf4d7c5e59bf36b66fc54d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_FREEBSD_CMSGCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddeaed40e68e3fd14be8ed83203f8c1a0f11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga23dcd37a16709d66dc7b4a437abf65fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_STARTER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga23dcd37a16709d66dc7b4a437abf65fba03c09bb52e7aefe379e3f6bda395dae3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga23dcd37a16709d66dc7b4a437abf65fba1609c4bd9d329b8922575974fad96b87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_SYSTEM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga23dcd37a16709d66dc7b4a437abf65fba49ae1414696bdbbf16986efa444c827b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga23dcd37a16709d66dc7b4a437abf65fba787d8f85206186f3c28f3b05488af4fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusConnectionFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga56cc88c85dffb62f3958d1f355056ff3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3a1c7eafba707bf1cc8ff3145b35fd3cf5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3a1c2585436cce421ca9e1b2aa3cb3859c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3aa7bf4366d4b15c0ff673ffa1a3a5c4ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3ad81c6cc4add016992678f09d597b0abe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3a0ffd64dde974865fd1a4d8c550da924c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga56cc88c85dffb62f3958d1f355056ff3a82f95fc26045347532b60fe2b0be1bff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusSendMessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd0957f1136064d34097c428f9e1a4c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SEND_MESSAGE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafd0957f1136064d34097c428f9e1a4c7af9201b32562b6e09d2c10ebe132022c5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafd0957f1136064d34097c428f9e1a4c7adc62b629ecc75747eaf377f323268dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusPropertyInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad6b3184f35d4713671611d47cc41d488</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROPERTY_INFO_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggad6b3184f35d4713671611d47cc41d488a222988e4894e4f986d525407caabc3fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROPERTY_INFO_FLAGS_READABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggad6b3184f35d4713671611d47cc41d488a533dd72504c0f3f80782e4192376c38c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROPERTY_INFO_FLAGS_WRITABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggad6b3184f35d4713671611d47cc41d488ac6f9e2d95e3e37b71b6e50aa5a309540</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusMessageType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1b3d10c6a453c6e6e443fe81787a1486</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486aab42b76388f657f9edcc0896329dd4e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_METHOD_CALL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486a12b687a13e76cce5805ed960f8e7e8c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_METHOD_RETURN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486aab46de50eec8351d66b98e6899053d6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_ERROR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486ad5e55cf62995db0a251c2be5ca214b07</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_TYPE_SIGNAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b3d10c6a453c6e6e443fe81787a1486a7d8cfb5693777ed95fe77cdc18955c31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusMessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4492dcbc011b9dc8b01ea454f446ba06</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4492dcbc011b9dc8b01ea454f446ba06a9f4167c2292248170898137a5308789b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4492dcbc011b9dc8b01ea454f446ba06a3ccdd9c6d903c816427d0390ec7e4d2f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_FLAGS_NO_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4492dcbc011b9dc8b01ea454f446ba06a77b832bee2b29b64647022f49e55b7d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusMessageHeaderField</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga895c97f538a2c1638f94b3e6cd0f209a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aaeccf8acd5bb3aed66aa167a7133bea88</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_PATH</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aacb4213794a2a3401cdf8cdf20c4a6470</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_INTERFACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aa3a0228bcfefcb703202239c7ed1e4c46</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_MEMBER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aaeef4b6ce589bb57451e5d50d4f7391f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aa395bb28dc49af18839b67d6d39d20908</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aab88c619b3195d866ccf9529dee1dd2ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aaec8f4505d173500bd2cfa5a65053448b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_SENDER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aaba58aec2ecd46ff47a57136ce0dcd947</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_SIGNATURE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aa4b5c674daab06e750c02125c776b938c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga895c97f538a2c1638f94b3e6cd0f209aa0b63471a3c69cf0c5d7fc10d56982644</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusCapabilityFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacbc63efe16e6ed04a6f228d42a4b90b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CAPABILITY_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggacbc63efe16e6ed04a6f228d42a4b90b9aff62b203d7087a9777e91a5734cdb205</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_CAPABILITY_FLAGS_UNIX_FD_PASSING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggacbc63efe16e6ed04a6f228d42a4b90b9aab1e9ceda547fbf097a01df6235fcd39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusProxyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga713b81b65694a2a3705780a94c0dddd8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROXY_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga713b81b65694a2a3705780a94c0dddd8ae5bdb6378bee5024e79bd6f48cc7c27c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga713b81b65694a2a3705780a94c0dddd8ac253a83e9fb2b742fc96241fe7a251f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga713b81b65694a2a3705780a94c0dddd8a0dfa76b396d70cbecc178b84afd06ef8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_PROXY_FLAGS_DO_NOT_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga713b81b65694a2a3705780a94c0dddd8a2ea1ae91f2a9752ba05bc7944252ff39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DBusServerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf1ae4aa65eb44b426ca7a46022743ad3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SERVER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf1ae4aa65eb44b426ca7a46022743ad3a9dde3244e0f6ff2b7cb4050e3518d417</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SERVER_FLAGS_RUN_IN_THREAD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf1ae4aa65eb44b426ca7a46022743ad3aaa31578021d155097425375800a04a27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_SERVER_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf1ae4aa65eb44b426ca7a46022743ad3a422bbf92819bee6229734f429fa9efe1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab628e70b1d028b3bc9b02b0d3b8acf2da6a46299fc0a721de0bed46063ba484de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartStopType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da01961d00b61f87fb25ba3001a042db5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_SHUTDOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da59acd7106146af052b9bc164ac85d1d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_NETWORK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da24f499a4eee0fb59870d42089fc8cc38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_MULTIDISK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da7f6a48659447fa2b3b0c1c9d0520e2ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2daf1a4c886e6d77d3a1f3d8b864a536da5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>EmblemOrigin</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8f8b573b5755138f1da852121c33027d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_DEVICE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a6bcc4f7fda6aee37062db66a6abe66c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_LIVEMETADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a746b49f22653188190760d6724f00c03</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_TAG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8ca854f52478785f462472c706aefa2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamByteOrder</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_BIG_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea18117d3d82013605e0200837278b61ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ead7d652c4c3be181175e6b3ce0b8a6b6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_HOST_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea4ee0fe7768cdcaa1bfe30a866e597fe5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamNewlineType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a2984664a935bd2803f9f8efb525ab1ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a684a76a8c6470952cf17935c0e6d4c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a668ad4c9993ae7201cad988ccb9f9265</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_ANY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a07aa934ff2e202ae347600466895d634</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketFamily</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a287dfaac297cc0158f78d7d62949ccaa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_UNIX</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a853383527365f9b02a474b76b96e2bb6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV4</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48aa4f0f6d511f5e4969c7fa77b7780c91e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV6</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a8077081b5558ee5a35497749c4f4901c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileQueryInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a25937649b891bc6e25fd3b102e961fa0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a111136a309875440d7b9a065e9d413fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa91626c845b45a4432c5c5be9f62db63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_PRIVATE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601a561d151d8be5524e68d0316baa6b3346</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_REPLACE_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa1edf0c05c6e4c84340200dcb4b981bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCopyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea2de95276b80f5261e9de761e98987273</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_OVERWRITE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeaa739f5a86205d73bc68ef06e59943b0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_BACKUP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeae4bdca31f92ed16bc4fbdcfed03f51d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea28d4e03c13c33cc8ee846dd74720b8c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_ALL_METADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea1a0416eaa1df264399127dcfc8787cb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NO_FALLBACK_FOR_MOVE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea8ba81fce89dc9733ef050a366cbc36ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_TARGET_DEFAULT_PERMS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea7c03196a0667919cbbbb692058351d80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649ab14b94920f9dd257f04b8d2089ee7f41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_WATCH_MOUNTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a125f456ecc2055488ae714ae03cafb9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_SEND_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a4c5d097f39bf10d159e87432e41e0051</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8e0404fb81075c7cb1947d391710df6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a42aaefaf1350bc75f0c59232f5427a00</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BYTE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1b5ce4388a50031998a766297c6809b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4ee1a4a4232372cc3ee901c60b04252b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1e05d09eec38684188623c5d66c80adc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8610920b627048811f8c83ff68815726</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a6146f4603d261931c170501119ecdf10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4420e14e2d76c78878480484b4824178</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_OBJECT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2abf2a03fdfe8fab868b52e7e2e31681cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRINGV</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a137ca5ab57718ba53c1425d8adb529ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a4cfd632fc68ef8907454ebf50e25ddea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WITH_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a1f079dce29168aefc78ffb19913a2f56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a31dfc4cee76aa4982b2f0b59df32d8ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeStatus</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_UNSET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a7d19f425a83dab27da6d3ad11622a0d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a163950d9d163bc80175e3fa34e917c71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_ERROR_SETTING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a146c1891a87c49ee9be95e76a92c3e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_NOT_KNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac879cd353f56a22f65c3267801953e30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_REGULAR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac07760305b8906edfcf52dbd6f7910d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca681e4e1f442347d50c9b0cd8ca03bb2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SYMBOLIC_LINK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca08dca91a6a47ea3a139b0c6afb0954c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SPECIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca5fad9f1f4585f8114f830eedea41e7ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SHORTCUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cab853c5774004a86eab09106b60046106</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_MOUNTABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824caa7c0c584a463721afb2f2bb57b27c2ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a2fa81d8cdfbb69372e2167267cc6bde8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGES_DONE_HINT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81af04e689b125341be3cc8425bed360fb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_DELETED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81aa99e4d03a648a9b43d43885b76b4db82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CREATED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a946dcf9aeeb8d22fb9631a912aeac751</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0b265fec915bf4d5ce4547c8645d4b8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_PRE_UNMOUNT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a9a904f978d9e725f84e12cc276faddae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_UNMOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a4e75e84f300f88c83e4a1b301e146a86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0466268ddfa83be0291871084ddfb31a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountUnmountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44a30cece3099822da07d5d74cc97fa4ad4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_FORCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44af26cca6f4bb36f76811bfe7d057459b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountMountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_MOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5484bace25c932fd4c7354259e138814a4fa5bb6630552f216d543dc14bdce93f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AskPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad72247e662c964b1f34673a2a9dac864</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_USERNAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6eca9176d669bd3832b47af7938ef2ab97da</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_DOMAIN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecaae4ff232f33015b669577b05c275ac64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_SAVING_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad9bf425560cd436e897cbdd1a7326673</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_ANONYMOUS_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecab54fea4ff83c960b28733ed9576b9ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PasswordSave</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_NEVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fae6580664da5e48500434f40e24bcd77d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_FOR_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9d5e5d263f2bfcdce02dfb8f25efb411</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_PERMANENTLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9f15426c23241e58661b559b12276323</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountOperationResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_HANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ad8feb3f3ff8deb01bb211593ea0c4f92</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_ABORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ab5edd0f1001b94ee66b725fb6425e7c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_UNHANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076a2c4507658069f86a1ef208a0967c9aa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OutputStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a876a19654c7cb1019edd78cffe3afe7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_SOURCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74abd49ddb3a5960d177ae417c5d12271e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_TARGET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a9db82f2020730fac9daa9acb5e7b57ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SettingsBindFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a41372eebf93040ac104d262c6a3b8c13</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_GET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a484abc3c0c33806a268658ce29bebf0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a6172535d7b8251c2d9a71349009c7c30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_NO_SENSITIVITY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a6c4e629d64904ff9d28b2759dfa4c5b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_GET_NO_CHANGES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a382cd16f79bcbb69f07fdefe495fda3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_INVERT_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61abc19c1dfe8b0580fa94f1d9953281dcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310af00948af66fed3af5d79f488132ec25f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_STREAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a449568cb50c6f759abbbccb633bbb266</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_DATAGRAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a7993070a3b3641e7da05c984ee08c8c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_SEQPACKET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a0395a0a66018835d7b4e07d68c731002</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketProtocol</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a91f25c6679ad3343806e22be00be76d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a1d6e5ce50037a49690304ba884287172</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_TCP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a369c33c8920f267e70d3e3a52022267e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UDP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a5b2d9d1efcdedddf53020cc15646b82f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_SCTP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16ae91b17d6dc2e813157474586fd2cc697</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketMsgFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea42d10ab5264669fd457d89aec658534b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_OOB</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eadabfe2785d08635e7a452b5ed9a0ad90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_PEEK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eafc3b9cd1274817ab778671fef134998e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_DONTROUTE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea19c8b9aa25981e200a297b25bf7d8e05</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac2ae439cef63de06f97ed8454b67ec32</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1f0f1235c25f5552c8a1467697bd66d3</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f582e5773b615c406ceb28b695b7015</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga302df8457f421e75eaea25a67cb63c19</anchor>
      <arglist>(AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaccda1b3df9583689a62a3add6715f640</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga179d7c2a3d709c7a8e4a0796a8b5e833</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5dac484830e37250c0942325fb4b85a3</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5eba3903f43d93e67bd20c5275f6d855</anchor>
      <arglist>(DBusConnectionFlags lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaca4bc258036fd4916f4c6292272679fb</anchor>
      <arglist>(DBusConnectionFlags lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga32e76725183cd54c74b95b92f29cdb86</anchor>
      <arglist>(DBusConnectionFlags lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5949a75e8d96639afdfe69ad10b8a93b</anchor>
      <arglist>(DBusConnectionFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga157c3a6eec4f34c0a62b94e27ecc00e6</anchor>
      <arglist>(DBusConnectionFlags &amp;lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabcc32f8924ad4cbb17c6e13d993987f6</anchor>
      <arglist>(DBusConnectionFlags &amp;lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusConnectionFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5446d244747b18d10c5649ab4dc93be7</anchor>
      <arglist>(DBusConnectionFlags &amp;lhs, DBusConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga329fff1d4fab3cda682916c5e16a3358</anchor>
      <arglist>(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3b08bdbd477a293e04ff33c222218bb0</anchor>
      <arglist>(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3b8891a357577c7a08df8e42de857b27</anchor>
      <arglist>(DBusSendMessageFlags lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga58335899d0fcbbbedfa74eae52c88e43</anchor>
      <arglist>(DBusSendMessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaee91db43b6b22f5c00e6cfda24081bb0</anchor>
      <arglist>(DBusSendMessageFlags &amp;lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8056b66cc8e0e94ba84a7faa0f9f2da7</anchor>
      <arglist>(DBusSendMessageFlags &amp;lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusSendMessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69ee0f13ac020e9dc26b415a7efd0b68</anchor>
      <arglist>(DBusSendMessageFlags &amp;lhs, DBusSendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga631edb593b9cd1098b889d4a4eb11289</anchor>
      <arglist>(DBusPropertyInfoFlags lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e2662bf4403c41f2abeed49db493deb</anchor>
      <arglist>(DBusPropertyInfoFlags lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga28a839120d12891746a3b8c05bcf20ba</anchor>
      <arglist>(DBusPropertyInfoFlags lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafe9a96a366e424774ef8da1508d63bb5</anchor>
      <arglist>(DBusPropertyInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae4c2c9de55aaeda257760868ea29e728</anchor>
      <arglist>(DBusPropertyInfoFlags &amp;lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab33e51821bf4884ad5e34f2aed886c7b</anchor>
      <arglist>(DBusPropertyInfoFlags &amp;lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusPropertyInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8c5a160120a72c4418fdb0b69c22f26f</anchor>
      <arglist>(DBusPropertyInfoFlags &amp;lhs, DBusPropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa67a84a61f426bdafe242b809244d4a1</anchor>
      <arglist>(DBusMessageFlags lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad50204238b980db05b6005b72e5e70ef</anchor>
      <arglist>(DBusMessageFlags lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3e3144567f30a2cf2d4605b7540c126c</anchor>
      <arglist>(DBusMessageFlags lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2a9e045b170a186633a849ab106e369c</anchor>
      <arglist>(DBusMessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae6a1c65174accf6d5ba1227b2309a681</anchor>
      <arglist>(DBusMessageFlags &amp;lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga095b4425dc2bfb3f2e7aa50a1b364210</anchor>
      <arglist>(DBusMessageFlags &amp;lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga759162970018b8b7455090318516a6b1</anchor>
      <arglist>(DBusMessageFlags &amp;lhs, DBusMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga95426620c93621f8e88ce7705394dff5</anchor>
      <arglist>(DBusCapabilityFlags lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae9060bbe2c14537b41c5c821b31d3ac1</anchor>
      <arglist>(DBusCapabilityFlags lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae88b49fdf7e1f1a54955da01b7cd6c90</anchor>
      <arglist>(DBusCapabilityFlags lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabe8a766c084f886c143ecfd74383a96b</anchor>
      <arglist>(DBusCapabilityFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga25a0aa5f29fdcbe78c5e3c9cf10c6f20</anchor>
      <arglist>(DBusCapabilityFlags &amp;lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0f5ac7e2a475fb699af73661dcba016</anchor>
      <arglist>(DBusCapabilityFlags &amp;lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd528855cfd67766b5b5fdaa012e8027</anchor>
      <arglist>(DBusCapabilityFlags &amp;lhs, DBusCapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4fc2c81c0e038049f4f51c4ef3163ca8</anchor>
      <arglist>(DBusProxyFlags lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb4cc22e8ba4ff6db8944d13e4c9229f</anchor>
      <arglist>(DBusProxyFlags lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga131ca414b9d12271ba0b08cf8c82034b</anchor>
      <arglist>(DBusProxyFlags lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c51f3f90c89a5d1e75d680d5fcb890e</anchor>
      <arglist>(DBusProxyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga10d1d6f0ab4e41ba367517c6725feb34</anchor>
      <arglist>(DBusProxyFlags &amp;lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga219142bdd4b1084a05462a23731dc793</anchor>
      <arglist>(DBusProxyFlags &amp;lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga99ba38b86d9ee4b94efda586124b3349</anchor>
      <arglist>(DBusProxyFlags &amp;lhs, DBusProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac91fc8667d810f80561cc861b8ffcc8b</anchor>
      <arglist>(DBusServerFlags lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1490086b8907a3963e6d1a54ec3b0601</anchor>
      <arglist>(DBusServerFlags lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad9593a470cadfa893d4146ee88122185</anchor>
      <arglist>(DBusServerFlags lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa1158079bf9b20933c5eccaf9b2c0b9b</anchor>
      <arglist>(DBusServerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e68a7a859802fb3afc0aae41f7e9fcc</anchor>
      <arglist>(DBusServerFlags &amp;lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd79bb3053c56e974bcc8f762d794288</anchor>
      <arglist>(DBusServerFlags &amp;lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadfd31cd06a92b5a3bd5db3683c1d9245</anchor>
      <arglist>(DBusServerFlags &amp;lhs, DBusServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga38b31de13d1949c2acb9255bdc858767</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c4f37b1ef92224ac50016d49c95bf00</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae75239258d148626dc4b0048b55a4c44</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf625621abb6c686d449c3f3c43aee02c</anchor>
      <arglist>(DriveStartFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga994648faf5be7fd03bc1929554044dac</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga77b3f8597aac448c2dd860f204e32b8f</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1c0e50bc08aaf61dc1fbbe786c5e6b33</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba7574ea0b336541af125d4eb9423088</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd57fe410ba970bb3cb78eb1c9942aeb</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacae77e10133f304081534efa76be4a52</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42422c40ea08ec4f0ad74c8e2a657eb5</anchor>
      <arglist>(FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac59d6f3b6a2adca24d2763ba2af99a02</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga203c5d02679e3aa4c78080fb9269b1f9</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga55adc6ecb3a15cb850b30bafb7eb9248</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga431f17ab67ccea562ea556c10df6bd27</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4a52dbf7b71137a0d00ef49c0eb163a6</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab4d3e010c78b9f5ca2673210269b999d</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga703109997bbde3b6a686dd36ec9d35ad</anchor>
      <arglist>(FileCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4f6ed1c3e6f2a3a7d394b62f3166df7a</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43d71b19c0e673331de89e1b1d84679b</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga045123aaa65f69e2a76a488d1024e34d</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0b841b27ceceb381f08e1bc5cf929eb1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb1d7757198076b221ba038b1d3ae841</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga29b016e93e7a6dfdebc4f9f6e4fbf1c1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70312f36423a73fbf663c64824631dc8</anchor>
      <arglist>(FileCopyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb9c03e9bbf1ef698696dc08b0d36371</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2f22009032ff6f0975c5a5701ca061d</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga514b3929469585c9cfc222ef2daf4fea</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3fab04e51aeff08aaf235f038e50d72</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf801bc2b57ef5136eba961cdcd68e2e6</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga81b5df359bd6a61df867af8274d182ae</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga501c69e3e5101b66d2e5fb8181229b2c</anchor>
      <arglist>(FileMonitorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8af51d7b4e7b78d3f0153090674470aa</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae45bc889f678f9f87ff04596b0de7d1a</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffa032f65b2c0270e12fe6bafa5c36bf</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3779f0623bf9380fb656028b9bc88323</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga31f3ea9c0f0f3b94b829cff51a483da3</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gade49ce26dfa73eb2eb9fc56534ac1319</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9150f4358ab779fd1267151c4ee84a46</anchor>
      <arglist>(FileAttributeInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadebdfefd85c32a1b626bce9ae251138b</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d263feb91a513421902169e234bb8c3</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8c86d142fcb81426bc429d51da4f7d9</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42e2925c2e192eb3e9b71b727e676644</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9ab823e8ba96b485774da1e93c7e576f</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76909c76363248e860a94b20dad18ad9</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace7018ee540582a709530dce1dd9191a</anchor>
      <arglist>(MountUnmountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2d1ab6ef14833802a3615e54b8115aa8</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae1e6af7ffa613a35d110daedd6671389</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6a939c0dc5f5b25dbad5cdb7a1848184</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1248f40d35ae4fb70d74c5df295cb4ae</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa459981a578b6e5ee443681687f9a777</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga02952bdc6c064b144e6667e326618c2d</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga74223d1de9c9db1c53429a6d23671d4f</anchor>
      <arglist>(MountMountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab40e5b0bc75d3308e8cb78606c4eb18</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga24a69ca68eff0e99a80c1c73f32c304e</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad941eb418369c3f95f0b5c046e7d868d</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab444ed2fbe1877464f469a64d9107e36</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a45caccd402223c595e5a160f15f030</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0b37f457e38844832549486982ed1d8</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga993dba04647b8f34ad72e86cbc88ba34</anchor>
      <arglist>(AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01e87fab2e1906ac5eafa153747ceae9</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90dc37e16010e611eed712a21ee0a787</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3411a2fa7d7f016953b5f84dbad4c1</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaef500d088ea9d123dc514f71c4c67b1d</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39f9583f05c94f16ce6228b52663e4e4</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga14a79b6dee4f711a22b52bf259539e34</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafcded381df7535fe7c41bb8f8c21c169</anchor>
      <arglist>(OutputStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5602d53794a62a9e823005e6f9aed428</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab363845e9d7769f38c78dc7cc55d9db6</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01f192f0f1b9f66047d603780c458e6e</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>hostname_to_ascii</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a77e0b4b95d9ab0d2c2b21e79117ec77a</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>hostname_to_unicode</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a80496bf6a136c6b3a4d995849d0665af</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hostname_is_non_ascii</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a0d47bc4dc47f82a829ee5e00e13987f3</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hostname_is_ascii_encoded</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a58e3cc92152717d75a9f5cf4d260815d</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hostname_is_ip_address</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a19e270aea166c888515b97d0623f4309</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8cd5ffb873f77345b515bf4ec2522ad7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf9c3bdce8aa4209b368419a8a4f374a7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabe81d29f028b8bfb85c189c2471a290d</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3faf22f64ae075a5465b7827001101d2</anchor>
      <arglist>(SettingsBindFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0299f50197606d69c0f306224760fcdb</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga93c66617507b97c4ce9d5e7b99bd0c04</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3f4f0e3823c4d8ce3470b656913fb4e0</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa085ca077592487a87d8339ce3324166</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7483601181aa5da2467e986408d0136a</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaadfaf5e3a456218e23ca0ee13ac3db3d</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf31952f93c501b25194ad46df8994752</anchor>
      <arglist>(SocketMsgFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga62b41279cd63908c0736e96f868e832e</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43e4984d2489a21f44a4ab961bf98541</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab892045d6e9cf73dc96593ead692145b</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_equals</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a496c304f10ea79f1a20137bf614466e8</anchor>
      <arglist>(const Glib::ustring &amp;type1, const Glib::ustring &amp;type2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_a</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a278fca288c7c2e9995ebb64ce43a6ffd</anchor>
      <arglist>(const Glib::ustring &amp;type, const Glib::ustring &amp;supertype)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_unknown</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aee153086e7cd9f1ab0509cbf81ec06e9</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_description</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ac065cb89d7abb5935cfa225e3d41a732</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_mime_type</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a92f379d45658e14f3ec1bec3da71d908</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>content_type_get_icon</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7972eb82466bf972bbbf5b58f6344e84</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_can_be_executable</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ae5107c4e00134d7d9df3b755a74f9494</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_from_mime_type</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ad5432d8f8c8ba74f8157af9d49930b4c</anchor>
      <arglist>(const Glib::ustring &amp;mime_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a48e8afbb7f1724efcdebd7c028da5560</anchor>
      <arglist>(const std::string &amp;filename, const guchar *data, gsize data_size, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ae46acc46aa5c33a8d1feda6a675fefa9</anchor>
      <arglist>(const std::string &amp;filename, const std::string &amp;data, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>content_type_guess_for_tree</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7e82e215c402edca50219020e43d08ec</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;root)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::ustring &gt;</type>
      <name>content_types_get_registered</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aeae6cd7ee77a7b1c52443116f346b476</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a28171d5c1584ce2516ba05b13cee04ec</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AppLaunchContext</name>
    <filename>classGio_1_1AppLaunchContext.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppLaunchContext</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a11fe8b5d8eb6de7c6d1a19d77d366c98</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAppLaunchContext *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a41ed3abab4ad83b765974dfa6cb66067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAppLaunchContext *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>aa05603f4fe010e75df7ca950183b9224</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GAppLaunchContext *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>ac14e1569a0a5a81f846c0e11e7109011</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_display</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>acb9df3c4d0856cf54725a0ec1baf29cb</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;info, const Glib::ListHandle&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_startup_notify_id</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>ac76a58054fccd2cfc6f3554e1d4b012a</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;info, const Glib::ListHandle&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>launch_failed</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>aeb5fe002776ad4f040b6be49fa25b46a</anchor>
      <arglist>(const std::string &amp;startup_notify_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppLaunchContext &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a9e0b952987932c15f4f8ac7ae6d2e046</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>AppLaunchContext</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a04c6b83e39f16c6ae04ad10c387e2cec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AppLaunchContext &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a3cda3d0a285e3ad87f1c94142b04a688</anchor>
      <arglist>(GAppLaunchContext *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AppInfo</name>
    <filename>classGio_1_1AppInfo.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppInfo</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>acf86d510216c430be4735d1f7b13113e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ab31e9bca0208159f0be42227397b8a94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a5e52c62432a61c5380bd5dc553898251</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a1803e87dccb051f4fe69cb10277c6c2e</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_id</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a3d929d82e4d7ae91f4d8904f91e7a1c4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a450c7e5a59919a66f73133749c318987</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_description</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>af7d89372dcf32cc6c25a9545a4ccffa0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_executable</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a06a665d4d812adb2eeb5c05d4c91c266</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_commandline</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ad389c830c25f58b5ec99d247a3517939</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a35a0c2c10ee787cc5d1d4ac7773bab0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a16fe789da6c7f5c8c023255b2faff226</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a4d5096988eea54e06832325276a78f2a</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;files, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a8bb534c3834b17ff80edb046ba78250e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_files</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a6ba8d06c3f3d99f907ae1aadbd8b24da</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a23a6ee89635a2b24468c73f137ad8de4</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;uris, GAppLaunchContext *launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>should_show</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a7b374a9120926615fc7454afab6452e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_delete</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ae9c4b3e178815a1fbbd60abe69d9e0f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>do_delete</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a634d024dee3e412df7dc794a280a438e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_as_default_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a59cefa47ef35940d5c0b74a396728808</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_as_default_for_extension</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a33b6e19f73a30f1dde7913282aa20aeb</anchor>
      <arglist>(const std::string &amp;extension)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a0dedbcba19457176114948c80efdfbe4</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_remove_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a150146aaba23bfa208d5c7100d986ee9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>aa1e9856c39e12c5ad1770299e391b6c0</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a12bbf2ad90f8915f46c3a49b6354e8ec</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>create_from_commandline</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ac77db461b3142c9459c8c1a211672bf9</anchor>
      <arglist>(const std::string &amp;commandline, const std::string &amp;application_name, AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ListHandle&lt; Glib::RefPtr&lt; AppInfo &gt; &gt;</type>
      <name>get_all</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a21c3fa9bf0f708f3cf52ec38eb837c2e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ListHandle&lt; Glib::RefPtr&lt; AppInfo &gt; &gt;</type>
      <name>get_all_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a05bb9f05067d8469f2de981794a31302</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>get_default_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a42907d07abfa7e35e2f220436d3fcb72</anchor>
      <arglist>(const std::string &amp;content_type, bool must_support_uris=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>get_default_for_uri_scheme</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ac278c0e445faed4288c6a719e059e0da</anchor>
      <arglist>(const std::string &amp;uri_scheme)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>reset_type_associations</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a01913be6448947643c9de26bddd0659c</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>launch_default_for_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>acf9d831fcddbf5626b1e1b9ff70c8598</anchor>
      <arglist>(const std::string &amp;uri, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;context)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>launch_default_for_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a164a90bd2c00e9c4acb1194c475dd5d5</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AppInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a074ab0526fd01e5ee2daf2c81c17f552</anchor>
      <arglist>(GAppInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Application</name>
    <filename>classGio_1_1Application.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a01c45143f595a603c38f0e6706b0145a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GApplication *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a5bf7165c776bb2979a15da499b67b906</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GApplication *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ad024d1c363f8e850b52cfea2726a1b52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GApplication *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a554fe8f0fbd560c6ab28fc7c49ac3ce5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>register_application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a8964856be3086656cc1f933381754d3a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_id</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a0850af24ee016a9dd6087a3d4fc78d4b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_action</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a8054bfd126bcf9fc5b7c17cc2343594a</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::ustring &amp;description)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_action</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aacd790e7fd6d2a614cfe41e0ddfe1701</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>list_actions</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a60d9c51432b1969d021991568c924dce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_action_enabled</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aa8ab1e0bb2bc031b8abca04a09d1d873</anchor>
      <arglist>(const Glib::ustring &amp;name, bool enabled=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_action_enabled</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a91302d6bc4861d28ed95322d52807905</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_action_description</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>abdfc3a66c58f0c2f5a05899e952e6e6e</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invoke_action</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ad23878d3f23905f6d2acd04b59b3f7f2</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>run</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ab9fe200f7fb6c3abbcf65775e92a8b2a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>quit_with_data</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aa47973e49ea88da12aae162dbd20990e</anchor>
      <arglist>(const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_remote</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a6510145fd5dce7b73b137174ffab918d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, const Glib::VariantBase &amp; &gt;</type>
      <name>signal_action_with_data</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a68d8bdfacac2782f8958880f37873a90</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::VariantBase &amp;, const Glib::VariantBase &amp; &gt;</type>
      <name>signal_prepare_activation</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ae24d06ecfa707a5b9dae1545749ac392</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, const Glib::VariantBase &amp; &gt;</type>
      <name>signal_quit_with_data</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ac89c67f5a012a0a98239f77785ee579b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>acb7cbb70f3355500b5e77ea9ffdf0cfb</anchor>
      <arglist>(const Glib::ustring &amp;appid, int argc, char **argv)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aefd0731907bfa6fc1dc4e4ce696d397e</anchor>
      <arglist>(const Glib::ustring &amp;appid)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>create_try</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a294c1472fba0d4ecc0f846ef8e28fd10</anchor>
      <arglist>(const Glib::ustring &amp;appid, int argc, char **argv)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>create_try</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>abfea21c46e0ca222ba1d9996064dd44c</anchor>
      <arglist>(const Glib::ustring &amp;appid)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>create_unregistered_try</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a9bd529b8be907a8a6de1a59a07e93981</anchor>
      <arglist>(const Glib::ustring &amp;appid, int argc, char **argv)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>create_unregistered_try</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a466dfa7d2d193be1fd65636eba0af515</anchor>
      <arglist>(const Glib::ustring &amp;appid)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>get_instance</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a22317bbc9a88d2fec309e21df68a2149</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>abff0025c16f73bb307fddbbc549f90c4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_action_with_data</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a925ceeed652758702f2d0a38fd9d9bce</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_prepare_activation</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>adfbfd4b1da019aef0f25505729612fd6</anchor>
      <arglist>(const Glib::VariantBase &amp;arguments, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_quit_with_data</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a233f3f88f2f32a110ee890479d1889c4</anchor>
      <arglist>(const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Application &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a49c378c598e06036b2ed954dd6405706</anchor>
      <arglist>(GApplication *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AsyncInitable</name>
    <filename>classGio_1_1AsyncInitable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AsyncInitable</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a48e4bd3e0a9033d24afa3a4e30d8508d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAsyncInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a17b715d899d7ff40a10e98cbc04fb950</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAsyncInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a470b482fc15de1b5ca307a9ba9c18649</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>ac9d58b099c38f8957f8780b459cd68dd</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init_async</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>ae1439e78cf813af329c36239c838b0ab</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init_async</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a05377786e1a1edd01541fd5768db65fa</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>init_finish</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>aa4ebc21d151dff891c551cb089966edd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>init_async_vfunc</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>affca6d14e16c2841101528edf768f9cc</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>init_finish_vfunc</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a14689b76b1fe02c25bf88ce0eec9f1d7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AsyncInitable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a631d18f9a5459cbb3848b2098738e6d6</anchor>
      <arglist>(GAsyncInitable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AsyncResult</name>
    <filename>classGio_1_1AsyncResult.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AsyncResult</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a9dae859748e44341d2c14a2777ca4fee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAsyncResult *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>ad7ebc2ac808bd8eff4f4cd4f94c1c70a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAsyncResult *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a134862761e05a548d2817505480140be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_source_object</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a3b89bee3ed3ff402ff58f836e1d2398e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::Object &gt;</type>
      <name>get_source_object</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>adcb9d80c42cf04098629a8153d51b32c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::ObjectBase &gt;</type>
      <name>get_source_object_base</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a65a9e867d84321b270e2b7be7b36e631</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::ObjectBase &gt;</type>
      <name>get_source_object_base</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>abd7320c43aed6281325c6ddfdb7db10e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; Glib::ObjectBase &gt;</type>
      <name>get_source_object_vfunc</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a305c556281152983343a2353e28ca05b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a27a2e7a0488f8a3db08fa9547c791c6a</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AsyncResult &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a08e7667c305f6c361345c9a8e261d73a</anchor>
      <arglist>(GAsyncResult *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::BufferedInputStream</name>
    <filename>classGio_1_1BufferedInputStream.html</filename>
    <base>Gio::FilterInputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a6d961bb2ebe9c213c1e4c49572bae6ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GBufferedInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>aa9d0c1e643650b9a45831865f06e21be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GBufferedInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>ad6b09565f69b4c1cf1f0ca05ee53709e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GBufferedInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a47dc5f78b1faed25cdaaafe42b526d6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a46384a96dc052e9d25e1a88281d69e40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>af5f861a5b30aadc48e21fb10a46afaa7</anchor>
      <arglist>(gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_available</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a436e3c852afdc67e8ba70d32e39ce6b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>peek</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a17a6489d7ab0b72268264c9f0a30e879</anchor>
      <arglist>(void *buffer, gsize offset, gsize count) const </arglist>
    </member>
    <member kind="function">
      <type>const void *</type>
      <name>peek_buffer</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a27838d9374fa86ae513bc27d939ede24</anchor>
      <arglist>(gsize &amp;count) const </arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a197687762599fb7c5b60141b55120cde</anchor>
      <arglist>(gssize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a271eab4876136b4960d37350738bfdfe</anchor>
      <arglist>(gssize count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_async</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0a41790e04e9ba500eb18d1ce8371d34</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, gssize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_async</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>aadb9c1b367e36c20c91e16ea840b6ef0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, gssize count, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill_finish</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a13c665ccc722a2544539086846137277</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a85477f09b58dfb83e5a1ef62f119457a</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a8741ffb62c82425f54bc5e005c2a238f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>add79ff7674ee8f29ed4c778d29e4ce91</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a4c14baabc1f6e3baffd38bdfb2797d55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>afc33c31f5c437df14d385d3aa9d1a37b</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedInputStream &gt;</type>
      <name>create_sized</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a47b3b1d2c774e7c322e29beb45653bf9</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, gsize size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0a81d8bea742203e775f796f73f46ea4</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a615364466836d73513cc9c052e1d0f72</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::BufferedInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>adfe9bf4339f83095d6e96dda7b747575</anchor>
      <arglist>(GBufferedInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::BufferedOutputStream</name>
    <filename>classGio_1_1BufferedOutputStream.html</filename>
    <base>Gio::FilterOutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ab2cf992f28ebf871b0025e5060356f40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GBufferedOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a6dfd09a0501267ef81030e3cf8e9ae47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GBufferedOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a4a906daf7be02fd1c1548253f5f0e95c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GBufferedOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a890c12d13d9f87332b00b785e32e4424</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a18ba1d42def3606fe3da3912046b1c11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a8044f48728b7020ba86e7364421b21fb</anchor>
      <arglist>(gsize size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a5c308a93b5538db6c614b67e015474c5</anchor>
      <arglist>(bool auto_grow=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a53501edadccf17be8908fae896d34dcc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>aa00fd9e312bc942df1c01047c1a71bd5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a9c832174c00f75f618d1d14b9056f445</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>aa898e7b7b62ff05c785cac3c3a6abf46</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a263f69601504ae97cc4b83afe19f116d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ad5cfe5126450ce9236a8c1f768aed4c5</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedOutputStream &gt;</type>
      <name>create_sized</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a32717dd0802cf24c7a7442181974a8b4</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, gsize size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>abd7e5b3a7dc3a71b5cae2214cce5e5d6</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a0a67daf674844c17385b63722e18a1ad</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::BufferedOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ab4fbaeef8ea590b6c674973d25678902</anchor>
      <arglist>(GBufferedOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Cancellable</name>
    <filename>classGio_1_1Cancellable.html</filename>
    <base>Glib::Object</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>SlotCancelledCallback</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a18d005aeefd0da4daab594f4c44ce9cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Cancellable</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a97c7c4d728865129bc6f0cd3f4ecfce7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GCancellable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ae19ec1e85fd9cd7893914d4d7c20120d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GCancellable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a668176a01f7ad3cc13c7448378f37b41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GCancellable *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a379e6394bad0fff1eb11e1a160f30235</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a47ce5f2f16541b7ae18bc5114b366d8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a80df23049daf594fda884f2932ce3b95</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_pollfd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a6627893047c8a375324b58e955661395</anchor>
      <arglist>(GPollFD *pollfd)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release_fd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad8f406bb61e80d382153ebf600822ce2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cancel</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a86adae0645cec20d09d1a2903fe46cc0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad893da5aebfb4baf34ecdbdad7a3608b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a93b5a39447d2b4eb9fb56748cb687fc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a2285370aea5d98141e742e73743b9c3e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad43ddee749e87373a2dd035f8eb989e6</anchor>
      <arglist>(const SlotCancelledCallback &amp;callback)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disconnect</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aa9277479b4bf0b80090e780e26215713</anchor>
      <arglist>(gulong handler_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a5a34d4782ccec014684c4eb6c20cf0a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Cancellable &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a8d59324b4c253f8c890901cd934203a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Cancellable &gt;</type>
      <name>get_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aaf923ce91ddf21fc03bf2902e12cd4e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Cancellable</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aab7733b6e915e4ebe280fbb669b6af2a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aff017e200824997b9c26d82f147e078f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Cancellable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ac45875da91c9c870a0f154a8249047c0</anchor>
      <arglist>(GCancellable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Credentials</name>
    <filename>classGio_1_1Credentials.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Credentials</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a50da8ce90cb83b14f364b4ae30502458</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GCredentials *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a046b2268030f002af002310500000873</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GCredentials *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ad27e3960d0694de6eb2cedc00dbcaa25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GCredentials *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ae88176bf9139ac2f8ec61fc2b243eddd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ae4852e93b213096b678584e5d90e0f0e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gpointer</type>
      <name>get_native</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a71bcd9f09372b9baeaebe515dfd98bf7</anchor>
      <arglist>(CredentialsType native_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_native</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>af513a0e52915235faf163d5de363a0bd</anchor>
      <arglist>(CredentialsType native_type, gpointer native)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_same_user</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a762d208e479db720c4e5124ed329131a</anchor>
      <arglist>(const Glib::RefPtr&lt; const Credentials &gt; &amp;other_credentials)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Credentials &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ad1d94115b234e0db180e48509fa18fd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Credentials</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a1aef06c5a74793011858b45cfd8d7898</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Credentials &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>af140151edb8dd5ccf10f9decf594b731</anchor>
      <arglist>(GCredentials *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DataInputStream</name>
    <filename>classGio_1_1DataInputStream.html</filename>
    <base>Gio::BufferedInputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DataInputStream</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae97b466761df6cccb9b4232e8dece6d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDataInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ad788764326462190e900785f50a50740</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDataInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5d8f01998854eac791a3089acef051c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDataInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a8252806b8ac5548c51a0418162ddb6ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a032c20df06b83828d3cb5e81f6b8f561</anchor>
      <arglist>(DataStreamByteOrder order)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamByteOrder</type>
      <name>get_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a3be4cc7ce927af027630cdeea0914004</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afbc8ad1476fd82e808234a661bfe4cd3</anchor>
      <arglist>(DataStreamNewlineType type)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamNewlineType</type>
      <name>get_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afe528b7ecf9401b7bf91f0c67e34de9f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guchar</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aca226b5c2d1248dd079d835dd089570d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guchar</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>af4d01aa4e791d403b79db406befcc28e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint16</type>
      <name>read_int16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9fd357f931715d83c69b7010ff86af80</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint16</type>
      <name>read_int16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a2407fa551610510cfdcda3b2d8adabdc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>read_uint16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9ac667e423ec3c3d997fc2a4683956d3</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>read_uint16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a4e99722aa033a78ac2f4dc593b36d197</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>read_int32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a6280a6c0c6cc1803dc3df8dc29910bcd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>read_int32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>adbbe894fae2ba5d071c3f50895af9067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>read_uint32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae7d36dbd67425b923fe335ec5a3f4124</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>read_uint32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a587856139c73d6c2df1ad2c5560cffec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>read_int64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5d9599527bcd651841fd4f73082d26e0</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>read_int64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a6ccd4123a211d1d89c17bb6e4a4aae35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>read_uint64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a2e486863876f833e910286300c7e17a4</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>read_uint64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9c7ed7807b2a8370f879a820dd0c7989</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a4e1ac2a250c7acd60417454379d580a7</anchor>
      <arglist>(std::string &amp;line, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5186689410fe626e35688190b65ec0c5</anchor>
      <arglist>(std::string &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aad31c733d13f737f893326b3b7f1ff0d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a538562b9bf3a80138ba9918b2249f834</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a058c5367f9be4e4e36d5fb9de2201815</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa7d2a04bf5a4628df0530ec40d4c33cf</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_until_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a708cba487c68c8c927fe8ae6277b6123</anchor>
      <arglist>(const std::string &amp;stop_chars, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa851cb398896f39bea56868b46bd480d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>acbc9d655a3a0475f6b921be899bc6cdc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>abb65c759a942acd59a82c1d124dda033</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamNewlineType &gt;</type>
      <name>property_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9b0be8e7ee14c413ba0e8c9b8e1acc1e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamNewlineType &gt;</type>
      <name>property_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a0aa39af96006289ad64d04d5a6c3c293</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DataInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5ecca0b3f4fdc5962c3c63e4e6706e4e</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DataInputStream</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a65e68eef09e6aa1d9e52d446a171fba3</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DataInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a88853a1864df25dc8dda900a6ad52266</anchor>
      <arglist>(GDataInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DataOutputStream</name>
    <filename>classGio_1_1DataOutputStream.html</filename>
    <base>Gio::BufferedOutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DataOutputStream</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad59e02b7e431eed80a7e8280576e4145</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDataOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>acf92da9c162b7a0805aabe334912d5cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDataOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a42d4127b7b7b16ae6ec3feb5f66b68d2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDataOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac1e10167167a2f5c894e567003483419</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad35d1b14012a1f4ce7aeca8e73a0560a</anchor>
      <arglist>(DataStreamByteOrder order)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamByteOrder</type>
      <name>get_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad9d00dd1dbb4e42186049130601e3117</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_byte</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a193a3d737db19250895ad4329b82a602</anchor>
      <arglist>(guchar data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_byte</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a82d0f12bac635dc5889847c4911c3407</anchor>
      <arglist>(guchar data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a967df26dca9c0948d78bd495800eeda3</anchor>
      <arglist>(gint16 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a29c0d46538383ed82d622068d826d06e</anchor>
      <arglist>(gint16 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa0f8a4fda83e453a49d5cf614868b392</anchor>
      <arglist>(guint16 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa222bd351437698643820251e28a406d</anchor>
      <arglist>(guint16 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac405b5c957d34ff068fb07a30dbb5f09</anchor>
      <arglist>(gint32 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac02e3766459a8bb970022ff3991d841e</anchor>
      <arglist>(gint32 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a4851b514c9f3ca166b581b35f530ea71</anchor>
      <arglist>(guint32 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a16cdae2dd633a4afaea583baa7d10d44</anchor>
      <arglist>(guint32 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac7efa2d21047145f79fd651129b372f2</anchor>
      <arglist>(gint64 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>abbe60cbe43ae446cef3a7c9764a6fe08</anchor>
      <arglist>(gint64 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a4a16076bd66c8f2e249ecde22f9762c1</anchor>
      <arglist>(guint64 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a5dfd43d27380c031314adf0dc67b4cb4</anchor>
      <arglist>(guint64 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_string</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a11a8e87ba2da06727d2c8751214b7055</anchor>
      <arglist>(std::string str, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_string</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ababf1898b1e49d7d16fdacdfe38db3f3</anchor>
      <arglist>(std::string str)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aba9c94369d178cf798bd77b8be4a6731</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>af1b6575e76c4c07d8b563079d80a1bcd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DataOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa9c23f0bf4d13c5a4ca5b7bb03991928</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DataOutputStream</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ab01b287da67c8d2312a82f03de59916f</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DataOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a53e38b7e7370532ed71a1f434050043a</anchor>
      <arglist>(GDataOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusAuthObserver</name>
    <filename>classGio_1_1DBusAuthObserver.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DBusAuthObserver</name>
      <anchorfile>classGio_1_1DBusAuthObserver.html</anchorfile>
      <anchor>ac8bd05ae3a9a8f1992a9ccfe4816e22f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusAuthObserver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusAuthObserver.html</anchorfile>
      <anchor>a1ce9e2a8ebbe959158343b678b664d0f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusAuthObserver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusAuthObserver.html</anchorfile>
      <anchor>a5d2ce92a9cd7ebe8020ef7d68d3146c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusAuthObserver *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusAuthObserver.html</anchorfile>
      <anchor>a9faeb42fbe7ea4d5233e2973b0f5362c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>authorize_authenticated_peer</name>
      <anchorfile>classGio_1_1DBusAuthObserver.html</anchorfile>
      <anchor>af482b55e4aa397cd8d2f4534a966bd5d</anchor>
      <arglist>(const Glib::RefPtr&lt; const IOStream &gt; &amp;stream, const Glib::RefPtr&lt; const Credentials &gt; &amp;credentials)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; bool, const Glib::RefPtr&lt; const IOStream &gt; &amp;, const Glib::RefPtr&lt; const Credentials &gt; &amp; &gt;</type>
      <name>signal_authorize_authenticated_peer</name>
      <anchorfile>classGio_1_1DBusAuthObserver.html</anchorfile>
      <anchor>a1a7a4910a22a79628f0d480df6c0363f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusAuthObserver &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBusAuthObserver.html</anchorfile>
      <anchor>a91c8e211c8e05ea671f37995d88d5dfc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusAuthObserver</name>
      <anchorfile>classGio_1_1DBusAuthObserver.html</anchorfile>
      <anchor>ade4a9e426ed2744edfb8ddb868832f02</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusAuthObserver &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusAuthObserver.html</anchorfile>
      <anchor>a873effa08e9bd5691b01cbb66cc25a50</anchor>
      <arglist>(GDBusAuthObserver *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusConnection</name>
    <filename>classGio_1_1DBusConnection.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Initable</base>
    <base>Gio::AsyncInitable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DBusConnection</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>aa3b9e63537e6ba6a6d3c890a82b895f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>aa1543bb6bcc2bd51779eaf45c12aafb9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a59a7e7092ff6f227510c9dd193536964</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusConnection *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>aa986c89dceeb9229d0293ecf9e655751</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>acdb337f84e377e1f2a5fa0c6ab4b99c1</anchor>
      <arglist>(BusType bus_type, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a16f6c2000794f6cb1f53ed8fb25e6283</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const Glib::ustring &amp;guid, DBusConnectionFlags flags, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_for_address</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a76485e3f6104e4b7d7e45b8339578d59</anchor>
      <arglist>(const Glib::ustring &amp;address, DBusConnectionFlags flags, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusConnection &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>aa1fe1d7fefd51a29e97a717dbb345416</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const Glib::ustring &amp;guid, DBusConnectionFlags flags, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusConnection &gt;</type>
      <name>create_for_address</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a00cdb1ed3808aeffa94ac86ab9e29ef9</anchor>
      <arglist>(const Glib::ustring &amp;address, DBusConnectionFlags flags, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a04483985388a4ec47207c7c60fba50a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>ae0bc6407b4607c6ec4d702aadf1c89c7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a2ca4f7964cbdd70b764951a55f10092d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a0ae468dd5d145d2fe301589be66e62f0</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_sync</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>af345620d52528d2a9318116877551dea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_sync</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a6324be45b24b1eb6135c1e06b5214465</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>acc06ad9754686df18cef948041d0359b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>ac23d6fc43a1764b413e520a8179da5f4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>ac40dd7f2b16eb6f5f2faa50774e9beee</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush_finish</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a1ba96bc969cb44e61c654e2ff97186e9</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_sync</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a4f33c7131fcf50d65035690adfa17513</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_sync</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a1b35360c8fa465f0a095069b7c9e0628</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send_message</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a988b39697acce53c021433c9506d94ec</anchor>
      <arglist>(const Glib::RefPtr&lt; DBusMessage &gt; &amp;message, DBusSendMessageFlags flags, guint32 *out_serial)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>send_message_with_reply</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>afeedd9e1786e1bf29e17af0ffb91b05a</anchor>
      <arglist>(const Glib::RefPtr&lt; DBusMessage &gt; &amp;message, int timeout_msec, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusMessage &gt;</type>
      <name>send_message_with_reply_finish</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a382e5ebbb16ab832b0316ee7660fd73e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start_message_processing</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a5173407f64fd5c3e8bb205ae6493b1ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>abc387a7fc6af302247df1bbf5e4b1801</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a13b400fe299d4bba4190363b3185fc16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const IOStream &gt;</type>
      <name>get_stream</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a7cd85c96292319d0e5cf1bc8b64d8bc2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_guid</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a49365f4b57fd0523e6add50a631f4c52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_unique_name</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>accf07401232a4e4fece115674ba37dbf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Credentials &gt;</type>
      <name>get_peer_credentials</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>aa1cdf09bac65570377a12a82d9c066d3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Credentials &gt;</type>
      <name>get_peer_credentials</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a51cc6f3cbc2b8da88c7f63a186be17db</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_exit_on_close</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a09f5cd7a7cd7cffb9742e0414b0b8e12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_exit_on_close</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a6c734559a5b03ad87f34daa5deccc118</anchor>
      <arglist>(bool exit_on_close=true)</arglist>
    </member>
    <member kind="function">
      <type>DBusCapabilityFlags</type>
      <name>get_capabilities</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a013c16067f4276d3fcc28e9482e33860</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusConnection &gt;</type>
      <name>get_finish</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a5dcf3005f8913e6ceeb6b1f54a831c16</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusConnection &gt;</type>
      <name>create_finish</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a060727e65b630ac4332d8691abaf4e17</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusConnection &gt;</type>
      <name>create_for_address_finish</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a83c6158d5c58560d13f264609c73b1e4</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusConnection</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>aedbfda4597ae2c230cb05d764fccc577</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const Glib::ustring &amp;guid, DBusConnectionFlags flags, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusConnection</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>af93a00fe1f0c42b8731aeed29b68fcb1</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const Glib::ustring &amp;guid, DBusConnectionFlags flags, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusConnection</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>abca923cafc5108e4294004d3322853c3</anchor>
      <arglist>(const Glib::ustring &amp;address, DBusConnectionFlags flags, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusConnection</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a4b006faccd9a9e30020776c44ad13a1b</anchor>
      <arglist>(const Glib::ustring &amp;address, DBusConnectionFlags flags, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusConnection &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusConnection.html</anchorfile>
      <anchor>a2d3ef8b87757c6f31b7354e461f8d666</anchor>
      <arglist>(GDBusConnection *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusAnnotationInfo</name>
    <filename>classGio_1_1DBusAnnotationInfo.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1DBusAnnotationInfo.html</anchorfile>
      <anchor>a2a6465fa872aca9e8675ea5a934f90f5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1DBusAnnotationInfo.html</anchorfile>
      <anchor>a6ef4a4abb03795c8bea9c9e7de345093</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusAnnotationInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusAnnotationInfo.html</anchorfile>
      <anchor>ad3fad25eae6628a9eab1a11845c0ed0f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusAnnotationInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusAnnotationInfo.html</anchorfile>
      <anchor>ad6e8f6cb3c6985332bb45292f3a43f8e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusAnnotationInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusAnnotationInfo.html</anchorfile>
      <anchor>aff83e3b0643b0ddf24d089dee5a034c2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>info_lookup</name>
      <anchorfile>classGio_1_1DBusAnnotationInfo.html</anchorfile>
      <anchor>a1ff86b196833f054437416b9bf8445de</anchor>
      <arglist>(const Glib::ArrayHandle&lt; Glib::RefPtr&lt; DBusAnnotationInfo &gt; &gt; &amp;annotations, const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusAnnotationInfo</name>
      <anchorfile>classGio_1_1DBusAnnotationInfo.html</anchorfile>
      <anchor>a494305d3d724a096726651b60043954a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1DBusAnnotationInfo.html</anchorfile>
      <anchor>ac663693c9f55fa72b69fdd7d63417624</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusAnnotationInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusAnnotationInfo.html</anchorfile>
      <anchor>a4aa5217ab033b6193afe1aad9af15f4b</anchor>
      <arglist>(GDBusAnnotationInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusArgInfo</name>
    <filename>classGio_1_1DBusArgInfo.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1DBusArgInfo.html</anchorfile>
      <anchor>a2f665cd6a5579980bd678a396366d4d7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1DBusArgInfo.html</anchorfile>
      <anchor>ae018cd0066e160d56a46b1b736b39554</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusArgInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusArgInfo.html</anchorfile>
      <anchor>a5e6f0ad30b1d02d1db4acda3ce2db5f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusArgInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusArgInfo.html</anchorfile>
      <anchor>ab5213c5fd38292ad56b74a156a250030</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusArgInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusArgInfo.html</anchorfile>
      <anchor>ad5f803938ae9572ac3402cecca92c8ac</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusArgInfo</name>
      <anchorfile>classGio_1_1DBusArgInfo.html</anchorfile>
      <anchor>a8b2ca8ec08839e29a68dfc1eaa3a344c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1DBusArgInfo.html</anchorfile>
      <anchor>a017aca8cf20ddebd090f33b328af549b</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusArgInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusArgInfo.html</anchorfile>
      <anchor>a9cb7ca34ac6cc29e7fffad9d5a4602b1</anchor>
      <arglist>(GDBusArgInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusMethodInfo</name>
    <filename>classGio_1_1DBusMethodInfo.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1DBusMethodInfo.html</anchorfile>
      <anchor>aae5c5351c84f8738b04bbf63ab1c6280</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1DBusMethodInfo.html</anchorfile>
      <anchor>a74d9e85c20544ddb76df8f8c53d01606</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusMethodInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusMethodInfo.html</anchorfile>
      <anchor>a42c3d75b49e4bfd396287190c7fb2e1b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusMethodInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusMethodInfo.html</anchorfile>
      <anchor>a31ba10a8cdf7e49aef8c4d8e7b4006ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusMethodInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusMethodInfo.html</anchorfile>
      <anchor>a9a6266f6e085dcaff5e34b8ab7a5bec2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusMethodInfo</name>
      <anchorfile>classGio_1_1DBusMethodInfo.html</anchorfile>
      <anchor>abf6c1e3e0851cbece4fd6d7e733865fc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1DBusMethodInfo.html</anchorfile>
      <anchor>aa8488448843988d097e07d4fa91d5eef</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusMethodInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusMethodInfo.html</anchorfile>
      <anchor>ade7ff57e28d5fd00006a6d79cefa28d7</anchor>
      <arglist>(GDBusMethodInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusSignalInfo</name>
    <filename>classGio_1_1DBusSignalInfo.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1DBusSignalInfo.html</anchorfile>
      <anchor>a6c0a4b9ab91b73094fca13db4d39e4bc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1DBusSignalInfo.html</anchorfile>
      <anchor>aae8451345e40082b172c106270d43588</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusSignalInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusSignalInfo.html</anchorfile>
      <anchor>ac0f257e3661197b5c96e3c69dc9156ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusSignalInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusSignalInfo.html</anchorfile>
      <anchor>a0cac7574a874b3e0d35cc5ddfc01b3a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusSignalInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusSignalInfo.html</anchorfile>
      <anchor>ac5927795255acbb7e28cfa5983667172</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusSignalInfo</name>
      <anchorfile>classGio_1_1DBusSignalInfo.html</anchorfile>
      <anchor>a98f19c7f4cb853b9167f6b1000c34635</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1DBusSignalInfo.html</anchorfile>
      <anchor>a9265f3c969dad722f0cc02b7e751adb5</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusSignalInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusSignalInfo.html</anchorfile>
      <anchor>a961c4d39f89591ec1e60aeeaa40e0b84</anchor>
      <arglist>(GDBusSignalInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusPropertyInfo</name>
    <filename>classGio_1_1DBusPropertyInfo.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1DBusPropertyInfo.html</anchorfile>
      <anchor>ad5dc991d6dfc2245761f8778ea5dd2b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1DBusPropertyInfo.html</anchorfile>
      <anchor>ab178766bf9bcd3c6adb50560d3dd5e4c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusPropertyInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusPropertyInfo.html</anchorfile>
      <anchor>a4de64a48f996fd95a8914f5014cae97d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusPropertyInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusPropertyInfo.html</anchorfile>
      <anchor>aa8fe5908ebbe0d876d4280d8bed3c444</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusPropertyInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusPropertyInfo.html</anchorfile>
      <anchor>a690363233b32e180dbda081aca4a2e31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusPropertyInfo</name>
      <anchorfile>classGio_1_1DBusPropertyInfo.html</anchorfile>
      <anchor>a1cac1088f31c3ff9b790fe4ddfac1384</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1DBusPropertyInfo.html</anchorfile>
      <anchor>a659e766b7b50a2a0e360a258517dc9c7</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusPropertyInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusPropertyInfo.html</anchorfile>
      <anchor>a03b2b19a2d44d032d611b1f1a7c39c7c</anchor>
      <arglist>(GDBusPropertyInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusInterfaceInfo</name>
    <filename>classGio_1_1DBusInterfaceInfo.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>af4def3290cd17c71146a9acde9fb5709</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>a9c8891318750e7fbc90d3dcd8be10e47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusInterfaceInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>add129b5527d7195798f46271c0469d92</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusInterfaceInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>a9517e06a670e4e6258fe0f38c939dae9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusInterfaceInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>aa11096f3f2eab19aec477445832bf7af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusMethodInfo &gt;</type>
      <name>lookup_method</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>ac0ead9b53f8cdc8968c71850e188ee7c</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBusMethodInfo &gt;</type>
      <name>lookup_method</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>a874f269b2406f9277054ad050a9b9593</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusSignalInfo &gt;</type>
      <name>lookup_signal</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>af3f8aff1ad96d4cd47c588e8db9c0af5</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBusSignalInfo &gt;</type>
      <name>lookup_signal</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>adad82232f7c36373c9f38655d58992b5</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusPropertyInfo &gt;</type>
      <name>lookup_property</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>abb3f8c8bc6b68cd81bec29d8015a1a25</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBusPropertyInfo &gt;</type>
      <name>lookup_property</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>a8016fbd8ef8765741dbfe96572eb1f32</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusInterfaceInfo</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>ac4b6c49c82697a504b5b527ee108b4a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>a3e959d164c1ceb5afce5303848714299</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusInterfaceInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusInterfaceInfo.html</anchorfile>
      <anchor>a7f6ac3536e564a392321fe4487d30018</anchor>
      <arglist>(GDBusInterfaceInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusNodeInfo</name>
    <filename>classGio_1_1DBusNodeInfo.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>ada03e891a18c66f22c85c2e22203e89e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>a0bebce42fa8546aee68d2fbad3ecd6d1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusNodeInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>a975139e79b901daa5f7cda9514aa51ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusNodeInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>a50d6699c87438408359ad387be4c9388</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusNodeInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>a8556383a953c7cfedefe6ab2908c25ed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusInterfaceInfo &gt;</type>
      <name>lookup_interface</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>aee674fbbdc481e1122702d150ae1beb9</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBusInterfaceInfo &gt;</type>
      <name>lookup_interface</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>a75d77feb9c1bfe95165d0b9b4a0bce99</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusNodeInfo &gt;</type>
      <name>new_for_xml</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>a57f4f41ad673678bbddd145bd6093c05</anchor>
      <arglist>(const Glib::ustring &amp;xml_data)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusNodeInfo</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>afdb7538edbfe5f330cbe98551c85d899</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>a15497627562e73bb4f868492759eeb09</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusNodeInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusNodeInfo.html</anchorfile>
      <anchor>a5f9c738e3cf1a835406804aa505b19ad</anchor>
      <arglist>(GDBusNodeInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusMessage</name>
    <filename>classGio_1_1DBusMessage.html</filename>
    <base>Glib::Object</base>
    <member kind="enumeration">
      <name>ByteOrder</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aed8f90819dacfd90d5c7b9cd7bcf8890</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BYTE_ORDER_BIG_ENDIAN</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aed8f90819dacfd90d5c7b9cd7bcf8890a4739e900d1eeb03a3fc27345a5567fe7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BYTE_ORDER_LITTLE_ENDIAN</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aed8f90819dacfd90d5c7b9cd7bcf8890a47bab0a10bdc7af3d8e67e178d3add27</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DBusMessage</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ab8ef37b19d59585a0bf8e49d80702a33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a140006b83093a0bac2e8c13d065a6c94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a99e9ea025b9e626e88f0df568c46189a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusMessage *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ad1f07bc9e2b07a64183b6703978824a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>print</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ace4cbef0ac0b8b44ce0d888bba5bdc47</anchor>
      <arglist>(guint indent)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_locked</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a38d26cba9a26b24e2ecd0a7b068e20af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lock</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a89416f57db36211cd9855d2d8b570203</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusMessage &gt;</type>
      <name>copy</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aba1482b2ad0a3f57cc490f9c782634af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DBusMessageType</type>
      <name>get_message_type</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aedec7a811335ae627fd8374ac5b2878b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_message_type</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a459180437ff5c93e765f2316463bdbf8</anchor>
      <arglist>(DBusMessageType type)</arglist>
    </member>
    <member kind="function">
      <type>ByteOrder</type>
      <name>get_byte_order</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a37ca0cf80319eaaf1c406c54430815e7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_byte_order</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aae7406372c0d583cebbe0413dc8b5a07</anchor>
      <arglist>(ByteOrder byte_order)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_serial</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aeb7bc3f60da160500bf57f86840372fe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_serial</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a013b7850769b1dbb68a7969f9e67592b</anchor>
      <arglist>(guint32 serial)</arglist>
    </member>
    <member kind="function">
      <type>DBusMessageFlags</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a11aebe9b869d3c305fd564e13eae7e3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_flags</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a8d742162e6705314f2fb86019925d97d</anchor>
      <arglist>(DBusMessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_body</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ace739af60c10c7a56826e61a402c79de</anchor>
      <arglist>(Glib::VariantBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_body</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aa42a790da3018175140b7535625eeb81</anchor>
      <arglist>(const Glib::VariantBase &amp;body)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_num_unix_fds</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>acabb101a1d718116782810986d8b635d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_num_unix_fds</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>abbf0474631a836a6d5bb03a3bc7d68ff</anchor>
      <arglist>(guint32 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_header</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aff17139a926e004c8724847e5757d942</anchor>
      <arglist>(Glib::VariantBase &amp;value, DBusMessageHeaderField header_field) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_header</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>addfe978af9571df662891a9d3d752c29</anchor>
      <arglist>(DBusMessageHeaderField header_field, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; guchar &gt;</type>
      <name>get_header_fields</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a3bd0787d9d95bbbbb72b4da685185c03</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_destination</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>abf74ec0f2a962827b0ff435d507b01fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_destination</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a8ee75928abcb42c58586d4303025e507</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_error_name</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ad274a328b8b74973b4a74c89e191ae0b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_error_name</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a77e18d9755f2a1fe28c78963312fdd92</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_interface</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a701e4b25304e8347bf7b79bf72d64418</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_interface</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a84785fb56fec2101b7c8499ac3768675</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_member</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aa27dd44036ee8908d1b12fdfdbf8ea2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_member</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a77ef7cab87bae0ec56e27942c98becd1</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_path</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a497236141948f392e122d8b0bbb31a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_path</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>af5392fa590a5fb87d926ee2f4209e86c</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_reply_serial</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a88055a8faf95213d70b4f2516fc6c8ed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_reply_serial</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ab5e54aaf131e25b845a2ea5032e4e362</anchor>
      <arglist>(guint32 value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sender</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a9fe811fc4939d985c272eb32b4d8846f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_sender</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>abbbdcdf80c9eb5692baa68917513dec8</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_signature</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a62fbfb787043d41c34a4925379482aa7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_signature</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a6e8a70ea9bd334d3632627958632da0c</anchor>
      <arglist>(const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_arg0</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aad5188449301495c927b2361dc7a8516</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guchar *</type>
      <name>to_blob</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a17c20645c52a28c5be818f7073cbc96c</anchor>
      <arglist>(gsize &amp;out_size, DBusCapabilityFlags capabilities=DBUS_CAPABILITY_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>to_exception</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a411d017acaf870d7cfa011383cb90d15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusMessage &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a5ca38e805ea8e37d5e4158103e37f33a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusMessage &gt;</type>
      <name>create_signal</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ad3903a81427083374b226052c4bb7d89</anchor>
      <arglist>(const Glib::ustring &amp;path, const Glib::ustring &amp;interface, const Glib::ustring &amp;signal)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusMessage &gt;</type>
      <name>create_method_call</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>aa68a3fda2aff661c69b04b47439ba8ee</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::ustring &amp;path, const Glib::ustring &amp;interface, const Glib::ustring &amp;method)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusMessage &gt;</type>
      <name>create_method_reply</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ac85df511d1ab23ff5afe0ab45c26c93a</anchor>
      <arglist>(const Glib::RefPtr&lt; DBusMessage &gt; &amp;method_call_message)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusMessage &gt;</type>
      <name>create_method_error_literal</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>abc3f7f1f3d64b4974f2cfbaff54401fa</anchor>
      <arglist>(const Glib::RefPtr&lt; const DBusMessage &gt; &amp;method_call_message, const Glib::ustring &amp;error_name, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusMessage &gt;</type>
      <name>create_from_blob</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>adf1f3a7b078382e170480dac9188e21c</anchor>
      <arglist>(const guchar *blob, gsize blob_len, DBusCapabilityFlags capabilities=DBUS_CAPABILITY_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static gssize</type>
      <name>bytes_needed</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ab10051312dd036c329683ed4cf8a6f2a</anchor>
      <arglist>(const guchar *blob, gsize blob_len)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusMessage</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>ad86e1ed91764cdc2d4f8b9fc07d1242c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusMessage &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusMessage.html</anchorfile>
      <anchor>a08aa49cff18a128a8e6661bda5365e83</anchor>
      <arglist>(GDBusMessage *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusMethodInvocation</name>
    <filename>classGio_1_1DBusMethodInvocation.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DBusMethodInvocation</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a8e31c02da11f69148a799af26640b0f4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusMethodInvocation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a64e2ce3475d074da42a180ccc7b53f61</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusMethodInvocation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a65b0ae9f22cfa45c3ce1ca250271776f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusMethodInvocation *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>acf65e9ab940d6bebcd455868bd0991c9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sender</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>ae46a89e817088298df24f8a824b98754</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_object_path</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>acd75ab126155146a14402f6e4858537d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_interface_name</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a2f7ca890a030e9c8255cf2af6939d384</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_method_name</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a49240b965c2edf3c2102d907363bc1ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBusMethodInfo &gt;</type>
      <name>get_method_info</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a3fee1135b7ef7586f8d42c3c6267678a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusConnection &gt;</type>
      <name>get_connection</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a76fdb7f702f5c6f122bfc37ec4b6227c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBusConnection &gt;</type>
      <name>get_connection</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a98e71d578f57289f1a0afe0fde26791a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusMessage &gt;</type>
      <name>get_message</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a606062f667208d8793d7cea2c2113deb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBusMessage &gt;</type>
      <name>get_message</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>ac7d549e4ff1a203ca91c796a3490877e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_parameters</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a2762423f96ca77ee5759777311e5d650</anchor>
      <arglist>(Glib::VariantBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>return_value</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a4286c4c5142afa68b2f24c1272e75bd3</anchor>
      <arglist>(const Glib::VariantBase &amp;parameters)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>return_error_literal</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>af25eeb77ac232e16d5cbeace0ffdff57</anchor>
      <arglist>(const Glib::ustring &amp;domain, int code, const Glib::ustring &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>return_gerror</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>ac12d678158144e117cf12b82ba9d2ac5</anchor>
      <arglist>(const Glib::Error &amp;error)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>return_dbus_error</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a06f0d3d3beb7e98d8c24f49dae9e19e5</anchor>
      <arglist>(const Glib::ustring &amp;error_name, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusMethodInvocation</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a1434bc6df6dc3745d151b597005f4d44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusMethodInvocation &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusMethodInvocation.html</anchorfile>
      <anchor>a247c30876948cb3c635065b5ed28cb4d</anchor>
      <arglist>(GDBusMethodInvocation *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusProxy</name>
    <filename>classGio_1_1DBusProxy.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Initable</base>
    <base>Gio::AsyncInitable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DBusProxy</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a43727252941557ea381ace8a644e38b7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusProxy *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>aec80f5ad9526f2500df3a8b0d895c1ba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusProxy *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a401074755d6909c2b09c67697fb43822</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusProxy *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a3cdc4142d721de4c4f6b7fb95a85af82</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DBusProxyFlags</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>ac5ec5f7c8b452a8f15abf1bb8e7229ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusConnection &gt;</type>
      <name>get_connection</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a9535003548572fa3489641e68521e4a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBusConnection &gt;</type>
      <name>get_connection</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a98ad7746300280d51fd786a8354beebd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>ac8d98fee63b9a69a56aa32753554ce2f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name_owner</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>ae6c2d3ccdfbedf66e84d2d0a3ce68383</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_object_path</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a9334c30232a2302c5c6656f5cfc4261e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_interface_name</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a15c88e7bbb0cf2ff0ea23dc7511494b0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_default_timeout</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>ad57bf50d03b8d42a40eb6a64688b4400</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_default_timeout</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>ac0dda7202a5aaf136f7570b4bb1ebfc4</anchor>
      <arglist>(int timeout_msec)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_cached_property</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>ad11472e620bc5d7214d8b15080e93dc4</anchor>
      <arglist>(const Glib::ustring &amp;property_name, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_cached_property_names</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a6d96dd7f7cd2c807c8e1e503db275ae7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_interface_info</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a2fd60dc5e201ced6e47da34d464d3b8e</anchor>
      <arglist>(const Glib::RefPtr&lt; DBusInterfaceInfo &gt; &amp;info)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; DBusInterfaceInfo &gt;</type>
      <name>get_interface_info</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a1c23b9b40824f7dd8439a4abcf5b1c04</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const DBusInterfaceInfo &gt;</type>
      <name>get_interface_info</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>aa1aba91e6b5014b68eb30876b04938ef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>ae971edfd61039203d9ca4a9115a7d6a7</anchor>
      <arglist>(const Glib::RefPtr&lt; DBusConnection &gt; &amp;connection, DBusProxyFlags flags, const Glib::RefPtr&lt; DBusInterfaceInfo &gt; &amp;info, const Glib::ustring &amp;name, const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusProxy &gt;</type>
      <name>create_finish</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a0f8604d8e01ba7695ec5a55af7ac9132</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusProxy &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>aa71bc49bc92952bf12026aaa73bf51b3</anchor>
      <arglist>(const Glib::RefPtr&lt; DBusConnection &gt; &amp;connection, DBusProxyFlags flags, const Glib::RefPtr&lt; DBusInterfaceInfo &gt; &amp;info, const Glib::ustring &amp;name, const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create_for_bus</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a5a510c3e3362e801cb81cf40e2710225</anchor>
      <arglist>(BusType bus_type, DBusProxyFlags flags, const Glib::RefPtr&lt; DBusInterfaceInfo &gt; &amp;info, const Glib::ustring &amp;name, const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusProxy &gt;</type>
      <name>create_for_bus_finish</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a474883490c848dc6d827acabcbcb9e92</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusProxy &gt;</type>
      <name>create_for_bus</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>aa7d0f0f72b480340ede3efd68dbae795</anchor>
      <arglist>(BusType bus_type, DBusProxyFlags flags, const Glib::RefPtr&lt; DBusInterfaceInfo &gt; &amp;info, const Glib::ustring &amp;name, const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusProxy</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a20acf008116bcecfd33df16318c716ca</anchor>
      <arglist>(const Glib::RefPtr&lt; DBusConnection &gt; &amp;connection, DBusProxyFlags flags, const Glib::RefPtr&lt; DBusInterfaceInfo &gt; &amp;info, const Glib::ustring &amp;name, const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusProxy</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>ab78b9270412f23ee002288a6e3b8edac</anchor>
      <arglist>(const Glib::RefPtr&lt; DBusConnection &gt; &amp;connection, DBusProxyFlags flags, const Glib::RefPtr&lt; DBusInterfaceInfo &gt; &amp;info, const Glib::ustring &amp;name, const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusProxy</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a5eac8e059756af7e5ef259f828b2b103</anchor>
      <arglist>(BusType bus_type, DBusProxyFlags flags, const Glib::RefPtr&lt; DBusInterfaceInfo &gt; &amp;info, const Glib::ustring &amp;name, const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusProxy</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>abbb9eca84aaeb8c1cc1f56b25c651598</anchor>
      <arglist>(BusType bus_type, DBusProxyFlags flags, const Glib::RefPtr&lt; DBusInterfaceInfo &gt; &amp;info, const Glib::ustring &amp;name, const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusProxy &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusProxy.html</anchorfile>
      <anchor>a79bac1b0bab3e1e893042211fbf0b1f2</anchor>
      <arglist>(GDBusProxy *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBusServer</name>
    <filename>classGio_1_1DBusServer.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Initable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DBusServer</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>ae7e5afb214a40ddb5850e54b3f5f8f7f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusServer *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a3cb22b7a5095c437be7dad5ba545a785</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusServer *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>aab17312536fc565b1762e9a738950809</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusServer *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>aef96cb7b1d64f5a495affa62d940e486</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a3f5b8ec8a4c43b588b2c05a07bd6176d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a62fba535c372ff343ebd3009fc3b0616</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_active</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a4ac705fa917b5ffe85998bbc6d8a12ef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_guid</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a90b91dc5d4f4b4aca1ff76fce4d315f4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DBusServerFlags</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a93f2234b04b4d627b4691edd69f5004e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_client_address</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a3d4b0a5f374207649e47bbbe45271d8e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_active</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a9380ed61cb1c38d0957e61814104e73e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_address</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a42867f9ec1c248ed8d3c1f447aca6946</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; DBusAuthObserver &gt; &gt;</type>
      <name>property_authentication_observer</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a085148efbf0d2711d6407e22d51948ee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_client_address</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>abfd95c8ad9880090b0b4013a6756b82b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DBusServerFlags &gt;</type>
      <name>property_flags</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>ab147868fe00f35b5a0c2da4a18e75c07</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_guid</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>aebf98104ae4ad3d3d2e992ed96557b13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; DBusConnection &gt; &amp; &gt;</type>
      <name>signal_new_connection</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>a5da842de0b602ac2e7fca91f30af5ddf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DBusServer &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>ac7c48310b1c8e6639954023559a2d829</anchor>
      <arglist>(const Glib::ustring &amp;address, const Glib::ustring &amp;guid, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;(), DBusServerFlags flags=Gio::DBUS_SERVER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DBusServer</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>aac1f76dd83da7c15f41c95c5c8526b6c</anchor>
      <arglist>(const Glib::ustring &amp;address, const Glib::ustring &amp;guid, const Glib::RefPtr&lt; DBusAuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, DBusServerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBusServer &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBusServer.html</anchorfile>
      <anchor>ac74fb8428ca4b6c440ac54a9051baded</anchor>
      <arglist>(GDBusServer *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Drive</name>
    <filename>classGio_1_1Drive.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Drive</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a92df3dab950a06a57ea2f5080b917a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDrive *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aaa1d4330f6e1d0faee6262f632c63227</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDrive *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ada0bdfcbce80c94f4b080f6de73706df</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a29125b6262e95613e92266221584ab2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa7bbfe3d9eb4c716e4e964388b504458</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ad0407bd1e193689a5b088abac49f581c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_volumes</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a42a2753bc97ae014a1649dc53b4acfae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Volume &gt; &gt;</type>
      <name>get_volumes</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>afe6e5759dcf759a1c862e172543d6bd3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_media_removable</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa9c9b3db01d76f26527702860498b531</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ad5397764c7a76adf9a0d8bc4f419fbe3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_media_check_automatic</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a0cbbb630e6f944f2cd078219d7e35cc7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a538ad0e01c3359d7d75e8389eb54dec0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a63d1960ea469bdb1a61ddf1752a6e9b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a4163a79cc5ff639693159110592e6be0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a7677be984564a7cf3c5ab7dd3ebb6c96</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a306949d0008fd30a59136e0759dd60ed</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a21a808bb07f7cb580899006fd42c76ea</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>af66cf6ad9b9027630f1c9303bbb6a8fe</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>acb804853bd5e4ecf4abc6503e6ffa82d</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>abdc299d32ba4dd96784db3a9a4523ea4</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1733be3e6aa7c23caa3c12a45d75878d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1c565d20c1f17a233db75dec9ce30415</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a85bd972cad1ef7e1c2627767a825eed0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>poll_for_media_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>afa415ce0439367e5d8685a2bb1bd9b8d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_identifier</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a6a94c55bba839fa834ba18bc4ef41c39</anchor>
      <arglist>(const std::string &amp;kind) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>enumerate_identifiers</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a8c6c6c5597208c8cc9610b5f2d9f8107</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a48cae86204823873e110ecdf7948a5c3</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a99ca25e21f33f54e79b9d62e47ddda71</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a7d81d812989e5dc79414c63149dda9d7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a2594f0176716f8aec2464a3b4dc856a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_start_degraded</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ac047620f769a455b2ca3869bf725e9eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a037cd31001af5d6d0540f4ccbe7b12bf</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1adf5f0d63a2d3a38acc4328f726f7ed</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stop_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a308102dbcef3dac0a3ad0006a0c1440e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a79c25c1986a1e46ca8dcdf8e331b4dba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DriveStartStopType</type>
      <name>get_start_stop_type</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a5c9954887834a697b9417188c4e0ccb0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>abda915e1b5fff2be69fc28bbbba05736</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_disconnected</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa65a212796147d65d4fa953755c33b6e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_eject_button</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aae48457a354c2bbde87b27c991bf867d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_stop_button</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a37a763ad90197500323edacc4e6a8f63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a4a00b2efd7a10fae3ffc6e67f30b0908</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Drive &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1a0d5aec4d31827ebfcbdea0c2ebee87</anchor>
      <arglist>(GDrive *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Emblem</name>
    <filename>classGio_1_1Emblem.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a3b0b61279f632bcac5894004b99c5f4b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GEmblem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a18a84361942885e0b75a82ffbc342947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GEmblem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>aedc2ab1a8682aff33ba0dbdaf5d05afb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GEmblem *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a37489c6af0fd3ebcc26f2ad70499ab69</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a2272bb4eb06787a561eae7593912aa04</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>aaea925c28921a3d9a5e772aace7a2ff4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EmblemOrigin</type>
      <name>get_origin</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>ae2e37f3de1e0d50b50a3ba4e9ff3d30f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Emblem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a73b765b853f364b1681352efc8a73a69</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Emblem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a49167949418fba4e254c3044b5b2808d</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, EmblemOrigin origin)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a145a95e9ca6ee5d31be2c94be935c060</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a2ff0e5c38e6fc97b2c57188099304fef</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, EmblemOrigin origin)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Emblem &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a53ecca7bfb4c8b1e3ac4305a8087bf3e</anchor>
      <arglist>(GEmblem *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::EmblemedIcon</name>
    <filename>classGio_1_1EmblemedIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a52372e1aef73698e9ed8dfe9623ef8e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GEmblemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ad19779f46ff62261df8b924f2e218f00</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GEmblemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a2b4a572414232927365ade6bf7bd1d5d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GEmblemedIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>afa5683d27b359053a929ca46d61ff512</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>aaa34ad2bbd13edbed76aaf908a04c630</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>afd4b52af91512a77936c0c1e13222436</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Emblem &gt; &gt;</type>
      <name>get_emblems</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ad1795232c2d5abd7edec6a56072d94e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_emblem</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>acf332055cf535914f444bc037ba7d324</anchor>
      <arglist>(const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; EmblemedIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ac4e4b5c233a669ac82db3852b5d9a1a6</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a2d790c876f3033983c5989a64f5ed83a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::EmblemedIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a1f2d2a7c6ad0125c6a9b4b41c2b7766a</anchor>
      <arglist>(GEmblemedIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Error</name>
    <filename>classGio_1_1Error.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4b7bf87fd22aea037daa6cadd0f6c6db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a71ba0a8ad3a2cee6b86aae19fa38f8d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXISTS</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a46c2fb3115cde148a9044a996a5f5947</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IS_DIRECTORY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aa3b4c2b6e1109309dfb04e111ae0eeae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_DIRECTORY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac89747d1a8296a2d7abc61e33e9a6849</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_EMPTY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4d1db4eab217424adeb9acbb8bdcbed1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_REGULAR_FILE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a5f4f1cdbfc26e0b284ddc971e69b1153</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_SYMBOLIC_LINK</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a308933795ee7ee7613e555eb6dfa89ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_MOUNTABLE_FILE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aad4e3bf56a2de0f7642eb5713a4e2da0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILENAME_TOO_LONG</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134af64160bec6d689e9143b2b065114a8b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_FILENAME</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4705fc1de258afdbf3d80d1e6a9c1a93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_LINKS</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6bc650c3933a11fd0eec1a03c96bacfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_SPACE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134adb48a8d32cc13f996feccfd7e7f4bfa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_ARGUMENT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2cc33d826acd1d12989ae83f4685db1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PERMISSION_DENIED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6f7122349d0108e792444d115cfe067e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_SUPPORTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aa46bb4ae8662767fb5bf2406c384ca58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_MOUNTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a37bbb3053c929cc59ba594a0e68c4e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ALREADY_MOUNTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2c70c6db9fe114fd367bb673a8f0d84e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CLOSED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a252082a76c9bf70f5df5e736b7334951</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CANCELLED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a9da2cb56b3e1b8db9adf481360e2ad0c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PENDING</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6420882bc2f68e77254adb9767bac2b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>READ_ONLY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a15305a05f8c09ef80549261f01d42ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CANT_CREATE_BACKUP</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ace8da5552c3ab58264e8c53011c68e18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WRONG_ETAG</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ab84b31830cf8bda8886977905d8c0843</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIMED_OUT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a44decc3b328a874eadd76414c7ebe4db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WOULD_RECURSE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a3af6165f166bf4e8aef85437d4497929</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUSY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a066d8df507fe9a2de219f618d6242cce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WOULD_BLOCK</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4041bd40a7ec2e6dc8dae84c30065fec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOST_NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a267c1b76c0f55be7e49beb9aeb387e7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOST_WAS_NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a207ecccfb593af57a3db3c9311e623a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WOULD_MERGE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac7a10c56c904ac8d1d977945c88d6b33</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED_HANDLED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a8001f1c0293ab55c88643e3eef3458aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_OPEN_FILES</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ab091e49c560d423fc47f1a9d5187540e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_INITIALIZED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a9664753e60bdd49ecee28c513c33b53e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ADDRESS_IN_USE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ad49388bed14b5c28982d23fdc3bd21e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PARTIAL_INPUT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4e616ea6aabe4b0ac1268d4eb7d1e23e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_DATA</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2e462d24aa411472f42467d6b1f6c349</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a215f4a0e611d0b19eb3ead2338e314b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOST_UNREACHABLE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac0376a95fd22bee8a154080a64abb857</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NETWORK_UNREACHABLE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134afece7f5dd896fff22c501c864ea4e9d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_REFUSED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a65c7317f63eaacebcde82199bb7dd467</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134af53bc67ed0d73d7dfc014e9284363ae4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_AUTH_FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a540cbcb6c05b20492c678495964f9a1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_NEED_AUTH</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a06379a3549173bb2a2b42fc749b3875e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_NOT_ALLOWED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac58b52f032fda78515a08348277eafda</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a6dbe1ed978ad03ee64dbec0a055c3914</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a0e59e13293663b6c1690f9277c5b48b6</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>ac353667814678e7406d8b1ab72cb430a</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ResolverError</name>
    <filename>classGio_1_1ResolverError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_FOUND</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2a47a46579525249b10ab091f44af1248b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEMPORARY_FAILURE</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2af94dc802d8d85a9fe0459f99e94b6a6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INTERNAL</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2a65ff77c88e58b40291356c7410a1c6e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResolverError</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a0d015ee9e313bfcd9a86414423f73fbb</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResolverError</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a70b6b6e5cef46494eca49d696afc2bd8</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a4966b66019b5f44295ab046d34fb2354</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::File</name>
    <filename>classGio_1_1File.html</filename>
    <base>Glib::Interface</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void, goffset, goffset &gt;</type>
      <name>SlotFileProgress</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac5ff32ee99845479d138eee49d92e59c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; bool, const char *, goffset &gt;</type>
      <name>SlotReadMore</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>add182d22071784fc345adc757b3d687b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~File</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af17e8c7b30baa13aaa5d58ef4d56e383</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFile *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a96552cfbaf2e5fa3659a1568db8cca91</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFile *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5437bc648d8b73451e8bee0bc902cfc0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9ea238062cdc317ae982ffae5c226c9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>hash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0320bac72ecc9ced1f894f1af696856f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8877115c870ea8f58b03d1d3c01a83e4</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_basename</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac731bed45bb7fcfd411eb69c49d3b883</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7b3edc7946b681b6db2cdcdad08d2b00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uri</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2d1313e4a4eb5de034b693ec1cc9fba0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_parse_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aea4a78163e3085a35cbaacde9a3a7628</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af39bbd5013b2dd675911df322e12ff94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae0b0d16b849b2f92699ad57ee7c935d9</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;parent) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa1daee0498c403e83ac509e6157edd1c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a53c533d6bbeaaadd1b5592cf1e5ef93c</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_child_for_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a479cfd632af30b29e125f904f809ed71</anchor>
      <arglist>(const Glib::ustring &amp;display_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_prefix</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4c40ec88dfc4333f19e939d26a1e0332</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;prefix) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_relative_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a464248111fa2bc5df89c620354eb99bb</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;descendant) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>resolve_relative_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac5e286d421c7236df39881f8ce0a4e03</anchor>
      <arglist>(const std::string &amp;relative_path) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_native</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aaa3b910bc9f240d4ebd0efc70979f163</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_uri_scheme</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a90d71529e5b51b9ff73914eaf90be0f1</anchor>
      <arglist>(const std::string &amp;uri_scheme) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uri_scheme</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aeecec6962f955bd72ac5595be37db7a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3ef959c7ad7096846f26eb8b282e3c68</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0395b3b0b8cec5dc1fd9953e52e5fbc1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2826eed0b1e76c3771f6ad5f5b993991</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab451a182a647408e697c9115e66f6194</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a64b10854ad1add1f888ecb19403eb921</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a91c93ee71eee738690cb551d11df9528</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8db337b93f3b9b9a6e163477391e6c89</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a86258e11b2884422819d051c3cfd07a2</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5cf2b17b953ccfefb1d13c39bd1be72c</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>create_file_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad5ec69c5360219bccb794bab6a128e88</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>create_file_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acf5673ceb9095405e458b5035b0986b4</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad7cf0360096504e40f799fde5cc8e9de</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acf55f9291659566f6fd36271801b013b</anchor>
      <arglist>(const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_to_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1e3dfb193e8f2ab69e24c4370de5335a</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_to_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>abff3163e9bf8d8208cd0c0e568b777de</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acb1f2d32055b8da274ea241c69487dc6</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae0c42446d37aa466173965b7db1a2053</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3fe6ed015f3d2bb72aa7aceed8dc7ca1</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a622b9f7aeaebe2ac53df0574c9c4211a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4c27a2460468aab1d3c3665234c24a56</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5a5989cfdee54778de733a529c24607b</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>create_file_readwrite_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae75da0ef250a3b27c2811a5e70f58536</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad777cdaa404a6a668ee8d520299687ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae51e51a2e3a45da4324230b4d5401a58</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab28557d592f2c53df618728cf865e65e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>open_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a128757d6cf7b152c82bb378a095003ef</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a73d95a731716c7ffaa86c3af90afe8d3</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a405af7082f531a7a39f3e7a453ab6267</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>open_readwrite_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9c501374d1257d5eeed903be20b66f63</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>replace_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af483e2ddc29cbb6cd1ad751403247bad</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>replace_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0c4aa84e74b27a67bce6b5fdccb91449</anchor>
      <arglist>(const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af5ebbb5e33c0afd302add9863f2d8c24</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a38b7d1782f03a4d6a4dbf3be16321324</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>replace_readwrite_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5733a0911dcd0ccc20f1f54fb3378b18</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>adb25ffdbe571d33e89c9503fe9a20dcd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4e4b9c07ade255b12e2b43c38c3aba90</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_exists</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad8b0a75e0afdb5f6874ea5e304d55ea8</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_exists</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab4cfdbf4fedacd364e40a72c71ab341a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>query_file_type</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa27c5b271c8f7667ce117cfc6118262e</anchor>
      <arglist>(FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>query_file_type</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a691a9de5512b870bf358a9b0d292e146</anchor>
      <arglist>(FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7bd60e7864f8954c35e3b0891058e61c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afcad69d782a971802a8aa85125ac2c8c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afd4ffc3630b41754c177658f2e745357</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40486bc2f0c8758ef8a705b6b8b57e57</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac737012f8df97d90e2447d94d30b817d</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a45b881926b8d58c49d3baa1f51f2ee5d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_filesystem_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a39184ff9c9437259df4b9a9e2f283a0b</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_filesystem_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4557ab16a50337f73d8a4649cf60fe70</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afd1159de8f782d918d8d460cddffee5b</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6eb675267c7ea1c2a0d40e2e754d8333</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>find_enclosing_mount_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a78c95d4fa47157f7757b686677dec018</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>find_enclosing_mount_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a67458be57c5687e7469bc26e2594f4be</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa12e6222d81179937cdc366f4d315433</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a68c3afcddc0d4860aa2afb4bf715bb20</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac0e293d607499b223f4892fb290ab2d6</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enumerate_children_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1ead7237b7057d9b15cf5f3065988131</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enumerate_children_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b5470cf1c97754a12169201665f1202</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a617a2950448788e68df128c58e068a14</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3dd75810d7c9ebafac398288f5afc018</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8c2aa80b2d0ecdd22f0222c8ce42d177</anchor>
      <arglist>(const Glib::ustring &amp;display_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0ac539d7758b9c0de809f8c83e0bba79</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a74d219d321dca3d438f876256dee82d2</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a101b555723233014c0185dd505303f0a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aded971b0cf84801f6684ad4bd5dc66c5</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a14f34508dea523cbf889b7193e513ca4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acae5ecd962e832cf8d538877f4118da8</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1925736f9af338eaf9942468b4d6d65e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af9e906ed93069e6adb6d87dae158cad9</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1d8159b5b377db174b376b3c09deb7c1</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7a6b45bed32567031bc7b48273ad4079</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1785b7a4780d5d4ba5ae651350e34398</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot_progress, const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b8ae7393c73a9a1d383a82d61f4ac30</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac2b1a85f29bbbe15998c090b3794cbf5</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot_progress, const SlotAsyncReady &amp;slot_ready, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad538a383b8761d04bd36ed1aa1071e50</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotAsyncReady &amp;slot_ready, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a68294636a2d649c9de53332faee02cf6</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a51c0d55880178c37dee578fdc723b0f2</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>adfb2d8bfed1cb7af50e5e5795ebea732</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aba1fab56c3a8bea0b7e4d7f7324c5320</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>abfa05e23e95e77cabac289ab4e294a58</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa1e9aa5f58a76a8562fd00a13434f554</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory_with_parents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afb0b5b094339057b4b15952eb73e08d6</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory_with_parents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a874a487551d49ca62b31a3e5cf32fee6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_symbolic_link</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2709318e1f24dfd0cd498d28f5e1b8fe</anchor>
      <arglist>(const std::string &amp;symlink_value, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_symbolic_link</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8a9a3d060c2675ff9ac1c758f0b2c024</anchor>
      <arglist>(const std::string &amp;symlink_value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_settable_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4a543339b58cff6a7e5ddd840df0e69e</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_settable_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1ae03d0652bcfbad2f47409b8f815bc4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_writable_namespaces</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af5c7463b92e2887597486e7b195ca12f</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_writable_namespaces</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa0278acd7d09ed292359004defb742b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_from_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a69d9e40a85b96809abc5189b34e8d9b7</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_from_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae9f6975ffef28f0d7145601a99de0903</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attributes_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a14165fba9bf7d91448c3207407ae50c2</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attributes_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a61317a1980318537aa8ada7bb8cc2390</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const SlotAsyncReady &amp;slot, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aefd45aed7b975b6e204e67927de2817a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, const Glib::RefPtr&lt; FileInfo &gt; &amp;info)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5ce5f43fd5e2836ac1989a54d3233ff6</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a75fa7e1a44e97a910d232f2b4ab4bfdd</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4f4373b8694c346a6908195f1f2644f3</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a09f574259052186e1b516bdcbe696710</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae53b0f4d2214e050a290c8e35cac0f27</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7f769f140143f2e96a7587a10b6792a9</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab0290ecba7b06ccf7736e2292708667e</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4a707084a3c0a963548a21d17d0ec0b5</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a48638081fd7af772a39af59a558b17f7</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4aa77b3580df88cfd3d7231af78155c7</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a111d73a2d003e5a5a4c5f86c7c3d2fb7</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4477b0063110951b26c855696ec34802</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a144aa2de6b696da90a6baffbe959d732</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a70fd22116d9c8682433c4bb8cbd764c1</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2172cdcdb683630b719c521bf00b1eb4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a20f8f18876102a5efaa0536bfa71d71c</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mount_enclosing_volume_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aefd44b1b3467bcc474b345ff98b4aa6d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40c88a403f5d01d722b5900545b6a4fe</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac3c29682ef5a50de73dc2c3c3333301c</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a049e06c3d95b49ad4bff1837ef6d8677</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8501fa88f4aaa8d52c001596960a4572</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>mount_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae15d36a7969c55122b9f85a1690a46e8</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b687c8f19411e955bb069c469be92b4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab6c8e9ef0e5d83a271c8307b18e779d8</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a95f3e87e198493f4332a08aa79f6ebd3</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a13f7cceb9754a7498789593dd58d818c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad82d5b087fef21cbadcb9407d7f43223</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae322b2d5f8f1d95023831c3964c9b015</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unmount_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a51458cf04ad25e4a784a3ebcb906155d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8a8223e3b661f03c7a60ac0f003b916e</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad8422a939a634d2248ef6d8658f0fdad</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aeb28fd505cab23a82c68ff00445b12e7</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1c103886296fd1ea1107906deebec8a5</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab6c75952828023d27d109a3a23fafc00</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab7aea22f6cb30b3f2be43682ddd543d9</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6a5124de7c55e9dc5e85ffcb9d3dd14f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a90726dcf94248d2fddf2e4c8584b7bf0</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a05c1101ede98028c9234486eb0434250</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa0fa22ffba0ff50779e49ff9d12344e6</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a12d36689c1024ff9fc8819f619910a92</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab8e14809f330ddd58e628c96921cd987</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa410183ed3b4a745093383d038d271b9</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a88aacee7bb6f6d968b4383311a9dd002</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a50896969a9de87f810f0bf5e2d3335bd</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa4438daeeb2171e3065bb677b6768721</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad629eaf059b2e05b1f9bfc10c5732974</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af11e51943807876180474b39d2e521ac</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac101831f87245a881c338014f15d38d8</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5ccfb3006c2bc69a32e5055939b462d6</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stop_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a195990af8825745d0d26147174824565</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8e81dd0bab13e56ed98456f6a53591ca</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2025339de9d7ed9b62300cad1a8e8fd4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>poll_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2da5ec13a4a32f229ca97cce8961e637</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>query_default_handler</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a753546465735b25633b003333b66d05c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>query_default_handler</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0c0fd0ece2570b6704889df5ee43c283</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac53be228d732b34e062a2a57814cdf15</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ada7c826a417f88b405244c8dc39ae1ef</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a77f7781b0ba65bc4e7e613b80b353fd7</anchor>
      <arglist>(char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40f3ce7cf905144bac7218f9988d2d35</anchor>
      <arglist>(char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad0e02ebffbaa13036e4636d2118f71a0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6af7ec98d5543bce07b917b65d7276ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5fd15277ab90bcc57db088be04cac457</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aee93c7e24e8391615f9f263584fb02bd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_partial_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0e8d95fcdf7c2aa38f54e90a22d3ab6f</anchor>
      <arglist>(const SlotReadMore &amp;slot_read_more, const SlotAsyncReady &amp;slot_async_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_partial_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a362d71932c0ba8797a8c47b77df1b6d7</anchor>
      <arglist>(const SlotReadMore &amp;slot_read_more, const SlotAsyncReady &amp;slot_async_ready)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_partial_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4b323508401d2e6fd2b3ad659f9bb5eb</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_partial_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae3a59c3831feeadea9bd0709617d2db9</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af10deca1d5c5d1f650d3b182624330dc</anchor>
      <arglist>(const char *contents, gsize length, const std::string &amp;etag, std::string &amp;new_etag, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae7febf1f0f3b4b9efca9fae469082846</anchor>
      <arglist>(const char *contents, gsize length, const std::string &amp;etag, std::string &amp;new_etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a23126b43cd262b63c0e458c3a4d0b65c</anchor>
      <arglist>(const std::string &amp;contents, const std::string &amp;etag, std::string &amp;new_etag, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aaf33a17461ff4f70fed06818e364f617</anchor>
      <arglist>(const std::string &amp;contents, const std::string &amp;etag, std::string &amp;new_etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad33b24a7942429157f47379f4353378c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const char *contents, gsize length, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9a1c445e84124e16294974a73f2f1bbb</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const char *contents, gsize length, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a380d6ce6362fc05e0e18ff1b881ceac7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;contents, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6fc86aab90620881899a701c2b2775cb</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;contents, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af019065c5503c7f47d778c20f8e5de32</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;etag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af0372ffd3f535f39b7e48c0483e4c1f4</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_thread_contexts</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab666a9ec3922903646504f4080758522</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa9352e68c93431dd16b8ac587703772f</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1b1a4553b226689d50b9525488223e25</anchor>
      <arglist>(const std::string &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_uri</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a412b6b55f37f69bd4fb8fbd24d4967be</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_commandline_arg</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab311a1c606b3907865fc8aecd4691de8</anchor>
      <arglist>(const std::string &amp;arg)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_parse_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7532baa6ce71fe27cfd1e9bba91a3536</anchor>
      <arglist>(const Glib::ustring &amp;parse_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::File &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a69670cdc7cf63783d6f9370dcbd7cc3d</anchor>
      <arglist>(GFile *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeInfo</name>
    <filename>classGio_1_1FileAttributeInfo.html</filename>
    <member kind="function">
      <type></type>
      <name>FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a5e4777c01a420d7265f4ccd8ed230189</anchor>
      <arglist>(const GFileAttributeInfo *ginfo)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>aa290f394f7f34b5b7ba9dbb7453ae792</anchor>
      <arglist>(const FileAttributeInfo &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfo &amp;</type>
      <name>operator=</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a19efa84d8e3f28299a2b89f86c9c7730</anchor>
      <arglist>(const FileAttributeInfo &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>af7057435f526fc718c2be147d0df5b79</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>ae2775dbf3905b88f52aee3828819792d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a113f8e990486cf35c33d4963342483f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>af3e06df4bf2d01ed2f1ff763c7ae01f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>m_name</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>ab3ac15f750d21ddb4f6c7cd3240f8e03</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileAttributeType</type>
      <name>m_type</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>abd2c79feb25a7adc6b9806d6b75d8c9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileAttributeInfoFlags</type>
      <name>m_flags</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a0b17e6847bad0bab1d90b7a3025e7dbf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeInfoList</name>
    <filename>classGio_1_1FileAttributeInfoList.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a1dd9c6baf89e1254fbed44338eb0a4a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a889a9813bba642c384b9b2d05bae0823</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeInfoList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a8aba8445408cbf56722946723e6919a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileAttributeInfoList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a030d5b7ddafbfa9e1b15d92254530203</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeInfoList *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a2339b9d0f1a13935e58bfd1a2210cdb8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>ae30d388537b163f12846afa47638e7be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a7584d4757d8ff2cab6dbc3bb1d28da94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfo</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a821a7de06545be2c6e18d7a53c5770eb</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a4253d86702cb4b18859e7ba06cb7e1fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>aed2f07a9ff6a250c3b8fa06324765c2f</anchor>
      <arglist>(const std::string &amp;name, FileAttributeType type, FileAttributeInfoFlags flags=FILE_ATTRIBUTE_INFO_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a0a0d066b1b2e3a0a533895922ff4c14a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileAttributeInfoList</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>af647ecbd4ab360b48deae74066993251</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>af33439073a6052f731c8712aaa08ef5b</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileAttributeInfoList &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a7f7b3ffb2c6258de375ee4cc566c0089</anchor>
      <arglist>(GFileAttributeInfoList *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileEnumerator</name>
    <filename>classGio_1_1FileEnumerator.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileEnumerator</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aa67510ecc9ddfbb3ef6f1d7ad560ca3f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a7c4e1d7258796a85d5b473e08168bd8c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aa54f2d24a93f78b20fa9c33913c862fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileEnumerator *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ac744c1c54800fb3764ea6ce5546f7937</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>next_file</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a73b5814cb108be591316cedabe362800</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>next_file</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a881873317d4a608d06405b3da3940e5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a731c5e104949ecd082bcd6a2ada25641</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ad3729d377a08f39e3f4fc44d5c37409f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_files_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a78de4d8a6a97cc68fc236a69a730f033</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int num_files=1, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_files_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ad51d86fbf6ebef0aed7f4321e1df6e79</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int num_files=1, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; FileInfo &gt; &gt;</type>
      <name>next_files_finish</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ab012d7f4428713efadbd10571f314973</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a0c878331956c2b28d749f561dbf84287</anchor>
      <arglist>(int io_priority, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aab848a136da3b0880f23e9084544e4ae</anchor>
      <arglist>(int io_priority, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a8f87519e9368a1db2399c24649976057</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3908b180f25ff93b1cb6cb86945981a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_pending</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3e1fb2fb2a8f8916929506828ded33b8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_pending</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a666470d02974350df0ed75f94321eaae</anchor>
      <arglist>(bool pending=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_container</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3ad9348edd27ff536e61ee6b87b0fd23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_container</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a639025c665bfef49b88902d16b889ec9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileEnumerator &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aba2d802d7865e00771c69e44da54318a</anchor>
      <arglist>(GFileEnumerator *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileIcon</name>
    <filename>classGio_1_1FileIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::LoadableIcon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileIcon</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a9e9ac46fa3312d274c8de2155a5343fe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a0461feec986f30a389d7db0bfbc55673</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a018eb170dea43e7bf697baa73070e195</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ac56c21ee2b4cc36ba9b6d177fdc184a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a91c091a48d9acadf0fa4ba5817459b8d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ad5414529acfb5cd8e118d8ce6cab676d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a09c67bb60019f8a14015d55ebfb89e25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileIcon</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a2637e26120b3abc4711be125e212a72b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a211fbcdf28b3b87440c75b2c1a0212dd</anchor>
      <arglist>(GFileIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeMatcher</name>
    <filename>classGio_1_1FileAttributeMatcher.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>af9f21d4f8a594676e747583cbc3ad61b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a9e66e5a86c52725b6bd4f16781229775</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeMatcher *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a34cf74569abe9a13c4412bf8f2347747</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileAttributeMatcher *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a5e217b69f70586991b2ef272746aa7a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeMatcher *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a35f18b4eb01427687fb0fe4f74dc0316</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a8e9f6798e6d368e0134ba00ca82106aa</anchor>
      <arglist>(const std::string &amp;full_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches_only</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a664ac79f08935d6c13396a6d607aea84</anchor>
      <arglist>(const std::string &amp;full_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>enumerate_namespace</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>ac0edeabc8f07048f8bb2ba96d84983b8</anchor>
      <arglist>(const std::string &amp;ns)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>enumerate_next</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a18103e91422814f576ff4b339bb085da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileAttributeMatcher &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a47b85316b6b6ce30841895ae6ef4f498</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileAttributeMatcher</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>ae91e6b65ca5bb2c635f5bdf9cba56ed7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a51a9c2dc02b96c5d902988c4a2a1bdae</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileAttributeMatcher &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a55c8ef1a5445afd09cc530d7c4945b7b</anchor>
      <arglist>(GFileAttributeMatcher *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileInfo</name>
    <filename>classGio_1_1FileInfo.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileInfo</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aaa6efce7f09cab1619475b27860a72cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ae03eb9c62254cc8581e3ec757f8d98a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a631bcd07a3ae085260e7b3358444dd4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4c85d7a363f3925102ae03442472ac7d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileInfo</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a740057465d0744299ef0f118b7efe083</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a15f9fc3eeafd0fa4e90d51d22781be99</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_into</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a43dff76c39bb388b7d67d77fa0024d25</anchor>
      <arglist>(Glib::RefPtr&lt; FileInfo &gt; &amp;dest) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_attribute</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa18458a7c75729d9521b3b0988bb9322</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>list_attributes</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a784a82a76bd8a10d16e6e78d311a8cae</anchor>
      <arglist>(const std::string &amp;name_space) const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeType</type>
      <name>get_attribute_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad9dfbef62139e9ea6d259d4bbe6b8b92</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_attribute</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ab36ffcf14c535c7fbbbb94907a3516c9</anchor>
      <arglist>(const std::string &amp;attribute)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_attribute_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aad2362ace81fdccc95eed6cf4e84af41</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_attribute_as_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a75ee20462c4f2dc2c696611427a98d8c</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_attribute_byte_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4803fb91a2fd7a754f030b63962b2bef</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_attribute_boolean</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a167589bb3e2fa091d7717abe6405fd9a</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_attribute_uint32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4f84f3668092ae12b0f89f3ff985e9b4</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>get_attribute_int32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad450ccf254244a053c11b14e88695c2f</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>get_attribute_uint64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a382b0afbec9d9ba59e7fbb7cbe5fc5a5</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>get_attribute_int64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aeb52d13f7ad792ca3cfa527a85b89809</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_attribute_object</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6211b572545a437f9691297cf439d394</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6273bbf43d262c18a67d5b407af8237c</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a65571d11697c7668be664b05145be73e</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_boolean</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a417d65b3879da104191b15aa31094e27</anchor>
      <arglist>(const std::string &amp;attribute, bool value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>adeb6d97a7234f8cb9f597530b16bd1e6</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>adc1806943e1726b44e1b41eddf79f8cf</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>acea5263ac50a21b59bd24075d2066ead</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a1fe7d70aa6504797ba032e50c767e23a</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_object</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ae2a4f18e80b03de854a29fc4fbfbcae7</anchor>
      <arglist>(const std::string &amp;attribute, const Glib::RefPtr&lt; Glib::Object &gt; &amp;object)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_status</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ac00eda5b1db8e5c7d3a756a43efe47fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>get_file_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>abf62545b515bef26ead386be87750edb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hidden</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a58ec7193682510c1455a6547fcabddb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_backup</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0e782dc65b4a048628c35af89bc2b894</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_symlink</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a7a7ef1e79deefd16be5fcea5ed00e6d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a2a237a251dce16850d2365f246e48e4e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_display_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aab26e342861a38ea9cfcd8b52813d655</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_edit_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a92f5240ac06f5848072e2f43aeb71516</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad835c26e3252232a437d1013a5ed9aa3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afa956e081955525b68c5af3f291b7b8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_content_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa67a68ee61c7b43f2051cf8639966e75</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>goffset</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a298f0414de960d56bb5a2bcd951f4900</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::TimeVal</type>
      <name>modification_time</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0bb8836539f5a2f4fe61c07e335110c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_symlink_target</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a848a2f85fa4f84c6477e076987d28770</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aaa44913ffe15c029ce09dfe828cf0a0b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>get_sort_order</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6527af61c645715e24863592246545b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_mask</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>add9025ae3f25e5213ab8fba055a4e09d</anchor>
      <arglist>(const Glib::RefPtr&lt; FileAttributeMatcher &gt; &amp;mask)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unset_attribute_mask</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afb9178c888fbf6fd2ef1344bc8523ba3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_file_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ab3ceaaaf6112575fd1b9cd6c75112606</anchor>
      <arglist>(FileType type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_hidden</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af817a5e2d32a2a7d0130c53e4bb3ca72</anchor>
      <arglist>(bool is_hidden=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_symlink</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a79304bdfa1e1e5e73f895c896ddf730e</anchor>
      <arglist>(bool is_symlink=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af2430c30058f424bbc71c342fd2e9cda</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6c0171f42d0877023cfe574b77359b59</anchor>
      <arglist>(const std::string &amp;display_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_edit_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0aec971ea570c1946b8e57462e1bc9ce</anchor>
      <arglist>(const std::string &amp;edit_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a3bd4ac6face055102cd02c679056a16a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_content_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a1a07b5776ff1a1a8ed8d942710df5688</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_size</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ac50fe95ac1dd596d44cd40225af223f5</anchor>
      <arglist>(goffset size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_modification_time</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a999893faef31be8d0989415852ec527e</anchor>
      <arglist>(const Glib::TimeVal &amp;mtime)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_symlink_target</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af0ca88a17c88c40b58890a68278528c4</anchor>
      <arglist>(const std::string &amp;symlink_target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_sort_order</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afec884c7bd2f655c7a3fe0122dfb4390</anchor>
      <arglist>(gint32 sort_order)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa08fd4d65078c227da321348eed9519d</anchor>
      <arglist>(GFileInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileInputStream</name>
    <filename>classGio_1_1FileInputStream.html</filename>
    <base>Gio::InputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileInputStream</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a8039942e23f7821a67f7d1003b486b73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a5411e06810e06ad339d7a21257772219</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>ab1afea7b758100ca02a6aa5b89d57662</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>aa35ad981b6f18b1e5ece395970c5991b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>ae9cf87761484839f4ea53bc33064f189</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a6ff4fe91f63b1eb38cca93591ba1f263</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a50c9554cfa15b88a1d30c7719569cc5f</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a21f82f427ab1e958308889b78308dcdf</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a1c8e42e09d92c59b05d122eead3e3161</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>aa3ca60bf8d52cd8c7d2688e58d634a36</anchor>
      <arglist>(GFileInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileIOStream</name>
    <filename>classGio_1_1FileIOStream.html</filename>
    <base>Gio::IOStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileIOStream</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a7b412e59741edea22ef424786aa2665a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a382fe1830e5e347db4ae0d941398c0df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>acd384df600b1aea26bd10ca2e74f1b21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileIOStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a2661e78434e66d48a54aa67ddd4d4e53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a11c3696bd12879c7554a8be1246ca069</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a1c4cefdd3b2ff134f01ecbc7a4439921</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>ae83afafd7a40cc116026af5452c26151</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>aeafe3bd19e6cf993dd7a2bb4e27ebd4d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a9838bea653f37c9ff298e16a96ce11dd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a98607843697e850776bd6736a93df4d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileIOStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a44679bcc0dadcf0eb3bf2691e51e7e98</anchor>
      <arglist>(GFileIOStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileMonitor</name>
    <filename>classGio_1_1FileMonitor.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileMonitor</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a6ffb078bc2ce7e7c4dde4c5731fa1f08</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a047a5032cf7905ecc37c6379e8c82f35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a3930ab1dd57d0ec9341edf13bd62712f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileMonitor *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a989efd770a3a68bc77f1917751feec9e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>cancel</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ab6bdfc13b4a27521304c9be8aedec677</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_cancelled</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ae5ebb0182704c6ea8314c6f0a6106fad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a47b6ca4693b67efead6c8dde6d526b31</anchor>
      <arglist>(int limit_msecs)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy3&lt; void, const Glib::RefPtr&lt; File &gt; &amp;, const Glib::RefPtr&lt; File &gt; &amp;, FileMonitorEvent &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a36215dcf2bf7a9476284f419f163aad9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a3e6afeaa6d7985f5e6ee16b140277eff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ab592fb7ad93948d35e8a19c8aebf2912</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_cancelled</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a7c38219889f137400c15510ca309682c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a42c6d3679e90ad17504d3c0a5937da7c</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;file, const Glib::RefPtr&lt; File &gt; &amp;other_file, FileMonitorEvent event_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileMonitor &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a5ad2474eedfd1ae12f2c75003e6f26fe</anchor>
      <arglist>(GFileMonitor *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilenameCompleter</name>
    <filename>classGio_1_1FilenameCompleter.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilenameCompleter</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ad72f983849b2ba03e2ef98868b56b27f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilenameCompleter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a6fa2ba7f28935b557fac0dfe965fe916</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilenameCompleter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a0a627a9eac4a916e93f94bc4e7bc0d25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilenameCompleter *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ae069b04fba4a9fff00023476772a7b5b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_completion_suffix</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ac881f6320fb90d70afa0a5a86a38db11</anchor>
      <arglist>(const std::string &amp;initial_text) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_completions</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>aa56775c73bc3d1bd5a9749926d8a7134</anchor>
      <arglist>(const std::string &amp;initial_text) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dirs_only</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>abe7160d315c69ed35cdd5e1a25cf06bc</anchor>
      <arglist>(bool dirs_only=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_got_completion_data</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a3acc6e4468f03d924b9efae217b49e70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FilenameCompleter &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>aeb7c3042c2f76a62f6806921bef56e89</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FilenameCompleter</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a1db98397daf75605c3a827f646ea98ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_got_completion_data</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a092cefc4a3cbeff19f60ef75ebfc8b87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilenameCompleter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ad03881744458e4aa6308376f5aebd2b3</anchor>
      <arglist>(GFilenameCompleter *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileOutputStream</name>
    <filename>classGio_1_1FileOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileOutputStream</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>ad441ab4039675535b59c65b4c5d14804</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aa69b1c94c5a3a2e0002fc6cf5127fc70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a2bf847a5064b01e671731ecd56f88968</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>af536865a9ed17c3093ab67465fba908b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a660a0130611aad21965a3f74c2fe90cd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a9b67d7fa0b9309ca42dea8607d2ef3d5</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a926ddca8782aeb271560a058ee6554aa</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aa9297d379f28510afd0d5dabba65a447</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aff73b62f94cc0be14f8271480aab6299</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a8e29de4e67428a79b41180ca27af0a3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a5fe0a7a8069a65b4a83b36f3a54b3142</anchor>
      <arglist>(GFileOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilterInputStream</name>
    <filename>classGio_1_1FilterInputStream.html</filename>
    <base>Gio::InputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilterInputStream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a5d3ea75436d7681061f6c320225d7848</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a6db43589745dcd172f4ca4082bc5d914</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>ac8fbd2cc879bfab4854d952b27ce271c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilterInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a55ef3320e423245cc69066c90785328e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>aa0e6304d8ea21a17b3e6a0127e3e7530</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a41af6a4af682c043ac9c91ed13608705</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a1a78226f76528f61c87ebe5a31b0f133</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a82e03517a6841b170c7e13fcf2f66920</anchor>
      <arglist>(bool close_base=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InputStream &gt; &gt;</type>
      <name>property_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>aee46182be8452b2b308e62b1fe932233</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a9b5145644bfe5e2472cb219517ad54d0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilterInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a5f5a6b8c088b86f8671d9dfaed24ac70</anchor>
      <arglist>(GFilterInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilterOutputStream</name>
    <filename>classGio_1_1FilterOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilterOutputStream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a65d7d0e8645a11065c74706d65e18fcd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a7cf09c946f16c1597e7ce038fd64f9ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a4497fb9f0cb87f953bbc8fa5bb218a0c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilterOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae0701328a1b8b2e71ba15dcdb83422b6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; OutputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a135f41e0b5e9ad029d17efdce11e3fd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const OutputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a983b98a5bca8404c6ac515ff8048b61e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a5b9f78803d5860833114852fdbbf2d7b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ad02373553035aa1b1c3bb2bd578a24f6</anchor>
      <arglist>(bool close_base=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InputStream &gt; &gt;</type>
      <name>property_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a080f2c7b32bcd1c05c04a437c5586afa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a4f7d6b22bbc388ce128f71a9b7590b08</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilterOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae070f4f975af2ac6beb39a5bef8d5f95</anchor>
      <arglist>(GFilterOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Icon</name>
    <filename>classGio_1_1Icon.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Icon</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a860156dd8f8c9143cce6fba134e5d7cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a02ef784d9a07a205ce1d7daac39d2054</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a94b7e4b63ce6c1c0f05673dd8b4adf94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>hash</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>acbcfcaa91ff4d50f700267e2928a61ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a7b0d721c852d1e5b0f9cd875769fabd7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a90820057c0e8974d43d2597df18efb20</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;other) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>abd37e490fdf4da67eb3bbe2561c16ee3</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Icon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a8ae9b8e7b8159620eea7f9215cac83ab</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Icon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a9f6d4523888318e40c362de6eea23004</anchor>
      <arglist>(GIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InetAddress</name>
    <filename>classGio_1_1InetAddress.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a681469990ccd8829c9c56f2c21b987ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInetAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a814cf259fbe2075145372ff8f041e2fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInetAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a02955cf2f6af819e6a33fae34f02a35d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInetAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ac5740ac33a8c1507165bfb24ad05867b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const guint8 *</type>
      <name>to_bytes</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a55511045dd96127a9e0c71277f6f09e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aad0c75db355f9202eb2d9abdfd62664f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aad520fbba41d5d4ff350c0e0b8aa8bd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_any</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a195f40df5aa0a539d4199dd8c89b67ce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ae27877a353888bda5cc7d6ef439b6f43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_loopback</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a123434ddbf161d5bd24bdd6e1a242042</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_global</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a4bc588e6ceab049f81458d17a282a696</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a0759e79028e0f3a967f21e9aa785708c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_node_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a30fedd1ab379f61ad0d43822a7fbd414</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_org_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a1933a994b55b0d3198187813aadabb8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>af50cbe1bd1fc064e37759026f60a2e78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_multicast</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a1751ce4f0815d2bef25c789f6a7c2c51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a6f18baee3fd0e8d4411ed6300e3f4ac9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_native_size</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aadfe97104f2bc53014fd70a2f1d8541e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ad9a5b29ab4211c5e6d03d7630d1f352e</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab34823f20a1719d0d4dd0b8908791196</anchor>
      <arglist>(const guint8 *bytes, SocketFamily family)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create_any</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a801b964256dd4934f58db81626e6f42a</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create_loopback</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>af78181b11c10d9d698d9a49cfa2136ed</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aeca7299962f7b75793c493ff32d91abe</anchor>
      <arglist>(const guint8 *bytes, SocketFamily family)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InetAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab8ed0814ec989e9c9b07332b19958a01</anchor>
      <arglist>(GInetAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InetSocketAddress</name>
    <filename>classGio_1_1InetSocketAddress.html</filename>
    <base>Gio::SocketAddress</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InetSocketAddress</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a86c013c0d7971681b61da945543f1071</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInetSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a2185ff490fa658c11854df16c41910dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInetSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>ad0a057e46b10504010e3e014d3207f4d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInetSocketAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a0d165726f19e26d3c03a184510b6df2b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>get_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a28a044f52e94263559a50197d4ddfd6b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InetAddress &gt;</type>
      <name>get_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a0ff00835b7a56e1df1c18aaa3d842bea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>ae9fc68c477f6ed7915befb4131f42f42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>property_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a11ed0ddfae5e91401ff0e2a64c0e4486</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint16 &gt;</type>
      <name>property_port</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a846bfac32dc21d47e98fe2576fa5c484</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetSocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a863fb8d260958e69d603e2903595a973</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetSocketAddress</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a54cf3e5885e7c14a26017ccdc5f552e8</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InetSocketAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a4498f65e8445567d4cacdc0a68437c33</anchor>
      <arglist>(GInetSocketAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Initable</name>
    <filename>classGio_1_1Initable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Initable</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>aa4da38b665a33995bf28ad1838253b7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a90206d58591c674e03c5de57623bac18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a30665fda96b812e27231ec5abc47b789</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a6b68b1a2c2ab02ed1f25887c7acd121c</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a7dbee3b8e980bf52ae2a66e1523127a3</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>init_vfunc</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a53c86a53352ecda8bca80d5132e4e99c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, GError **error)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Initable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a9a2f7929de61e6b32a2317fe0ebde865</anchor>
      <arglist>(GInitable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InputStream</name>
    <filename>classGio_1_1InputStream.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InputStream</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>afff624e3125add13c88e8a99907ba903</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a2ed1120b3d03a12086e7f0ed3946aba1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1b0ef82ab81b3ded607584c7029fe1e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a28a9394b07e9183c0c79798ea344c65c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a49a1f4219f96c7fafdcf1ed12eb443e2</anchor>
      <arglist>(void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a42ab2486116d40f6ef828277befb508a</anchor>
      <arglist>(void *buffer, gsize count)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_all</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1dc8a2babf32f93a0a5dccc0c39e0959</anchor>
      <arglist>(void *buffer, gsize count, gsize &amp;bytes_read, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_all</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a6da0fc57d1a5df7107370c67e84aa496</anchor>
      <arglist>(void *buffer, gsize count, gsize &amp;bytes_read)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a17ea65f35c15043156db90af831a44a3</anchor>
      <arglist>(gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1ea9146d612c666168886734b79a5d65</anchor>
      <arglist>(gsize count)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1b76b2503e607475f63731a886456e09</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a7a3202cf7014bcfb2c0a7f301448ae50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a5b7762ee3f3c571fbc59a0c9af6e879e</anchor>
      <arglist>(void *buffer, gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a05bea76fa9ac3c098a167d2b377e36a6</anchor>
      <arglist>(void *buffer, gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ac089ab220e671ba0af2dd97f2405c0c5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>skip_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1bf7a4a30005813b0a46e069215907a2</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>skip_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a111e86dad4548394edcff16d7735d2d5</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1522468bd203ab3082ab54e9eba68b03</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>af66159778ee2d577e9df52063ced53bf</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ab5160982124f34ed6e475776acd126d2</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gboolean</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ae5a0d2c3ccf27661e374f151117a8fb7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>aec580b0fc1e0807d7ccba6cbb7e302db</anchor>
      <arglist>(GInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::IOStream</name>
    <filename>classGio_1_1IOStream.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~IOStream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a1257d3a0df6edf25cf1088e4be7144e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a6e8d13f8095555cecbe0d59f1542893f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a94eb81fa811399ece0ef743cd9d178ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GIOStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a632594c5b02e0311448e79f6d495c65a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>get_input_stream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>afab74f0f339afb505556f6cb8b8c2b45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; OutputStream &gt;</type>
      <name>get_output_stream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>acdea8fc29d817070fa9cca124f398930</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>ae22ea1e4e3cd6db48b5e012f35a2306d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a7d9c63eb525827d27f897d6823f719a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a289fe0ef58e44117952a2e01985afdd7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a41451e389068b3a61245b43695186ee6</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a205a044f155178460336bd6efd05554c</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a32d887d5d205566fe1cdfd0bf4176a8d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>afecb3079c5a4adf9fe186b4a44923da3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a7217e0c7ef1659a8b293a81e5b2e95e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>ac15dc0ec5596a9bb5ee174ea70a2b59d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::IOStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a13101385680c3857e7027d78e1f6259a</anchor>
      <arglist>(GIOStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::LoadableIcon</name>
    <filename>classGio_1_1LoadableIcon.html</filename>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LoadableIcon</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>ac1a01de0d91f26e45babaea521a982a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GLoadableIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>aa590b3b76843c19f5dbf51448f30e9f7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GLoadableIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a50a6f22519524e14d36d070cd2cb1c89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>load</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>af92f75fd1b6d4284e169c199a2c6b8c3</anchor>
      <arglist>(int size, Glib::ustring &amp;type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>load</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>acd3a877867f4ca2cbf5b1a5b059e2eb6</anchor>
      <arglist>(int size, Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_async</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a0218104cdd576b7dde4846de9b997e41</anchor>
      <arglist>(int size, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_async</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a3e2f5cf5ef217e53e6dfcbd83cc553e1</anchor>
      <arglist>(int size, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>aac15ee4e49c92f2822760cc774f908d8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::LoadableIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>afa55d29b9394247f8824820bb92e8e6b</anchor>
      <arglist>(GLoadableIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MemoryInputStream</name>
    <filename>classGio_1_1MemoryInputStream.html</filename>
    <base>Gio::InputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MemoryInputStream</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a73bc118fab39a89f4d8e8434ff951ba8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMemoryInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a076380153e01599446bd991e0985db69</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMemoryInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>af9ea44af840fc0d29d460498c8ce7d0e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMemoryInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>af63cbdce2036e383cb7e77a7df83651c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a483a0f4811f64a0a83204e22c227bf80</anchor>
      <arglist>(const std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a9700ab039b7d4654330f2786bd8786eb</anchor>
      <arglist>(const void *data, gssize len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>aa26832ff7a8bce5cc15518d5a2f0a14b</anchor>
      <arglist>(const void *data, gssize len, GDestroyNotify destroy)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MemoryInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>adb6e55009e51b59fa19dcd69617cfda1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MemoryInputStream</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a3878e7ba1b947b72a8ab835e2ff24473</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MemoryInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a37bf0e5204e95253e4119ad954b3f7b9</anchor>
      <arglist>(GMemoryInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MemoryOutputStream</name>
    <filename>classGio_1_1MemoryOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MemoryOutputStream</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ad46729116d268fe1f8f540c692a43bf4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMemoryOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a3a52447ebfbc60722ced10d8aa625825</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMemoryOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a026181901b030a2f1f6e3b66026de5d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMemoryOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>aa6b728d48c0817347df70d41bd57708f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>get_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>af3260b7ddbda5b7eb0447de717c7fb67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ae8e5b9a0551bba70974c99cbb24a91e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_data_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a7325ac59862190abfbbd8402ca7e7fe5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; void * &gt;</type>
      <name>property_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a68dc65c48dcb4bbef99e7c8077edb263</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; gulong &gt;</type>
      <name>property_data_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ad08b20bb0b2bbf88503a752cc863c670</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; gulong &gt;</type>
      <name>property_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ad2b807f29eb4f0e8f436c951cae71e14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MemoryOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a7348c98dc71c1ff04c404df77515011d</anchor>
      <arglist>(void *data, gsize size, GReallocFunc realloc_function, GDestroyNotify destroy_function)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MemoryOutputStream</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>acdedb0b457edf81294061bef3289b9b4</anchor>
      <arglist>(void *data, gsize size, GReallocFunc realloc_function, GDestroyNotify destroy_function)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MemoryOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a294410b0d5c9b2d1a08dc9375338f187</anchor>
      <arglist>(GMemoryOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Mount</name>
    <filename>classGio_1_1Mount.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Mount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a13e8fa0a412e509ed8a5cc10bf212ee2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMount *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>afdab4fd2377e912d2baef0cc6a825eca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMount *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae15d61c7a8bb68f66fc46e3eaaaffbe6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_root</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>accf83f7b2599411cb82f5f4c0172db81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_root</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac2bf8f7a467856c39cfc016d61fe8c5f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a951d543f8907069e20678dd503928cd0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae368f1d91fc927b809f27acce5aff58e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4c26c21db5fb5960b24d780018c6d04f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uuid</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8a58874fb45ac7960dec34f094f0306e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Volume &gt;</type>
      <name>get_volume</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9497eb3a3a928144f522489b5b432cad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Volume &gt;</type>
      <name>get_volume</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac9f2177094e6203eaf6aa186b7ea3ee4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ab9b8889c7b8c8fdb885a46dad7419fed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9045c2d50f4433ebfa137c501b00fd96</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a52771234b6feb921931f28886bced5f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a279bb465c4781cf4a769db412db947f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a6eb057d27f3729dc451d32e8c6bc8fa0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a99bb5452908456ece101cee94d58efe9</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aedbcd024f16a92c704261c17eb7b1cf6</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4673333db9d066f1f0fef5e4b2d5bd2b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a833c71dbd0d5cfa222cec64cafaaf328</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>af40b60bca3e9bc53496f0ac926a4db04</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unmount_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a319db22009f052fb5d0c45596f203d4d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aae983acbd58daf68125f5129466d4de1</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a088ae08b4bc3a8dc44c0e18aa2b438e3</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a2059d92df5b2cc36268545b3dbd2c171</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4ef4769ca5b2e9a55f8a1981b2cc051e</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remount_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a5cb279b126e6086b5f0ae0957794f023</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a6bbacd6b5ab2251d8df9db538d6f0d60</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a3573df8a4d1d10dd321e2f46d9afc337</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a0fe94aae6876d196348f786c5e830b49</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8c2898b067f5651cb641c4375833f15b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9a27b41f48e3a00783b0d8ac313d0014</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac7ff80c7b83d251de9a8c47ce79e9e5b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aee0c22ba1711f4d84d1eb0d2989c2d0d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a3ab56ac69c41c668990e91d7be2a2b73</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a498994191262236c4bddf0b95df92642</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ada39b6385004f938c38ce14b0566756b</anchor>
      <arglist>(bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type_sync</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a42de2d821060ef0f958ec176749ab595</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type_sync</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a7e6b4c96208fca788cedb49dbea89258</anchor>
      <arglist>(bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>guess_content_type_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a274064a160c15338580685a9e1603497</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_shadowed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a7788da3491e20c6a5563adb7690001fb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shadow</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a1988ef61bd5316876ef434593a45f584</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unshadow</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ab25d880d541247871be715e13fa2b39e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_default_location</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8ff89751cfd5b626952525a079829fed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae9331b0fb0c2154885818ed72ddb21a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_unmounted</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adafc3d61a654cf2236f568e534aa6616</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_pre_unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae0c76ef0e895f2781add651624c590ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aad5f6e7a513330f247f71c9475a3eec8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adf264056921a09b1426625973fb1d182</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_unmounted</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adc6f47efdfd20501692f82a2c94b7efa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Mount &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4723a81c56625aa5920589115060812c</anchor>
      <arglist>(GMount *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MountOperation</name>
    <filename>classGio_1_1MountOperation.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MountOperation</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6899f6121cf5a44a39ae3cc662d92fc6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMountOperation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a580640ff16e8cd1cbd9d0ce4659daa7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMountOperation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a100962323f73438a4d35253b5763cc30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMountOperation *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6e6feac74568a2eb7e6ca1a63122c31b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a13621e9b35aa25b8f62e5a6db14d3967</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ae9e313d9dca3421676c590cf50134d62</anchor>
      <arglist>(const Glib::ustring &amp;username)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ac874e50f4915199d6013932633841ac0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a9df86e31c73fea9e438586fde8a92b70</anchor>
      <arglist>(const Glib::ustring &amp;password)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aa30b6f82881ae1afea5a21836e5bd036</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ad5a97dd24b05012c93211932880edc02</anchor>
      <arglist>(bool anonymous=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a3f0ed216f46c7a914c73d7d1e4a8c0c7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a09fd2984393678b8592b7a3d565c0307</anchor>
      <arglist>(const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>PasswordSave</type>
      <name>get_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>abc1af61dac7d1427775b7505d27cd319</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a58bda8feb48b1e163931d96b5dfdc245</anchor>
      <arglist>(PasswordSave password_save)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ab7eaa8f1ea17c14c86c5f30cc0c5eda9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6fbd101a1db62e2f34b23b9fa5cca869</anchor>
      <arglist>(int choice)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a1f444eede759bae682091b8fc5f108d3</anchor>
      <arglist>(MountOperationResult result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy4&lt; void, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, AskPasswordFlags &gt;</type>
      <name>signal_ask_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a10cfcab05979a518d20f0c03cbf1a6cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, const Glib::StringArrayHandle &amp; &gt;</type>
      <name>signal_ask_question</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a38daf1bcead0ae90cc61db691616c342</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, MountOperationResult &gt;</type>
      <name>signal_reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a55fa9cab0e2955fa6142f5dcc95198dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_aborted</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a2aaec5c293ef88d3c331b67ee92f0493</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a7a8ebc0a62b0e8e0b33bddde7db96706</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a4508d7bc848d0a0a0c9445c5ca9abe9d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a17670a49103488add212c9b29329e51e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a874cf5588821b4c8b4ea5ccbb4a3ab0c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aa92ded64dceb5ea08d3eeb1cac25b3de</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a22622be32255873c07bdf6ea42109d84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>abddb368062abd7d6e225887ac57a026b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a223b2776dbcd745a319ffd03800764cd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; PasswordSave &gt;</type>
      <name>property_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a0c44df49a85b8f281a306c38ebd0499c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; PasswordSave &gt;</type>
      <name>property_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>af6aaf7f15aa28944bfa89266fc2437ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a17e402048ff4be6503348eaffd54346d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a5f614f827c4496c3e7ba099eb702cc4f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MountOperation &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a3e59fd19498a9be34bbb7462d87e2ca1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MountOperation</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a415e62c32b8d497d859e50da0c8431cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_ask_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a2bfee2a7879e75708a22cfb59e99280b</anchor>
      <arglist>(const Glib::ustring &amp;message, const Glib::ustring &amp;default_user, const Glib::ustring &amp;default_domain, AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_ask_question</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>af4d007e34e6f023de14a667aabfe3a39</anchor>
      <arglist>(const Glib::ustring &amp;message, const Glib::StringArrayHandle &amp;choices)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a9480654f1624640c719ce260883c8f9e</anchor>
      <arglist>(MountOperationResult result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MountOperation &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a65da8ecee4b6b6cfd9e846ec6bc950fe</anchor>
      <arglist>(GMountOperation *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::NetworkAddress</name>
    <filename>classGio_1_1NetworkAddress.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~NetworkAddress</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a6907240bebaea930f6a4ea0cf48e9478</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GNetworkAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>ac3bece6c2edb44d1346abd2a07995df9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNetworkAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a34f56c110e7a2e843680d8ac8f9b7501</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GNetworkAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>aa38b8f4bb0392393ea1235f3adbe79e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_hostname</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a859e032334faefe8c8c7d68f8ee2cdfe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a8a8893314bda54fc9b09a52f4bf9c33d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_scheme</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>abb7200ac34651f35c5520f25156664db</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_hostname</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>aa981c8b93746cb0e71d1f0393d587fc7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_port</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a7063532bb773b162e803f40541ff7168</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_scheme</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a6483ac41d645969a600e75ceefe9883e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a30cc7b78902bb94a53b7eca98fbee083</anchor>
      <arglist>(const std::string &amp;hostname, guint16 port)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkAddress &gt;</type>
      <name>parse</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a0090a07db819bd872a1379cb6d6c635a</anchor>
      <arglist>(const std::string &amp;host_and_port, guint16 default_port)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::NetworkAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a8283831783706b23dea2801e56bf1b1d</anchor>
      <arglist>(GNetworkAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::NetworkService</name>
    <filename>classGio_1_1NetworkService.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~NetworkService</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a991fb9d21ee21f41b0f6f78c57ba354b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GNetworkService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a01c7acc26f88ba9b62cebecfadf0eb81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNetworkService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a4163659ccfef2fe1459e54f542a04a83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GNetworkService *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ac73f00e197b587678ea62ed430d7592c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_service</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ab6d8f3c7d9da2a302645eecce0707a7e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a2789410b339d1fd4770ca24243421520</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_domain</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a5ee1798c274fc4868fc108c6e3b0fbef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ae05a9369ddaeee4ebd69009972f6621a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a70830dab9f87d2278cdbfcff65960726</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_service</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a129ba5bc4179072852d5bfc39a40f129</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkService &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a1e6e8639ee28297dbce656fa93cafe65</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::NetworkService &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ac0ea3336b85237336a8c8efeb4f864ec</anchor>
      <arglist>(GNetworkService *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::OutputStream</name>
    <filename>classGio_1_1OutputStream.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~OutputStream</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ae03f14924981183936d800fcde857fea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac5a71a1f432f8ac2a53de2c66eb81d9d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac29e6ad7ccffde24201a1da608f25ac9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ad9128985ea683716db40d7831cb7075c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a0a714bc357db90c5e34f1d001446fe29</anchor>
      <arglist>(const void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a5037c7a24ba87c7e8f1992f7586f032c</anchor>
      <arglist>(const void *buffer, gsize count)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aee589585890960b4c26c86865fe3f0b4</anchor>
      <arglist>(const std::string &amp;buffer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>afa3cf9f1b7006b1f79d8e452616f3324</anchor>
      <arglist>(const std::string &amp;buffer)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac9ff8d59409bfdfdfd95643f3ee4c98d</anchor>
      <arglist>(const void *buffer, gsize count, gsize &amp;bytes_written, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aca15317cfd772d712b44147d378788b8</anchor>
      <arglist>(const void *buffer, gsize count, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac10263d00bf17a158d4aad207fbb2d64</anchor>
      <arglist>(const std::string &amp;buffer, gsize &amp;bytes_written, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a9171833c0c7c88103afd3fc12efbcf17</anchor>
      <arglist>(const std::string &amp;buffer, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a080bff3f1f2017b4d4ff8343a5bfbf15</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aaca5a5891175c7c66cb77e476bae1843</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a413a349600ecd6013d15f563d6c6fd85</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a6bb81a11ef79dc8ffa9f5a275d2d6e0c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a4fefad6d6b244924b4fe51c105d3805c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac3e92678425dd530b22eaab97852ca23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a947eefdb85b9081348a1c0cc04be2eaa</anchor>
      <arglist>(const void *buffer, gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aae0f58d27908beb35f24a88b6254107a</anchor>
      <arglist>(const void *buffer, gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac61dbaa1f910c14bf3beaadc0498065f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a4bfe08685268b2236362bce84ba1cc77</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a85e95838d577180e11831b0f149e8f5c</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const SlotAsyncReady &amp;slot, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a29461238b7b3cf9c2d6dde85b4a6a6ea</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac76478281be9559cb0a924bcc4ead263</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aa82f241b6c72fef632eaf51b279b25ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>af2e8a3c48152c2fdc744a50016911a3a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a47fb0dbd7f88c9167dacd577dcd8c6c7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a92f6a9cc67bfa6a2356a031fb3f691c0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a8db5ee9e7a3a0c091eeebe960550e6f5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::OutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a96aad4c49fb938a88b75abe5339bef4f</anchor>
      <arglist>(GOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Proxy</name>
    <filename>classGio_1_1Proxy.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Proxy</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a86fd06700799e30e5a433c722951fedd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GProxy *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a5d635bea4b7b93e6dfe4a9e0d50f569f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GProxy *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>af7968158aaa54282ca7cab466d491ff6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>ab6215bb736fab46dcab1fef362736824</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;connection, const Glib::RefPtr&lt; const ProxyAddress &gt; &amp;proxy_adress, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>ac95ea8b9613b7f125baa2d96041d8397</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;connection, const Glib::RefPtr&lt; const ProxyAddress &gt; &amp;proxy_address, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>aa65146dc11e84e4ee09f0f78500d6279</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;connection, const Glib::RefPtr&lt; const ProxyAddress &gt; &amp;proxy_address, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>connect_finish</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a14d0ba006367a41d64ae58deb8b2d074</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_hostname</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a74fc2a43857241702bfa3668c68c14f3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a1922e1348160624161a7da73a12d401e</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Proxy &gt;</type>
      <name>get_default_for_protocol</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a13d55cd6a30e21b62d96fab02138f2f0</anchor>
      <arglist>(const Glib::ustring &amp;protocol)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Proxy &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a2618cd487487871eff6e8ad5d2d3695b</anchor>
      <arglist>(GProxy *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ProxyAddress</name>
    <filename>classGio_1_1ProxyAddress.html</filename>
    <base>Gio::InetSocketAddress</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ProxyAddress</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>aeee66714ca21aee0e8fd58df73c6a372</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GProxyAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>aa085bc6a03d6c8861c12bba387d395c2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GProxyAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a010e1f1f91c72e9be01afce6cb6f55ce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GProxyAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>ae54b9556db86b4f13b2aef789685fcad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>abbe07e03c353db1f52de7df7a8d82e0f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_destination_hostname</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a62d7233e953e6b570dd0b3b8502a46c2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_destination_port</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a47d0a94a1bffabce35ce7dcc5674db82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_username</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a1a4c55743dd829c42b5abad0fbacad3e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_password</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a903bdaf26d3905a264c3a9decfa03e47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a3b02358f947df9a9f8040ff4ab23085d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_destination_hostname</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a500428540087fe3311a03a73cfbd8633</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_destination_port</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>ad98f9d00ccc5fb6039170d9e93231261</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a6095d3ac3b26507a15c0c2c5bc3172cf</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a95ba8a770368d2d351366a5822541f1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ProxyAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a31cd08b2cce1b8a1d04af9a6e39db600</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port, const Glib::ustring &amp;protocol, const Glib::ustring &amp;destination_hostname, guint16 destination_port, const Glib::ustring &amp;username=Glib::ustring(), const Glib::ustring &amp;password=Glib::ustring())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ProxyAddress</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>af36bca5cb7e8bc4a8791600e7267b66b</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port, const Glib::ustring &amp;protocol, const Glib::ustring &amp;destination_hostname, guint16 destination_port, const Glib::ustring &amp;username=Glib::ustring(), const Glib::ustring &amp;password=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ProxyAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>af5ac5530f123a7fc5a0720fb1a806e0b</anchor>
      <arglist>(GProxyAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ProxyResolver</name>
    <filename>classGio_1_1ProxyResolver.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ProxyResolver</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a5c63b3c94c77b16894b0edac5fbef1e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GProxyResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a3131a7a3022a4006769e0776c3eafc57</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GProxyResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ae1cb23c9cd789ef7e4bad90b0829d47e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_supported</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a2f9af129acc2febba9ba323bf436a243</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a4e68fd5cf69ed433028eb4008b09dd21</anchor>
      <arglist>(const Glib::ustring &amp;uri, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a2c7e661f21582b059e2cbaa4fa2ef087</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_async</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a4fe46f67b2787252395103798a9891d2</anchor>
      <arglist>(const Glib::ustring &amp;uri, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_async</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ab46bc2b5f3672e11ea26c0289aea572e</anchor>
      <arglist>(const Glib::ustring &amp;uri, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>lookup_finish</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a7872e9993471e704373b3d6236b2a066</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>aa5f390c09142e4a6c8fd6bedf310f154</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ProxyResolver &gt;</type>
      <name>get_default</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ac8cbc11eb57150f28dfc8f6046bb4648</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ProxyResolver &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a3f4b5af03af6650ce85eb1df6e50add6</anchor>
      <arglist>(GProxyResolver *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Resolver</name>
    <filename>classGio_1_1Resolver.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Resolver</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a91fb01b808b2e2d315d9ffc149f1f71e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a4d323772493d0cf739816c80f08398d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a77d572cc0c4a48c47ec06e9a5f2d02a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GResolver *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae1cf170f1700985b286238d5f1dcbab2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aea1576fa2684d9bca58a589098a8371e</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a4aaf18d0bcc67d6d139d993b140a8b14</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_name_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a0130482bb442e3a006e06d57665c2318</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_name_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae38a0fc714443839c0bb3a0e40dcd082</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>afaf6f9f003fd213ebecb893d60f14380</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>abb5740225148191d2e93d7a6b12caf23</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a81f793a31c8ddaa2bf26361721c3fd1c</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_address_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a3bfd36d312e60b748df35089d5126b4f</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_address_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a91d05a43f8083af54826fcb3303e0eba</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae127e4682bfb20ef0b292e7b98460762</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aab5e246c4f14e55e079c8a280dd3de5b</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a3b131a66a7a7bd3e89713384ff2f6be3</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_service_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a49d103c02f6e0e8ad5d4e7abb1967ef0</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_service_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a58d46752ddd5305d811df4707c3ce4a7</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aae68cb39415c9286474d92c7aeba2e47</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_reload</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a097abf4f88816a46fa2272430a1b5e3d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Resolver &gt;</type>
      <name>get_default</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ac822ffe60ab0ce2acfdc85ccb908f6fc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_default</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>afbb1fb4f9edb0e553dbb61ca2437601c</anchor>
      <arglist>(const Glib::RefPtr&lt; Resolver &gt; &amp;resolver)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Resolver &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aa710fc39dacfe0e34730487741d84fb9</anchor>
      <arglist>(GResolver *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Seekable</name>
    <filename>classGio_1_1Seekable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Seekable</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a9b3fcb7df7b3e63b737e5bc5c7e74271</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSeekable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a96176a5c51102b9a2d02f4555f2e048f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSeekable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>ac60caf803ddd50d08115da50ccb149dd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>goffset</type>
      <name>tell</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a3f270a74f487712bb0a89d86a8313987</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a5dd0a134172ea72595a9c7b2072e0350</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>aa717d10e2322df67b488657add79c70b</anchor>
      <arglist>(goffset offset, Glib::SeekType type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a3404742af5d7855f6017578091f432cc</anchor>
      <arglist>(goffset offset, Glib::SeekType type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a961a029a8498e9223ed9c136cfe14597</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>aaf0792e6281670ea411cd7c3ef981998</anchor>
      <arglist>(goffset offset, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a4458c08f1486ce89f8a7f9b49f10eb13</anchor>
      <arglist>(goffset offset)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>ae8a94d31313527ff431cf49ba5af2bd8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Seekable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a0756ddeb91dc62f76d8a380716ecd228</anchor>
      <arglist>(GSeekable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Settings</name>
    <filename>classGio_1_1Settings.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Settings</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a4c89c4537e05922457cf09f279d6fcab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSettings *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1350e8f1b8a2f0f02c0e00d0cd7077d0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSettings *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a3c1af502c3c7a372b07987c4d8e320c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSettings *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ade0eeed443f1dfbc4b649bb294e445f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_value</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a3b98d9d71ac41b70f09caf6cb4341183</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac36cd4d128d4af6c0aac34572f4d0930</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::VariantBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_int</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1f980e517365e5aa4520e982f5e11b27</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_int</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a7b252643c8ce35c7892cb0b831d67046</anchor>
      <arglist>(const Glib::ustring &amp;key, int value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_boolean</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a0e00e5ad1bf22709184cb576e4b933a7</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_boolean</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a08d737b902c907b692894ab577c4142e</anchor>
      <arglist>(const Glib::ustring &amp;key, bool value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_string</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a52bda84f1cb85f2efab6b82c72b41b7f</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_string</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ad1b4617d76cc9166e68bc849d22c5677</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_double</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac5055dc109007beb12256ca312a0c356</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_double</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a81b1bebc7cbf6518aa13ab00bf9966d5</anchor>
      <arglist>(const Glib::ustring &amp;key, double value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_string_array</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae5524c5c368069a6676755c01b968f10</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_string_array</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a9e6e1bf8334f40cb76999a0678ac1b41</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::StringArrayHandle &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_enum</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a4f6a1558661cba8ceea376fc9f81f52f</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_enum</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a7fe28dd8bb422f55471d636e6bc5b648</anchor>
      <arglist>(const Glib::ustring &amp;key, int value)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a679796b7368f679fa28478c6861cdad9</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a049877419a2d25a282ebbfd013bfea79</anchor>
      <arglist>(const Glib::ustring &amp;key, guint value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Settings &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a98cfd433996d89d031108ca92e4d43d8</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Settings &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ab5afa45ac5edd6ee5c3d55325c9984a9</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_writable</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aa04dc0ea2f4f4a1c8ad369e5a4238399</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>delay</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a33b026961c111c7cb811dd8886bd10aa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae1309ff09c69e278fbb9869219c3ac03</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>revert</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac11529acbf1dd553e5f3ebc5c0125ecd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_unapplied</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a84b99d6419887e0812f3a58eaece8e88</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a8fe9b5174d02d36b6b8fdacb0b10a049</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>list_children</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a9cdbcfb1fd556ed9655f22d011f9b731</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>list_keys</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a11d8a88cf1feacbf3057dc9d90ec3eb0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a39d962b3e73ec10608a3a744cb4255b4</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::ObjectBase *object, const Glib::ustring &amp;property, SettingsBindFlags flags=SETTINGS_BIND_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a893453b68172f5ecb6c008d2d642da3f</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::PropertyProxy_Base &amp;property_proxy, SettingsBindFlags flags=SETTINGS_BIND_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind_writable</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a47c913cd1ce8122d742911fa54896fa7</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::ObjectBase *object, const Glib::ustring &amp;property, bool inverted=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind_writable</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac0da884631dc04c338287e475a5b93fe</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::PropertyProxy_Base &amp;property_proxy, bool inverted=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aedb2d1200cfc06141c56daf8a6c45456</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, guint &gt;</type>
      <name>signal_writable_change_event</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae24c1784fc1f2fae4f758ea62bc70c31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_writable_changed</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aa155c63e6c1c5218e3793f86f9cab0ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Settings &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a7a7fcf5a7c18611e224541309841205b</anchor>
      <arglist>(const Glib::ustring &amp;schema)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Settings &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aa985b9447d252fb8d8d1e727e51b0b7b</anchor>
      <arglist>(const Glib::ustring &amp;schema, const Glib::ustring &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Settings &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a8d879cd82351641ce98efd2d040e95bf</anchor>
      <arglist>(const Glib::ustring &amp;schema, const Glib::RefPtr&lt; SettingsBackend &gt; &amp;backend)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Settings &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a4b2c0db48dd738829cd689cb9c807531</anchor>
      <arglist>(const Glib::ustring &amp;schema, const Glib::RefPtr&lt; SettingsBackend &gt; &amp;backend, const Glib::ustring &amp;path)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Settings</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1c549bfe41401ed0fb2eb7059cf8a45b</anchor>
      <arglist>(const Glib::ustring &amp;schema)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Settings</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a947930fadf94b1d0a4860eeafc04dd76</anchor>
      <arglist>(const Glib::ustring &amp;schema, const Glib::ustring &amp;path)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Settings</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ad498658b424471ad8b3eef10e0926a8c</anchor>
      <arglist>(const Glib::ustring &amp;schema, const Glib::RefPtr&lt; SettingsBackend &gt; &amp;backend)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Settings</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a6fdaf1cc7ab4887762a6556cf1b5c3e4</anchor>
      <arglist>(const Glib::ustring &amp;schema, const Glib::RefPtr&lt; SettingsBackend &gt; &amp;backend, const Glib::ustring &amp;path)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a4e88dd069cb1aab8e39ca1c058e552ce</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_writable_change_event</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a6824e75577a579815cc9eaf64f8b15f9</anchor>
      <arglist>(guint key)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_writable_changed</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a2428f5d4bf7c40753fc112412197c5cb</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Settings &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae47167a74b09e7410bc6eadea3ba989c</anchor>
      <arglist>(GSettings *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SettingsBackend</name>
    <filename>classGio_1_1SettingsBackend.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SettingsBackend</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>a84d4869febcd7642dd7876eff49669f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSettingsBackend *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>ae5521fb90b8aae1f610648fda6138069</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSettingsBackend *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>ab9bd0420ba1597360a91b6d013a2a4a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>backend_changed</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>add96ce3033e6fd3ba1aeffb18a14d66b</anchor>
      <arglist>(const Glib::ustring &amp;key, gpointer origin_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>path_changed</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>ad680c4ef9591e342f60e1515b925505e</anchor>
      <arglist>(const Glib::ustring &amp;path, gpointer origin_tag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>path_writable_changed</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>a0c03014629849b84ad784af4c4c747a1</anchor>
      <arglist>(const Glib::ustring &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writable_changed</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>a1aebf56390162a2a61ab621734e2338c</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changed_tree</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>a5bfb05cbda552a85e8a799daf0f071d9</anchor>
      <arglist>(GTree *tree, gpointer origin_tag)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>acb8a693799e4f9c0885fe9116649c535</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SettingsBackend &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SettingsBackend.html</anchorfile>
      <anchor>ae4edf13cc72053f8a0ce1868b6cbf6cb</anchor>
      <arglist>(GSettingsBackend *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Socket</name>
    <filename>classGio_1_1Socket.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Initable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Socket</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a8efac59d8562ceb635b76fe70087572d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocket *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a1d51f7bcd83450331d7261898e9007d6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocket *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a51c7fa832ce1c984a7bbceb4d7ba93a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocket *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ae2fe06b1a579c40b596933da0ded4e37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a16044bba5924c183cff90f0a4cf47394</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, bool allow_reuse)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>listen</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>af16eed3fd42f3769b5e608f96db214fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a137ae34a8f211eaed11f9a58ca6b3f5e</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4b6c036db4e484e6b7f0419962254888</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9ab220f5714a6116d35e846b00f4ad23</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a0828763fe472d46aed833fad30af1c0b</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>check_connect_result</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a06b68dc0948e6dfa158487c314f9a521</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a742403f4d076ba9050a435d95fea5d1c</anchor>
      <arglist>(char *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a73463b7677ffdfddaced49bdf170b4b6</anchor>
      <arglist>(char *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive_from</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4d2d4382139553881ae139920e8db93e</anchor>
      <arglist>(Glib::RefPtr&lt; SocketAddress &gt; &amp;address, char *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive_from</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a056fd2c3609971d5befcf2b4ccf51aa3</anchor>
      <arglist>(Glib::RefPtr&lt; SocketAddress &gt; &amp;address, char *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>adc5c3145109841e0406150ad0b7f547c</anchor>
      <arglist>(const gchar *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a986efa2a33528ce5aba0d7c6a7be1b65</anchor>
      <arglist>(const gchar *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send_to</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a8b2d4ff883535e696b6cdaacd730f729</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, const char *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send_to</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a929c8c4e0c10a39d65358853e94d9c4f</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, const char *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aab30d39b9e73fef6401c76d1d4edc118</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a7ac925f7e6592ad4a96afe0f75411a96</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shutdown</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4f685bc040e9e10abe093deec0719fd7</anchor>
      <arglist>(bool shutdown_read, bool shutdown_write)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_connected</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aea9561511b77e652271705fbfdb2f8f2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::IOCondition</type>
      <name>condition_check</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a86fdc5d814fd61abab15ec03c7da20ec</anchor>
      <arglist>(Glib::IOCondition condition)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>condition_wait</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aaae28fa63035c05396064f5f4bb4fc36</anchor>
      <arglist>(Glib::IOCondition condition, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>condition_wait</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9ae420715a2050cc09112f178bae88ba</anchor>
      <arglist>(Glib::IOCondition condition)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>adc7b9d6cecc1c2234f9979b2ffb1b309</anchor>
      <arglist>(int backlog)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a22a9e70db9abc7fc6383641afde8ee6f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a51d5a174441c255b69be9e809cdb96b3</anchor>
      <arglist>(bool blocking)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a1ffcbc226b08ae14856ea0dfe4d580e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a6cfac67927584ae7afe53006eebb06d7</anchor>
      <arglist>(bool keepalive)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a530b4adc3d295f7c000981286dee8019</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aac1e2a576e62d1e339eefae1fe12e24b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>af3bb5076efcb022e31db9622a1c6e0ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a654e36f8577b61a4df93a0a70479a7f1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_remote_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>adce45788b8ac674bdf32a3ec8fb683c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketProtocol</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4ecd966ee71eb956258b289cf63eb43e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketType</type>
      <name>get_socket_type</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a05cd563d5bc68362f3a574054ce63481</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>speaks_ipv4</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ae33e646694bf6c5062683ba4b79d4fe1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Credentials &gt;</type>
      <name>get_credentials</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a2fcda0eba8fcb30bd020624ce3f14d8f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Credentials &gt;</type>
      <name>get_credentials</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>afcc5b5f562eb0255d846a41bde23d0f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ae6c0fdc10c1dd971bd75241dc8e3edaf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a004c9014634a2d15bf72bde26d0946d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketFamily &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9644d9441f3c4217c5f4f59b8821d966</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_fd</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aad681d273768f49f75fbee70abaa97f2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a2dc3436d7a9a94b4355fef411659845e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a86d147686d1bc91bc1350ed522ce04eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a013fbb1ab58b01f7f7457a1069ab5f4f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a24c7c56d57439271b9817ae13447550e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_local_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ac52bc9e13993758922ce0d3683f336af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_remote_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a0affc1f63146a265a1d1c2b884091708</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketProtocol &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a5b8ba56215c4f828d0db182c72ee5c1f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketType &gt;</type>
      <name>property_type</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a43cc07ec00548b77642200014a160400</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Socket &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aad87b57121a04302e4d9b41c322f59ca</anchor>
      <arglist>(SocketFamily family, SocketType type, SocketProtocol protocol, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Socket &gt;</type>
      <name>create_from_fd</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a8d0268c13028a8e3eeb551ca14b83b8e</anchor>
      <arglist>(int fd, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Socket</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9d2455e8d617dc7a828480d65db7b473</anchor>
      <arglist>(SocketFamily family, SocketType type, SocketProtocol protocol, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Socket</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a74d7c4338fcf53743f23926fccc8c6d6</anchor>
      <arglist>(int fd, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Socket &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4b4f2145105f84580f0a2659a9e8e5db</anchor>
      <arglist>(GSocket *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketAddress</name>
    <filename>classGio_1_1SocketAddress.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketAddress</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>aeedceaf982ff7e7dc75d419022bafde1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a1f65b6f40eeb9a30eb613345be919eb6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>aa2c5c7f04c127ad5037814f847ab2d6f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>afe1a5b0091f024fa725ff31b88d01e7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>ab4fb1e63e629e88e5263e8bf5d095809</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>to_native</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>adec995b9e46746a5d55b3c5af592ec44</anchor>
      <arglist>(gpointer dest, gsize destlen)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>get_native_size</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a25fd6c43478da2eef785467f75ba02ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a3d2233d8fc6b47668d38d4b450b5bae2</anchor>
      <arglist>(gpointer native, gsize len)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>adf0c2a59f4fc452b8b8e81f86ed1dc43</anchor>
      <arglist>(GSocketAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketAddressEnumerator</name>
    <filename>classGio_1_1SocketAddressEnumerator.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketAddressEnumerator</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a4d707b12b6751fb9b2331d66f84578cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketAddressEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a4e72db226aa1d74293b99dc1af495d29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketAddressEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>aba67cc02b09d4cea3a9a1df65dc9b726</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketAddressEnumerator *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a38a1287d76bd77803c85439077dd019f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>next</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a2aac35c9406f82a2c627e70d815ad4f9</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>next</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a2a0ab29942c1516f22127aea2a184d09</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_async</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>aa8c329070a4465ccfce945bb2cb24bd1</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_async</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a5fccf3d959f7ea6cfab87ef3c751513f</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>next_finish</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>ac125504ce63d7d6f562a197f85b4e174</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketAddressEnumerator &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a333f94acb7c1811f6c649de72427f9d0</anchor>
      <arglist>(GSocketAddressEnumerator *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketClient</name>
    <filename>classGio_1_1SocketClient.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketClient</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a1991de732f92e167da3707775f6f11c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketClient *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a0cab44f8d959f5561ce09db40f37fbab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketClient *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a1ec407a9162517f19d11d343376d17b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketClient *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a740585d6674ed733071adb9e363eac97</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a9ea53526045a866da66afd1159d66378</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_family</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>abbb05b3692bd0a44edc3f97909c8a06b</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function">
      <type>SocketType</type>
      <name>get_socket_type</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ad1377482afae4c1dc6e8032c5f186886</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_socket_type</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a48c627d9a69600bb5276a798c4f28bb9</anchor>
      <arglist>(SocketType type)</arglist>
    </member>
    <member kind="function">
      <type>SocketProtocol</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a5a06cbe4921463c3838b092e24f0c922</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_protocol</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>af1dce19d3e7d03342df0fc59cc5fd180</anchor>
      <arglist>(SocketProtocol protocol)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>aa86e32cfad979f41423cd5f188668761</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a93e3955a892a0f08b838b63536a2a7a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a70fffdb258e88a89b193d55175a4ac11</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>adc4843134253e4164ff2a88d7157d941</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnectable &gt; &amp;connectable, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a4fe4a6da1e0d5c257a0c403ed5d9ed29</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnectable &gt; &amp;connectable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_host</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a3ccf9ffb7da2fda13c486db95190022d</anchor>
      <arglist>(const Glib::ustring &amp;host_and_port, guint16 default_port, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_host</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>aa3690d023ef5323e4374e64876cf23d8</anchor>
      <arglist>(const Glib::ustring &amp;host_and_port, guint16 default_port)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_service</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a2eb95cad0f24bd060e407bb9a03b4e29</anchor>
      <arglist>(const Glib::ustring &amp;domain, const Glib::ustring &amp;service, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_service</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a5dd523c612cbfb762ffbc66e7186a6f9</anchor>
      <arglist>(const Glib::ustring &amp;domain, const Glib::ustring &amp;service)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ac72506d54e8b9a6a288e97890bd02428</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnectable &gt; &amp;connectable, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a1c61ed29ce5197e72b910701c2654f0c</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnectable &gt; &amp;connectable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_finish</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ae72760264a73e7013cd6a44118246140</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_host_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>adecacab1a97c8293ff8181c234a7d140</anchor>
      <arglist>(const Glib::ustring &amp;host_and_port, guint16 default_port, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_host_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ad8e0be1bed11128046292c5a8e3e6221</anchor>
      <arglist>(const Glib::ustring &amp;host_and_port, guint16 default_port, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_host_finish</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a519e772e91e08afa019fefd41797f0cf</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_service_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a01c8e91e6b392a2bdd3185e6d272de76</anchor>
      <arglist>(const Glib::ustring &amp;domain, const Glib::ustring &amp;service, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_service_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ac9c710b06b609593e6dada7c8c44e83d</anchor>
      <arglist>(const Glib::ustring &amp;domain, const Glib::ustring &amp;service, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_service_finish</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>af3f1887916549a434a2b1dbde2271105</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; SocketFamily &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>aaeb81cb6f6963638a384d24b1b60e4f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketFamily &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a421291a49ba0425727b091ce55f86169</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ab8e42af55ac48bc251f4651eb0ab304b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>af2e8727f1a260e775833ccb1ca632013</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; SocketProtocol &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ab00c4d06e77e7050e57ba80fdcfec2f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketProtocol &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a6fa5c0616a4f6facd74eefed399e0b69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; SocketType &gt;</type>
      <name>property_type</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>afc2ab9d6f4ba1ea17cdaf5599be9de5c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketType &gt;</type>
      <name>property_type</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ab38738d8284645fb09575122a487b42c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketClient &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a769c130f5e7e5855892e47917a981b8d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SocketClient</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>abb8de2a3854aae7741efae1093929fd7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketClient &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>afe64acd90030e7e0128470f329b62129</anchor>
      <arglist>(GSocketClient *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketConnectable</name>
    <filename>classGio_1_1SocketConnectable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketConnectable</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a4cb889aad12cbcf04f6c64002f040226</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketConnectable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a25988d9aeb115345500d09b282cf7023</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketConnectable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a5ba8bd26578fa49ce4a6f8fbb544858c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddressEnumerator &gt;</type>
      <name>enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a52dcce3726042d15225accd1413689aa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ac5522339bc623835f4a7245205d2ce5c</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketConnectable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ad7c218506ae7370a57399d87d1ec1459</anchor>
      <arglist>(GSocketConnectable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketConnection</name>
    <filename>classGio_1_1SocketConnection.html</filename>
    <base>Gio::IOStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketConnection</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a475fbbbecd4fdc73a814f0123f67f9e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a64ee8c7b7af10f959e1ddf0badfdb5d0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>ad9c7556fe550d295cc67b6d128da1c2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketConnection *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a8aaaeca771edee679c8550972add66ba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>get_socket</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>ab5913458956df812371086bda641f512</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Socket &gt;</type>
      <name>get_socket</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a06bc1b92d486ef54d617090d5d717c71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a04953ff02f45951bc3d56ef5315a77bb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>aca0be2d355a88059035e0cdd2815070c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_remote_address</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a4c31833dcef2ca7ac5a87bfb87868a39</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddress &gt;</type>
      <name>get_remote_address</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a4150b9c55eecac1aac9e2ecd5587eb51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Socket &gt; &gt;</type>
      <name>property_socket</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a7fc0eff608a308e73361bef904884033</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>aa1808bd3d8d8a069aefe0856d10a1345</anchor>
      <arglist>(const Glib::RefPtr&lt; Socket &gt; &amp;socket)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketConnection &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>af05cf28021ec850be5c5d691d287a19b</anchor>
      <arglist>(GSocketConnection *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketControlMessage</name>
    <filename>classGio_1_1SocketControlMessage.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketControlMessage</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a1897230c7d1ba4c52f73e01964bb8541</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketControlMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a97e6e55c88c8f9b1f1a8f7e3af07c8da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketControlMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a85206fb4ad9d3c31bcce0a451d163334</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketControlMessage *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a1065632f7968d8047a9783ec48a8fad7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_level</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>aef4de30adb5a102526a38f5740058807</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_msg_type</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a44dd04c620f42277ab2310b2bfc09d2e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>ad4614038ef853aea294d3708005ecda3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a2137251ce7cf980eb5cabb656de266c9</anchor>
      <arglist>(gpointer data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual gsize</type>
      <name>get_size_vfunc</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>af8675992e2db2694ee1186c39fbaa284</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>get_level_vfunc</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>aa7efa3e548eb61edc214caa2009eaf57</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>get_type_vfunc</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a61d0903d8bfdbc629a1803e47b65db36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>serialize_vfunc</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>ab24ab562d8b308ef103223ebee3ddd47</anchor>
      <arglist>(gpointer data)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SocketControlMessage</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a166e0661cc74954dc20aaebb51a9cc71</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketControlMessage &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a7435ea455d9fe22543d135da294db37f</anchor>
      <arglist>(GSocketControlMessage *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketListener</name>
    <filename>classGio_1_1SocketListener.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketListener</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a72cc482888057f1e6747309e382ae669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketListener *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a112233a13be0e663a39b677d8c1a8952</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketListener *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>aa0befe419ff983ed1b28e5b1c99b511b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketListener *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a9cdd04703b826b397f73f0bbf6badf99</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_backlog</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a1e0b34890d5475229a96696b3bc136c8</anchor>
      <arglist>(int listen_backlog)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>af14e9d38af77406d829fda8c1090c06b</anchor>
      <arglist>(const Glib::RefPtr&lt; Socket &gt; &amp;socket, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>aa24cb88b5d0e78505e533e65fb8e7dea</anchor>
      <arglist>(const Glib::RefPtr&lt; Socket &gt; &amp;socket)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_address</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a478b171019370dee7059c4a8fdaf6ec2</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, SocketType type, SocketProtocol protocol, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object, Glib::RefPtr&lt; SocketAddress &gt; &amp;effective_address)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_address</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a17961c5dff54d2d6e311c50d2c744bc1</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, SocketType type, SocketProtocol protocol, Glib::RefPtr&lt; SocketAddress &gt; &amp;effective_address)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_inet_port</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a3ccffa841f43c0df0f632eb54ad1b441</anchor>
      <arglist>(guint16 port, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_inet_port</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a59491f0159709ed08cd71c55cb738def</anchor>
      <arglist>(guint16 port)</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>add_any_inet_port</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a7639ca25eb3efe301ba08df635c2fc37</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>add_any_inet_port</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a8cf1d0491124ef2eb40de9a4392e973b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a5a9657d9840d3e9d85efb406bb2393d2</anchor>
      <arglist>(Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a3e79b5b10555b73e4359671cdb53e038</anchor>
      <arglist>(Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ac1951a2d25a34ee2305e8d82ae45250f</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a7caaf5afa1bf47bce88db9322271f804</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>accept_socket_async</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a8fcc271647a1aa8628d2b2e60dd53d16</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>accept_socket_async</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>aac3928ba157107d4f7609d8686ae4c6e</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket_finish</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a8875402a2dd1c5b1705236fd89081b3c</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket_finish</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ad6aeb8c8c05167b47a1479e2cbf8453c</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a9329c1c706b3e53e8afbf29b8b320a68</anchor>
      <arglist>(Glib::RefPtr&lt; Object &gt; &amp;source_object, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ae6658e2ae53b7108ee7f6b15dddbfa56</anchor>
      <arglist>(Glib::RefPtr&lt; Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a2a0508771a9423713be6bf642fd1a3c4</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ac06069d9d192be5fe770272f213bc9e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>accept_async</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a671c1485ca21446d5e0d2e555c05fa21</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>accept_async</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a27c6ce168ebbebd3848b246d7b9ecb64</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept_finish</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ad09943bd09686f6cba2a6ad661000592</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept_finish</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ab9a973269f259350e38b7843dfa93aa5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>aa6da0570259eeeee527757628dc0f351</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>affdd3f3f729d7e4250685f45f7fbefdc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a3e69246769b0c483cf395865efa62f32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketListener &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a9ccbd6cc071b99b9631a84e50f920c67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SocketListener</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ac60f15482d07f3d1396f7aba35f03462</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketListener &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ad1255a07751ad4ab4cf8c76ffef73d7e</anchor>
      <arglist>(GSocketListener *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketService</name>
    <filename>classGio_1_1SocketService.html</filename>
    <base>Gio::SocketListener</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketService</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a3ab42152cf2cf9e02ab2ecfbdcc85b02</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a6e08a8e365648d3b7b8d78e694f9e136</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>adf4f54dcaa8e285061e5101e1ca37187</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketService *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a02c4f3bec98ba70fd2cc2663227cc5d3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a6dfa1c48a8a600b19bd51c211086ebd2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>aa7dd1c079cb8348dadfe0aae2fe17165</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_active</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>ab7a6caab3830da1b5aee21f412165ede</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; bool, const Glib::RefPtr&lt; SocketConnection &gt; &amp;, const Glib::RefPtr&lt; Glib::Object &gt; &amp; &gt;</type>
      <name>signal_incoming</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a83f8517dbd5d47aca17ae1d473c62ef7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketService &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a40a2042eaff19ac07203edf3563770e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SocketService</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a1c4e09eb82f5cebc40fc679359986999</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_incoming</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>abf31b054cf96e76b61b52d6db828474e</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnection &gt; &amp;connection, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketService &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>af8d745c9fb106e7ae3d85e443e9b7424</anchor>
      <arglist>(GSocketService *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SrvTarget</name>
    <filename>classGio_1_1SrvTarget.html</filename>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a8aedab3176f67cfd04621cf50225cbaa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a2897e03425b8a29f8199b82bc30c683d</anchor>
      <arglist>(GSrvTarget *gobject, bool make_a_copy=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a39893a5f54f11a7b7aaa1d534ddab141</anchor>
      <arglist>(const SrvTarget &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>SrvTarget &amp;</type>
      <name>operator=</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a64c9981401d91fcfdd64e4f3f90de7d4</anchor>
      <arglist>(const SrvTarget &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>afa511e356ee4caa752b9489ca3374542</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a2c0d698efc035391fb75d506d6dab1fe</anchor>
      <arglist>(SrvTarget &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>GSrvTarget *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a6c3577ff466e24fde7da91dbb8267942</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSrvTarget *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>aa1f565df7de8461f815e28175a2746ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSrvTarget *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a6b59da54bc6f97e17b1aa34e4b110608</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a4c7ea721d35439712d77e031ef46c15e</anchor>
      <arglist>(const Glib::ustring &amp;hostname, guint16 port, guint16 priority, guint16 weight)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_hostname</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a9fde92e3f76aff55f7b93066a0c20e18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a128f762bd022cac6727ad488137d5830</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_priority</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a84eafd7887631f0d910a1d764de166f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_weight</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>ad86b3be1b52aeb216e915e2620854b16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GSrvTarget *</type>
      <name>gobject_</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>aca9c337827344ebc87400d400e1bd267</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a227f6813cdaea409308c3253e8d583ee</anchor>
      <arglist>(SrvTarget &amp;lhs, SrvTarget &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>Gio::SrvTarget</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>ab09dd935751f2e15732c5f90d9c49cf8</anchor>
      <arglist>(GSrvTarget *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::TcpConnection</name>
    <filename>classGio_1_1TcpConnection.html</filename>
    <base>Gio::SocketConnection</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~TcpConnection</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a460e51993bd952f688cea902e7d02c23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GTcpConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a508d386c8df898197a17111b751de117</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GTcpConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>aa572fc2171ec0c880b5883b44ec47f63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GTcpConnection *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a20bf39e1c736ae833b61b28ae7782f11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_graceful_disconnect</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>af8ebdafdd65cdd474ecda7c6f57480c1</anchor>
      <arglist>(bool graceful_disconnect)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_graceful_disconnect</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a15fd744d53d648f80e11627844b1fa9e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_graceful_disconnect</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a44f637fc8ed0b3c43b0b020817a60599</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_graceful_disconnect</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a581a783104e60ffc94fe1cd7a47becb9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::TcpConnection &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a49374d0d4787fd7904044cd68369f23b</anchor>
      <arglist>(GTcpConnection *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ThreadedSocketService</name>
    <filename>classGio_1_1ThreadedSocketService.html</filename>
    <base>Gio::SocketService</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ThreadedSocketService</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a3ece526a564acd8b4b9222c43c0e06b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GThreadedSocketService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a96312b53e69f1f46fc6de0561dfaeef2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GThreadedSocketService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>afb30f6700033321e12b7cf6aff933a6e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GThreadedSocketService *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>abe79abc5c8e85b5a5a7147060a145318</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; bool, const Glib::RefPtr&lt; SocketConnection &gt; &amp;, const Glib::RefPtr&lt; Glib::Object &gt; &amp; &gt;</type>
      <name>signal_run</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a4344f0e5a46d79f3c0e4d8fb77270c8f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_max_threads</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>ab3782487ff1f44edc88daed1448c35c4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ThreadedSocketService &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>ae7418690132dfb019dd5c4b44281e3ea</anchor>
      <arglist>(int max_threads)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ThreadedSocketService</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a4d4514d72b332558f58b8511bd64311d</anchor>
      <arglist>(int max_threads)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_run</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>ac464e420a34995b48bba33ee8f8729b9</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnection &gt; &amp;connection, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ThreadedSocketService &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a0456c34762034433f8d642659256fedb</anchor>
      <arglist>(GThreadedSocketService *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ThemedIcon</name>
    <filename>classGio_1_1ThemedIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ThemedIcon</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac5c41faafeffac479079e871edc4a66f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GThemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>aa179d9788f6a17df73a258c6f89049fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GThemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac962dc5a62c1d2b19611a497d92671ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GThemedIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a077eea103e0f5713697f55cb66243997</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepend_name</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>aa61fe78bdd8512c138a3ec23c6fa32f6</anchor>
      <arglist>(const std::string &amp;iconname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_name</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a15fb8158d3eede3d3aa4050fbdcbe124</anchor>
      <arglist>(const std::string &amp;iconname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_names</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a1c5b06d64d5b6a6c9419cb2dafe891b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_use_default_fallbacks</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>add0cea54573bfff7a41d0f8d60445ced</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ThemedIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a843b98f320f1aa6316d55f266fbf8219</anchor>
      <arglist>(const std::string &amp;iconname, bool use_default_callbacks=false)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ThemedIcon</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac378bb89f60335fe0c24e10ce96cba12</anchor>
      <arglist>(const std::string &amp;iconname, bool use_default_callbacks=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ThemedIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a6e1861d53d63b929cd84e012e704c396</anchor>
      <arglist>(GThemedIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Volume</name>
    <filename>classGio_1_1Volume.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Volume</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a3d35e595beb2a74009a06c42a5d26ccd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GVolume *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>af75306117005b88b2c3f678d7a4e81fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GVolume *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a93fc1178f76cfc3bd14210f6e042a526</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ac66808206b78f8d721a08c8d3377b02a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uuid</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a099a949c09c9218e35d04a1fc6b1b526</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a1c127e8f75fc65bb5abedc810bae6448</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a2a19117219838e05748eff7a432893b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a666ee0dc70e5f4aefa194d64c489dc5d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ac0e436e5d0503de051501b668d674a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>get_mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a24b406858eff715570864fc787520a42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Mount &gt;</type>
      <name>get_mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a5cbca187b9f04da9ad42d523a3766287</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>adc2040fdc6985444b6f17ee5e1d65573</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ae09d0182b4deb272957016fc8b08ec46</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>should_automount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a1d2a3feca8a056d064be4db77809bc26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a17599f8132a9c8a4ef9bfc0f5645033a</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ab506f07856b214bbf09d52f76ba94501</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a4620147fca3f9de5bcba571415f47349</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>aa34ce25eeb35a5c86dcedd1db5104579</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mount_finish</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a76b89705e10164880792f17d6670f655</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ac238638763e26aa3e838d9abc1dd63f7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a7d9d20ce35aceb00c89d093e2e944c79</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a0eb78deac53941d4fe83e5b889cdf848</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a9844d9de96e64d547b9f91c745abb8c6</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a7d520a329a66ee666955c0a85b5085ce</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a75cf0202b35942ab2c36dc9086704064</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a0f7234208d822c48a732ac0a84362473</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_identifier</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a8f1582d0af0f02639db5a9a271c6fa11</anchor>
      <arglist>(const std::string &amp;kind) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>enumerate_identifiers</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a67368fcdf28762a5a7eefbb4fbc82b40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_activation_root</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>adbf1a1ad7b49e483a0990a6d30765010</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_activation_root</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a2500d8babf1e205170f8f8a73f3ec884</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a87fc3d3e43291cbaaadf0900e44cc3ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_removed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>adda17e98cd46e9a08a78064e4392fd9c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a284c9080be40b24012691302ec96568e</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a7a28465c703fbc59e85e62eb0ee53cc5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_removed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ace7a6a8760d17f19f0620c4aeb255455</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Volume &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ad88965901e2804959a1df827a721a547</anchor>
      <arglist>(GVolume *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::VolumeMonitor</name>
    <filename>classGio_1_1VolumeMonitor.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~VolumeMonitor</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac726e6da4be5f55347f3ee81902dd5b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GVolumeMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a26f35f4479293662897520eb7b06542e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GVolumeMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>af0f6fda541a5b69b87971e2728f18ca5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GVolumeMonitor *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a26c03982f6bebaaa15e5682e051e58c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Drive &gt; &gt;</type>
      <name>get_connected_drives</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac4a5e2749a0439bd75779b2a6b6783da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Volume &gt; &gt;</type>
      <name>get_volumes</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a3781089d1267a1663bc9120ab21db25a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Mount &gt; &gt;</type>
      <name>get_mounts</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a93723d6d66d3349f0a958390cf9d02af</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Volume &gt;</type>
      <name>get_volume_for_uuid</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a8ac52203cace8e352f1adce1fe7f385a</anchor>
      <arglist>(const std::string &amp;uuid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>get_mount_for_uuid</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a379fa574824d12a68309d015e367171d</anchor>
      <arglist>(const std::string &amp;uuid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Volume &gt; &amp; &gt;</type>
      <name>signal_volume_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a8d55505f95820af5b7b12dacd3d3969a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Volume &gt; &amp; &gt;</type>
      <name>signal_volume_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ab185c68fcb6d60d7c1aa8bb8297a8401</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Volume &gt; &amp; &gt;</type>
      <name>signal_volume_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a79c7a849f12b7849c68d827fc43c47ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>aa2547e4e1ef9a3e172f1ddc3118e6b23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a8b2bab7ce793a0d90dbb4ff681b6f559</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_pre_unmount</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ab4e2b566fcee2dc841c123f30855fff9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ab7972f59213c7a01c1086fa668768617</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_connected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>abe8053e0681fca3c8c8af58f8c6a99c7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_disconnected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a2894836b90cc97f18c13137f8ae9cd2e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a0f99a06c42eb70593432e305099266ba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_eject_button</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac2fa5fa6ab82a9e29f5cce8975bce81a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_stop_button</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a393811457e1b82a246459e978478d605</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; VolumeMonitor &gt;</type>
      <name>get</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a25c516228d8ecedf40d45e82e4bbb3c8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Volume &gt;</type>
      <name>adopt_orphan_mount</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ad02559ca69412cc5e202302de3f37a95</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_volume_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>acedc14897e721109142ae5d5fdf4daf0</anchor>
      <arglist>(const Glib::RefPtr&lt; Volume &gt; &amp;volume)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_volume_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ae57c09c2c8e5322ae8f241c92cae5e5c</anchor>
      <arglist>(const Glib::RefPtr&lt; Volume &gt; &amp;volume)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_volume_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a9838b33847a193882538a5ecfb5c8679</anchor>
      <arglist>(const Glib::RefPtr&lt; Volume &gt; &amp;volume)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a5323ab624d89a6488cfd08aaf6ff248e</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ad912e1894509b15010e87f242982bcf5</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_pre_unmount</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac51d8587804a6c09cf1a4476a21bf318</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>aa20faca7436ee75febf9112b163e4d77</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_drive_connected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a1c8095c8ab8bed1f8b09d97aedf2ef33</anchor>
      <arglist>(const Glib::RefPtr&lt; Drive &gt; &amp;drive)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_drive_disconnected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a70cb85fac2f07bdec4f896e5e3d7716d</anchor>
      <arglist>(const Glib::RefPtr&lt; Drive &gt; &amp;drive)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_drive_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a32f398cde4a82c609f5e60667f4a2afe</anchor>
      <arglist>(const Glib::RefPtr&lt; Drive &gt; &amp;drive)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::VolumeMonitor &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a6e2656255f0de0710b8c35524b67ec89</anchor>
      <arglist>(GVolumeMonitor *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DesktopAppInfo</name>
    <filename>classGio_1_1DesktopAppInfo.html</filename>
    <base>Glib::Object</base>
    <base>Gio::AppInfo</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DesktopAppInfo</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a8dbb1f225b0f9512c0cef546b7d32012</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDesktopAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a3098e225a5b79ac496941ae2ab804c0c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDesktopAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>af6f5698a7fd78187bac77556ac54622f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDesktopAppInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a60fe723570666ef15c3b024bdfaf6165</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_filename</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>aba05bd82eb13c39f1ec8b6aeb233cd03</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hidden</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a23113d028a906d5b3e2626dc558f36e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ab6d9c00e00745f57d2e5b35f83060aad</anchor>
      <arglist>(const std::string &amp;desktop_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create_from_keyfile</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a4c474a10b54e12eac4cf71ee409c61c0</anchor>
      <arglist>(Glib::KeyFile &amp;key_file)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create_from_filename</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a42dca267f3ad09aaacd4937d20e4ed1d</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_desktop_env</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ad3d07eea529c72d51aa868fe30d63392</anchor>
      <arglist>(const std::string &amp;desktop_env)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DesktopAppInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ac075226810f278017e3a0fbcc372e739</anchor>
      <arglist>(GDesktopAppInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixConnection</name>
    <filename>classGio_1_1UnixConnection.html</filename>
    <base>Gio::SocketConnection</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixConnection</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a8ee81174ad727f97dda927deb38e2ce5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a9aedb22a5a9706ae144b2d4d21f57a45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a1a22c655f5fe21b9c670eaf1ea01eef7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixConnection *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a1372a4da6cbecbad7a80dde274921024</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send_fd</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>ab40d022ded6013f70072d3b69dad9b46</anchor>
      <arglist>(int fd, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>receive_fd</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a33a49ee939a8232b9a41501bf5d90a88</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Credentials &gt;</type>
      <name>receive_credentials</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>ad50ee58c1df7c351358e003c70e17d56</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Credentials &gt;</type>
      <name>receive_credentials</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a330ec633856353620e781123ca2ce46d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send_credentials</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>abe2f3b0f09c25340816677fe34653c51</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixConnection &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>ae45f6ec45d565efddc6215d44cc017d4</anchor>
      <arglist>(GUnixConnection *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixCredentialsMessage</name>
    <filename>classGio_1_1UnixCredentialsMessage.html</filename>
    <base>Gio::SocketControlMessage</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixCredentialsMessage</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>a909f7fbdb10c78194acb1dc456bcbc50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixCredentialsMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>aeebce74d3e79d9cc2fab4ec5cf114206</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixCredentialsMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>ade289685b886a71cc315b1fbc7cbb822</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixCredentialsMessage *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>ac68e4ef0dd2786ef1ca482504f14f496</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Credentials &gt;</type>
      <name>get_credentials</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>a93647219a626d1b8d21687fd59b196e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Credentials &gt;</type>
      <name>get_credentials</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>a3c49c17b7fcc93db357fe910c06c7cfd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixCredentialsMessage &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>ab8eb09a8b771de8ca634e4e4780ac091</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixCredentialsMessage &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>accab1f2a5621f97eb320bb283b0a7c39</anchor>
      <arglist>(const Glib::RefPtr&lt; Credentials &gt; &amp;credentials)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>is_supported</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>abdfe6efc4bf659ca9557ebbfbfdfc6c6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixCredentialsMessage</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>af041e1e9b3e01ded2696f73d0d2da394</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixCredentialsMessage</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>a881bd0106fad4a555d0af457cc153458</anchor>
      <arglist>(const Glib::RefPtr&lt; Credentials &gt; &amp;credentials)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixCredentialsMessage &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>ac549c0849cc357cd39da842d53cf02fd</anchor>
      <arglist>(GUnixCredentialsMessage *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixFDList</name>
    <filename>classGio_1_1UnixFDList.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixFDList</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>aede85e064f0dd4c5eb8d3157793cd799</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixFDList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a13369401ffc5804f1d08f21f8767efb3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixFDList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>af1eeeaeadc809eba2061eaa6c22d9107</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixFDList *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>aa584b34d376383010cbf72c999a39442</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_length</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a509aef6d94ac576341436e97073a6cca</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>abee8d9542776283f7e621fdfcc03badb</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Glib::ArrayHandle&lt; int &gt;</type>
      <name>peek_fds</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a3a649024e1da34de1c0659338e7df07c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; int &gt;</type>
      <name>steal_fds</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a9167e4e9d3adf8f06405d4928b15b614</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>append</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a8e99c050949497a05a6e65e8b2548101</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>ad8865d446428f2590a7393c54e655307</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a7095f1477818fa6cce563e1260933c5c</anchor>
      <arglist>(const Glib::ArrayHandle&lt; int &gt; &amp;fds)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>aee6c787908674c69e6d39a859c08b7fb</anchor>
      <arglist>(const Glib::ArrayHandle&lt; int &gt; &amp;fds, int n_fds)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDList</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>af994190fe054980701789befb81bbbc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDList</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a5b668c1766c02bb0a2661384695942cb</anchor>
      <arglist>(const Glib::ArrayHandle&lt; int &gt; &amp;fds)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDList</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a24759393f0445985fd7ddadbc9acd41d</anchor>
      <arglist>(const Glib::ArrayHandle&lt; int &gt; &amp;fds, int n_fds)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixFDList &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>ac7c943cb9e8b46bfa4f6bae95569b7c7</anchor>
      <arglist>(GUnixFDList *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixFDMessage</name>
    <filename>classGio_1_1UnixFDMessage.html</filename>
    <base>Gio::SocketControlMessage</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixFDMessage</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>ad9374324d214f5bfbbb8d609e6ee9fca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixFDMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>ae6df3f6003202acb871dd6649ca8d073</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixFDMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>ab9af0b10611b98572c784e720a385b78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixFDMessage *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a7d9b6c8bfa419d0010712b40c2a7aa4d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; UnixFDList &gt;</type>
      <name>get_fd_list</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>aecf8e53af113ebfc1f47730f2910fdba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const UnixFDList &gt;</type>
      <name>get_fd_list</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>aa7b7f1c61c34cc8298af0c7bb06fc7a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>append_fd</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a7e3f1da81fe5c9a50592cceb30b7a167</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; int &gt;</type>
      <name>steal_fds</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a22b7789635651e38f767f0018e447a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDMessage &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a5195f6f4f5f27112269bbbd5a9996075</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDMessage &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a3fbc7ddfcfafe4fe966c2195a1a52d4e</anchor>
      <arglist>(const Glib::RefPtr&lt; UnixFDList &gt; &amp;fd_list)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDMessage</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a5a92924d8bd62f4ca79ce0f404d42fc2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDMessage</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>adb2b787dac2ad113ae51fa34ab5c1cc2</anchor>
      <arglist>(const Glib::RefPtr&lt; UnixFDList &gt; &amp;fd_list)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixFDMessage &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a25f3bfe7cde291aafaed41c70831e947</anchor>
      <arglist>(GUnixFDMessage *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixInputStream</name>
    <filename>classGio_1_1UnixInputStream.html</filename>
    <base>Gio::InputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixInputStream</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a21a51896fece91ec2034dea1a47f659b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>aa0b863b654d38a9e10f7d7d49b82c5ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>adc7b87c43606f90378a521df99220971</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a5f05de3f98b2dd8e7f0f2c5038fbc69f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a86e845ad209749c3358634a58be66023</anchor>
      <arglist>(bool close_fd=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a110e2c9201e53065f2140053ebb442c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a6bf398ce16adca31b594e0f4fad40a76</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a9fc70aa3eb7e8b9848bf0995351d51be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a1dd943a8606e68c30916b50f9c495d0b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a136c4f6529c203b8aa613ebd9ac027af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>afa7800e1d9f83a7f6c9e89691ddccab5</anchor>
      <arglist>(int fd, bool close_fd)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixInputStream</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a7df00cf2bbccab59d70af960eff25bf9</anchor>
      <arglist>(int fd, bool close_fd)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a631c2896887d90e8fa13ac8132c9f5db</anchor>
      <arglist>(GUnixInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixOutputStream</name>
    <filename>classGio_1_1UnixOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixOutputStream</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a176f5170fbd871cfc5a9ef60c9fc93e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ac22d258873e88661e29140587687d1d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ab9e89719d791ca893290ef5074fe2cf7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a9d24719266d36067e08320d597f84f0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a537abb20777901b37115aa527c791599</anchor>
      <arglist>(bool close_fd=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a9cfacde4665024383bbb8d40c70c739f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a60dbaa5fc2db03c096452693b9eb6bf7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a2c176ac39c262c3aa42ab49cc40baaff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a9eec7de6ee2ae4829c944162ad4027cf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>aedf70cd26e305a13423a790b9c60efe1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a95b6f82ae5e6dcc7019e825750db9c37</anchor>
      <arglist>(int fd, bool close_fd)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixOutputStream</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a846c3deb5eb713f50c5a04422f161623</anchor>
      <arglist>(int fd, bool close_fd)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ad0dc702aab1a415385bf6225fc71388f</anchor>
      <arglist>(GUnixOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Gio::DBus</name>
    <filename>namespaceGio_1_1DBus.html</filename>
    <namespace>Gio::DBus::Error</namespace>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBusConnection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotBusAcquired</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>aed3251a2fcc05a4b265bd1dbc81fe46e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBusConnection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameAcquired</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a56e01dbdcac480bd1f2bf655f7a674ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBusConnection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameLost</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a8f22a5b567bbcd4c81c34f30e31b7c44</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBusConnection &gt; &amp;, Glib::ustring, const Glib::ustring &amp; &gt;</type>
      <name>SlotNameAppeared</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a13a1fe1021315a9d6abd939afbdc5c41</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBusConnection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameVanished</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a8513dd94bd178d301b95f11c6bda957d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusNameOwnerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90e13b67fdf97528695baa4a6a18b051</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051a6f6a351717c214f7504c32d91bb1ce8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051ac35f459d321c52977e12b1cfb97e7a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_REPLACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051aac4ada47441dcb1ac4e24fc78155c7fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusNameWatcherFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga724a510e53ed4df47411bcdbaf680c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_WATCHER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga724a510e53ed4df47411bcdbaf680c85a01d4229ebcfb078416d859d7f242504a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_WATCHER_FLAGS_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga724a510e53ed4df47411bcdbaf680c85a08efa890043aa8a8930a0c7b79b9872c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6ee165e164ee5ac76fcae97d149b0096</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae95dbcb5c39a041199a14ef692ff190e</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga66e5ff30c50eda68a6e9c9856ff24929</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76ae3c19edb95730bbf26a8bd2fe41fc</anchor>
      <arglist>(BusNameOwnerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1082185ea5b919ef8e797f5a4a2cbd84</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3b00479dfbf4a7ead540cf77612f13</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8256822b508991b36784f8633f5a2a41</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>own_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>acd901a4cdf248002a91dcecaee1c9bfb</anchor>
      <arglist>(BusType bus_type, const Glib::ustring &amp;name, BusNameOwnerFlags flags, const SlotBusAcquired &amp;bus_acquired_slot, const SlotNameAcquired &amp;name_acquired_slot, const SlotNameLost &amp;name_lost_slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unown_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a56eb716650330a147b033d7aec56e0ed</anchor>
      <arglist>(guint owner_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>generate_guid</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>acbd4641e60f1d74c59a644008642cfbf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_guid</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a1eeb38fa15e8f909ac91f9d19a64e547</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a05c67dee67b2ccccdcb0c19714abd5e1</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_unique_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a04c3f3efa55c252ce9299a934f3bc9ed</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_member_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a2383c7d151a59adc91e4fbfbd1e4652a</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_interface_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>af8f12ce74f2521c357d814a0105359ea</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11d69d7cecb05e6a1ab2e29802001c0d</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e9cd27579fc08b486bf6963e0e48828</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3c6767c920f33ef0acf5273d87d44191</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f09a804dfb04f4a256cfb22cac05378</anchor>
      <arglist>(BusNameWatcherFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3cde961e2c29d55871ad3cb2b4d0f7b1</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a9b2721d1528e637f826498f93486be</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga606fa2da2a5a44a01e084c959fd1cca2</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>watch_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a102df4db2c9a1122f2c6d461953ef505</anchor>
      <arglist>(BusType bus_type, const Glib::ustring &amp;name, BusNameWatcherFlags flags, const SlotNameAppeared &amp;name_appeared_slot, const SlotNameVanished &amp;name_vanished_slot)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>watch_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a18fe6b989ff1e40b770697acd2cea824</anchor>
      <arglist>(const Glib::RefPtr&lt; DBusConnection &gt; &amp;connection, const Glib::ustring &amp;name, BusNameWatcherFlags flags, const SlotNameAppeared &amp;name_appeared_slot, const SlotNameVanished &amp;name_vanished_slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unwatch_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>aa5106315b09d6fc5ad019ecfcc8d5342</anchor>
      <arglist>(guint watcher_id)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Gio::DBus::Error</name>
    <filename>namespaceGio_1_1DBus_1_1Error.html</filename>
    <member kind="enumeration">
      <name>DBusError</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1b341a5947f8025ec1b38a8b4dbfcbb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a8a6252fa73d350e87f6135090958e4e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NO_MEMORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a3ad98e2aee167d4e7c133f7d8e7fcd0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SERVICE_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9fe839d46dbf157fe52e9dc0a5c29fcf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NAME_HAS_NO_OWNER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a073550042a52f04d435bf4fb1d63b17d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NO_REPLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a4e63b7adf8bb001ec8cf2ac39bc5e074</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_IO_ERROR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a6fea0e79b52b625ff387afab049c851d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_BAD_ADDRESS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a46b057da0025ef4c766baaa0263c372e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NOT_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9f27417f751ea54009a297bd9ab8bf99</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_LIMITS_EXCEEDED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a902d800a60a8a6953e8540ff433e1a9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_ACCESS_DENIED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3adbe1ea11a15ad6f820b861b3fcb97d60</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_AUTH_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a8f6d73b15e1b23f5b7c6c973274c3553</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NO_SERVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ae5c0a4db40d3232fc1d4befaadc93ef7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_TIMEOUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3af76f4836f259d393ea62c2f5acb5c381</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_NO_NETWORK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a03f49b1ec1889c78049242a4dc9e8bba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_ADDRESS_IN_USE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3aab4f81aed041923c5b17b025b44a5ac4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_DISCONNECTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a1870fca6b3958d2f8fba286f91f860e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_INVALID_ARGS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a710eaef39a468e36cb6bec55f9844f54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_FILE_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a31ff1fde8c7672b8ebeef5811700410b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_FILE_EXISTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3aa8d5ff2f84ce5a5584c8349c384b0ee1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_UNKNOWN_METHOD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a93f182d8f2956fd030d6f2b45fe1e99e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_TIMED_OUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3aef80f58c0063ba7e4c607295cb8bc96f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_MATCH_RULE_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a33a5262d710bf333fe59d6174ea4b8cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_MATCH_RULE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3abe506d68d5ca39e730352fd23b09df86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_EXEC_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a61e5f3e83b131d2cccb0fd754a460ea8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_FORK_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a624d8259d9421be5650f48db8db45c0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_CHILD_EXITED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a3362b9054c5acaa404deafac62271da6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_CHILD_SIGNALED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9ee2a496856b47f0e65b642877d3212e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ab0dd1356d58f1544688800ee58660962</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_SETUP_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a1a4499045a2a1a2aabd4f57784719792</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_CONFIG_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a2535f7c79af7e9dc8274f090d8559daf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_SERVICE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3add87fd73e1e2fa8d55f7a16bf9d8cb66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_SERVICE_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ac6d7496162930a544dc48b367af11f0f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_PERMISSIONS_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a64665dbb2768d0a40590ee666da9150d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_FILE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a4ebf25ee0f21c1ef1de73e1702a66079</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SPAWN_NO_MEMORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ae5a909b07125508ae4559726d1d8f8a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_UNIX_PROCESS_ID_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3ae027768e6ac9d77a95bccc7bb3b65860</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_INVALID_SIGNATURE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a511626827492429e879a3e30b2ef082d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_INVALID_FILE_CONTENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a7f350b45750a7a1e61b88a677d6be451</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a0e2cf606b00964895d155450f4932aef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_ADT_AUDIT_DATA_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9c04490292009753f508472c359eb944</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR_OBJECT_PATH_IN_USE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga1b341a5947f8025ec1b38a8b4dbfcbb3a9e3df4e0addf2527b03617ca2d1ac6df</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_remote_error</name>
      <anchorfile>namespaceGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>a0f90730655c0c30f13eac7b5b6e97a5c</anchor>
      <arglist>(const Glib::Error &amp;error)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_remote_error</name>
      <anchorfile>namespaceGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>ad0433f939f19eb17c95c28535beb612d</anchor>
      <arglist>(const Glib::Error &amp;error)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>strip_remote_error</name>
      <anchorfile>namespaceGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>aad2f9b27cabe6dda7c82526d93f09116</anchor>
      <arglist>(Glib::Error &amp;error)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Glib</name>
    <filename>namespaceGlib.html</filename>
    <namespace>Glib::Ascii</namespace>
    <namespace>Glib::Container_Helpers</namespace>
    <namespace>Glib::Markup</namespace>
    <namespace>Glib::Unicode</namespace>
    <class kind="class">Glib::BalancedTree</class>
    <class kind="class">Glib::Checksum</class>
    <class kind="class">Glib::ConvertError</class>
    <class kind="class">Glib::IConv</class>
    <class kind="class">Glib::Date</class>
    <class kind="class">Glib::FileError</class>
    <class kind="class">Glib::DirIterator</class>
    <class kind="class">Glib::Dir</class>
    <class kind="class">Glib::IOChannelError</class>
    <class kind="class">Glib::IOChannel</class>
    <class kind="class">Glib::KeyFileError</class>
    <class kind="class">Glib::KeyFile</class>
    <class kind="class">Glib::MarkupError</class>
    <class kind="class">Glib::Module</class>
    <class kind="class">Glib::NodeTree</class>
    <class kind="class">Glib::OptionError</class>
    <class kind="class">Glib::OptionContext</class>
    <class kind="class">Glib::OptionEntry</class>
    <class kind="class">Glib::OptionGroup</class>
    <class kind="class">Glib::RegexError</class>
    <class kind="class">Glib::Regex</class>
    <class kind="class">Glib::ShellError</class>
    <class kind="class">Glib::SpawnError</class>
    <class kind="class">Glib::ThreadError</class>
    <class kind="class">Glib::Thread</class>
    <class kind="struct">Glib::StaticMutex</class>
    <class kind="class">Glib::Mutex</class>
    <class kind="struct">Glib::StaticRecMutex</class>
    <class kind="class">Glib::RecMutex</class>
    <class kind="struct">Glib::StaticRWLock</class>
    <class kind="class">Glib::RWLock</class>
    <class kind="class">Glib::Cond</class>
    <class kind="struct">Glib::StaticPrivate</class>
    <class kind="class">Glib::Private</class>
    <class kind="class">Glib::ValueArray</class>
    <class kind="class">Glib::VariantBase</class>
    <class kind="class">Glib::Variant</class>
    <class kind="class">Glib::Variant&lt; VariantBase &gt;</class>
    <class kind="class">Glib::Variant&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::VariantIter</class>
    <class kind="class">Glib::VariantType</class>
    <class kind="class">Glib::SignalProxyBase</class>
    <class kind="class">Glib::SignalProxyNormal</class>
    <class kind="class">Glib::SignalProxy0</class>
    <class kind="class">Glib::SignalProxy1</class>
    <class kind="class">Glib::SignalProxy2</class>
    <class kind="class">Glib::SignalProxy3</class>
    <class kind="class">Glib::SignalProxy4</class>
    <class kind="class">Glib::SignalProxy5</class>
    <class kind="class">Glib::SignalProxy6</class>
    <class kind="class">Glib::Value&lt; bool &gt;</class>
    <class kind="class">Glib::Value&lt; char &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Value&lt; int &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned int &gt;</class>
    <class kind="class">Glib::Value&lt; long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long &gt;</class>
    <class kind="class">Glib::Value&lt; long long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long long &gt;</class>
    <class kind="class">Glib::Value&lt; float &gt;</class>
    <class kind="class">Glib::Value&lt; double &gt;</class>
    <class kind="class">Glib::Value&lt; void * &gt;</class>
    <class kind="class">Glib::Variant&lt; bool &gt;</class>
    <class kind="class">Glib::Variant&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Variant&lt; gint16 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint16 &gt;</class>
    <class kind="class">Glib::Variant&lt; gint32 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint32 &gt;</class>
    <class kind="class">Glib::Variant&lt; gint64 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint64 &gt;</class>
    <class kind="class">Glib::Variant&lt; double &gt;</class>
    <class kind="class">Glib::ArrayHandle</class>
    <class kind="class">Glib::Sequence</class>
    <class kind="class">Glib::Dispatcher</class>
    <class kind="class">Glib::Error</class>
    <class kind="class">Glib::Exception</class>
    <class kind="class">Glib::HelperList</class>
    <class kind="class">Glib::Interface</class>
    <class kind="class">Glib::ListHandle</class>
    <class kind="class">Glib::PollFD</class>
    <class kind="class">Glib::SignalTimeout</class>
    <class kind="class">Glib::SignalIdle</class>
    <class kind="class">Glib::SignalIO</class>
    <class kind="class">Glib::SignalChildWatch</class>
    <class kind="class">Glib::MainContext</class>
    <class kind="class">Glib::MainLoop</class>
    <class kind="class">Glib::Source</class>
    <class kind="class">Glib::TimeoutSource</class>
    <class kind="class">Glib::IdleSource</class>
    <class kind="class">Glib::IOSource</class>
    <class kind="class">Glib::Object</class>
    <class kind="class">Glib::ObjectBase</class>
    <class kind="class">Glib::PatternSpec</class>
    <class kind="class">Glib::PropertyBase</class>
    <class kind="class">Glib::Property</class>
    <class kind="class">Glib::PropertyProxy</class>
    <class kind="class">Glib::PropertyProxy_WriteOnly</class>
    <class kind="class">Glib::PropertyProxy_ReadOnly</class>
    <class kind="class">Glib::SignalProxyProperty</class>
    <class kind="class">Glib::PropertyProxy_Base</class>
    <class kind="class">Glib::QueryQuark</class>
    <class kind="class">Glib::Quark</class>
    <class kind="class">Glib::Rand</class>
    <class kind="class">Glib::RefPtr</class>
    <class kind="class">Glib::SListHandle</class>
    <class kind="class">Glib::StreamIOChannel</class>
    <class kind="class">Glib::ThreadPool</class>
    <class kind="class">Glib::Timer</class>
    <class kind="struct">Glib::TimeVal</class>
    <class kind="class">Glib::ustring_Iterator</class>
    <class kind="class">Glib::ustring</class>
    <class kind="class">Glib::ValueBase</class>
    <class kind="class">Glib::ValueBase_Boxed</class>
    <class kind="class">Glib::ValueBase_Object</class>
    <class kind="class">Glib::ValueBase_Enum</class>
    <class kind="class">Glib::ValueBase_Flags</class>
    <class kind="class">Glib::ValueBase_String</class>
    <class kind="class">Glib::Value_Boxed</class>
    <class kind="class">Glib::Value&lt; std::string &gt;</class>
    <class kind="class">Glib::Value&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::Value_Enum</class>
    <class kind="class">Glib::Value_Flags</class>
    <class kind="class">Glib::Value_Pointer</class>
    <class kind="class">Glib::Value</class>
    <class kind="class">Glib::Value&lt; T * &gt;</class>
    <class kind="class">Glib::Value&lt; const T * &gt;</class>
    <member kind="typedef">
      <type>GPid</type>
      <name>Pid</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a48d413f720e558ccfc0e5b141fc07f0e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>StringArrayHandle</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga8e243b697be740f5f7d4b578ae50db41</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>SArray</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a4e357796ff84955c958209e877211f66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileTest</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_REGULAR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a3181e2e655e765b00dfdb1e1ea443f62</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_SYMLINK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a86cda9ff0bf25358070a9bc8b4a186d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_DIR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad3679641c18e5e4d4578c2122492cea4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_EXECUTABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad9ab64f07fd4fc2105b53b7379265535</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_EXISTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a37c8f223bda6b6ce2875490351989ddd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SeekType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa3767731311bdba4ef42dc99215e5cda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_CUR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa48f0a394042c3a8e117b2ae64af33960</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_SET</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa1e0d3b4a03e5dd32f135acc89982889f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_END</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaafa5ff5cdf7e6623866c717fe49cfbaec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOStatus</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_ERROR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea121996c81c45593110cd714bb81bc349</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5eaf249c5b8e984c37db0847258aeeae86a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_EOF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ead42ae91b402716ab4faaec9b0f3823fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_AGAIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea5a33609d7ff07e1d711185c0765cf5de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_APPEND</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a121e65986f06397730c4c36d09fb4dc7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_NONBLOCK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a3724a778574d25ba0bd83139a80b2c0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_READABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a162bfe5ccb18465d0f11e954cc4a89d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_WRITEABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7af9738e0234ae1d1f15c4512d6edb16db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_SEEKABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7ac1373a306084710994199b3de0137cfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a290937753007a9d182326eb334438a6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_GET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a9431cd6fcef2a716b7d313bd9cde85b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_SET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a1d4db9b335a96f503cd491973b162105</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KeyFileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5866be36312563d91e5a7be27348459b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_NONE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba06a606cb7b5f244a0f3ad4f5e67b30bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_COMMENTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba00058fa3d8e271d9ff5e1469dc39dc69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_TRANSLATIONS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba7ff723c84c930b978dccd6732eebe985</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ModuleFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga502283ffbe523adf38c69905ec8640f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LAZY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3acd94d05ef9ba97ceb6f3904b87f5bbfc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LOCAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a8e5768a91ee8dbf459785dee8b664b72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a9cbf95b359863e9296457cbb0f193169</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TraverseType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae3a70fa1e451da068323419e8c98e9a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_IN_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9aa7f260b474a886df2bf1aefcfc0f14b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_PRE_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9abed8efe71581ccb087323f38b6807661</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_POST_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a0af70e322b94dfbbfc98b100d21cef4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_LEVEL_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a16cd819f4ab8175453f6287aeefad870</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexCompileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_CASELESS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0f604aee4eae77ce7bca901c8b3de37d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MULTILINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daee58700869ae67ad0823d10a7c51cb9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOTALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da7ec3013d10b6360c921d67f23ff585fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_EXTENDED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da4ef80551354a8a16bcefaf9b35f55a17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da67404d06bba595dec28fb4e6e05da427</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOLLAR_ENDONLY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0d7cf52858b215b55ff10ccae9732dd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_UNGREEDY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daf9c564d8191b7220f0f072b3b694f8ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_RAW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3acb6bdd173741b57cf267be3a3c7f75</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NO_AUTO_CAPTURE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dac6ccf906840973453a55625b2edf2f25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_OPTIMIZE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da581257f414998f8ea0e0f55adf0844f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DUPNAMES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da895a8a3fb7141b91a1890ee0bdb1a6b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3cab374f897aaac10d71c5437f9d77f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dabbbc306156a05aa67fde8d86d6d3b3c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da8a419c54023c5dbedbd8960c9367d68a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexMatchFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac387b5b0e77b1726553e5d77e77191d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746afcdffce16a01e99f25f52bfe3deafd80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a70b70be752f4874a262c15b99b3ee75f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEMPTY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a58bc907f6f6e19c30456c895d18ea655</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_PARTIAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aaa4d21e1c7f7ab1df117d433cafc5ad6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aed663630c5623dc65f0ea23a04cf2979</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746af5656ccd40cd632e00bc71b08834386e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a4b76b13cfd30f891108f491a58dbb2a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_ANY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac76fe84aa6df3f8e6af74504ff5e7ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SpawnFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_LEAVE_DESCRIPTORS_OPEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26ddaa2a457be3bdc07bbd0d32e1a63264d90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_DO_NOT_REAP_CHILD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda0ad30b49d46750083ddd1e0643635e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_SEARCH_PATH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda341e5cb2803eb06a0f2f0431d6305e04</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDOUT_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda450919630c2ce753374d1d05760bb205</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDERR_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda5ae7fa0d4f6a0bdfc37adeb578634491</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_CHILD_INHERITS_STDIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda9fb3c6cfddb2ef201f7b11829da8b5d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_FILE_AND_ARGV_ZERO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda55dc12133953441059847e8633227a84</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ThreadPriority</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_LOW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a035a7bdc6a5b5eae6f644ed2605e8a37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a6216bb25baaaca32642841ade911a92e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_HIGH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448aef77081535e90116b203ce3b3b0fe523</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_URGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a5b79355bbd59c508995af57e0ed39a94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>NotLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga2dd111336e3b057b51ca5871795fffa4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga2dd111336e3b057b51ca5871795fffa4a9681fb4e85e62ba64e39a12526eaa840</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TryLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga7441a36336ea4cdb35c0fddbf3f97b19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRY_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga7441a36336ea4cdb35c0fddbf3f97b19adf6b2565785992ff637cbc453988841d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONTROL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac280382585f1014b43ed228760e7c558</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FORMAT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaaedc3e279c1c7e01f1bec907bbe313ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UNASSIGNED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eafc32abac3afbe8380d54790f178fd3de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PRIVATE_USE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5ca14907043380b1e9d725671bc71a56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea0b99b4f93ef273ea4c49fb82970f5e54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LOWERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eadb83c3e23724b6ef15888c6527a063bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae6e48ddd5b4eacb4cbf67fa902743458</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea57ced328464824fe23113e7b98a4ae61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_TITLECASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab72e09c06a5aeffccdd94d5695dfcbc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UPPERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea8f344db3f8e39ed99bc2c9665ab96c89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_COMBINING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5d22c0c4d39d68b815dccd52bb5ff01c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_ENCLOSING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea4508b84626068a2dbf23a69b96475e6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_NON_SPACING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea857864a5d1c145cc3ff8ccba54834f19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DECIMAL_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae75e5f353bc068ec3d8bf2555c540995</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LETTER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea19811baedb3dbc8afddde43d00eb3cd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea45a259cec90b0ada120fe7116be422b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONNECT_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea649c83b23fb3d9bd7bf1803858cc5afe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DASH_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaa1169c4e20b3a47f597005f84f9fa7fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea1ffaf2aac92ca1e818cf3e26b8301b90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FINAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab549f212a3f340bd660a962b298409ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_INITIAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab247e5e7480ecbf382b2128c600b8720</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5c9416f9219bf9282c49b7ca831f0c9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea806e11a7f8d1a0b0688a0237ad1fa190</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CURRENCY_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea40b40c2bb5d39acee2b81327e2efb905</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b693a82d2e497a2b13cae8d5668097c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MATH_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea28100e9fa5a262bbd32b973303746490</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea298582645a73c91d191b7e1dc61d214f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LINE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ead7650a40ddf3741e87a1039eba56b1a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PARAGRAPH_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b3c71c265af11b331d0ec4240af1c8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SPACE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac2eafb967dc62399aeb5ff27c8896b0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeBreakType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_MANDATORY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37c762c3c7b080f5795ed6f828231923</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CARRIAGE_RETURN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa6b7c9d7a0ac78d14cf06b18bfeb2ccf9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_LINE_FEED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7839936b879938c5056bdb55eb0b6b7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMBINING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa014f326eb07effe48f1b771459caa7c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa032b712c48700209c7cc414ca88cda34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ZERO_WIDTH_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaadb5ff8a11c4e596677d161903c732c56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INSEPARABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa38f51c8283586493a3ebd45fa3b0113e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_BREAKING_GLUE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa47784c7e2cd80f6ac179de7f7a3f54e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CONTINGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae80d6fef8acf765da47c8235e39f4896</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab37a6597dbf2e248b610769be7e5cb3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaada4027a9bfc5ffdf90e3be612adad7aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab1efcdcd3d6ecb55dff58a2e2ee1b9e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE_AND_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaafce05d8590e1b40ec427f8f78cf15ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HYPHEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7e6dd69fc00fdc42ab091a2916426dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_STARTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaabe412d94a1f7d9e92cc5a20f0b549626</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa52ebd39d1b02dfd368992a2ef8e7fa7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaad1284afc0511ab69aa18554b8306fbca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_QUOTATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa8fe57a799eacc3299fd256285dd1246d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_EXCLAMATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaf628849c1e5b531c022e12695c1f6f5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_IDEOGRAPHIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa22047a88734e9fe1e9e0fef994cfb20b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NUMERIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa50a61c3c53da7558d08c1fcbcfc3b138</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INFIX_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa07f3d0d76db141033eff38ee7577ffd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaafc02ec4862f016b6c2da35592f6cd62b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ALPHABETIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaea27a8970e74f93f485d45f6a1684586</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_PREFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa580794ffc9992e65666adce0611eecb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_POSTFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ca3941d5dea03a5c824ae55212db01a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMPLEX_CONTEXT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa3a96b8e59ba5815700d33c1f6006a339</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AMBIGUOUS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae79244811e61b30eb68ee02dc45f1c09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_UNKNOWN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaeb94f98b2233fae0afb38bf115b4b42d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NEXT_LINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ffad3080f483a6b97680db786836ced</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_WORD_JOINER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa9a74e7d947f75ef93d4e3aacebdb898b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_L_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab3449fb99a5694c3f6debd9d1a887a1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_V_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa156946aa6aec4f4e0f8e69d352f31f90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_T_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37082de3ccd45cca392c6dee935d7cc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LV_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7a11c61184436fe2fb6e74d0ea916f86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LVT_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa44dec475bcc1d26dc3ad905c302efc87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AsciiType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2e5a690ed07dfaa6f9ad9f1c57acd787</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALNUM</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787af7d63a99479102b5391b44f631b5f009</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALPHA</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ac87947c729ac3c3f9f58b0ca28460152</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_CNTRL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2e19c57ce5a6eac38d911a86cc44a2fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_DIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9acd9a82d0670a3eb0377db782f48853</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_GRAPH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2ecdbe5137af423fce73ff2bbb34d625</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_LOWER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a875d3cb7494e1548db0d37ab44d4057e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PRINT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9b1775043a8043d994c0c0ab890e86c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PUNCT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad3416d8662560db626259013ff72c58f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a7d7a68814efba3cf3d294475123413ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_UPPER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a5ae30681069b2ab88eed13e358c08090</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_XDIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad78490a35d65839f2f06449e7e472337</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>NormalizeMode</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848acbaee513b23e0066962df2e540cd4c99</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a169a0ae0910535038d8d403f874f0b5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848ad9fb4be6b95958030771b4e8cba4144c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a20e4b8b42b12a7972ca4f6c84030978d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa1cf5911572000f5273dc46fe2c5b270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a995775ef324bbd76a91a74c7f2686867</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a7c98a2300648a33ca0ebc87fed999ca5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa7f62ac84c5ed8a8868cbb49a889dd98</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OwnershipType</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga64c27560b41710ccf64a3679a3ba3f20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_NONE</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a7d594cffcc2d2d6c4313ddb4d6613c79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_SHALLOW</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a448c598cdc37e2de8a162e1020001715</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_DEEP</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a2a6d6bfadc36f9eda31af79d32928c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOCondition</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_IN</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918af244f3e8c1c9525762f3630befd76336</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_OUT</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a60f61c8f26f2bb61afd3ad8afd673099</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_PRI</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a36bb5411dda1131e5c23e17a8619c820</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERR</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a2e402c9fd5879c49ef5359fa4189acd3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_HUP</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ab5dcc0e24c236c027b041d362dcff35b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_NVAL</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ad37b5d6ba6a0c1ad98510f352ac2f885</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_HIGH</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834faa3219d7be6fa3282a80d7a850c401db9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_DEFAULT</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834fa597ed3aa6067516c9c752896f3816b5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_HIGH_IDLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834faf2d20696a8afab425c00268d981e9897</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_DEFAULT_IDLE</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834fae8c1127af0a2dab71f196a957dab8375</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PRIORITY_LOW</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a0c450f82b9e34689e2dda2038ba7834fac6034649b50f9f92a69c1e67b92ecfc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabf5fac564c47a7a9ad6037044c3909f4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga88965337df48a173a6b013e8243e4631</anchor>
      <arglist>(std::string &amp;charset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga58f7e4556c436a96c64b186bbc8f7f4c</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga40b5aa172fabd1f3dbf50a962d0d351f</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaf1b091e4397a7637e884148484b1f71e</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset, const Glib::ustring &amp;fallback)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga4517b17f2aad4cd5c0e0640de212d928</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>locale_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gacc062729285890a7e9b22bece6fb987c</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga6cf95dc00505401594260a360d70c17b</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga2bd94064ad97b43324a7854b62f0835b</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gada23cd7f7dc8eb25e99b867a55551763</anchor>
      <arglist>(const Glib::ustring &amp;uri, Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gab1cb94f4a4a70bad06b715fb14a252d9</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gae1b2f056bde3fbab578c602fe42e3de9</anchor>
      <arglist>(const std::string &amp;filename, const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaaf69aec83665229cc06596cf627d9d5a</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_basename</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga05dd67157ad35da4401263247b6f4d81</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_name</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabc1b404cc965f3da6beecddfe2623afc</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e018d8609ba17b0f6955505a8363bf7</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae652f47e7b61603b9a6b86b7251d5526</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6c089f23d6bfd92e083edc75519db75e</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga948edadd8ee7442b83d37dc3c325f890</anchor>
      <arglist>(FileTest flags)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9a6f5470f667596e897f5bfbd1068283</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga112ada474a7aad83af2bd49403abf41e</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2219c78993a5196ca2a435a18e0fc3a7</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>file_test</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga0b2fce78896a9a84f7ea3a5646cc7d36</anchor>
      <arglist>(const std::string &amp;filename, FileTest test)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mkstemp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae4c8d716bd109b6b8e1420a8c20b3507</anchor>
      <arglist>(std::string &amp;filename_template)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae91f239f1cf0123399374deed54fbf3a</anchor>
      <arglist>(std::string &amp;name_used, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga682379de4ea119540b4bdc1759e93e1d</anchor>
      <arglist>(std::string &amp;name_used)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>file_get_contents</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga835da54212fe78e833ac55b49150b989</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>file_set_contents</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a4c6c4cb2115f410b15f09634909b0b7c</anchor>
      <arglist>(const std::string &amp;filename, const gchar *contents, gssize length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>file_set_contents</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a3e51edee26822f97749f589138776850</anchor>
      <arglist>(const std::string &amp;filename, const std::string &amp;contents)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga0dd0a8800b6311ee8f3867eb27a72ae5</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7662618e73d046d4df5eb7cce3e487f8</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad61c57b0678c703e8a14230d18bacff7</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga548c1cb09208fef57e5d0b3c992d71b9</anchor>
      <arglist>(IOFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac3539f6df5e0c0658726f4f0573146f9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae84d9361a6154e6b0e8d099705ad6cad</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2180a5c566ced37bbeb37050d9632da9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOChannel &gt;</type>
      <name>wrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a671306f4a3a0cae5ab4d7a9d54886592</anchor>
      <arglist>(GIOChannel *gobject, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabac5e1493392116b118e4d1048e3fef0</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1827ef58fe5e85d65ff8166e51b33556</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacc28b21831114895abfdbae6c1908114</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab99ff1d7c6d96da2ddfcfd1c4954e9b6</anchor>
      <arglist>(KeyFileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7096a34594825c90d7b6257935a62eb1</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga80dd56fcaea8bc3f0a5f21b9d3049877</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac90869f74a743e2f99f55708c28a585d</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gade862759d091b90329ba8f85aa2fd010</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaacd06c8457fa8f31c1483f96c4933ddf</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga333d93ef372c08c322d27ac05bda0e18</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaa723a5b4d33e54167f7adbb18746004</anchor>
      <arglist>(ModuleFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae9df767ea1ec74b0d9d9acce426a07a8</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab903aa5397125ce37c66a259c4b1a5f5</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e73a634c6441630eddf8805b22dd163</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5c44b3a4eee7eefbb1f2d1d8f22642ca</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4ae748a01d312275d2ca4e15c5df5826</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69068f48bbea92cdd3cc7d69fdc017e1</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacb650222b1a3f6a44e72df95d815a7f8</anchor>
      <arglist>(RegexCompileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae6fd65d5a674d2e2e453793d86fa64cd</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaeefcf05c20e07dde23268b83a1ff1c45</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1425051a4ffed939a1bff1e0543c9498</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab63da3a959cbd5f00f4fa535e35eda08</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga29b80a6c4482fae8e19f9328ec0c3147</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga06c395f619dffca3f0fc483fab302122</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf192ce556cbd7ddb416e8078bdb09523</anchor>
      <arglist>(RegexMatchFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f30deab298559a873d7beca40279ead</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga283a3e82cd9d3da8746edbe13a6f616a</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga402d81f594d95305aa6e275aa74126ae</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>shell_parse_argv</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>gabc52fcb14cfc7a5ba37ca821cc837818</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_quote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga55ebfb935f2131b2ae40d339568f568c</anchor>
      <arglist>(const std::string &amp;unquoted_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_unquote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga449dc37c6ea7e7563740df86e31c263c</anchor>
      <arglist>(const std::string &amp;quoted_string)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaba6cac919da111ebf69667bf9f8006ff</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2d10b36fdc1ceb9fea2ffcd58406f3e2</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga84449a9a461b381f88f65435ef8389ec</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga065f45ca68d1397febf331293e4cc4de</anchor>
      <arglist>(SpawnFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabbe289c910b34a158f8dc22bb0b0095f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga93f15ab009ea244c1d8b069e27ec193f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga40166fcca8eb8ec5b148c82444553927</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0a530eed9f6343ea1d51cb8ec8051ce7</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga36b7c1d110d10f86f3ef5d6e10db206f</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga5d42ba801678215f3820382388df32b0</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0c4e1708989b50fb34266504cc038ee6</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gad4fbf31fdb5536b104f4f75bf58c60e1</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gacc157258907be90b58184baeebc9c740</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga648167a4af607f87763f1334fe5a472f</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga713bdb79396eda85ad186cb2db89564f</anchor>
      <arglist>(const std::string &amp;command_line, std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_close_pid</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gaaea8f41c7a08af3b2919ce64fd0c27e5</anchor>
      <arglist>(Pid pid)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>thread_init</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gab26d01c776801f1fff00753e97af4fc7</anchor>
      <arglist>(GThreadFunctions *vtable=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>thread_supported</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gad59d126f6197035e6f6a31e7f4d87818</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5bc1518eb5547dbb8af77b944ccaa048</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4c340e00aeb13a9124081f383283eed0</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga682a545ca2e86b3e162305e4f14fa8d5</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad7ea47582094c6d092a8f485e1e709c6</anchor>
      <arglist>(AsciiType flags)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69bba23f4c9a83c268d0599f241b8ebe</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f4b46bf548b21ef21a568ecc18a5871</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac1b0239e539cf250333fe0adc04dbb41</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_unescape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0c070cac984dc463fd60ccbdb4237e25</anchor>
      <arglist>(const std::string &amp;escaped_string, const std::string &amp;illegal_characters=std::string())</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_parse_scheme</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0cc4270d6796b2166964f08a5cb746b3</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_escape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>gad902095ab5049111caa9207770b0a437</anchor>
      <arglist>(const std::string &amp;unescaped, const std::string &amp;reserved_chars_allowed=std::string(), bool allow_utf8=true)</arglist>
    </member>
    <member kind="function">
      <type>Sequence&lt; Iterator &gt;</type>
      <name>sequence</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga33e5a3a70ef5f7bed112046726ff8b04</anchor>
      <arglist>(Iterator pbegin, Iterator pend)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ac90aee10d0b90e3d8a96a86b5394f87b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RefPtr&lt; ObjectBase &gt;</type>
      <name>wrap_interface</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a75643fed688d354848a0379d3da00133</anchor>
      <arglist>(GObject *object, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator|</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gab5937e9164f36f75ba87fd67903348d5</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator&amp;</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga12928ddba0f38406f19d55547bac552b</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator^</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga6416bbf923045261beb85241fff8ef0d</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator~</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga85461947d24f306cefd2fe17999deb97</anchor>
      <arglist>(IOCondition flags)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga8269a01826f8737d98ab0d345a0004f4</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11f46ad6051058eeeb34d5963a4f7c44</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga995d6d5d01db67af62661bcd5dfd1ad6</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalTimeout</type>
      <name>signal_timeout</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaadb206fcc112f086f9d47c016b1f2175</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIdle</type>
      <name>signal_idle</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga76792522d9680a05e232d3519a25f98d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIO</type>
      <name>signal_io</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaf391654b755a32169d18be4835677376</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalChildWatch</type>
      <name>signal_child_watch</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11ee7db80cc44ece02056a38bb049e3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9c2f67828083d74925b23c59ab868698</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga40e45835b7b461cba0f7a10fbb63c0d3</anchor>
      <arglist>(const Glib::ustring &amp;application_name)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga391655dededb496010eee2e92d0f1fdf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga7d5c429822c09048892c4dee9c8e08c1</anchor>
      <arglist>(const std::string &amp;prgname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga5e186fdb08835342a5866b11fe787ebb</anchor>
      <arglist>(const std::string &amp;variable, bool &amp;found)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga8e2c8f250aa7f059956737851ace08f6</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga862657f21e5a930541d048a920204f59</anchor>
      <arglist>(const std::string &amp;variable, const std::string &amp;value, bool overwrite=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unsetenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6fb89001630714ec9ee5244cab56343e</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>listenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga350a5f6f1ae631f748c89d8dbe7557df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga52964bfd712e8c9e688f668da51f3ed9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_real_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga30692e3263e66868878f535e0b7c9722</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_home_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9412ea70c7fea058c03211dac318f8e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_tmp_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gac42272146fd9320958132f1591d28991</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_current_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga06d93c95572d6a382b8cc4e09dd5a339</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_special_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gabc928a4e477df53f90e221a854cc73cb</anchor>
      <arglist>(GUserDirectory directory)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_data_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga821b704b5ede1583e4057990976d394b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_config_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae517b931f4753abcd48adb2769a8fc48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_cache_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa68121f26e82df1c293c82b89c8998e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>path_is_absolute</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gad82525f39f7408f97f2c096c4f721b3b</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_skip_root</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga306eee64abc3d28993895b826f4dd533</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_basename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga20ebf2917a7fce5d1901568017b95a35</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_dirname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae03457226c4239a74b83486739521434</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4a70bf050b3f318f87049ed30206a9a</anchor>
      <arglist>(const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gada06023cc39be3a44eb68e38d6cbea6c</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6afc89d45cc34f3cfce4a55f3f5e7afa</anchor>
      <arglist>(const std::string &amp;separator, const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>find_program_in_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4c4ecb9a3eb803ae6d9dee51e1e5b14</anchor>
      <arglist>(const std::string &amp;program)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>str_has_prefix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6b7e8354049756e92a97554a107618ac</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>str_has_suffix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga5c4e380ffc6617ac61ca92e203e45630</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;suffix)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga35e288b5ce34cb15eeec907421d2b77c</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gad24f3547c8d6b3ec56d7f5805a11d6ab</anchor>
      <arglist>(const std::string &amp;source, const std::string &amp;exceptions)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strcompress</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga85cd83bd40baf0119aac3ff0a9a5e7b2</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strerror</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga1eb869894996c91c0f69dbff96714c71</anchor>
      <arglist>(int errnum)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strsignal</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga44ce9f689aff8abe1e3073b209f360d3</anchor>
      <arglist>(int signum)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>usleep</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a5d75264c8b47f13fb33f973b0d4fc73e</anchor>
      <arglist>(unsigned long microseconds)</arglist>
    </member>
    <member kind="function">
      <type>gunichar</type>
      <name>get_unichar_from_std_iterator</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a1053052aad41d0dcf51f36c345bf4625</anchor>
      <arglist>(std::string::const_iterator pos)</arglist>
    </member>
    <member kind="function">
      <type>T::BaseObjectType *</type>
      <name>unwrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a104920ed41b79c0b3b0aeaf3ed63d84b</anchor>
      <arglist>(T *ptr)</arglist>
    </member>
    <member kind="function">
      <type>const T::BaseObjectType *</type>
      <name>unwrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a666f8c59e1804aeb02f48ff940fa602c</anchor>
      <arglist>(const T *ptr)</arglist>
    </member>
    <member kind="function">
      <type>T::BaseObjectType *</type>
      <name>unwrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a5bbf90603746c170d0a99cef59bbe2d0</anchor>
      <arglist>(const Glib::RefPtr&lt; T &gt; &amp;ptr)</arglist>
    </member>
    <member kind="function">
      <type>const T::BaseObjectType *</type>
      <name>unwrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a5bd5ddd4c962f4a26bf52a3ec783e8c5</anchor>
      <arglist>(const Glib::RefPtr&lt; const T &gt; &amp;ptr)</arglist>
    </member>
    <member kind="function">
      <type>T::BaseObjectType *</type>
      <name>unwrap_copy</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a6cdcc90e63b4650a8f03f72bce01902a</anchor>
      <arglist>(const Glib::RefPtr&lt; T &gt; &amp;ptr)</arglist>
    </member>
    <member kind="function">
      <type>const T::BaseObjectType *</type>
      <name>unwrap_copy</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ad344713e5c0ac8ee6a46f9d04181a60e</anchor>
      <arglist>(const Glib::RefPtr&lt; const T &gt; &amp;ptr)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Drive &gt;</type>
      <name>wrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a3c4b3f9afbb1f72fcd0db0fb9d96a23e</anchor>
      <arglist>(GDrive *object, bool take_copy)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::File &gt;</type>
      <name>wrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aa536133405cc52c5887f4b87879e3bd6</anchor>
      <arglist>(GFile *object, bool take_copy)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Mount &gt;</type>
      <name>wrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aecec41aa86f5a57489c23f367593802c</anchor>
      <arglist>(GMount *object, bool take_copy)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Volume &gt;</type>
      <name>wrap</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aa4ad6dff9c5f095f3b45b6af8124c883</anchor>
      <arglist>(GVolume *object, bool take_copy)</arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeBool</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a18cda661b07b4263cc52f7e2c78003c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeByte</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a4f6342e887ae9d266a27d35d57e9d2cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeInt16</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a4aa43fab174247705b5887ffeb0994e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeUint16</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aed273878b22e419d08bee1f8102f4651</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeInt32</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a313479d7314e547b11474c1b01f752fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeUint32</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ab25e22d1d65d3099da7c2beed8d1574b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeInt64</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a526371e5072a5aa41e0ef86506c7bbea</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeUint64</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>af04ab9098620945e587369e6b720a826</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeDouble</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aa71b7b8bbc542bd65e9d504504a56b5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeString</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aaabfc810e274ee2fc2dc901565c9c51c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeObjectPath</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ae233f0e5dd5934e393ce80264ef4f620</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeSignature</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aaa62b40dfc3dad48504e7b5fab5ecded</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeVariant</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a9dea6faf435083edec49e7710e2776bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeHandle</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ad1e34f3becbd993d4fa4d27d17880035</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeUnit</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a3fc71479bac9cea42bd47ed1f1951cc6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeAny</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>afa1e93221200c5e80dec5ac6c7ab8a98</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeBasic</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ab15bebee82ccd3b629b2282ec3b34e60</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeMaybe</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a5d79cb411ad5d9774bec14b2be0c3d30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeArray</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>abf5c22970672c0ab7523c44cbde4a31c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeTuple</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a55f4f856a5112872fa0ee2d8e7b1b78a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeDictEntry</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>aa7a3c5ad4d6df5537af5d21642c3d041</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeDictionary</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>ad9bb3e68fc1df827ffe85db7725c39e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeStringArray</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a4bd4f2c92a81e8402b8f651183b75c1a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeByteString</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a57997bcc6a9cf3f96b4381a92eaf750e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const VariantType</type>
      <name>VariantTypeByteStringArray</name>
      <anchorfile>namespaceGlib.html</anchorfile>
      <anchor>a66400d7d4b5ca37b649c84a772b518e6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Glib::BalancedTree</name>
    <filename>classGlib_1_1BalancedTree.html</filename>
    <templarg></templarg>
    <templarg></templarg>
    <member kind="typedef">
      <type>sigc::slot&lt; bool, const K &amp;, const V &amp; &gt;</type>
      <name>TraverseFunc</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a4ff14046f2cef700ea37b5b9eb1e2e4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; int, const K &amp;, const K &amp; &gt;</type>
      <name>CompareFunc</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a9d637241cab431a674cadf806c0a83d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~BalancedTree</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a6ad3ee2e4c7a396e059171800f703e13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GTree *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a3992ca9669a73f98167e988ce0ff4415</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GTree *</type>
      <name>gobj</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>aa95ee73b9302c6e53dce0e2b9a642b4c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a80e50b78322d85f165ac2d6607ca9cb3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a6530fc006eec5d249a520be7e8bf4f20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a1ff2e47b569956c2c8d19ba3f538346c</anchor>
      <arglist>(const K &amp;key, const V &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a751401d64137e241cacfec8e05ea5971</anchor>
      <arglist>(const K &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>V *</type>
      <name>lookup</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a1004e229bf2fccbd79b15a7f567a51e0</anchor>
      <arglist>(const K &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>const V *</type>
      <name>lookup</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>acc3b86a40f9c6ce3f2870d2d51627cae</anchor>
      <arglist>(const K &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>gint</type>
      <name>height</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>ab7f312cc9aa4a0cfc4d2b8b24b3d9749</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gint</type>
      <name>nnodes</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>aa5965a94bd4afaa5da1dfb1c6406fef7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>foreach</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>aa1235b0242c3d7d87310adb6e370ec12</anchor>
      <arglist>(const TraverseFunc &amp;func) const </arglist>
    </member>
    <member kind="function">
      <type>V *</type>
      <name>search</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a55668fb48bb53d3099084db1088c9495</anchor>
      <arglist>(const CompareFunc &amp;search_func, const K &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>const V *</type>
      <name>search</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>ae9339e46ced588dfc632ef35a6e97418</anchor>
      <arglist>(const CompareFunc &amp;search_func, const K &amp;key) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BalancedTree&lt; K, V &gt; &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a346b8289fc878c1d9d3398e81800208e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BalancedTree&lt; K, V &gt; &gt;</type>
      <name>create</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a225d6f1c845767474de9d024f9fa876a</anchor>
      <arglist>(const CompareFunc &amp;key_compare_slot)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BalancedTree</name>
      <anchorfile>classGlib_1_1BalancedTree.html</anchorfile>
      <anchor>a26c7764fe28c41b2527be4111ef76a59</