// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DBUSMETHODINVOCATION_H
#define _GIOMM_DBUSMETHODINVOCATION_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2010 The giomm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <glibmm/variant.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDBusMethodInvocation GDBusMethodInvocation;
typedef struct _GDBusMethodInvocationClass GDBusMethodInvocationClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DBusMethodInvocation_Class; } // namespace Gio
namespace Gio
{

class DBusConnection;
class DBusMessage;

/** DBusMethodInvocation - Object for handling remote calls.
 * Instances of the DBusMethodInvocation class are used when handling D-Bus
 * method calls. It provides a way to asynchronously return results and
 * errors.
 *
 * The normal way to obtain a DBusMethodInvocation object is to receive it as
 * an argument to the SlotMethodCall that was passed to
 * Gio::DBusConnection::register_object().
 *
 * @newin{2,26}
 */

class DBusMethodInvocation : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DBusMethodInvocation CppObjectType;
  typedef DBusMethodInvocation_Class CppClassType;
  typedef GDBusMethodInvocation BaseObjectType;
  typedef GDBusMethodInvocationClass BaseClassType;

private:  friend class DBusMethodInvocation_Class;
  static CppClassType dbusmethodinvocation_class_;

private:
  // noncopyable
  DBusMethodInvocation(const DBusMethodInvocation&);
  DBusMethodInvocation& operator=(const DBusMethodInvocation&);

protected:
  explicit DBusMethodInvocation(const Glib::ConstructParams& construct_params);
  explicit DBusMethodInvocation(GDBusMethodInvocation* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DBusMethodInvocation();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDBusMethodInvocation*       gobj()       { return reinterpret_cast<GDBusMethodInvocation*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDBusMethodInvocation* gobj() const { return reinterpret_cast<GDBusMethodInvocation*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDBusMethodInvocation* gobj_copy();

private:


protected:
   DBusMethodInvocation();

public:
  
  /** Gets the bus name that invoked the method.
   * 
   * @newin{2,26}
   * @return A string. Do not free, it is owned by @a invocation.
   */
  Glib::ustring get_sender() const;
  
  /** Gets the object path the method was invoked on.
   * 
   * @newin{2,26}
   * @return A string. Do not free, it is owned by @a invocation.
   */
  Glib::ustring get_object_path() const;
  
  /** Gets the name of the D-Bus interface the method was invoked on.
   * 
   * @newin{2,26}
   * @return A string. Do not free, it is owned by @a invocation.
   */
  Glib::ustring get_interface_name() const;
  
  /** Gets the name of the method that was invoked.
   * 
   * @newin{2,26}
   * @return A string. Do not free, it is owned by @a invocation.
   */
  Glib::ustring get_method_name() const;

  //TODO?:_WRAP_METHOD(const GDBusMethodInfo* get_method_info(), g_dbus_method_invocation_get_method_info)

  
  /** Gets the DBusConnection the method was invoked on.
   * 
   * @newin{2,26}
   * @return A DBusConnection. Do not free, it is owned by @a invocation.
   */
  Glib::RefPtr<DBusConnection> get_connection();
  
  /** Gets the DBusConnection the method was invoked on.
   * 
   * @newin{2,26}
   * @return A DBusConnection. Do not free, it is owned by @a invocation.
   */
  Glib::RefPtr<const DBusConnection> get_connection() const;

  
  /** Gets the DBusMessage for the method invocation. This is useful if
   * you need to use low-level protocol features, such as UNIX file
   * descriptor passing, that cannot be properly expressed in the
   * Variant API.
   * 
   * See <xref linkend="gdbus-server"/> and <xref
   * linkend="gdbus-unix-fd-client"/> for an example of how to use this
   * low-level API to send and receive UNIX file descriptors.
   * 
   * @newin{2,26}
   * @return A DBusMessage. Do not free, it is owned by @a invocation.
   */
  Glib::RefPtr<DBusMessage> get_message();
  
  /** Gets the DBusMessage for the method invocation. This is useful if
   * you need to use low-level protocol features, such as UNIX file
   * descriptor passing, that cannot be properly expressed in the
   * Variant API.
   * 
   * See <xref linkend="gdbus-server"/> and <xref
   * linkend="gdbus-unix-fd-client"/> for an example of how to use this
   * low-level API to send and receive UNIX file descriptors.
   * 
   * @newin{2,26}
   * @return A DBusMessage. Do not free, it is owned by @a invocation.
   */
  Glib::RefPtr<const DBusMessage> get_message() const;

  /** Gets the parameters of the method invocation.
   *
   * @param value The location in which to return the parameters.
   *
   * @newin{2,26}
   */
  void get_parameters(Glib::VariantBase& value) const;
  

  /** Finishes handling a D-Bus method call by returning @parameters.
   * If the @parameters GVariant is floating, it is consumed.
   * 
   * It is an error if @parameters is not of the right format.
   * 
   * This method will free @a invocation, you cannot use it afterwards.
   * 
   * @newin{2,26}
   * @param parameters A Variant tuple with out parameters for the method or <tt>0</tt> if not passing any parameters.
   */
  void return_value(const Glib::VariantBase& parameters);

 
  /** Like g_dbus_method_invocation_return_error() but without printf()-style formatting.
   * 
   * This method will free @a invocation, you cannot use it afterwards.
   * 
   * @newin{2,26}
   * @param domain A Quark for the Error error domain.
   * @param code The error code.
   * @param message The error message.
   */
  void return_error_literal(const Glib::ustring& domain, int code, const Glib::ustring& message);

 
  /** Like g_dbus_method_invocation_return_error() but takes a Error
   * instead of the error domain, error code and message.
   * 
   * This method will free @a invocation, you cannot use it afterwards.
   * 
   * @newin{2,26}
   */
  void return_gerror(const Glib::Error& error);

  
  /** Finishes handling a D-Bus method call by returning an error.
   * 
   * This method will free @a invocation, you cannot use it afterwards.
   * 
   * @newin{2,26}
   * @param error_name A valid D-Bus error name.
   * @param error_message A valid D-Bus error message.
   */
  void return_dbus_error(const Glib::ustring& error_name, const Glib::ustring& error_message);

  // Ignore vararg methods and ones that don't make sense for C++ API.
  

public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DBusMethodInvocation
   */
  Glib::RefPtr<Gio::DBusMethodInvocation> wrap(GDBusMethodInvocation* object, bool take_copy = false);
}


#endif /* _GIOMM_DBUSMETHODINVOCATION_H */

