// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_INETADDRESS_H
#define _GIOMM_INETADDRESS_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2009 jonathon jongsma
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <giomm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GInetAddress GInetAddress;
typedef struct _GInetAddressClass GInetAddressClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class InetAddress_Class; } // namespace Gio
namespace Gio
{

/** An IPv4/IPv6 address
 *
 * InetAddress represents an IPv4 or IPv6 internet address. Use
 * Resolver::lookup_by_name() or Resolver::lookup_by_name_async() to look up
 * the InetAddress for a hostname. Use Resolver::lookup_by_address() or
 * Resolver::lookup_by_address_async() to look up the hostname for a
 * InetAddress.
 *
 * To actually connect to a remote host, you will need a InetSocketAddress
 * (which includes a InetAddress as well as a port number).
 *
 * @newin2p22
 */

class InetAddress
: public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef InetAddress CppObjectType;
  typedef InetAddress_Class CppClassType;
  typedef GInetAddress BaseObjectType;
  typedef GInetAddressClass BaseClassType;

private:  friend class InetAddress_Class;
  static CppClassType inetaddress_class_;

private:
  // noncopyable
  InetAddress(const InetAddress&);
  InetAddress& operator=(const InetAddress&);

protected:
  explicit InetAddress(const Glib::ConstructParams& construct_params);
  explicit InetAddress(GInetAddress* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~InetAddress();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GInetAddress*       gobj()       { return reinterpret_cast<GInetAddress*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GInetAddress* gobj() const { return reinterpret_cast<GInetAddress*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GInetAddress* gobj_copy();

private:


protected:
 explicit InetAddress(const Glib::ustring& string);
 explicit InetAddress(const guint8 *bytes, SocketFamily family);
 explicit InetAddress(SocketFamily family);
 // TODO: new_loopback has the same signature as new_any

public:
  
  static Glib::RefPtr<InetAddress> create(const Glib::ustring& string);

  
  static Glib::RefPtr<InetAddress> create(const guint8 * bytes, SocketFamily family);

  
  static Glib::RefPtr<InetAddress> create(SocketFamily family);

  // TODO: create for new_loopback

  
  /** Gets the raw binary address data from @a address.
   * @return A pointer to an internal array of the bytes in @a address,
   * which should not be modified, stored, or freed.
   * 
   * @newin2p22.
   */
  const guint8* to_bytes() const;
  
  /** Converts @a address to string form.
   * @return A representation of @a address as a string, which should be
   * freed after use.
   * 
   * @newin2p22.
   */
  Glib::ustring to_string() const;
  
  /** Gets @a address's family
   * @return  @a address's family
   * 
   * @newin2p22.
   */
  SocketFamily get_family() const;
  
  /** Tests whether @a address is the "any" address for its family.
   * @return <tt>true</tt> if @a address is the "any" address for its family.
   * 
   * @newin2p22.
   */
  bool get_is_any() const;
  
  /** Tests whether @a address is a link-local address (that is, if it
   * identifies a host on a local network that is not connected to the
   * Internet).
   * @return <tt>true</tt> if @a address is a link-local address.
   * 
   * @newin2p22.
   */
  bool get_is_link_local() const;
  
  /** Tests whether @a address is the loopback address for its family.
   * @return <tt>true</tt> if @a address is the loopback address for its family.
   * 
   * @newin2p22.
   */
  bool get_is_loopback() const;
  
  /** Tests whether @a address is a global multicast address.
   * @return <tt>true</tt> if @a address is a global multicast address.
   * 
   * @newin2p22.
   */
  bool get_is_mc_global() const;
  
  /** Tests whether @a address is a link-local multicast address.
   * @return <tt>true</tt> if @a address is a link-local multicast address.
   * 
   * @newin2p22.
   */
  bool get_is_mc_link_local() const;
  
  /** Tests whether @a address is a node-local multicast address.
   * @return <tt>true</tt> if @a address is a node-local multicast address.
   * 
   * @newin2p22.
   */
  bool get_is_mc_node_local() const;
  
  /** Tests whether @a address is an organization-local multicast address.
   * @return <tt>true</tt> if @a address is an organization-local multicast address.
   * 
   * @newin2p22.
   */
  bool get_is_mc_org_local() const;
  
  /** Tests whether @a address is a site-local multicast address.
   * @return <tt>true</tt> if @a address is a site-local multicast address.
   * 
   * @newin2p22.
   */
  bool get_is_mc_site_local() const;
  
  /** Tests whether @a address is a multicast address.
   * @return <tt>true</tt> if @a address is a multicast address.
   * 
   * @newin2p22.
   */
  bool get_is_multicast() const;
  
  /** Tests whether @a address is a site-local address such as 10.0.0.1
   * (that is, the address identifies a host on a local network that can
   * not be reached directly from the Internet, but which may have
   * outgoing Internet connectivity via a NAT or firewall).
   * @return <tt>true</tt> if @a address is a site-local address.
   * 
   * @newin2p22.
   */
  bool get_is_site_local() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::InetAddress
   */
  Glib::RefPtr<Gio::InetAddress> wrap(GInetAddress* object, bool take_copy = false);
}


#endif /* _GIOMM_INETADDRESS_H */

