// Generated by gtkmmproc -- DO NOT MODIFY!


#include <giomm/mount.h>
#include <giomm/private/mount_p.h>

// -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/drive.h>
#include <giomm/volume.h>
#include <gio/gio.h>
#include "slot_async.h"

namespace Gio
{

void Mount::unmount(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_mount_unmount(gobj(),
                  GMountUnmountFlags(flags),
                  cancellable->gobj(), 
                  &SignalProxy_async_callback,
                  slot_copy);
}

void Mount::unmount(const SlotAsyncReady& slot, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_mount_unmount(gobj(),
                  GMountUnmountFlags(flags),
                  NULL, 
                  &SignalProxy_async_callback,
                  slot_copy);
}

void Mount::unmount(MountUnmountFlags flags)
{
  g_mount_unmount(gobj(),
                  GMountUnmountFlags(flags),
                  NULL, 
                  NULL,
                  NULL);
}


void Mount::remount(const Glib::RefPtr<MountOperation>& operation, const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_mount_remount(gobj(),
                  operation->gobj(),
                  cancellable->gobj(), 
                  &SignalProxy_async_callback,
                  slot_copy);
}

void Mount::remount(const Glib::RefPtr<MountOperation>& operation, const SlotAsyncReady& slot)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_mount_remount(gobj(),
                  operation->gobj(),
                  NULL, 
                  &SignalProxy_async_callback,
                  slot_copy);
}

void Mount::remount(const Glib::RefPtr<MountOperation>& operation)
{
  g_mount_remount(gobj(),
                  operation->gobj(),
                  NULL, 
                  NULL,
                  NULL);
}

void Mount::remount()
{
  g_mount_remount(gobj(),
                  NULL,
                  NULL, 
                  NULL,
                  NULL);
}

void Mount::eject(const SlotAsyncReady& slot, const Glib::RefPtr<Cancellable>& cancellable, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_mount_eject(gobj(),
                  GMountUnmountFlags(flags),
                  cancellable->gobj(), 
                  &SignalProxy_async_callback,
                  slot_copy);
}

void Mount::eject(const SlotAsyncReady& slot, MountUnmountFlags flags)
{
  // Create a copy of the slot.
  // A pointer to it will be passed through the callback's data parameter
  // and deleted in the callback.
  SlotAsyncReady* slot_copy = new SlotAsyncReady(slot);

  g_mount_eject(gobj(),
                  GMountUnmountFlags(flags),
                  NULL, 
                  &SignalProxy_async_callback,
                  slot_copy);
}

void Mount::eject(MountUnmountFlags flags)
{
  g_mount_eject(gobj(),
                  GMountUnmountFlags(flags),
                  NULL, 
                  NULL,
                  NULL);
}


} // namespace Gio


namespace
{
} // anonymous namespace


namespace Glib
{

Glib::RefPtr<Gio::Mount> wrap(GMount* object, bool take_copy)
{
  return Glib::RefPtr<Gio::Mount>( dynamic_cast<Gio::Mount*> (Glib::wrap_auto_interface<Gio::Mount> ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} // namespace Glib


namespace Gio
{


/* The *_Class implementation: */

const Glib::Interface_Class& Mount_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Interface_Class has to know the interface init function
    // in order to add interfaces to implementing types.
    class_init_func_ = &Mount_Class::iface_init_function;

    // We can not derive from another interface, and it is not necessary anyway.
    gtype_ = g_mount_get_type();
  }

  return *this;
}

void Mount_Class::iface_init_function(void* g_iface, void*)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_iface);

  //This is just to avoid an "unused variable" warning when there are no vfuncs or signal handlers to connect.
  //This is a temporary fix until I find out why I can not seem to derive a GtkFileChooser interface. murrayc
  g_assert(klass != 0); 

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Mount_Class::wrap_new(GObject* object)
{
  return new Mount((GMount*)(object));
}


/* The implementation: */

Mount::Mount()
:
  Glib::Interface(mount_class_.init())
{}

Mount::Mount(GMount* castitem)
:
  Glib::Interface((GObject*)(castitem))
{}

Mount::Mount(const Glib::Interface_Class& interface_class)
: Glib::Interface(interface_class)
{
}

Mount::~Mount()
{}

// static
void Mount::add_interface(GType gtype_implementer)
{
  mount_class_.init().add_interface(gtype_implementer);
}

Mount::CppClassType Mount::mount_class_; // initialize static member

GType Mount::get_type()
{
  return mount_class_.init().get_type();
}

GType Mount::get_base_type()
{
  return g_mount_get_type();
}


Glib::RefPtr<File> Mount::get_root()
{

  Glib::RefPtr<File> retvalue = Glib::wrap(g_mount_get_root(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const File> Mount::get_root() const
{
  return const_cast<Mount*>(this)->get_root();
}

std::string Mount::get_name() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_mount_get_name(const_cast<GMount*>(gobj())));
}

Glib::RefPtr<Icon> Mount::get_icon()
{

  Glib::RefPtr<Icon> retvalue = Glib::wrap(g_mount_get_icon(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Icon> Mount::get_icon() const
{
  return const_cast<Mount*>(this)->get_icon();
}

std::string Mount::get_uuid() const
{
  return Glib::convert_return_gchar_ptr_to_stdstring(g_mount_get_uuid(const_cast<GMount*>(gobj())));
}

Glib::RefPtr<Volume> Mount::get_volume()
{

  Glib::RefPtr<Volume> retvalue = Glib::wrap(g_mount_get_volume(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Volume> Mount::get_volume() const
{
  return const_cast<Mount*>(this)->get_volume();
}

Glib::RefPtr<Drive> Mount::get_drive()
{

  Glib::RefPtr<Drive> retvalue = Glib::wrap(g_mount_get_drive(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const Drive> Mount::get_drive() const
{
  return const_cast<Mount*>(this)->get_drive();
}

bool Mount::can_unmount() const
{
  return g_mount_can_unmount(const_cast<GMount*>(gobj()));
}

bool Mount::can_eject() const
{
  return g_mount_can_eject(const_cast<GMount*>(gobj()));
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Mount::unmount_finish(const Glib::RefPtr<AsyncResult>& result)
#else
bool Mount::unmount_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_mount_unmount_finish(gobj(), Glib::unwrap(result), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Mount::remount_finish(const Glib::RefPtr<AsyncResult>& result)
#else
bool Mount::remount_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_mount_remount_finish(gobj(), Glib::unwrap(result), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
bool Mount::eject_finish(const Glib::RefPtr<AsyncResult>& result)
#else
bool Mount::eject_finish(const Glib::RefPtr<AsyncResult>& result, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  bool retvalue = g_mount_eject_finish(gobj(), Glib::unwrap(result), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;

}


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Gio


