// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_VOLUMEMONITOR_H
#define _GIOMM_VOLUMEMONITOR_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/drive.h>
#include <giomm/volume.h>
#include <giomm/mount.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GVolumeMonitor GVolumeMonitor;
typedef struct _GVolumeMonitorClass GVolumeMonitorClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class VolumeMonitor_Class; } // namespace Gio
namespace Gio
{

//gtkmmproc error: GVolumeMonitorEvent : enum defs lookup failed.

/** Monitors a file or directory for changes.
 * TODO: Documentation: See http://bugzilla.gnome.org/show_bug.cgi?id=509994.
 * @newin2p16
 */

class VolumeMonitor : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef VolumeMonitor CppObjectType;
  typedef VolumeMonitor_Class CppClassType;
  typedef GVolumeMonitor BaseObjectType;
  typedef GVolumeMonitorClass BaseClassType;

private:  friend class VolumeMonitor_Class;
  static CppClassType volumemonitor_class_;

private:
  // noncopyable
  VolumeMonitor(const VolumeMonitor&);
  VolumeMonitor& operator=(const VolumeMonitor&);

protected:
  explicit VolumeMonitor(const Glib::ConstructParams& construct_params);
  explicit VolumeMonitor(GVolumeMonitor* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~VolumeMonitor();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GVolumeMonitor*       gobj()       { return reinterpret_cast<GVolumeMonitor*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GVolumeMonitor* gobj() const { return reinterpret_cast<GVolumeMonitor*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GVolumeMonitor* gobj_copy();

private:

protected:

public:

  
  /** Gets the volume monitor used by gio.
   * @return A reference to the G::VolumeMonitor used by gio. Call
   * Glib::object_unref() when done with it.
   */
  static Glib::RefPtr<VolumeMonitor> get();

 
  /** Gets a list of drives connected to the system.
   * @return A G::List of connected G::Drives.
   */
  Glib::ListHandle< Glib::RefPtr<Drive> > get_connected_drives();;

 
  /** Gets a list of the volumes on the system.
   * @return A G::List of G::Volume.
   */
  Glib::ListHandle< Glib::RefPtr<Volume> > get_volumes();;

 
  /** Gets a list of the mounts on the system.
   * @return A G::List of G::Mount.
   */
  Glib::ListHandle< Glib::RefPtr<Mount> > get_mounts();;

  
  /** Finds a G::Volume object by it's UUID (see g_volume_get_uuid())
   * @param uuid The UUID to look for.
   * @return A G::Volume or <tt>0</tt> if no such volume is available.
   */
  Glib::RefPtr<Volume> get_volume_for_uuid(const std::string& uuid);
  
  /** Finds a G::Mount object by it's UUID (see g_mount_get_uuid())
   * @param uuid The UUID to look for.
   * @return A G::Mount or <tt>0</tt> if no such mount is available.
   */
  Glib::RefPtr<Mount> get_mount_for_uuid(const std::string& uuid);

  
  /** This function should be called by any G::VolumeMonitor
   * implementation when a new G::Mount object is created that is not
   * associated with a G::Volume object. It must be called just before
   * emitting the @a mount_added  signal.
   * 
   * If the return value is not <tt>0</tt>, the caller must associate the
   * returned G::Volume object with the G::Mount. This involves returning
   * it in it's g_mount_get_volume() implementation. The caller must
   * also listen for the "removed" signal on the returned object
   * and give up it's reference when handling that signal
   * 
   * Similary, if implementing g_volume_monitor_adopt_orphan_mount(),
   * the implementor must take a reference to @a mount  and return it in
   * it's g_volume_get_mount() implemented. Also, the implementor must
   * listen for the "unmounted" signal on @a mount  and give up it's
   * reference upon handling that signal.
   * 
   * There are two main use cases for this function.
   * 
   * One is when implementing a user space file system driver that reads
   * blocks of a block device that is already represented by the native
   * volume monitor (for example a CD Audio file system driver). Such
   * a driver will generate it's own G::Mount object that needs to be
   * assoicated with the G::Volume object that represents the volume.
   * 
   * The other is for implementing a G::VolumeMonitor whose sole purpose
   * is to return G::Volume objects representing entries in the users
   * "favorite servers" list or similar.
   * @param mount A G::Mount object to find a parent for.
   * @return The G::Volume object that is the parent for @a mount  or <tt>0</tt>
   * if no wants to adopt the G::Mount.
   */
  static Glib::RefPtr<Volume> adopt_orphan_mount(const Glib::RefPtr<Mount>& mount);

  
  //TODO: vfuncs and signals.

  //There are no properties.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::VolumeMonitor
   */
  Glib::RefPtr<Gio::VolumeMonitor> wrap(GVolumeMonitor* object, bool take_copy = false);
}


#endif /* _GIOMM_VOLUMEMONITOR_H */

