/* birthday-details-interface.c generated by valac 0.12.0, the Vala compiler
 * generated from birthday-details-interface.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks/folks-tracker.h>
#include <gio/gio.h>


#define TYPE_BIRTHDAY_DETAILS_INTERFACE_TESTS (birthday_details_interface_tests_get_type ())
#define BIRTHDAY_DETAILS_INTERFACE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BIRTHDAY_DETAILS_INTERFACE_TESTS, BirthdayDetailsInterfaceTests))
#define BIRTHDAY_DETAILS_INTERFACE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BIRTHDAY_DETAILS_INTERFACE_TESTS, BirthdayDetailsInterfaceTestsClass))
#define IS_BIRTHDAY_DETAILS_INTERFACE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BIRTHDAY_DETAILS_INTERFACE_TESTS))
#define IS_BIRTHDAY_DETAILS_INTERFACE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BIRTHDAY_DETAILS_INTERFACE_TESTS))
#define BIRTHDAY_DETAILS_INTERFACE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BIRTHDAY_DETAILS_INTERFACE_TESTS, BirthdayDetailsInterfaceTestsClass))

typedef struct _BirthdayDetailsInterfaceTests BirthdayDetailsInterfaceTests;
typedef struct _BirthdayDetailsInterfaceTestsClass BirthdayDetailsInterfaceTestsClass;
typedef struct _BirthdayDetailsInterfaceTestsPrivate BirthdayDetailsInterfaceTestsPrivate;
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData;

struct _BirthdayDetailsInterfaceTests {
	FolksTestCase parent_instance;
	BirthdayDetailsInterfaceTestsPrivate * priv;
};

struct _BirthdayDetailsInterfaceTestsClass {
	FolksTestCaseClass parent_class;
};

struct _BirthdayDetailsInterfaceTestsPrivate {
	TrackerTestBackend* _tracker_backend;
	gboolean _found_birthday;
	GDateTime* _dobj;
	GMainLoop* _main_loop;
	FolksIndividualAggregator* _aggregator;
	gchar* _fullname;
};

struct _BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BirthdayDetailsInterfaceTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GError * e;
	GError * _inner_error_;
};


static gpointer birthday_details_interface_tests_parent_class = NULL;

GType birthday_details_interface_tests_get_type (void) G_GNUC_CONST;
#define BIRTHDAY_DETAILS_INTERFACE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BIRTHDAY_DETAILS_INTERFACE_TESTS, BirthdayDetailsInterfaceTestsPrivate))
enum  {
	BIRTHDAY_DETAILS_INTERFACE_TESTS_DUMMY_PROPERTY
};
BirthdayDetailsInterfaceTests* birthday_details_interface_tests_new (void);
BirthdayDetailsInterfaceTests* birthday_details_interface_tests_construct (GType object_type);
void birthday_details_interface_tests_test_birthay_details_interface (BirthdayDetailsInterfaceTests* self);
static void _birthday_details_interface_tests_test_birthay_details_interface_folks_test_case_test_method (gpointer self);
static void birthday_details_interface_tests_real_set_up (FolksTestCase* base);
static void birthday_details_interface_tests_real_tear_down (FolksTestCase* base);
static void _birthday_details_interface_tests_test_birthay_details_interface (BirthdayDetailsInterfaceTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _birthday_details_interface_tests_test_birthay_details_interface_finish (BirthdayDetailsInterfaceTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (BirthdayDetailsInterfaceTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _birthday_details_interface_tests_test_birthay_details_interface_data_free (gpointer _data);
static gboolean _birthday_details_interface_tests_test_birthay_details_interface_co (BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData* data);
static void _birthday_details_interface_tests_test_birthay_details_interface_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _birthday_details_interface_tests_individuals_changed_cb (BirthdayDetailsInterfaceTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __birthday_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _birthday_details_interface_tests_notify_birthday_cb (BirthdayDetailsInterfaceTests* self, GObject* individual_obj, GParamSpec* ps);
static void __birthday_details_interface_tests_notify_birthday_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void birthday_details_interface_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _birthday_details_interface_tests_test_birthay_details_interface_folks_test_case_test_method (gpointer self) {
	birthday_details_interface_tests_test_birthay_details_interface (self);
}


BirthdayDetailsInterfaceTests* birthday_details_interface_tests_construct (GType object_type) {
	BirthdayDetailsInterfaceTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (BirthdayDetailsInterfaceTests*) folks_test_case_construct (object_type, "BirthdayDetailsInterfaceTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	tracker_test_backend_set_debug (self->priv->_tracker_backend, FALSE);
	folks_test_case_add_test ((FolksTestCase*) self, "test birthday details interface", _birthday_details_interface_tests_test_birthay_details_interface_folks_test_case_test_method, self);
	return self;
}


BirthdayDetailsInterfaceTests* birthday_details_interface_tests_new (void) {
	return birthday_details_interface_tests_construct (TYPE_BIRTHDAY_DETAILS_INTERFACE_TESTS);
}


static void birthday_details_interface_tests_real_set_up (FolksTestCase* base) {
	BirthdayDetailsInterfaceTests * self;
	self = (BirthdayDetailsInterfaceTests*) base;
}


static void birthday_details_interface_tests_real_tear_down (FolksTestCase* base) {
	BirthdayDetailsInterfaceTests * self;
	self = (BirthdayDetailsInterfaceTests*) base;
}


static gboolean _lambda0_ (BirthdayDetailsInterfaceTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void birthday_details_interface_tests_test_birthay_details_interface (BirthdayDetailsInterfaceTests* self) {
	GMainLoop* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeHashMap* c1;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* birthday;
	GTimeVal t = {0};
	GDateTime* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	c1 = _tmp1_;
	_tmp2_ = g_strdup ("persona #1");
	_g_free0 (self->priv->_fullname);
	self->priv->_fullname = _tmp2_;
	_tmp3_ = g_strdup ("2001-10-26T20:32:52Z");
	birthday = _tmp3_;
	g_get_current_time (&t);
	g_time_val_from_iso8601 (birthday, &t);
	_tmp4_ = g_date_time_new_from_timeval_utc (&t);
	_g_date_time_unref0 (self->priv->_dobj);
	self->priv->_dobj = _tmp4_;
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_FULLNAME, self->priv->_fullname);
	gee_abstract_map_set ((GeeAbstractMap*) c1, TRF_ONTOLOGY_DEFS_NCO_BIRTHDAY, birthday);
	tracker_test_backend_add_contact (self->priv->_tracker_backend, c1);
	tracker_test_backend_set_up (self->priv->_tracker_backend);
	self->priv->_found_birthday = FALSE;
	_birthday_details_interface_tests_test_birthay_details_interface (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	g_assert (self->priv->_found_birthday == TRUE);
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	_g_free0 (birthday);
	_g_object_unref0 (c1);
}


static void _birthday_details_interface_tests_test_birthay_details_interface_data_free (gpointer _data) {
	BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _birthday_details_interface_tests_test_birthay_details_interface (BirthdayDetailsInterfaceTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData* _data_;
	_data_ = g_slice_new0 (BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _birthday_details_interface_tests_test_birthay_details_interface);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _birthday_details_interface_tests_test_birthay_details_interface_data_free);
	_data_->self = _g_object_ref0 (self);
	_birthday_details_interface_tests_test_birthay_details_interface_co (_data_);
}


static void _birthday_details_interface_tests_test_birthay_details_interface_finish (BirthdayDetailsInterfaceTests* self, GAsyncResult* _res_) {
	BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _birthday_details_interface_tests_test_birthay_details_interface_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_birthday_details_interface_tests_test_birthay_details_interface_co (data);
}


static void __birthday_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_birthday_details_interface_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static gboolean _birthday_details_interface_tests_test_birthay_details_interface_co (BirthdayDetailsInterfaceTestsTestBirthayDetailsInterfaceData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _birthday_details_interface_tests_test_birthay_details_interface_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __birthday_details_interface_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _birthday_details_interface_tests_test_birthay_details_interface_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("birthday-details-interface.vala:100: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __birthday_details_interface_tests_notify_birthday_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_birthday_details_interface_tests_notify_birthday_cb (self, _sender, pspec);
}


static void _birthday_details_interface_tests_individuals_changed_cb (BirthdayDetailsInterfaceTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			const gchar* _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
			if (g_strcmp0 (_tmp3_, self->priv->_fullname) == 0) {
				GDateTime* _tmp4_ = NULL;
				g_signal_connect_object ((GObject*) i, "notify::birthday", (GCallback) __birthday_details_interface_tests_notify_birthday_cb_g_object_notify, self, 0);
				_tmp4_ = folks_birthday_details_get_birthday ((FolksBirthdayDetails*) i);
				if (_tmp4_ != NULL) {
					GDateTime* _tmp5_ = NULL;
					gint _tmp6_;
					_tmp5_ = folks_birthday_details_get_birthday ((FolksBirthdayDetails*) i);
					_tmp6_ = g_date_time_compare (_tmp5_, self->priv->_dobj);
					if (_tmp6_ == 0) {
						self->priv->_found_birthday = TRUE;
						g_main_loop_quit (self->priv->_main_loop);
					}
				}
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp7_ = gee_collection_get_size ((GeeCollection*) removed);
	g_assert (_tmp7_ == 0);
}


static void _birthday_details_interface_tests_notify_birthday_cb (BirthdayDetailsInterfaceTests* self, GObject* individual_obj, GParamSpec* ps) {
	FolksIndividual* _tmp0_;
	FolksIndividual* individual;
	gboolean _tmp1_ = FALSE;
	GDateTime* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual_obj != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (individual_obj));
	individual = _tmp0_;
	_tmp2_ = folks_birthday_details_get_birthday ((FolksBirthdayDetails*) individual);
	if (_tmp2_ != NULL) {
		GDateTime* _tmp3_ = NULL;
		gint _tmp4_;
		_tmp3_ = folks_birthday_details_get_birthday ((FolksBirthdayDetails*) individual);
		_tmp4_ = g_date_time_compare (_tmp3_, self->priv->_dobj);
		_tmp1_ = _tmp4_ == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		self->priv->_found_birthday = TRUE;
	}
	_g_object_unref0 (individual);
}


static void birthday_details_interface_tests_class_init (BirthdayDetailsInterfaceTestsClass * klass) {
	birthday_details_interface_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BirthdayDetailsInterfaceTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = birthday_details_interface_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = birthday_details_interface_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = birthday_details_interface_tests_finalize;
}


static void birthday_details_interface_tests_instance_init (BirthdayDetailsInterfaceTests * self) {
	self->priv = BIRTHDAY_DETAILS_INTERFACE_TESTS_GET_PRIVATE (self);
}


static void birthday_details_interface_tests_finalize (GObject* obj) {
	BirthdayDetailsInterfaceTests * self;
	self = BIRTHDAY_DETAILS_INTERFACE_TESTS (obj);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_date_time_unref0 (self->priv->_dobj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_fullname);
	G_OBJECT_CLASS (birthday_details_interface_tests_parent_class)->finalize (obj);
}


GType birthday_details_interface_tests_get_type (void) {
	static volatile gsize birthday_details_interface_tests_type_id__volatile = 0;
	if (g_once_init_enter (&birthday_details_interface_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BirthdayDetailsInterfaceTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) birthday_details_interface_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BirthdayDetailsInterfaceTests), 0, (GInstanceInitFunc) birthday_details_interface_tests_instance_init, NULL };
		GType birthday_details_interface_tests_type_id;
		birthday_details_interface_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "BirthdayDetailsInterfaceTests", &g_define_type_info, 0);
		g_once_init_leave (&birthday_details_interface_tests_type_id__volatile, birthday_details_interface_tests_type_id);
	}
	return birthday_details_interface_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	BirthdayDetailsInterfaceTests* _tmp1_ = NULL;
	BirthdayDetailsInterfaceTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = birthday_details_interface_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



