/* add-persona.c generated by valac 0.12.0, the Vala compiler
 * generated from add-persona.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tracker-test.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks-tracker.h>
#include <gee.h>
#include <gio/gio.h>


#define TYPE_ADD_PERSONA_TESTS (add_persona_tests_get_type ())
#define ADD_PERSONA_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADD_PERSONA_TESTS, AddPersonaTests))
#define ADD_PERSONA_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADD_PERSONA_TESTS, AddPersonaTestsClass))
#define IS_ADD_PERSONA_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADD_PERSONA_TESTS))
#define IS_ADD_PERSONA_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADD_PERSONA_TESTS))
#define ADD_PERSONA_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADD_PERSONA_TESTS, AddPersonaTestsClass))

typedef struct _AddPersonaTests AddPersonaTests;
typedef struct _AddPersonaTestsClass AddPersonaTestsClass;
typedef struct _AddPersonaTestsPrivate AddPersonaTestsPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _tracker_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (tracker_test_backend_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AddPersonaTestsTestAddPersonaAsyncData AddPersonaTestsTestAddPersonaAsyncData;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
typedef struct _AddPersonaTestsAddPersonaData AddPersonaTestsAddPersonaData;

struct _AddPersonaTests {
	FolksTestCase parent_instance;
	AddPersonaTestsPrivate * priv;
};

struct _AddPersonaTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AddPersonaTestsPrivate {
	GMainLoop* _main_loop;
	TrackerTestBackend* _tracker_backend;
	FolksIndividualAggregator* _aggregator;
	gchar* _persona_fullname;
	gchar* _persona_alias;
	gchar* _family_name;
	gchar* _given_name;
	GHashTable* _properties_found;
	gchar* _persona_iid;
	gchar* _file_uri;
	gchar* _birthday;
	GDateTime* _bday;
	gchar* _email_1;
	gchar* _email_2;
	gchar* _im_addr_1;
	gchar* _im_addr_2;
	gchar* _note_1;
	gchar* _phone_1;
	gchar* _phone_2;
	gchar* _title_1;
	gchar* _organisation_1;
	FolksPostalAddress* _address;
	gchar* _po_box;
	gchar* _locality;
	gchar* _postal_code;
	gchar* _street;
	gchar* _extension;
	gchar* _country;
	gchar* _region;
	gchar* _url_1;
	gchar* _url_2;
	TrfPersonaStore* _pstore;
	gboolean _added_persona;
	GStaticRecMutex __lock__added_persona;
};

struct _AddPersonaTestsTestAddPersonaAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AddPersonaTests* self;
	FolksBackendStore* _tmp0_;
	FolksBackendStore* store;
	FolksIndividualAggregator* _tmp1_;
	GeeMap* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _tmp6_;
	GeeIterator* _backend_it;
	gboolean _tmp7_;
	gpointer _tmp8_;
	FolksBackend* backend;
	GeeMap* _tmp9_;
	gpointer _tmp10_;
	GError * e;
	GError * _inner_error_;
};

struct _AddPersonaTestsAddPersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AddPersonaTests* self;
	GHashTable* _tmp0_;
	GHashTable* details;
	GValue _tmp1_;
	GValue _tmp2_;
	GValue _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_;
	GValue* v1;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GValue* _tmp8_;
	GValue _tmp9_;
	GValue _tmp10_;
	GValue _tmp11_;
	GValue* _tmp12_;
	GValue* _tmp13_;
	GValue* v2;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GValue* _tmp16_;
	GValue _tmp17_;
	GValue _tmp18_;
	GValue _tmp19_;
	GValue* _tmp20_;
	GValue* _tmp21_;
	GValue* v3;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	GValue* _tmp24_;
	GValue _tmp25_;
	GValue _tmp26_;
	GValue _tmp27_;
	GValue* _tmp28_;
	GValue* _tmp29_;
	GValue* v4;
	FolksStructuredName* _tmp30_;
	FolksStructuredName* sname;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GValue* _tmp33_;
	GValue _tmp34_;
	GValue _tmp35_;
	GValue _tmp36_;
	GValue* _tmp37_;
	GValue* _tmp38_;
	GValue* v5;
	GFile* _tmp39_;
	GFile* avatar;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GValue* _tmp42_;
	GValue _tmp43_;
	GValue _tmp44_;
	GValue _tmp45_;
	GValue* _tmp46_;
	GValue* _tmp47_;
	GValue* v6;
	GTimeVal t;
	GDateTime* _tmp48_;
	GDateTime* dobj;
	const gchar* _tmp49_;
	gchar* _tmp50_;
	GValue* _tmp51_;
	GValue _tmp52_;
	GValue _tmp53_;
	GValue _tmp54_;
	GValue* _tmp55_;
	GValue* _tmp56_;
	GValue* v7;
	const gchar* _tmp57_;
	gchar* _tmp58_;
	GValue* _tmp59_;
	GValue _tmp60_;
	GValue _tmp61_;
	GValue _tmp62_;
	GValue* _tmp63_;
	GValue* _tmp64_;
	GValue* v8;
	GeeHashSet* _tmp65_;
	GeeHashSet* emails;
	FolksFieldDetails* _tmp66_;
	FolksFieldDetails* email_1;
	FolksFieldDetails* _tmp67_;
	FolksFieldDetails* email_2;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	GValue* _tmp70_;
	GValue _tmp71_;
	GValue _tmp72_;
	GValue _tmp73_;
	GValue* _tmp74_;
	GValue* _tmp75_;
	GValue* v9;
	GeeHashMultiMap* _tmp76_;
	GeeHashMultiMap* im_addrs;
	const gchar* _tmp77_;
	gchar* _tmp78_;
	GValue* _tmp79_;
	GValue _tmp80_;
	GValue _tmp81_;
	GValue _tmp82_;
	GValue* _tmp83_;
	GValue* _tmp84_;
	GValue* v10;
	GeeHashSet* _tmp85_;
	GeeHashSet* notes;
	FolksNote* _tmp86_;
	FolksNote* n1;
	const gchar* _tmp87_;
	gchar* _tmp88_;
	GValue* _tmp89_;
	GValue _tmp90_;
	GValue _tmp91_;
	GValue _tmp92_;
	GValue* _tmp93_;
	GValue* _tmp94_;
	GValue* v11;
	GeeHashSet* _tmp95_;
	GeeHashSet* phones;
	FolksFieldDetails* _tmp96_;
	FolksFieldDetails* phone_1;
	FolksFieldDetails* _tmp97_;
	FolksFieldDetails* phone_2;
	const gchar* _tmp98_;
	gchar* _tmp99_;
	GValue* _tmp100_;
	GValue _tmp101_;
	GValue _tmp102_;
	GValue _tmp103_;
	GValue* _tmp104_;
	GValue* _tmp105_;
	GValue* v12;
	GeeHashSet* _tmp106_;
	GeeHashSet* roles;
	FolksRole* _tmp107_;
	FolksRole* r1;
	const gchar* _tmp108_;
	gchar* _tmp109_;
	GValue* _tmp110_;
	GValue _tmp111_;
	GValue _tmp112_;
	GValue _tmp113_;
	GValue* _tmp114_;
	GValue* _tmp115_;
	GValue* v13;
	GeeHashSet* _tmp116_;
	GeeHashSet* postal_addresses;
	GeeHashSet* _tmp117_;
	GeeHashSet* types;
	FolksPostalAddress* _tmp118_;
	FolksPostalAddress* postal_a;
	const gchar* _tmp119_;
	gchar* _tmp120_;
	GValue* _tmp121_;
	GValue _tmp122_;
	GValue _tmp123_;
	GValue _tmp124_;
	GValue* _tmp125_;
	GValue* _tmp126_;
	GValue* v14;
	GeeHashSet* _tmp127_;
	GeeHashSet* urls;
	FolksFieldDetails* _tmp128_;
	FolksFieldDetails* url_1;
	FolksFieldDetails* _tmp129_;
	FolksFieldDetails* url_2;
	const gchar* _tmp130_;
	gchar* _tmp131_;
	GValue* _tmp132_;
	FolksPersona* _tmp133_;
	FolksPersona* _tmp134_;
	TrfPersona* persona;
	const gchar* _tmp135_;
	gchar* _tmp136_;
	GError * e;
	GError * _inner_error_;
};


static gpointer add_persona_tests_parent_class = NULL;

GType add_persona_tests_get_type (void) G_GNUC_CONST;
#define ADD_PERSONA_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ADD_PERSONA_TESTS, AddPersonaTestsPrivate))
enum  {
	ADD_PERSONA_TESTS_DUMMY_PROPERTY
};
AddPersonaTests* add_persona_tests_new (void);
AddPersonaTests* add_persona_tests_construct (GType object_type);
void add_persona_tests_test_add_persona (AddPersonaTests* self);
static void _add_persona_tests_test_add_persona_folks_test_case_test_method (gpointer self);
static void add_persona_tests_real_set_up (FolksTestCase* base);
static void add_persona_tests_real_tear_down (FolksTestCase* base);
static void _g_free0_ (gpointer var);
static void _add_persona_tests_test_add_persona_async (AddPersonaTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _add_persona_tests_test_add_persona_finish (AddPersonaTests* self, GAsyncResult* _res_);
static gboolean _lambda0_ (AddPersonaTests* self);
static gboolean __lambda0__gsource_func (gpointer self);
static void _add_persona_tests_test_add_persona_async_data_free (gpointer _data);
static gboolean _add_persona_tests_test_add_persona_async_co (AddPersonaTestsTestAddPersonaAsyncData* data);
static void _add_persona_tests_test_add_persona_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _add_persona_tests_individuals_changed_cb (AddPersonaTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason);
static void __add_persona_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static void _add_persona_tests_notify_pstore_cb (AddPersonaTests* self, GObject* _pstore, GParamSpec* ps);
static void __add_persona_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _add_persona_tests_try_to_add (AddPersonaTests* self);
static void _add_persona_tests_add_persona_data_free (gpointer _data);
static void _add_persona_tests_add_persona (AddPersonaTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _add_persona_tests_add_persona_finish (AddPersonaTests* self, GAsyncResult* _res_);
static gboolean _add_persona_tests_add_persona_co (AddPersonaTestsAddPersonaData* data);
static void _vala_GValue_free (GValue* self);
static void __vala_GValue_free0_ (gpointer var);
static GValue* _g_value_dup (GValue* self);
static void _add_persona_tests_add_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _add_persona_tests_notify_persona_sname (AddPersonaTests* self, GObject* persona_p, GParamSpec* ps);
static void __add_persona_tests_notify_persona_sname_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _add_persona_tests_notify_cb (AddPersonaTests* self, GObject* individual_obj, GParamSpec* ps);
static void __add_persona_tests_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _add_persona_tests_check_properties (AddPersonaTests* self, FolksIndividual* i);
static void _add_persona_tests_check_sname (AddPersonaTests* self, FolksStructuredName* sname);
static void _add_persona_tests_exit_if_all_properties_found (AddPersonaTests* self);
static void add_persona_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _add_persona_tests_test_add_persona_folks_test_case_test_method (gpointer self) {
	add_persona_tests_test_add_persona (self);
}


AddPersonaTests* add_persona_tests_construct (GType object_type) {
	AddPersonaTests * self = NULL;
	TrackerTestBackend* _tmp0_ = NULL;
	self = (AddPersonaTests*) folks_test_case_construct (object_type, "AddPersonaTests");
	_tmp0_ = tracker_test_backend_new ();
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	self->priv->_tracker_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "test adding personas to Tracker ", _add_persona_tests_test_add_persona_folks_test_case_test_method, self);
	return self;
}


AddPersonaTests* add_persona_tests_new (void) {
	return add_persona_tests_construct (TYPE_ADD_PERSONA_TESTS);
}


static void add_persona_tests_real_set_up (FolksTestCase* base) {
	AddPersonaTests * self;
	self = (AddPersonaTests*) base;
}


static void add_persona_tests_real_tear_down (FolksTestCase* base) {
	AddPersonaTests * self;
	self = (AddPersonaTests*) base;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gboolean _lambda0_ (AddPersonaTests* self) {
	gboolean result = FALSE;
	g_main_loop_quit (self->priv->_main_loop);
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda0_ (self);
	return result;
}


void add_persona_tests_test_add_persona (AddPersonaTests* self) {
	GMainLoop* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GeeHashSet* _tmp17_ = NULL;
	GeeHashSet* types;
	FolksPostalAddress* _tmp18_ = NULL;
	GTimeVal t = {0};
	GDateTime* _tmp19_ = NULL;
	GHashTable* _tmp20_ = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	GList* _tmp39_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->_main_loop);
	self->priv->_main_loop = _tmp0_;
	_tmp1_ = g_strdup ("persona #1");
	_g_free0 (self->priv->_persona_fullname);
	self->priv->_persona_fullname = _tmp1_;
	_tmp2_ = g_strdup ("alias");
	_g_free0 (self->priv->_persona_alias);
	self->priv->_persona_alias = _tmp2_;
	_tmp3_ = g_strdup ("family");
	_g_free0 (self->priv->_family_name);
	self->priv->_family_name = _tmp3_;
	_tmp4_ = g_strdup ("given");
	_g_free0 (self->priv->_given_name);
	self->priv->_given_name = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (self->priv->_persona_iid);
	self->priv->_persona_iid = _tmp5_;
	_tmp6_ = g_strdup ("file:///tmp/some-avatar.jpg");
	_g_free0 (self->priv->_file_uri);
	self->priv->_file_uri = _tmp6_;
	_tmp7_ = g_strdup ("2001-10-26T20:32:52Z");
	_g_free0 (self->priv->_birthday);
	self->priv->_birthday = _tmp7_;
	_tmp8_ = g_strdup ("someone-1@example.org");
	_g_free0 (self->priv->_email_1);
	self->priv->_email_1 = _tmp8_;
	_tmp9_ = g_strdup ("someone-2@example.org");
	_g_free0 (self->priv->_email_2);
	self->priv->_email_2 = _tmp9_;
	_tmp10_ = g_strdup ("someone-1@jabber.example.org");
	_g_free0 (self->priv->_im_addr_1);
	self->priv->_im_addr_1 = _tmp10_;
	_tmp11_ = g_strdup ("someone-2@jabber.example.org");
	_g_free0 (self->priv->_im_addr_2);
	self->priv->_im_addr_2 = _tmp11_;
	_tmp12_ = g_strdup ("this is a note");
	_g_free0 (self->priv->_note_1);
	self->priv->_note_1 = _tmp12_;
	_tmp13_ = g_strdup ("12345");
	_g_free0 (self->priv->_phone_1);
	self->priv->_phone_1 = _tmp13_;
	_tmp14_ = g_strdup ("54321");
	_g_free0 (self->priv->_phone_2);
	self->priv->_phone_2 = _tmp14_;
	_tmp15_ = g_strdup ("CFO");
	_g_free0 (self->priv->_title_1);
	self->priv->_title_1 = _tmp15_;
	_tmp16_ = g_strdup ("Example Inc.");
	_g_free0 (self->priv->_organisation_1);
	self->priv->_organisation_1 = _tmp16_;
	_tmp17_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	types = _tmp17_;
	_tmp18_ = folks_postal_address_new (self->priv->_po_box, self->priv->_extension, self->priv->_street, self->priv->_locality, self->priv->_region, self->priv->_postal_code, self->priv->_country, NULL, (GeeSet*) types, NULL);
	_g_object_unref0 (self->priv->_address);
	self->priv->_address = _tmp18_;
	g_get_current_time (&t);
	g_time_val_from_iso8601 (self->priv->_birthday, &t);
	_tmp19_ = g_date_time_new_from_timeval_utc (&t);
	_g_date_time_unref0 (self->priv->_bday);
	self->priv->_bday = _tmp19_;
	_tmp20_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->_properties_found);
	self->priv->_properties_found = _tmp20_;
	_tmp21_ = g_strdup ("full_name");
	g_hash_table_insert (self->priv->_properties_found, _tmp21_, GINT_TO_POINTER (FALSE));
	_tmp22_ = g_strdup ("alias");
	g_hash_table_insert (self->priv->_properties_found, _tmp22_, GINT_TO_POINTER (FALSE));
	_tmp23_ = g_strdup ("is_favourite");
	g_hash_table_insert (self->priv->_properties_found, _tmp23_, GINT_TO_POINTER (FALSE));
	_tmp24_ = g_strdup ("structured_name");
	g_hash_table_insert (self->priv->_properties_found, _tmp24_, GINT_TO_POINTER (FALSE));
	_tmp25_ = g_strdup ("avatar");
	g_hash_table_insert (self->priv->_properties_found, _tmp25_, GINT_TO_POINTER (FALSE));
	_tmp26_ = g_strdup ("birthday");
	g_hash_table_insert (self->priv->_properties_found, _tmp26_, GINT_TO_POINTER (FALSE));
	_tmp27_ = g_strdup ("gender");
	g_hash_table_insert (self->priv->_properties_found, _tmp27_, GINT_TO_POINTER (FALSE));
	_tmp28_ = g_strdup ("email-1");
	g_hash_table_insert (self->priv->_properties_found, _tmp28_, GINT_TO_POINTER (FALSE));
	_tmp29_ = g_strdup ("email-2");
	g_hash_table_insert (self->priv->_properties_found, _tmp29_, GINT_TO_POINTER (FALSE));
	_tmp30_ = g_strdup ("im-addr-1");
	g_hash_table_insert (self->priv->_properties_found, _tmp30_, GINT_TO_POINTER (FALSE));
	_tmp31_ = g_strdup ("im-addr-2");
	g_hash_table_insert (self->priv->_properties_found, _tmp31_, GINT_TO_POINTER (FALSE));
	_tmp32_ = g_strdup ("note-1");
	g_hash_table_insert (self->priv->_properties_found, _tmp32_, GINT_TO_POINTER (FALSE));
	_tmp33_ = g_strdup ("phone-1");
	g_hash_table_insert (self->priv->_properties_found, _tmp33_, GINT_TO_POINTER (FALSE));
	_tmp34_ = g_strdup ("phone-2");
	g_hash_table_insert (self->priv->_properties_found, _tmp34_, GINT_TO_POINTER (FALSE));
	_tmp35_ = g_strdup ("role-1");
	g_hash_table_insert (self->priv->_properties_found, _tmp35_, GINT_TO_POINTER (FALSE));
	_tmp36_ = g_strdup ("postal-address-1");
	g_hash_table_insert (self->priv->_properties_found, _tmp36_, GINT_TO_POINTER (FALSE));
	_tmp37_ = g_strdup ("url-1");
	g_hash_table_insert (self->priv->_properties_found, _tmp37_, GINT_TO_POINTER (FALSE));
	_tmp38_ = g_strdup ("url-2");
	g_hash_table_insert (self->priv->_properties_found, _tmp38_, GINT_TO_POINTER (FALSE));
	_add_persona_tests_test_add_persona_async (self, NULL, NULL);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda0__gsource_func, g_object_ref (self), g_object_unref);
	g_main_loop_run (self->priv->_main_loop);
	_tmp39_ = g_hash_table_get_values (self->priv->_properties_found);
	{
		GList* k_collection;
		GList* k_it;
		k_collection = _tmp39_;
		for (k_it = k_collection; k_it != NULL; k_it = k_it->next) {
			gboolean k;
			k = GPOINTER_TO_INT (k_it->data);
			{
				g_assert (k);
			}
		}
		_g_list_free0 (k_collection);
	}
	tracker_test_backend_tear_down (self->priv->_tracker_backend);
	_g_object_unref0 (types);
}


static void _add_persona_tests_test_add_persona_async_data_free (gpointer _data) {
	AddPersonaTestsTestAddPersonaAsyncData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (AddPersonaTestsTestAddPersonaAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _add_persona_tests_test_add_persona_async (AddPersonaTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AddPersonaTestsTestAddPersonaAsyncData* _data_;
	_data_ = g_slice_new0 (AddPersonaTestsTestAddPersonaAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _add_persona_tests_test_add_persona_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _add_persona_tests_test_add_persona_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_add_persona_tests_test_add_persona_async_co (_data_);
}


static void _add_persona_tests_test_add_persona_finish (AddPersonaTests* self, GAsyncResult* _res_) {
	AddPersonaTestsTestAddPersonaAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _add_persona_tests_test_add_persona_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AddPersonaTestsTestAddPersonaAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_add_persona_tests_test_add_persona_async_co (data);
}


static void __add_persona_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_add_persona_tests_individuals_changed_cb (self, added, removed, message, actor, reason);
}


static void __add_persona_tests_notify_pstore_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_add_persona_tests_notify_pstore_cb (self, _sender, pspec);
}


static gboolean _add_persona_tests_test_add_persona_async_co (AddPersonaTestsTestAddPersonaAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = folks_backend_store_dup ();
	data->store = data->_tmp0_;
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, _add_persona_tests_test_add_persona_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_tmp1_ = NULL;
	data->_tmp1_ = folks_individual_aggregator_new ();
	_g_object_unref0 (data->self->priv->_aggregator);
	data->self->priv->_aggregator = data->_tmp1_;
	g_signal_connect_object (data->self->priv->_aggregator, "individuals-changed", (GCallback) __add_persona_tests_individuals_changed_cb_folks_individual_aggregator_individuals_changed, data->self, 0);
	data->_state_ = 2;
	folks_individual_aggregator_prepare (data->self->priv->_aggregator, _add_persona_tests_test_add_persona_async_ready, data);
	return FALSE;
	_state_2:
	folks_individual_aggregator_prepare_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	_g_object_unref0 (data->self->priv->_pstore);
	data->self->priv->_pstore = NULL;
	{
		data->_tmp2_ = NULL;
		data->_tmp2_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp3_ = NULL;
		data->_tmp3_ = gee_map_get_values (data->_tmp2_);
		data->_tmp4_ = data->_tmp3_;
		data->_tmp5_ = NULL;
		data->_tmp5_ = gee_iterable_iterator ((GeeIterable*) data->_tmp4_);
		data->_tmp6_ = data->_tmp5_;
		_g_object_unref0 (data->_tmp4_);
		data->_backend_it = data->_tmp6_;
		while (TRUE) {
			data->_tmp7_ = gee_iterator_next (data->_backend_it);
			if (!data->_tmp7_) {
				break;
			}
			data->_tmp8_ = NULL;
			data->_tmp8_ = gee_iterator_get (data->_backend_it);
			data->backend = (FolksBackend*) data->_tmp8_;
			data->_tmp9_ = NULL;
			data->_tmp9_ = folks_backend_get_persona_stores (data->backend);
			data->_tmp10_ = NULL;
			data->_tmp10_ = gee_map_get (data->_tmp9_, "tracker");
			_g_object_unref0 (data->self->priv->_pstore);
			data->self->priv->_pstore = TRF_PERSONA_STORE ((FolksPersonaStore*) data->_tmp10_);
			if (data->self->priv->_pstore != NULL) {
				_g_object_unref0 (data->backend);
				break;
			}
			_g_object_unref0 (data->backend);
		}
		_g_object_unref0 (data->_backend_it);
	}
	g_assert (data->self->priv->_pstore != NULL);
	g_signal_connect_object ((GObject*) data->self->priv->_pstore, "notify::is-prepared", (GCallback) __add_persona_tests_notify_pstore_cb_g_object_notify, data->self, 0);
	_add_persona_tests_try_to_add (data->self);
	goto __finally0;
	__catch0_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("add-persona.vala:172: Error when calling prepare: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally0:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->store);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _add_persona_tests_add_persona_data_free (gpointer _data) {
	AddPersonaTestsAddPersonaData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (AddPersonaTestsAddPersonaData, data);
}


static void _add_persona_tests_add_persona (AddPersonaTests* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AddPersonaTestsAddPersonaData* _data_;
	_data_ = g_slice_new0 (AddPersonaTestsAddPersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _add_persona_tests_add_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _add_persona_tests_add_persona_data_free);
	_data_->self = _g_object_ref0 (self);
	_add_persona_tests_add_persona_co (_data_);
}


static void _add_persona_tests_add_persona_finish (AddPersonaTests* self, GAsyncResult* _res_) {
	AddPersonaTestsAddPersonaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void __vala_GValue_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL));
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static void _add_persona_tests_add_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AddPersonaTestsAddPersonaData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	_add_persona_tests_add_persona_co (data);
}


static gboolean _add_persona_tests_add_persona_co (AddPersonaTestsAddPersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, __vala_GValue_free0_);
	data->details = data->_tmp0_;
	memset (&data->_tmp1_, 0, sizeof (GValue));
	g_value_init (&data->_tmp1_, G_TYPE_STRING);
	memset (&data->_tmp2_, 0, sizeof (GValue));
	data->_tmp2_ = data->_tmp1_;
	data->_tmp3_ = data->_tmp2_;
	data->_tmp4_ = __g_value_dup0 (&data->_tmp3_);
	data->_tmp5_ = data->_tmp4_;
	G_IS_VALUE (&data->_tmp3_) ? (g_value_unset (&data->_tmp3_), NULL) : NULL;
	data->v1 = data->_tmp5_;
	g_value_set_string (data->v1, data->self->priv->_persona_fullname);
	data->_tmp6_ = NULL;
	data->_tmp6_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_FULL_NAME);
	data->_tmp7_ = g_strdup (data->_tmp6_);
	data->_tmp8_ = data->v1;
	data->v1 = NULL;
	g_hash_table_insert (data->details, data->_tmp7_, data->_tmp8_);
	memset (&data->_tmp9_, 0, sizeof (GValue));
	g_value_init (&data->_tmp9_, G_TYPE_STRING);
	memset (&data->_tmp10_, 0, sizeof (GValue));
	data->_tmp10_ = data->_tmp9_;
	data->_tmp11_ = data->_tmp10_;
	data->_tmp12_ = __g_value_dup0 (&data->_tmp11_);
	data->_tmp13_ = data->_tmp12_;
	G_IS_VALUE (&data->_tmp11_) ? (g_value_unset (&data->_tmp11_), NULL) : NULL;
	data->v2 = data->_tmp13_;
	g_value_set_string (data->v2, data->self->priv->_persona_alias);
	data->_tmp14_ = NULL;
	data->_tmp14_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_ALIAS);
	data->_tmp15_ = g_strdup (data->_tmp14_);
	data->_tmp16_ = data->v2;
	data->v2 = NULL;
	g_hash_table_insert (data->details, data->_tmp15_, data->_tmp16_);
	memset (&data->_tmp17_, 0, sizeof (GValue));
	g_value_init (&data->_tmp17_, G_TYPE_BOOLEAN);
	memset (&data->_tmp18_, 0, sizeof (GValue));
	data->_tmp18_ = data->_tmp17_;
	data->_tmp19_ = data->_tmp18_;
	data->_tmp20_ = __g_value_dup0 (&data->_tmp19_);
	data->_tmp21_ = data->_tmp20_;
	G_IS_VALUE (&data->_tmp19_) ? (g_value_unset (&data->_tmp19_), NULL) : NULL;
	data->v3 = data->_tmp21_;
	g_value_set_boolean (data->v3, TRUE);
	data->_tmp22_ = NULL;
	data->_tmp22_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IS_FAVOURITE);
	data->_tmp23_ = g_strdup (data->_tmp22_);
	data->_tmp24_ = data->v3;
	data->v3 = NULL;
	g_hash_table_insert (data->details, data->_tmp23_, data->_tmp24_);
	memset (&data->_tmp25_, 0, sizeof (GValue));
	g_value_init (&data->_tmp25_, FOLKS_TYPE_STRUCTURED_NAME);
	memset (&data->_tmp26_, 0, sizeof (GValue));
	data->_tmp26_ = data->_tmp25_;
	data->_tmp27_ = data->_tmp26_;
	data->_tmp28_ = __g_value_dup0 (&data->_tmp27_);
	data->_tmp29_ = data->_tmp28_;
	G_IS_VALUE (&data->_tmp27_) ? (g_value_unset (&data->_tmp27_), NULL) : NULL;
	data->v4 = data->_tmp29_;
	data->_tmp30_ = NULL;
	data->_tmp30_ = folks_structured_name_new (data->self->priv->_family_name, data->self->priv->_given_name, NULL, NULL, NULL);
	data->sname = data->_tmp30_;
	g_value_set_object (data->v4, (GObject*) data->sname);
	data->_tmp31_ = NULL;
	data->_tmp31_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_STRUCTURED_NAME);
	data->_tmp32_ = g_strdup (data->_tmp31_);
	data->_tmp33_ = data->v4;
	data->v4 = NULL;
	g_hash_table_insert (data->details, data->_tmp32_, data->_tmp33_);
	memset (&data->_tmp34_, 0, sizeof (GValue));
	g_value_init (&data->_tmp34_, G_TYPE_FILE);
	memset (&data->_tmp35_, 0, sizeof (GValue));
	data->_tmp35_ = data->_tmp34_;
	data->_tmp36_ = data->_tmp35_;
	data->_tmp37_ = __g_value_dup0 (&data->_tmp36_);
	data->_tmp38_ = data->_tmp37_;
	G_IS_VALUE (&data->_tmp36_) ? (g_value_unset (&data->_tmp36_), NULL) : NULL;
	data->v5 = data->_tmp38_;
	data->_tmp39_ = NULL;
	data->_tmp39_ = g_file_new_for_uri (data->self->priv->_file_uri);
	data->avatar = data->_tmp39_;
	g_value_set_object (data->v5, (GObject*) data->avatar);
	data->_tmp40_ = NULL;
	data->_tmp40_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_AVATAR);
	data->_tmp41_ = g_strdup (data->_tmp40_);
	data->_tmp42_ = data->v5;
	data->v5 = NULL;
	g_hash_table_insert (data->details, data->_tmp41_, data->_tmp42_);
	memset (&data->_tmp43_, 0, sizeof (GValue));
	g_value_init (&data->_tmp43_, G_TYPE_DATE_TIME);
	memset (&data->_tmp44_, 0, sizeof (GValue));
	data->_tmp44_ = data->_tmp43_;
	data->_tmp45_ = data->_tmp44_;
	data->_tmp46_ = __g_value_dup0 (&data->_tmp45_);
	data->_tmp47_ = data->_tmp46_;
	G_IS_VALUE (&data->_tmp45_) ? (g_value_unset (&data->_tmp45_), NULL) : NULL;
	data->v6 = data->_tmp47_;
	g_get_current_time (&data->t);
	g_time_val_from_iso8601 (data->self->priv->_birthday, &data->t);
	data->_tmp48_ = NULL;
	data->_tmp48_ = g_date_time_new_from_timeval_utc (&data->t);
	data->dobj = data->_tmp48_;
	g_value_set_boxed (data->v6, data->dobj);
	data->_tmp49_ = NULL;
	data->_tmp49_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_BIRTHDAY);
	data->_tmp50_ = g_strdup (data->_tmp49_);
	data->_tmp51_ = data->v6;
	data->v6 = NULL;
	g_hash_table_insert (data->details, data->_tmp50_, data->_tmp51_);
	memset (&data->_tmp52_, 0, sizeof (GValue));
	g_value_init (&data->_tmp52_, FOLKS_TYPE_GENDER);
	memset (&data->_tmp53_, 0, sizeof (GValue));
	data->_tmp53_ = data->_tmp52_;
	data->_tmp54_ = data->_tmp53_;
	data->_tmp55_ = __g_value_dup0 (&data->_tmp54_);
	data->_tmp56_ = data->_tmp55_;
	G_IS_VALUE (&data->_tmp54_) ? (g_value_unset (&data->_tmp54_), NULL) : NULL;
	data->v7 = data->_tmp56_;
	g_value_set_enum (data->v7, (gint) FOLKS_GENDER_MALE);
	data->_tmp57_ = NULL;
	data->_tmp57_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_GENDER);
	data->_tmp58_ = g_strdup (data->_tmp57_);
	data->_tmp59_ = data->v7;
	data->v7 = NULL;
	g_hash_table_insert (data->details, data->_tmp58_, data->_tmp59_);
	memset (&data->_tmp60_, 0, sizeof (GValue));
	g_value_init (&data->_tmp60_, GEE_TYPE_SET);
	memset (&data->_tmp61_, 0, sizeof (GValue));
	data->_tmp61_ = data->_tmp60_;
	data->_tmp62_ = data->_tmp61_;
	data->_tmp63_ = __g_value_dup0 (&data->_tmp62_);
	data->_tmp64_ = data->_tmp63_;
	G_IS_VALUE (&data->_tmp62_) ? (g_value_unset (&data->_tmp62_), NULL) : NULL;
	data->v8 = data->_tmp64_;
	data->_tmp65_ = NULL;
	data->_tmp65_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->emails = data->_tmp65_;
	data->_tmp66_ = NULL;
	data->_tmp66_ = folks_field_details_new (data->self->priv->_email_1);
	data->email_1 = data->_tmp66_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->emails, data->email_1);
	data->_tmp67_ = NULL;
	data->_tmp67_ = folks_field_details_new (data->self->priv->_email_2);
	data->email_2 = data->_tmp67_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->emails, data->email_2);
	g_value_set_object (data->v8, (GObject*) data->emails);
	data->_tmp68_ = NULL;
	data->_tmp68_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_EMAIL_ADDRESSES);
	data->_tmp69_ = g_strdup (data->_tmp68_);
	data->_tmp70_ = data->v8;
	data->v8 = NULL;
	g_hash_table_insert (data->details, data->_tmp69_, data->_tmp70_);
	memset (&data->_tmp71_, 0, sizeof (GValue));
	g_value_init (&data->_tmp71_, GEE_TYPE_MULTI_MAP);
	memset (&data->_tmp72_, 0, sizeof (GValue));
	data->_tmp72_ = data->_tmp71_;
	data->_tmp73_ = data->_tmp72_;
	data->_tmp74_ = __g_value_dup0 (&data->_tmp73_);
	data->_tmp75_ = data->_tmp74_;
	G_IS_VALUE (&data->_tmp73_) ? (g_value_unset (&data->_tmp73_), NULL) : NULL;
	data->v9 = data->_tmp75_;
	data->_tmp76_ = NULL;
	data->_tmp76_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	data->im_addrs = data->_tmp76_;
	gee_multi_map_set ((GeeMultiMap*) data->im_addrs, "jabber", data->self->priv->_im_addr_1);
	gee_multi_map_set ((GeeMultiMap*) data->im_addrs, "yahoo", data->self->priv->_im_addr_2);
	g_value_set_object (data->v9, (GObject*) data->im_addrs);
	data->_tmp77_ = NULL;
	data->_tmp77_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IM_ADDRESSES);
	data->_tmp78_ = g_strdup (data->_tmp77_);
	data->_tmp79_ = __g_value_dup0 (data->v9);
	g_hash_table_insert (data->details, data->_tmp78_, data->_tmp79_);
	memset (&data->_tmp80_, 0, sizeof (GValue));
	g_value_init (&data->_tmp80_, GEE_TYPE_SET);
	memset (&data->_tmp81_, 0, sizeof (GValue));
	data->_tmp81_ = data->_tmp80_;
	data->_tmp82_ = data->_tmp81_;
	data->_tmp83_ = __g_value_dup0 (&data->_tmp82_);
	data->_tmp84_ = data->_tmp83_;
	G_IS_VALUE (&data->_tmp82_) ? (g_value_unset (&data->_tmp82_), NULL) : NULL;
	data->v10 = data->_tmp84_;
	data->_tmp85_ = NULL;
	data->_tmp85_ = gee_hash_set_new (FOLKS_TYPE_NOTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->notes = data->_tmp85_;
	data->_tmp86_ = NULL;
	data->_tmp86_ = folks_note_new (data->self->priv->_note_1, NULL);
	data->n1 = data->_tmp86_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->notes, data->n1);
	g_value_set_object (data->v10, (GObject*) data->notes);
	data->_tmp87_ = NULL;
	data->_tmp87_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_NOTES);
	data->_tmp88_ = g_strdup (data->_tmp87_);
	data->_tmp89_ = data->v10;
	data->v10 = NULL;
	g_hash_table_insert (data->details, data->_tmp88_, data->_tmp89_);
	memset (&data->_tmp90_, 0, sizeof (GValue));
	g_value_init (&data->_tmp90_, GEE_TYPE_SET);
	memset (&data->_tmp91_, 0, sizeof (GValue));
	data->_tmp91_ = data->_tmp90_;
	data->_tmp92_ = data->_tmp91_;
	data->_tmp93_ = __g_value_dup0 (&data->_tmp92_);
	data->_tmp94_ = data->_tmp93_;
	G_IS_VALUE (&data->_tmp92_) ? (g_value_unset (&data->_tmp92_), NULL) : NULL;
	data->v11 = data->_tmp94_;
	data->_tmp95_ = NULL;
	data->_tmp95_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->phones = data->_tmp95_;
	data->_tmp96_ = NULL;
	data->_tmp96_ = folks_field_details_new (data->self->priv->_phone_1);
	data->phone_1 = data->_tmp96_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->phones, data->phone_1);
	data->_tmp97_ = NULL;
	data->_tmp97_ = folks_field_details_new (data->self->priv->_phone_2);
	data->phone_2 = data->_tmp97_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->phones, data->phone_2);
	g_value_set_object (data->v11, (GObject*) data->phones);
	data->_tmp98_ = NULL;
	data->_tmp98_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_PHONE_NUMBERS);
	data->_tmp99_ = g_strdup (data->_tmp98_);
	data->_tmp100_ = data->v11;
	data->v11 = NULL;
	g_hash_table_insert (data->details, data->_tmp99_, data->_tmp100_);
	memset (&data->_tmp101_, 0, sizeof (GValue));
	g_value_init (&data->_tmp101_, GEE_TYPE_SET);
	memset (&data->_tmp102_, 0, sizeof (GValue));
	data->_tmp102_ = data->_tmp101_;
	data->_tmp103_ = data->_tmp102_;
	data->_tmp104_ = __g_value_dup0 (&data->_tmp103_);
	data->_tmp105_ = data->_tmp104_;
	G_IS_VALUE (&data->_tmp103_) ? (g_value_unset (&data->_tmp103_), NULL) : NULL;
	data->v12 = data->_tmp105_;
	data->_tmp106_ = NULL;
	data->_tmp106_ = gee_hash_set_new (FOLKS_TYPE_ROLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->roles = data->_tmp106_;
	data->_tmp107_ = NULL;
	data->_tmp107_ = folks_role_new (data->self->priv->_title_1, data->self->priv->_organisation_1, NULL);
	data->r1 = data->_tmp107_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->roles, data->r1);
	g_value_set_object (data->v12, (GObject*) data->roles);
	data->_tmp108_ = NULL;
	data->_tmp108_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_ROLES);
	data->_tmp109_ = g_strdup (data->_tmp108_);
	data->_tmp110_ = data->v12;
	data->v12 = NULL;
	g_hash_table_insert (data->details, data->_tmp109_, data->_tmp110_);
	memset (&data->_tmp111_, 0, sizeof (GValue));
	g_value_init (&data->_tmp111_, GEE_TYPE_SET);
	memset (&data->_tmp112_, 0, sizeof (GValue));
	data->_tmp112_ = data->_tmp111_;
	data->_tmp113_ = data->_tmp112_;
	data->_tmp114_ = __g_value_dup0 (&data->_tmp113_);
	data->_tmp115_ = data->_tmp114_;
	G_IS_VALUE (&data->_tmp113_) ? (g_value_unset (&data->_tmp113_), NULL) : NULL;
	data->v13 = data->_tmp115_;
	data->_tmp116_ = NULL;
	data->_tmp116_ = gee_hash_set_new (FOLKS_TYPE_POSTAL_ADDRESS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->postal_addresses = data->_tmp116_;
	data->_tmp117_ = NULL;
	data->_tmp117_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	data->types = data->_tmp117_;
	data->_tmp118_ = NULL;
	data->_tmp118_ = folks_postal_address_new (data->self->priv->_po_box, data->self->priv->_extension, data->self->priv->_street, data->self->priv->_locality, data->self->priv->_region, data->self->priv->_postal_code, data->self->priv->_country, NULL, (GeeSet*) data->types, NULL);
	data->postal_a = data->_tmp118_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->postal_addresses, data->postal_a);
	g_value_set_object (data->v13, (GObject*) data->postal_addresses);
	data->_tmp119_ = NULL;
	data->_tmp119_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_POSTAL_ADDRESSES);
	data->_tmp120_ = g_strdup (data->_tmp119_);
	data->_tmp121_ = data->v13;
	data->v13 = NULL;
	g_hash_table_insert (data->details, data->_tmp120_, data->_tmp121_);
	memset (&data->_tmp122_, 0, sizeof (GValue));
	g_value_init (&data->_tmp122_, GEE_TYPE_SET);
	memset (&data->_tmp123_, 0, sizeof (GValue));
	data->_tmp123_ = data->_tmp122_;
	data->_tmp124_ = data->_tmp123_;
	data->_tmp125_ = __g_value_dup0 (&data->_tmp124_);
	data->_tmp126_ = data->_tmp125_;
	G_IS_VALUE (&data->_tmp124_) ? (g_value_unset (&data->_tmp124_), NULL) : NULL;
	data->v14 = data->_tmp126_;
	data->_tmp127_ = NULL;
	data->_tmp127_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	data->urls = data->_tmp127_;
	data->_tmp128_ = NULL;
	data->_tmp128_ = folks_field_details_new (data->self->priv->_url_1);
	data->url_1 = data->_tmp128_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->urls, data->url_1);
	data->_tmp129_ = NULL;
	data->_tmp129_ = folks_field_details_new (data->self->priv->_url_2);
	data->url_2 = data->_tmp129_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->urls, data->url_2);
	g_value_set_object (data->v14, (GObject*) data->urls);
	data->_tmp130_ = NULL;
	data->_tmp130_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_URLS);
	data->_tmp131_ = g_strdup (data->_tmp130_);
	data->_tmp132_ = data->v14;
	data->v14 = NULL;
	g_hash_table_insert (data->details, data->_tmp131_, data->_tmp132_);
	data->_state_ = 1;
	folks_individual_aggregator_add_persona_from_details (data->self->priv->_aggregator, NULL, (FolksPersonaStore*) data->self->priv->_pstore, data->details, _add_persona_tests_add_persona_ready, data);
	return FALSE;
	_state_1:
	data->_tmp133_ = NULL;
	data->_tmp133_ = folks_individual_aggregator_add_persona_from_details_finish (data->self->priv->_aggregator, data->_res_, &data->_inner_error_);
	data->_tmp134_ = data->_tmp133_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == FOLKS_INDIVIDUAL_AGGREGATOR_ERROR) {
			goto __catch1_folks_individual_aggregator_error;
		}
		_g_object_unref0 (data->url_2);
		_g_object_unref0 (data->url_1);
		_g_object_unref0 (data->urls);
		__vala_GValue_free0 (data->v14);
		_g_object_unref0 (data->postal_a);
		_g_object_unref0 (data->types);
		_g_object_unref0 (data->postal_addresses);
		__vala_GValue_free0 (data->v13);
		_g_object_unref0 (data->r1);
		_g_object_unref0 (data->roles);
		__vala_GValue_free0 (data->v12);
		_g_object_unref0 (data->phone_2);
		_g_object_unref0 (data->phone_1);
		_g_object_unref0 (data->phones);
		__vala_GValue_free0 (data->v11);
		_g_object_unref0 (data->n1);
		_g_object_unref0 (data->notes);
		__vala_GValue_free0 (data->v10);
		_g_object_unref0 (data->im_addrs);
		__vala_GValue_free0 (data->v9);
		_g_object_unref0 (data->email_2);
		_g_object_unref0 (data->email_1);
		_g_object_unref0 (data->emails);
		__vala_GValue_free0 (data->v8);
		__vala_GValue_free0 (data->v7);
		_g_date_time_unref0 (data->dobj);
		__vala_GValue_free0 (data->v6);
		_g_object_unref0 (data->avatar);
		__vala_GValue_free0 (data->v5);
		_g_object_unref0 (data->sname);
		__vala_GValue_free0 (data->v4);
		__vala_GValue_free0 (data->v3);
		__vala_GValue_free0 (data->v2);
		__vala_GValue_free0 (data->v1);
		_g_hash_table_unref0 (data->details);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->persona = TRF_PERSONA (data->_tmp134_);
	data->_tmp135_ = NULL;
	data->_tmp135_ = folks_persona_get_iid ((FolksPersona*) data->persona);
	data->_tmp136_ = g_strdup (data->_tmp135_);
	_g_free0 (data->self->priv->_persona_iid);
	data->self->priv->_persona_iid = data->_tmp136_;
	_g_object_unref0 (data->persona);
	goto __finally1;
	__catch1_folks_individual_aggregator_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_warning ("add-persona.vala:302: [AddPersonaError] add_persona_from_details: %s\n", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally1:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->url_2);
		_g_object_unref0 (data->url_1);
		_g_object_unref0 (data->urls);
		__vala_GValue_free0 (data->v14);
		_g_object_unref0 (data->postal_a);
		_g_object_unref0 (data->types);
		_g_object_unref0 (data->postal_addresses);
		__vala_GValue_free0 (data->v13);
		_g_object_unref0 (data->r1);
		_g_object_unref0 (data->roles);
		__vala_GValue_free0 (data->v12);
		_g_object_unref0 (data->phone_2);
		_g_object_unref0 (data->phone_1);
		_g_object_unref0 (data->phones);
		__vala_GValue_free0 (data->v11);
		_g_object_unref0 (data->n1);
		_g_object_unref0 (data->notes);
		__vala_GValue_free0 (data->v10);
		_g_object_unref0 (data->im_addrs);
		__vala_GValue_free0 (data->v9);
		_g_object_unref0 (data->email_2);
		_g_object_unref0 (data->email_1);
		_g_object_unref0 (data->emails);
		__vala_GValue_free0 (data->v8);
		__vala_GValue_free0 (data->v7);
		_g_date_time_unref0 (data->dobj);
		__vala_GValue_free0 (data->v6);
		_g_object_unref0 (data->avatar);
		__vala_GValue_free0 (data->v5);
		_g_object_unref0 (data->sname);
		__vala_GValue_free0 (data->v4);
		__vala_GValue_free0 (data->v3);
		__vala_GValue_free0 (data->v2);
		__vala_GValue_free0 (data->v1);
		_g_hash_table_unref0 (data->details);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->url_2);
	_g_object_unref0 (data->url_1);
	_g_object_unref0 (data->urls);
	__vala_GValue_free0 (data->v14);
	_g_object_unref0 (data->postal_a);
	_g_object_unref0 (data->types);
	_g_object_unref0 (data->postal_addresses);
	__vala_GValue_free0 (data->v13);
	_g_object_unref0 (data->r1);
	_g_object_unref0 (data->roles);
	__vala_GValue_free0 (data->v12);
	_g_object_unref0 (data->phone_2);
	_g_object_unref0 (data->phone_1);
	_g_object_unref0 (data->phones);
	__vala_GValue_free0 (data->v11);
	_g_object_unref0 (data->n1);
	_g_object_unref0 (data->notes);
	__vala_GValue_free0 (data->v10);
	_g_object_unref0 (data->im_addrs);
	__vala_GValue_free0 (data->v9);
	_g_object_unref0 (data->email_2);
	_g_object_unref0 (data->email_1);
	_g_object_unref0 (data->emails);
	__vala_GValue_free0 (data->v8);
	__vala_GValue_free0 (data->v7);
	_g_date_time_unref0 (data->dobj);
	__vala_GValue_free0 (data->v6);
	_g_object_unref0 (data->avatar);
	__vala_GValue_free0 (data->v5);
	_g_object_unref0 (data->sname);
	__vala_GValue_free0 (data->v4);
	__vala_GValue_free0 (data->v3);
	__vala_GValue_free0 (data->v2);
	__vala_GValue_free0 (data->v1);
	_g_hash_table_unref0 (data->details);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void __add_persona_tests_notify_persona_sname_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_add_persona_tests_notify_persona_sname (self, _sender, pspec);
}


static void __add_persona_tests_notify_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_add_persona_tests_notify_cb (self, _sender, pspec);
}


static void _add_persona_tests_individuals_changed_cb (AddPersonaTests* self, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason) {
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = gee_iterable_iterator ((GeeIterable*) added);
		_i_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksIndividual* i;
			gboolean _tmp3_;
			_tmp1_ = gee_iterator_next (_i_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_i_it);
			i = (FolksIndividual*) _tmp2_;
			_tmp3_ = folks_individual_get_is_user (i);
			if (_tmp3_ == FALSE) {
				{
					GeeSet* _tmp4_ = NULL;
					GeeIterator* _tmp5_ = NULL;
					GeeIterator* _p_it;
					_tmp4_ = folks_individual_get_personas (i);
					_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
					_p_it = _tmp5_;
					while (TRUE) {
						gboolean _tmp6_;
						gpointer _tmp7_ = NULL;
						FolksPersona* p;
						gboolean _tmp8_ = FALSE;
						_tmp6_ = gee_iterator_next (_p_it);
						if (!_tmp6_) {
							break;
						}
						_tmp7_ = gee_iterator_get (_p_it);
						p = (FolksPersona*) _tmp7_;
						if (FOLKS_IS_NAME_DETAILS (p)) {
							FolksStructuredName* _tmp9_ = NULL;
							_tmp9_ = folks_name_details_get_structured_name (FOLKS_NAME_DETAILS (p));
							_tmp8_ = _tmp9_ != NULL;
						} else {
							_tmp8_ = FALSE;
						}
						if (_tmp8_) {
							g_signal_connect_object ((GObject*) p, "notify::structured-name", (GCallback) __add_persona_tests_notify_persona_sname_g_object_notify, self, 0);
						}
						_g_object_unref0 (p);
					}
					_g_object_unref0 (_p_it);
				}
				g_signal_connect_object ((GObject*) i, "notify::full-name", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::alias", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::avatar", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::is-favourite", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::structured-name", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::family-name", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::given-name", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::avatar", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::birthday", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::gender", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::email-addresses", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::im-addresses", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::notes", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::phone-numbers", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::roles", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::postal-addresses", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) i, "notify::urls", (GCallback) __add_persona_tests_notify_cb_g_object_notify, self, 0);
				_add_persona_tests_check_properties (self, i);
			}
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp10_ = gee_collection_get_size ((GeeCollection*) removed);
	g_assert (_tmp10_ == 0);
}


static void _add_persona_tests_notify_cb (AddPersonaTests* self, GObject* individual_obj, GParamSpec* ps) {
	FolksIndividual* _tmp0_;
	FolksIndividual* i;
	g_return_if_fail (self != NULL);
	g_return_if_fail (individual_obj != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (FOLKS_INDIVIDUAL (individual_obj));
	i = _tmp0_;
	_add_persona_tests_check_properties (self, i);
	_g_object_unref0 (i);
}


static void _add_persona_tests_notify_persona_sname (AddPersonaTests* self, GObject* persona_p, GParamSpec* ps) {
	TrfPersona* _tmp0_;
	TrfPersona* persona;
	FolksStructuredName* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (persona_p != NULL);
	g_return_if_fail (ps != NULL);
	_tmp0_ = _g_object_ref0 (TRF_PERSONA (persona_p));
	persona = _tmp0_;
	_tmp1_ = folks_name_details_get_structured_name ((FolksNameDetails*) persona);
	_add_persona_tests_check_sname (self, _tmp1_);
	_add_persona_tests_exit_if_all_properties_found (self);
	_g_object_unref0 (persona);
}


static void _add_persona_tests_notify_pstore_cb (AddPersonaTests* self, GObject* _pstore, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_pstore != NULL);
	g_return_if_fail (ps != NULL);
	_add_persona_tests_try_to_add (self);
}


static void _add_persona_tests_try_to_add (AddPersonaTests* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_;
		g_static_rec_mutex_lock (&self->priv->__lock__added_persona);
		_tmp1_ = folks_persona_store_get_is_prepared ((FolksPersonaStore*) self->priv->_pstore);
		if (_tmp1_) {
			_tmp0_ = self->priv->_added_persona == FALSE;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			self->priv->_added_persona = TRUE;
			_add_persona_tests_add_persona (self, NULL, NULL);
		}
		__finally2:
		g_static_rec_mutex_unlock (&self->priv->__lock__added_persona);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void _add_persona_tests_check_properties (AddPersonaTests* self, FolksIndividual* i) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp4_;
	FolksStructuredName* _tmp6_ = NULL;
	gboolean _tmp8_ = FALSE;
	GFile* _tmp9_ = NULL;
	gboolean _tmp14_ = FALSE;
	GDateTime* _tmp15_ = NULL;
	FolksGender _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	_tmp0_ = folks_name_details_get_full_name ((FolksNameDetails*) i);
	if (g_strcmp0 (_tmp0_, self->priv->_persona_fullname) == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("full_name");
		g_hash_table_replace (self->priv->_properties_found, _tmp1_, GINT_TO_POINTER (TRUE));
	}
	_tmp2_ = folks_alias_details_get_alias ((FolksAliasDetails*) i);
	if (g_strcmp0 (_tmp2_, self->priv->_persona_alias) == 0) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("alias");
		g_hash_table_replace (self->priv->_properties_found, _tmp3_, GINT_TO_POINTER (TRUE));
	}
	_tmp4_ = folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) i);
	if (_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("is_favourite");
		g_hash_table_replace (self->priv->_properties_found, _tmp5_, GINT_TO_POINTER (TRUE));
	}
	_tmp6_ = folks_name_details_get_structured_name ((FolksNameDetails*) i);
	if (_tmp6_ != NULL) {
		FolksStructuredName* _tmp7_ = NULL;
		_tmp7_ = folks_name_details_get_structured_name ((FolksNameDetails*) i);
		_add_persona_tests_check_sname (self, _tmp7_);
	}
	_tmp9_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) i);
	if (_tmp9_ != NULL) {
		GFile* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		_tmp10_ = folks_avatar_details_get_avatar ((FolksAvatarDetails*) i);
		_tmp11_ = g_file_get_uri (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp8_ = g_strcmp0 (_tmp12_, self->priv->_file_uri) == 0;
		_g_free0 (_tmp12_);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp13_;
		_tmp13_ = g_strdup ("avatar");
		g_hash_table_replace (self->priv->_properties_found, _tmp13_, GINT_TO_POINTER (TRUE));
	}
	_tmp15_ = folks_birthday_details_get_birthday ((FolksBirthdayDetails*) i);
	if (_tmp15_ != NULL) {
		GDateTime* _tmp16_ = NULL;
		gint _tmp17_;
		_tmp16_ = folks_birthday_details_get_birthday ((FolksBirthdayDetails*) i);
		_tmp17_ = g_date_time_compare (_tmp16_, self->priv->_bday);
		_tmp14_ = _tmp17_ == 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("birthday");
		g_hash_table_replace (self->priv->_properties_found, _tmp18_, GINT_TO_POINTER (TRUE));
	}
	_tmp19_ = folks_gender_details_get_gender ((FolksGenderDetails*) i);
	if (_tmp19_ == FOLKS_GENDER_MALE) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup ("gender");
		g_hash_table_replace (self->priv->_properties_found, _tmp20_, GINT_TO_POINTER (TRUE));
	}
	{
		GeeSet* _tmp21_ = NULL;
		GeeIterator* _tmp22_ = NULL;
		GeeIterator* _e_it;
		_tmp21_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) i);
		_tmp22_ = gee_iterable_iterator ((GeeIterable*) _tmp21_);
		_e_it = _tmp22_;
		while (TRUE) {
			gboolean _tmp23_;
			gpointer _tmp24_ = NULL;
			FolksFieldDetails* e;
			const gchar* _tmp25_ = NULL;
			_tmp23_ = gee_iterator_next (_e_it);
			if (!_tmp23_) {
				break;
			}
			_tmp24_ = gee_iterator_get (_e_it);
			e = (FolksFieldDetails*) _tmp24_;
			_tmp25_ = folks_field_details_get_value (e);
			if (g_strcmp0 (_tmp25_, self->priv->_email_1) == 0) {
				gchar* _tmp26_;
				_tmp26_ = g_strdup ("email-1");
				g_hash_table_replace (self->priv->_properties_found, _tmp26_, GINT_TO_POINTER (TRUE));
			} else {
				const gchar* _tmp27_ = NULL;
				_tmp27_ = folks_field_details_get_value (e);
				if (g_strcmp0 (_tmp27_, self->priv->_email_2) == 0) {
					gchar* _tmp28_;
					_tmp28_ = g_strdup ("email-2");
					g_hash_table_replace (self->priv->_properties_found, _tmp28_, GINT_TO_POINTER (TRUE));
				}
			}
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	{
		GeeMultiMap* _tmp29_ = NULL;
		GeeSet* _tmp30_ = NULL;
		GeeSet* _tmp31_;
		GeeIterator* _tmp32_ = NULL;
		GeeIterator* _tmp33_;
		GeeIterator* _proto_it;
		_tmp29_ = folks_im_details_get_im_addresses ((FolksImDetails*) i);
		_tmp30_ = gee_multi_map_get_keys (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
		_tmp33_ = _tmp32_;
		_g_object_unref0 (_tmp31_);
		_proto_it = _tmp33_;
		while (TRUE) {
			gboolean _tmp34_;
			gpointer _tmp35_ = NULL;
			gchar* proto;
			GeeMultiMap* _tmp36_ = NULL;
			GeeCollection* _tmp37_ = NULL;
			GeeCollection* addrs;
			_tmp34_ = gee_iterator_next (_proto_it);
			if (!_tmp34_) {
				break;
			}
			_tmp35_ = gee_iterator_get (_proto_it);
			proto = (gchar*) _tmp35_;
			_tmp36_ = folks_im_details_get_im_addresses ((FolksImDetails*) i);
			_tmp37_ = gee_multi_map_get (_tmp36_, proto);
			addrs = _tmp37_;
			{
				GeeIterator* _tmp38_ = NULL;
				GeeIterator* _a_it;
				_tmp38_ = gee_iterable_iterator ((GeeIterable*) addrs);
				_a_it = _tmp38_;
				while (TRUE) {
					gboolean _tmp39_;
					gpointer _tmp40_ = NULL;
					gchar* a;
					_tmp39_ = gee_iterator_next (_a_it);
					if (!_tmp39_) {
						break;
					}
					_tmp40_ = gee_iterator_get (_a_it);
					a = (gchar*) _tmp40_;
					if (g_strcmp0 (a, self->priv->_im_addr_1) == 0) {
						gchar* _tmp41_;
						_tmp41_ = g_strdup ("im-addr-1");
						g_hash_table_replace (self->priv->_properties_found, _tmp41_, GINT_TO_POINTER (TRUE));
					} else {
						if (g_strcmp0 (a, self->priv->_im_addr_2) == 0) {
							gchar* _tmp42_;
							_tmp42_ = g_strdup ("im-addr-2");
							g_hash_table_replace (self->priv->_properties_found, _tmp42_, GINT_TO_POINTER (TRUE));
						}
					}
					_g_free0 (a);
				}
				_g_object_unref0 (_a_it);
			}
			_g_object_unref0 (addrs);
			_g_free0 (proto);
		}
		_g_object_unref0 (_proto_it);
	}
	{
		GeeSet* _tmp43_ = NULL;
		GeeIterator* _tmp44_ = NULL;
		GeeIterator* _n_it;
		_tmp43_ = folks_note_details_get_notes ((FolksNoteDetails*) i);
		_tmp44_ = gee_iterable_iterator ((GeeIterable*) _tmp43_);
		_n_it = _tmp44_;
		while (TRUE) {
			gboolean _tmp45_;
			gpointer _tmp46_ = NULL;
			FolksNote* n;
			const gchar* _tmp47_ = NULL;
			_tmp45_ = gee_iterator_next (_n_it);
			if (!_tmp45_) {
				break;
			}
			_tmp46_ = gee_iterator_get (_n_it);
			n = (FolksNote*) _tmp46_;
			_tmp47_ = folks_note_get_content (n);
			if (g_strcmp0 (_tmp47_, self->priv->_note_1) == 0) {
				gchar* _tmp48_;
				_tmp48_ = g_strdup ("note-1");
				g_hash_table_replace (self->priv->_properties_found, _tmp48_, GINT_TO_POINTER (TRUE));
			}
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_it);
	}
	{
		GeeSet* _tmp49_ = NULL;
		GeeIterator* _tmp50_ = NULL;
		GeeIterator* _e_it;
		_tmp49_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) i);
		_tmp50_ = gee_iterable_iterator ((GeeIterable*) _tmp49_);
		_e_it = _tmp50_;
		while (TRUE) {
			gboolean _tmp51_;
			gpointer _tmp52_ = NULL;
			FolksFieldDetails* e;
			const gchar* _tmp53_ = NULL;
			_tmp51_ = gee_iterator_next (_e_it);
			if (!_tmp51_) {
				break;
			}
			_tmp52_ = gee_iterator_get (_e_it);
			e = (FolksFieldDetails*) _tmp52_;
			_tmp53_ = folks_field_details_get_value (e);
			if (g_strcmp0 (_tmp53_, self->priv->_phone_1) == 0) {
				gchar* _tmp54_;
				_tmp54_ = g_strdup ("phone-1");
				g_hash_table_replace (self->priv->_properties_found, _tmp54_, GINT_TO_POINTER (TRUE));
			} else {
				const gchar* _tmp55_ = NULL;
				_tmp55_ = folks_field_details_get_value (e);
				if (g_strcmp0 (_tmp55_, self->priv->_phone_2) == 0) {
					gchar* _tmp56_;
					_tmp56_ = g_strdup ("phone-2");
					g_hash_table_replace (self->priv->_properties_found, _tmp56_, GINT_TO_POINTER (TRUE));
				}
			}
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	{
		GeeSet* _tmp57_ = NULL;
		GeeIterator* _tmp58_ = NULL;
		GeeIterator* _r_it;
		_tmp57_ = folks_role_details_get_roles ((FolksRoleDetails*) i);
		_tmp58_ = gee_iterable_iterator ((GeeIterable*) _tmp57_);
		_r_it = _tmp58_;
		while (TRUE) {
			gboolean _tmp59_;
			gpointer _tmp60_ = NULL;
			FolksRole* r;
			gboolean _tmp61_ = FALSE;
			const gchar* _tmp62_ = NULL;
			_tmp59_ = gee_iterator_next (_r_it);
			if (!_tmp59_) {
				break;
			}
			_tmp60_ = gee_iterator_get (_r_it);
			r = (FolksRole*) _tmp60_;
			_tmp62_ = folks_role_get_title (r);
			if (g_strcmp0 (_tmp62_, self->priv->_title_1) == 0) {
				const gchar* _tmp63_ = NULL;
				_tmp63_ = folks_role_get_organisation_name (r);
				_tmp61_ = g_strcmp0 (_tmp63_, self->priv->_organisation_1) == 0;
			} else {
				_tmp61_ = FALSE;
			}
			if (_tmp61_) {
				gchar* _tmp64_;
				_tmp64_ = g_strdup ("role-1");
				g_hash_table_replace (self->priv->_properties_found, _tmp64_, GINT_TO_POINTER (TRUE));
			}
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_it);
	}
	{
		GeeSet* _tmp65_ = NULL;
		GeeIterator* _tmp66_ = NULL;
		GeeIterator* _pa_it;
		_tmp65_ = folks_postal_address_details_get_postal_addresses ((FolksPostalAddressDetails*) i);
		_tmp66_ = gee_iterable_iterator ((GeeIterable*) _tmp65_);
		_pa_it = _tmp66_;
		while (TRUE) {
			gboolean _tmp67_;
			gpointer _tmp68_ = NULL;
			FolksPostalAddress* pa;
			const gchar* _tmp69_ = NULL;
			gboolean _tmp70_;
			_tmp67_ = gee_iterator_next (_pa_it);
			if (!_tmp67_) {
				break;
			}
			_tmp68_ = gee_iterator_get (_pa_it);
			pa = (FolksPostalAddress*) _tmp68_;
			_tmp69_ = folks_postal_address_get_uid (pa);
			folks_postal_address_set_uid (self->priv->_address, _tmp69_);
			_tmp70_ = folks_postal_address_equal (pa, self->priv->_address);
			if (_tmp70_) {
				gchar* _tmp71_;
				_tmp71_ = g_strdup ("postal-address-1");
				g_hash_table_replace (self->priv->_properties_found, _tmp71_, GINT_TO_POINTER (TRUE));
			}
			_g_object_unref0 (pa);
		}
		_g_object_unref0 (_pa_it);
	}
	{
		GeeSet* _tmp72_ = NULL;
		GeeIterator* _tmp73_ = NULL;
		GeeIterator* _u_it;
		_tmp72_ = folks_url_details_get_urls ((FolksUrlDetails*) i);
		_tmp73_ = gee_iterable_iterator ((GeeIterable*) _tmp72_);
		_u_it = _tmp73_;
		while (TRUE) {
			gboolean _tmp74_;
			gpointer _tmp75_ = NULL;
			FolksFieldDetails* u;
			const gchar* _tmp76_ = NULL;
			const gchar* _tmp78_ = NULL;
			_tmp74_ = gee_iterator_next (_u_it);
			if (!_tmp74_) {
				break;
			}
			_tmp75_ = gee_iterator_get (_u_it);
			u = (FolksFieldDetails*) _tmp75_;
			_tmp76_ = folks_field_details_get_value (u);
			if (g_strcmp0 (_tmp76_, self->priv->_url_1) == 0) {
				gchar* _tmp77_;
				_tmp77_ = g_strdup ("url-1");
				g_hash_table_replace (self->priv->_properties_found, _tmp77_, GINT_TO_POINTER (TRUE));
			}
			_tmp78_ = folks_field_details_get_value (u);
			if (g_strcmp0 (_tmp78_, self->priv->_url_2) == 0) {
				gchar* _tmp79_;
				_tmp79_ = g_strdup ("url-2");
				g_hash_table_replace (self->priv->_properties_found, _tmp79_, GINT_TO_POINTER (TRUE));
			}
			_g_object_unref0 (u);
		}
		_g_object_unref0 (_u_it);
	}
	_add_persona_tests_exit_if_all_properties_found (self);
}


static void _add_persona_tests_exit_if_all_properties_found (AddPersonaTests* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_hash_table_get_keys (self->priv->_properties_found);
	{
		GList* k_collection;
		GList* k_it;
		k_collection = _tmp0_;
		for (k_it = k_collection; k_it != NULL; k_it = k_it->next) {
			const gchar* k;
			k = (const gchar*) k_it->data;
			{
				gconstpointer _tmp1_ = NULL;
				gboolean v;
				_tmp1_ = g_hash_table_lookup (self->priv->_properties_found, k);
				v = GPOINTER_TO_INT (_tmp1_);
				if (v == FALSE) {
					_g_list_free0 (k_collection);
					return;
				}
			}
		}
		_g_list_free0 (k_collection);
	}
	g_main_loop_quit (self->priv->_main_loop);
}


static void _add_persona_tests_check_sname (AddPersonaTests* self, FolksStructuredName* sname) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sname != NULL);
	_tmp1_ = folks_structured_name_get_family_name (sname);
	if (g_strcmp0 (_tmp1_, self->priv->_family_name) == 0) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = folks_structured_name_get_given_name (sname);
		_tmp0_ = g_strcmp0 (_tmp2_, self->priv->_given_name) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("structured_name");
		g_hash_table_replace (self->priv->_properties_found, _tmp3_, GINT_TO_POINTER (TRUE));
	}
}


static void add_persona_tests_class_init (AddPersonaTestsClass * klass) {
	add_persona_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AddPersonaTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = add_persona_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = add_persona_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = add_persona_tests_finalize;
}


static void add_persona_tests_instance_init (AddPersonaTests * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	self->priv = ADD_PERSONA_TESTS_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("12345");
	self->priv->_po_box = _tmp0_;
	_tmp1_ = g_strdup ("locality");
	self->priv->_locality = _tmp1_;
	_tmp2_ = g_strdup ("code");
	self->priv->_postal_code = _tmp2_;
	_tmp3_ = g_strdup ("some street");
	self->priv->_street = _tmp3_;
	_tmp4_ = g_strdup ("some extension");
	self->priv->_extension = _tmp4_;
	_tmp5_ = g_strdup ("some country");
	self->priv->_country = _tmp5_;
	_tmp6_ = g_strdup ("some region");
	self->priv->_region = _tmp6_;
	_tmp7_ = g_strdup ("http://www-1.example.org");
	self->priv->_url_1 = _tmp7_;
	_tmp8_ = g_strdup ("http://www-1.example.org");
	self->priv->_url_2 = _tmp8_;
	g_static_rec_mutex_init (&self->priv->__lock__added_persona);
	self->priv->_added_persona = FALSE;
}


static void add_persona_tests_finalize (GObject* obj) {
	AddPersonaTests * self;
	self = ADD_PERSONA_TESTS (obj);
	_g_main_loop_unref0 (self->priv->_main_loop);
	_tracker_test_backend_unref0 (self->priv->_tracker_backend);
	_g_object_unref0 (self->priv->_aggregator);
	_g_free0 (self->priv->_persona_fullname);
	_g_free0 (self->priv->_persona_alias);
	_g_free0 (self->priv->_family_name);
	_g_free0 (self->priv->_given_name);
	_g_hash_table_unref0 (self->priv->_properties_found);
	_g_free0 (self->priv->_persona_iid);
	_g_free0 (self->priv->_file_uri);
	_g_free0 (self->priv->_birthday);
	_g_date_time_unref0 (self->priv->_bday);
	_g_free0 (self->priv->_email_1);
	_g_free0 (self->priv->_email_2);
	_g_free0 (self->priv->_im_addr_1);
	_g_free0 (self->priv->_im_addr_2);
	_g_free0 (self->priv->_note_1);
	_g_free0 (self->priv->_phone_1);
	_g_free0 (self->priv->_phone_2);
	_g_free0 (self->priv->_title_1);
	_g_free0 (self->priv->_organisation_1);
	_g_object_unref0 (self->priv->_address);
	_g_free0 (self->priv->_po_box);
	_g_free0 (self->priv->_locality);
	_g_free0 (self->priv->_postal_code);
	_g_free0 (self->priv->_street);
	_g_free0 (self->priv->_extension);
	_g_free0 (self->priv->_country);
	_g_free0 (self->priv->_region);
	_g_free0 (self->priv->_url_1);
	_g_free0 (self->priv->_url_2);
	_g_object_unref0 (self->priv->_pstore);
	g_static_rec_mutex_free (&self->priv->__lock__added_persona);
	G_OBJECT_CLASS (add_persona_tests_parent_class)->finalize (obj);
}


GType add_persona_tests_get_type (void) {
	static volatile gsize add_persona_tests_type_id__volatile = 0;
	if (g_once_init_enter (&add_persona_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AddPersonaTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) add_persona_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AddPersonaTests), 0, (GInstanceInitFunc) add_persona_tests_instance_init, NULL };
		GType add_persona_tests_type_id;
		add_persona_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AddPersonaTests", &g_define_type_info, 0);
		g_once_init_leave (&add_persona_tests_type_id__volatile, add_persona_tests_type_id);
	}
	return add_persona_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	AddPersonaTests* _tmp1_ = NULL;
	AddPersonaTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = add_persona_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



