/* backend-loading.c generated by valac 0.12.0, the Vala compiler
 * generated from backend-loading.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <tp-test-contactlist.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>
#include <gee.h>
#include <folks/folks.h>


#define TYPE_BACKEND_LOADING_TESTS (backend_loading_tests_get_type ())
#define BACKEND_LOADING_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKEND_LOADING_TESTS, BackendLoadingTests))
#define BACKEND_LOADING_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKEND_LOADING_TESTS, BackendLoadingTestsClass))
#define IS_BACKEND_LOADING_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKEND_LOADING_TESTS))
#define IS_BACKEND_LOADING_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKEND_LOADING_TESTS))
#define BACKEND_LOADING_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKEND_LOADING_TESTS, BackendLoadingTestsClass))

typedef struct _BackendLoadingTests BackendLoadingTests;
typedef struct _BackendLoadingTestsClass BackendLoadingTestsClass;
typedef struct _BackendLoadingTestsPrivate BackendLoadingTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _BackendLoadingTestsTestDisablingAsyncData BackendLoadingTestsTestDisablingAsyncData;
typedef struct _BackendLoadingTestsTestReloadingAsyncData BackendLoadingTestsTestReloadingAsyncData;

struct _BackendLoadingTests {
	FolksTestCase parent_instance;
	BackendLoadingTestsPrivate * priv;
};

struct _BackendLoadingTestsClass {
	FolksTestCaseClass parent_class;
};

struct _BackendLoadingTestsPrivate {
	TpTestBackend* _tp_backend;
	void* _account_handle;
	GMainLoop* main_loop;
};

struct _Block1Data {
	int _ref_count_;
	BackendLoadingTests * self;
	GMainLoop* main_loop;
	GeeHashSet* backends_expected;
	FolksBackendStore* store;
};

struct _BackendLoadingTestsTestDisablingAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BackendLoadingTests* self;
	FolksBackendStore* store;
	GeeHashSet* _tmp0_;
	GeeHashSet* backends_expected;
	GeeMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _backend_it;
	gboolean _tmp6_;
	gpointer _tmp7_;
	FolksBackend* backend;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	GError * e;
	GError * _inner_error_;
};

struct _BackendLoadingTestsTestReloadingAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BackendLoadingTests* self;
	FolksBackendStore* store;
	GeeHashSet* backends_expected;
	GeeHashSet* _tmp0_;
	GeeMap* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeIterator* _tmp4_;
	GeeIterator* _tmp5_;
	GeeIterator* _backend1_it;
	gboolean _tmp6_;
	gpointer _tmp7_;
	FolksBackend* backend1;
	const gchar* _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	GError * e1;
	GeeHashSet* _tmp12_;
	GeeMap* _tmp13_;
	GeeCollection* _tmp14_;
	GeeCollection* _tmp15_;
	GeeIterator* _tmp16_;
	GeeIterator* _tmp17_;
	GeeIterator* _backend2_it;
	gboolean _tmp18_;
	gpointer _tmp19_;
	FolksBackend* backend2;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	const gchar* _tmp22_;
	gint _tmp23_;
	GError * e2;
	GeeHashSet* _tmp24_;
	GeeMap* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	GeeIterator* _tmp28_;
	GeeIterator* _tmp29_;
	GeeIterator* _backend3_it;
	gboolean _tmp30_;
	gpointer _tmp31_;
	FolksBackend* backend3;
	const gchar* _tmp32_;
	gboolean _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	GError * e3;
	GeeHashSet* _tmp36_;
	GeeMap* _tmp37_;
	GeeCollection* _tmp38_;
	GeeCollection* _tmp39_;
	GeeIterator* _tmp40_;
	GeeIterator* _tmp41_;
	GeeIterator* _backend_it;
	gboolean _tmp42_;
	gpointer _tmp43_;
	FolksBackend* backend;
	const gchar* _tmp44_;
	gboolean _tmp45_;
	const gchar* _tmp46_;
	gint _tmp47_;
	GError * e4;
	GError * _inner_error_;
};


static gpointer backend_loading_tests_parent_class = NULL;

GType backend_loading_tests_get_type (void) G_GNUC_CONST;
#define BACKEND_LOADING_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BACKEND_LOADING_TESTS, BackendLoadingTestsPrivate))
enum  {
	BACKEND_LOADING_TESTS_DUMMY_PROPERTY
};
#define BACKEND_LOADING_TESTS_STORE_FILE_PATH "folks-test-backend-store.ini"
BackendLoadingTests* backend_loading_tests_new (void);
BackendLoadingTests* backend_loading_tests_construct (GType object_type);
void backend_loading_tests_test_load_and_prep (BackendLoadingTests* self);
static void _backend_loading_tests_test_load_and_prep_folks_test_case_test_method (gpointer self);
void backend_loading_tests_test_disabling (BackendLoadingTests* self);
static void _backend_loading_tests_test_disabling_folks_test_case_test_method (gpointer self);
void backend_loading_tests_test_reloading (BackendLoadingTests* self);
static void _backend_loading_tests_test_reloading_folks_test_case_test_method (gpointer self);
static void backend_loading_tests_real_set_up (FolksTestCase* base);
static void backend_loading_tests_real_tear_down (FolksTestCase* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (GObject* o, GAsyncResult* r, Block1Data* _data1_);
static void __lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _lambda1_ (GObject* o, GAsyncResult* r, Block1Data* _data1_);
static void __lambda1__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void backend_loading_tests_test_disabling_async (BackendLoadingTests* self, FolksBackendStore* store, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void backend_loading_tests_test_disabling_finish (BackendLoadingTests* self, GAsyncResult* _res_);
static void _lambda2_ (GObject* o, GAsyncResult* r, BackendLoadingTests* self);
static void __lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void backend_loading_tests_test_disabling_async_data_free (gpointer _data);
static gboolean backend_loading_tests_test_disabling_async_co (BackendLoadingTestsTestDisablingAsyncData* data);
static void backend_loading_tests_test_disabling_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void backend_loading_tests_test_reloading_async (BackendLoadingTests* self, FolksBackendStore* store, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void backend_loading_tests_test_reloading_finish (BackendLoadingTests* self, GAsyncResult* _res_);
static void _lambda3_ (GObject* o, GAsyncResult* r, BackendLoadingTests* self);
static void __lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void backend_loading_tests_test_reloading_async_data_free (gpointer _data);
static gboolean backend_loading_tests_test_reloading_async_co (BackendLoadingTestsTestReloadingAsyncData* data);
static void backend_loading_tests_test_reloading_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void backend_loading_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);


static void _backend_loading_tests_test_load_and_prep_folks_test_case_test_method (gpointer self) {
	backend_loading_tests_test_load_and_prep (self);
}


static void _backend_loading_tests_test_disabling_folks_test_case_test_method (gpointer self) {
	backend_loading_tests_test_disabling (self);
}


static void _backend_loading_tests_test_reloading_folks_test_case_test_method (gpointer self) {
	backend_loading_tests_test_reloading (self);
}


BackendLoadingTests* backend_loading_tests_construct (GType object_type) {
	BackendLoadingTests * self = NULL;
	TpTestBackend* _tmp0_ = NULL;
	self = (BackendLoadingTests*) folks_test_case_construct (object_type, "BackendLoading");
	_tmp0_ = tp_test_backend_new ();
	_g_object_unref0 (self->priv->_tp_backend);
	self->priv->_tp_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "load and prep", _backend_loading_tests_test_load_and_prep_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "disabling", _backend_loading_tests_test_disabling_folks_test_case_test_method, self);
	folks_test_case_add_test ((FolksTestCase*) self, "reloading", _backend_loading_tests_test_reloading_folks_test_case_test_method, self);
	return self;
}


BackendLoadingTests* backend_loading_tests_new (void) {
	return backend_loading_tests_construct (TYPE_BACKEND_LOADING_TESTS);
}


static void backend_loading_tests_real_set_up (FolksTestCase* base) {
	BackendLoadingTests * self;
	void* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* kf_path;
	GKeyFile* _tmp3_ = NULL;
	GKeyFile* kf;
	GFile* _tmp4_ = NULL;
	GFile* backend_f;
	gchar* _tmp5_ = NULL;
	gchar* data;
	gint _tmp6_;
	GError * _inner_error_ = NULL;
	self = (BackendLoadingTests*) base;
	tp_test_backend_set_up (self->priv->_tp_backend);
	_tmp0_ = tp_test_backend_add_account (self->priv->_tp_backend, "protocol", "me@example.com", "cm", "account");
	self->priv->_account_handle = _tmp0_;
	_tmp1_ = g_get_tmp_dir ();
	_tmp2_ = g_build_filename (_tmp1_, BACKEND_LOADING_TESTS_STORE_FILE_PATH, NULL, NULL);
	kf_path = _tmp2_;
	g_remove (kf_path);
	_tmp3_ = g_key_file_new ();
	kf = _tmp3_;
	g_key_file_set_boolean (kf, "all-others", "enabled", FALSE);
	g_key_file_set_boolean (kf, "telepathy", "enabled", TRUE);
	g_key_file_set_boolean (kf, "key-file", "enabled", TRUE);
	_tmp4_ = g_file_new_for_path (kf_path);
	backend_f = _tmp4_;
	_tmp5_ = g_key_file_to_data (kf, NULL, NULL);
	data = _tmp5_;
	_tmp6_ = strlen (data);
	g_file_replace_contents (backend_f, data, (gsize) _tmp6_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_object_unref0 (backend_f);
		goto __catch0_g_error;
	}
	_g_free0 (data);
	_g_object_unref0 (backend_f);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("backend-loading.vala:49: Could not write updated backend key file '%s'" \
": %s", kf_path, e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (kf);
		_g_free0 (kf_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_setenv ("FOLKS_BACKEND_STORE_KEY_FILE_PATH", kf_path, TRUE);
	_g_key_file_free0 (kf);
	_g_free0 (kf_path);
}


static void backend_loading_tests_real_tear_down (FolksTestCase* base) {
	BackendLoadingTests * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	self = (BackendLoadingTests*) base;
	_tmp0_ = g_get_tmp_dir ();
	_tmp1_ = g_build_filename (_tmp0_, BACKEND_LOADING_TESTS_STORE_FILE_PATH, NULL, NULL);
	_tmp2_ = _tmp1_;
	g_remove (_tmp2_);
	_g_free0 (_tmp2_);
	tp_test_backend_remove_account (self->priv->_tp_backend, self->priv->_account_handle);
	tp_test_backend_tear_down (self->priv->_tp_backend);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->store);
		_g_object_unref0 (_data1_->backends_expected);
		_g_main_loop_unref0 (_data1_->main_loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda0_ (GObject* o, GAsyncResult* r, Block1Data* _data1_) {
	BackendLoadingTests * self;
	self = _data1_->self;
	g_return_if_fail (r != NULL);
	folks_backend_store_prepare_finish (_data1_->store, r);
}


static void __lambda0__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda0_ (source_object, res, self);
	block1_data_unref (self);
}


static void _lambda1_ (GObject* o, GAsyncResult* r, Block1Data* _data1_) {
	BackendLoadingTests * self;
	gint _tmp10_;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	g_return_if_fail (r != NULL);
	folks_backend_store_load_backends_finish (_data1_->store, r, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch1_g_error;
	}
	{
		GeeMap* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		GeeIterator* _tmp4_;
		GeeIterator* _backend_it;
		_tmp0_ = folks_backend_store_get_enabled_backends (_data1_->store);
		_tmp1_ = gee_map_get_values (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_backend_it = _tmp4_;
		while (TRUE) {
			gboolean _tmp5_;
			gpointer _tmp6_ = NULL;
			FolksBackend* backend;
			const gchar* _tmp7_ = NULL;
			gboolean _tmp8_;
			const gchar* _tmp9_ = NULL;
			_tmp5_ = gee_iterator_next (_backend_it);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = gee_iterator_get (_backend_it);
			backend = (FolksBackend*) _tmp6_;
			_tmp7_ = folks_backend_get_name (backend);
			_tmp8_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _data1_->backends_expected, _tmp7_);
			g_assert (_tmp8_);
			_tmp9_ = folks_backend_get_name (backend);
			gee_abstract_collection_remove ((GeeAbstractCollection*) _data1_->backends_expected, _tmp9_);
			_g_object_unref0 (backend);
		}
		_g_object_unref0 (_backend_it);
	}
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _data1_->backends_expected);
	g_assert (_tmp10_ == 0);
	g_main_loop_quit (_data1_->main_loop);
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_error ("backend-loading.vala:97: Failed to load backends: %s", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda1__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda1_ (source_object, res, self);
	block1_data_unref (self);
}


void backend_loading_tests_test_load_and_prep (BackendLoadingTests* self) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_ = NULL;
	GeeHashSet* _tmp1_ = NULL;
	FolksBackendStore* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data1_->main_loop = _tmp0_;
	_tmp1_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_data1_->backends_expected = _tmp1_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data1_->backends_expected, "key-file");
	gee_abstract_collection_add ((GeeAbstractCollection*) _data1_->backends_expected, "telepathy");
	_tmp2_ = folks_backend_store_dup ();
	_data1_->store = _tmp2_;
	folks_backend_store_prepare (_data1_->store, __lambda0__gasync_ready_callback, block1_data_ref (_data1_));
	folks_backend_store_load_backends (_data1_->store, __lambda1__gasync_ready_callback, block1_data_ref (_data1_));
	g_main_loop_run (_data1_->main_loop);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void _lambda2_ (GObject* o, GAsyncResult* r, BackendLoadingTests* self) {
	g_return_if_fail (r != NULL);
	backend_loading_tests_test_disabling_finish (self, r);
}


static void __lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda2_ (source_object, res, self);
	g_object_unref (self);
}


void backend_loading_tests_test_disabling (BackendLoadingTests* self) {
	GMainLoop* _tmp0_ = NULL;
	FolksBackendStore* _tmp1_ = NULL;
	FolksBackendStore* store;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp0_;
	_tmp1_ = folks_backend_store_dup ();
	store = _tmp1_;
	backend_loading_tests_test_disabling_async (self, store, __lambda2__gasync_ready_callback, g_object_ref (self));
	g_main_loop_run (self->priv->main_loop);
	_g_object_unref0 (store);
}


static void backend_loading_tests_test_disabling_async_data_free (gpointer _data) {
	BackendLoadingTestsTestDisablingAsyncData* data;
	data = _data;
	_g_object_unref0 (data->store);
	_g_object_unref0 (data->self);
	g_slice_free (BackendLoadingTestsTestDisablingAsyncData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void backend_loading_tests_test_disabling_async (BackendLoadingTests* self, FolksBackendStore* store, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BackendLoadingTestsTestDisablingAsyncData* _data_;
	_data_ = g_slice_new0 (BackendLoadingTestsTestDisablingAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, backend_loading_tests_test_disabling_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, backend_loading_tests_test_disabling_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->store = _g_object_ref0 (store);
	backend_loading_tests_test_disabling_async_co (_data_);
}


static void backend_loading_tests_test_disabling_finish (BackendLoadingTests* self, GAsyncResult* _res_) {
	BackendLoadingTestsTestDisablingAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void backend_loading_tests_test_disabling_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BackendLoadingTestsTestDisablingAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	backend_loading_tests_test_disabling_async_co (data);
}


static gboolean backend_loading_tests_test_disabling_async_co (BackendLoadingTestsTestDisablingAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	data->backends_expected = data->_tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->backends_expected, "key-file");
	data->_state_ = 1;
	folks_backend_store_prepare (data->store, backend_loading_tests_test_disabling_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_prepare_finish (data->store, data->_res_);
	data->_state_ = 2;
	folks_backend_store_disable_backend (data->store, "telepathy", backend_loading_tests_test_disabling_async_ready, data);
	return FALSE;
	_state_2:
	folks_backend_store_disable_backend_finish (data->store, data->_res_);
	data->_state_ = 3;
	folks_backend_store_load_backends (data->store, backend_loading_tests_test_disabling_async_ready, data);
	return FALSE;
	_state_3:
	folks_backend_store_load_backends_finish (data->store, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	{
		data->_tmp1_ = NULL;
		data->_tmp1_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp2_ = NULL;
		data->_tmp2_ = gee_map_get_values (data->_tmp1_);
		data->_tmp3_ = data->_tmp2_;
		data->_tmp4_ = NULL;
		data->_tmp4_ = gee_iterable_iterator ((GeeIterable*) data->_tmp3_);
		data->_tmp5_ = data->_tmp4_;
		_g_object_unref0 (data->_tmp3_);
		data->_backend_it = data->_tmp5_;
		while (TRUE) {
			data->_tmp6_ = gee_iterator_next (data->_backend_it);
			if (!data->_tmp6_) {
				break;
			}
			data->_tmp7_ = NULL;
			data->_tmp7_ = gee_iterator_get (data->_backend_it);
			data->backend = (FolksBackend*) data->_tmp7_;
			data->_tmp8_ = NULL;
			data->_tmp8_ = folks_backend_get_name (data->backend);
			data->_tmp9_ = gee_abstract_collection_contains ((GeeAbstractCollection*) data->backends_expected, data->_tmp8_);
			g_assert (data->_tmp9_);
			data->_tmp10_ = NULL;
			data->_tmp10_ = folks_backend_get_name (data->backend);
			gee_abstract_collection_remove ((GeeAbstractCollection*) data->backends_expected, data->_tmp10_);
			_g_object_unref0 (data->backend);
		}
		_g_object_unref0 (data->_backend_it);
	}
	data->_tmp11_ = gee_collection_get_size ((GeeCollection*) data->backends_expected);
	g_assert (data->_tmp11_ == 0);
	g_main_loop_quit (data->self->priv->main_loop);
	goto __finally2;
	__catch2_g_error:
	{
		data->e = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_error ("backend-loading.vala:141: Failed to load backends: %s", data->e->message);
		_g_error_free0 (data->e);
	}
	__finally2:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->backends_expected);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	_g_object_unref0 (data->backends_expected);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void _lambda3_ (GObject* o, GAsyncResult* r, BackendLoadingTests* self) {
	g_return_if_fail (r != NULL);
	backend_loading_tests_test_reloading_finish (self, r);
}


static void __lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda3_ (source_object, res, self);
	g_object_unref (self);
}


void backend_loading_tests_test_reloading (BackendLoadingTests* self) {
	GMainLoop* _tmp0_ = NULL;
	FolksBackendStore* _tmp1_ = NULL;
	FolksBackendStore* store;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp0_;
	_tmp1_ = folks_backend_store_dup ();
	store = _tmp1_;
	backend_loading_tests_test_reloading_async (self, store, __lambda3__gasync_ready_callback, g_object_ref (self));
	g_main_loop_run (self->priv->main_loop);
	_g_object_unref0 (store);
}


static void backend_loading_tests_test_reloading_async_data_free (gpointer _data) {
	BackendLoadingTestsTestReloadingAsyncData* data;
	data = _data;
	_g_object_unref0 (data->store);
	_g_object_unref0 (data->self);
	g_slice_free (BackendLoadingTestsTestReloadingAsyncData, data);
}


static void backend_loading_tests_test_reloading_async (BackendLoadingTests* self, FolksBackendStore* store, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BackendLoadingTestsTestReloadingAsyncData* _data_;
	_data_ = g_slice_new0 (BackendLoadingTestsTestReloadingAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, backend_loading_tests_test_reloading_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, backend_loading_tests_test_reloading_async_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->store = _g_object_ref0 (store);
	backend_loading_tests_test_reloading_async_co (_data_);
}


static void backend_loading_tests_test_reloading_finish (BackendLoadingTests* self, GAsyncResult* _res_) {
	BackendLoadingTestsTestReloadingAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void backend_loading_tests_test_reloading_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BackendLoadingTestsTestReloadingAsyncData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	backend_loading_tests_test_reloading_async_co (data);
}


static gboolean backend_loading_tests_test_reloading_async_co (BackendLoadingTestsTestReloadingAsyncData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		case 4:
		goto _state_4;
		case 5:
		goto _state_5;
		case 6:
		goto _state_6;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_g_object_unref0 (data->backends_expected);
	data->backends_expected = data->_tmp0_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->backends_expected, "key-file");
	gee_abstract_collection_add ((GeeAbstractCollection*) data->backends_expected, "telepathy");
	data->_state_ = 1;
	folks_backend_store_load_backends (data->store, backend_loading_tests_test_reloading_async_ready, data);
	return FALSE;
	_state_1:
	folks_backend_store_load_backends_finish (data->store, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch3_g_error;
	}
	{
		data->_tmp1_ = NULL;
		data->_tmp1_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp2_ = NULL;
		data->_tmp2_ = gee_map_get_values (data->_tmp1_);
		data->_tmp3_ = data->_tmp2_;
		data->_tmp4_ = NULL;
		data->_tmp4_ = gee_iterable_iterator ((GeeIterable*) data->_tmp3_);
		data->_tmp5_ = data->_tmp4_;
		_g_object_unref0 (data->_tmp3_);
		data->_backend1_it = data->_tmp5_;
		while (TRUE) {
			data->_tmp6_ = gee_iterator_next (data->_backend1_it);
			if (!data->_tmp6_) {
				break;
			}
			data->_tmp7_ = NULL;
			data->_tmp7_ = gee_iterator_get (data->_backend1_it);
			data->backend1 = (FolksBackend*) data->_tmp7_;
			data->_tmp8_ = NULL;
			data->_tmp8_ = folks_backend_get_name (data->backend1);
			data->_tmp9_ = gee_abstract_collection_contains ((GeeAbstractCollection*) data->backends_expected, data->_tmp8_);
			g_assert (data->_tmp9_);
			data->_tmp10_ = NULL;
			data->_tmp10_ = folks_backend_get_name (data->backend1);
			gee_abstract_collection_remove ((GeeAbstractCollection*) data->backends_expected, data->_tmp10_);
			_g_object_unref0 (data->backend1);
		}
		_g_object_unref0 (data->_backend1_it);
	}
	data->_tmp11_ = gee_collection_get_size ((GeeCollection*) data->backends_expected);
	g_assert (data->_tmp11_ == 0);
	goto __finally3;
	__catch3_g_error:
	{
		data->e1 = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_error ("backend-loading.vala:183: Failed to load backends: %s", data->e1->message);
		_g_error_free0 (data->e1);
	}
	__finally3:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->backends_expected);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp12_ = NULL;
	data->_tmp12_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_g_object_unref0 (data->backends_expected);
	data->backends_expected = data->_tmp12_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->backends_expected, "telepathy");
	data->_state_ = 2;
	folks_backend_store_disable_backend (data->store, "key-file", backend_loading_tests_test_reloading_async_ready, data);
	return FALSE;
	_state_2:
	folks_backend_store_disable_backend_finish (data->store, data->_res_);
	data->_state_ = 3;
	folks_backend_store_load_backends (data->store, backend_loading_tests_test_reloading_async_ready, data);
	return FALSE;
	_state_3:
	folks_backend_store_load_backends_finish (data->store, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	{
		data->_tmp13_ = NULL;
		data->_tmp13_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp14_ = NULL;
		data->_tmp14_ = gee_map_get_values (data->_tmp13_);
		data->_tmp15_ = data->_tmp14_;
		data->_tmp16_ = NULL;
		data->_tmp16_ = gee_iterable_iterator ((GeeIterable*) data->_tmp15_);
		data->_tmp17_ = data->_tmp16_;
		_g_object_unref0 (data->_tmp15_);
		data->_backend2_it = data->_tmp17_;
		while (TRUE) {
			data->_tmp18_ = gee_iterator_next (data->_backend2_it);
			if (!data->_tmp18_) {
				break;
			}
			data->_tmp19_ = NULL;
			data->_tmp19_ = gee_iterator_get (data->_backend2_it);
			data->backend2 = (FolksBackend*) data->_tmp19_;
			data->_tmp20_ = NULL;
			data->_tmp20_ = folks_backend_get_name (data->backend2);
			data->_tmp21_ = gee_abstract_collection_contains ((GeeAbstractCollection*) data->backends_expected, data->_tmp20_);
			g_assert (data->_tmp21_);
			data->_tmp22_ = NULL;
			data->_tmp22_ = folks_backend_get_name (data->backend2);
			gee_abstract_collection_remove ((GeeAbstractCollection*) data->backends_expected, data->_tmp22_);
			_g_object_unref0 (data->backend2);
		}
		_g_object_unref0 (data->_backend2_it);
	}
	data->_tmp23_ = gee_collection_get_size ((GeeCollection*) data->backends_expected);
	g_assert (data->_tmp23_ == 0);
	goto __finally4;
	__catch4_g_error:
	{
		data->e2 = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_error ("backend-loading.vala:210: Failed to load backends: %s", data->e2->message);
		_g_error_free0 (data->e2);
	}
	__finally4:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->backends_expected);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp24_ = NULL;
	data->_tmp24_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_g_object_unref0 (data->backends_expected);
	data->backends_expected = data->_tmp24_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->backends_expected, "key-file");
	gee_abstract_collection_add ((GeeAbstractCollection*) data->backends_expected, "telepathy");
	data->_state_ = 4;
	folks_backend_store_enable_backend (data->store, "key-file", backend_loading_tests_test_reloading_async_ready, data);
	return FALSE;
	_state_4:
	folks_backend_store_enable_backend_finish (data->store, data->_res_);
	data->_state_ = 5;
	folks_backend_store_load_backends (data->store, backend_loading_tests_test_reloading_async_ready, data);
	return FALSE;
	_state_5:
	folks_backend_store_load_backends_finish (data->store, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	{
		data->_tmp25_ = NULL;
		data->_tmp25_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp26_ = NULL;
		data->_tmp26_ = gee_map_get_values (data->_tmp25_);
		data->_tmp27_ = data->_tmp26_;
		data->_tmp28_ = NULL;
		data->_tmp28_ = gee_iterable_iterator ((GeeIterable*) data->_tmp27_);
		data->_tmp29_ = data->_tmp28_;
		_g_object_unref0 (data->_tmp27_);
		data->_backend3_it = data->_tmp29_;
		while (TRUE) {
			data->_tmp30_ = gee_iterator_next (data->_backend3_it);
			if (!data->_tmp30_) {
				break;
			}
			data->_tmp31_ = NULL;
			data->_tmp31_ = gee_iterator_get (data->_backend3_it);
			data->backend3 = (FolksBackend*) data->_tmp31_;
			data->_tmp32_ = NULL;
			data->_tmp32_ = folks_backend_get_name (data->backend3);
			data->_tmp33_ = gee_abstract_collection_contains ((GeeAbstractCollection*) data->backends_expected, data->_tmp32_);
			g_assert (data->_tmp33_);
			data->_tmp34_ = NULL;
			data->_tmp34_ = folks_backend_get_name (data->backend3);
			gee_abstract_collection_remove ((GeeAbstractCollection*) data->backends_expected, data->_tmp34_);
			_g_object_unref0 (data->backend3);
		}
		_g_object_unref0 (data->_backend3_it);
	}
	data->_tmp35_ = gee_collection_get_size ((GeeCollection*) data->backends_expected);
	g_assert (data->_tmp35_ == 0);
	goto __finally5;
	__catch5_g_error:
	{
		data->e3 = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_error ("backend-loading.vala:238: Failed to load backends: %s", data->e3->message);
		_g_error_free0 (data->e3);
	}
	__finally5:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->backends_expected);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	data->_tmp36_ = NULL;
	data->_tmp36_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_g_object_unref0 (data->backends_expected);
	data->backends_expected = data->_tmp36_;
	gee_abstract_collection_add ((GeeAbstractCollection*) data->backends_expected, "key-file");
	gee_abstract_collection_add ((GeeAbstractCollection*) data->backends_expected, "telepathy");
	data->_state_ = 6;
	folks_backend_store_load_backends (data->store, backend_loading_tests_test_reloading_async_ready, data);
	return FALSE;
	_state_6:
	folks_backend_store_load_backends_finish (data->store, data->_res_, &data->_inner_error_);
	if (data->_inner_error_ != NULL) {
		goto __catch6_g_error;
	}
	{
		data->_tmp37_ = NULL;
		data->_tmp37_ = folks_backend_store_get_enabled_backends (data->store);
		data->_tmp38_ = NULL;
		data->_tmp38_ = gee_map_get_values (data->_tmp37_);
		data->_tmp39_ = data->_tmp38_;
		data->_tmp40_ = NULL;
		data->_tmp40_ = gee_iterable_iterator ((GeeIterable*) data->_tmp39_);
		data->_tmp41_ = data->_tmp40_;
		_g_object_unref0 (data->_tmp39_);
		data->_backend_it = data->_tmp41_;
		while (TRUE) {
			data->_tmp42_ = gee_iterator_next (data->_backend_it);
			if (!data->_tmp42_) {
				break;
			}
			data->_tmp43_ = NULL;
			data->_tmp43_ = gee_iterator_get (data->_backend_it);
			data->backend = (FolksBackend*) data->_tmp43_;
			data->_tmp44_ = NULL;
			data->_tmp44_ = folks_backend_get_name (data->backend);
			data->_tmp45_ = gee_abstract_collection_contains ((GeeAbstractCollection*) data->backends_expected, data->_tmp44_);
			g_assert (data->_tmp45_);
			data->_tmp46_ = NULL;
			data->_tmp46_ = folks_backend_get_name (data->backend);
			gee_abstract_collection_remove ((GeeAbstractCollection*) data->backends_expected, data->_tmp46_);
			_g_object_unref0 (data->backend);
		}
		_g_object_unref0 (data->_backend_it);
	}
	data->_tmp47_ = gee_collection_get_size ((GeeCollection*) data->backends_expected);
	g_assert (data->_tmp47_ == 0);
	goto __finally6;
	__catch6_g_error:
	{
		data->e4 = data->_inner_error_;
		data->_inner_error_ = NULL;
		g_error ("backend-loading.vala:264: Failed to load backends: %s", data->e4->message);
		_g_error_free0 (data->e4);
	}
	__finally6:
	if (data->_inner_error_ != NULL) {
		_g_object_unref0 (data->backends_expected);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	g_main_loop_quit (data->self->priv->main_loop);
	_g_object_unref0 (data->backends_expected);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void backend_loading_tests_class_init (BackendLoadingTestsClass * klass) {
	backend_loading_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BackendLoadingTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = backend_loading_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = backend_loading_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = backend_loading_tests_finalize;
}


static void backend_loading_tests_instance_init (BackendLoadingTests * self) {
	self->priv = BACKEND_LOADING_TESTS_GET_PRIVATE (self);
}


static void backend_loading_tests_finalize (GObject* obj) {
	BackendLoadingTests * self;
	self = BACKEND_LOADING_TESTS (obj);
	_g_object_unref0 (self->priv->_tp_backend);
	_g_main_loop_unref0 (self->priv->main_loop);
	G_OBJECT_CLASS (backend_loading_tests_parent_class)->finalize (obj);
}


GType backend_loading_tests_get_type (void) {
	static volatile gsize backend_loading_tests_type_id__volatile = 0;
	if (g_once_init_enter (&backend_loading_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BackendLoadingTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backend_loading_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackendLoadingTests), 0, (GInstanceInitFunc) backend_loading_tests_instance_init, NULL };
		GType backend_loading_tests_type_id;
		backend_loading_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "BackendLoadingTests", &g_define_type_info, 0);
		g_once_init_leave (&backend_loading_tests_type_id__volatile, backend_loading_tests_type_id);
	}
	return backend_loading_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	BackendLoadingTests* _tmp1_ = NULL;
	BackendLoadingTests* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = backend_loading_tests_new ();
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_test_case_get_suite ((FolksTestCase*) _tmp2_);
	g_test_suite_add_suite (root, _tmp3_);
	_g_object_unref0 (_tmp2_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



