/* field-details.c generated by valac 0.12.0, the Vala compiler
 * generated from field-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define FOLKS_TYPE_FIELD_DETAILS (folks_field_details_get_type ())
#define FOLKS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetails))
#define FOLKS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetailsClass))
#define FOLKS_IS_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_FIELD_DETAILS))
#define FOLKS_IS_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_FIELD_DETAILS))
#define FOLKS_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetailsClass))

typedef struct _FolksFieldDetails FolksFieldDetails;
typedef struct _FolksFieldDetailsClass FolksFieldDetailsClass;
typedef struct _FolksFieldDetailsPrivate FolksFieldDetailsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _FolksFieldDetails {
	GObject parent_instance;
	FolksFieldDetailsPrivate * priv;
};

struct _FolksFieldDetailsClass {
	GObjectClass parent_class;
};

struct _FolksFieldDetailsPrivate {
	gchar* _value;
	GeeMultiMap* _parameters;
};


static gpointer folks_field_details_parent_class = NULL;

GType folks_field_details_get_type (void) G_GNUC_CONST;
#define FOLKS_FIELD_DETAILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_FIELD_DETAILS, FolksFieldDetailsPrivate))
enum  {
	FOLKS_FIELD_DETAILS_DUMMY_PROPERTY,
	FOLKS_FIELD_DETAILS_VALUE,
	FOLKS_FIELD_DETAILS_PARAMETERS
};
FolksFieldDetails* folks_field_details_new (const gchar* value);
FolksFieldDetails* folks_field_details_construct (GType object_type, const gchar* value);
void folks_field_details_set_value (FolksFieldDetails* self, const gchar* value);
void folks_field_details_set_parameters (FolksFieldDetails* self, GeeMultiMap* value);
GeeCollection* folks_field_details_get_parameter_values (FolksFieldDetails* self, const gchar* parameter_name);
GeeMultiMap* folks_field_details_get_parameters (FolksFieldDetails* self);
void folks_field_details_add_parameter (FolksFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value);
void folks_field_details_set_parameter (FolksFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value);
void folks_field_details_extend_parameters (FolksFieldDetails* self, GeeMultiMap* additional);
void folks_field_details_remove_parameter_all (FolksFieldDetails* self, const gchar* parameter_name);
const gchar* folks_field_details_get_value (FolksFieldDetails* self);
static void folks_field_details_finalize (GObject* obj);
static void _vala_folks_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
   * Create a new FieldDetails.
   *
   * @param value the value of the field
   * @return a new FieldDetails
   *
   * @since 0.3.5
   */
FolksFieldDetails* folks_field_details_construct (GType object_type, const gchar* value) {
	FolksFieldDetails * self = NULL;
	GeeHashMultiMap* _tmp0_ = NULL;
	GeeHashMultiMap* _tmp1_;
	g_return_val_if_fail (value != NULL, NULL);
	self = (FolksFieldDetails*) g_object_new (object_type, NULL);
	folks_field_details_set_value (self, value);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	folks_field_details_set_parameters (self, (GeeMultiMap*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}


FolksFieldDetails* folks_field_details_new (const gchar* value) {
	return folks_field_details_construct (FOLKS_TYPE_FIELD_DETAILS, value);
}


/**
   * Get the values for a parameter
   *
   * @param parameter_name the parameter name
   * @return a collection of values for `parameter_name` or `null` (i.e. no
   * collection) if there are no such parameters.
   *
   * @since 0.5.1
   */
GeeCollection* folks_field_details_get_parameter_values (FolksFieldDetails* self, const gchar* parameter_name) {
	GeeCollection* result = NULL;
	gboolean _tmp0_;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_ = NULL;
	GeeCollection* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parameter_name != NULL, NULL);
	_tmp0_ = gee_multi_map_contains (self->priv->_parameters, parameter_name);
	if (_tmp0_ == FALSE) {
		result = NULL;
		return result;
	}
	_tmp1_ = gee_multi_map_get (self->priv->_parameters, parameter_name);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_collection_get_read_only_view (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	result = _tmp4_;
	return result;
}


/**
   * Add a new value for a parameter.
   *
   * If there is already a parameter called `parameter_name` then
   * `parameter_value` is added to the existing ones.
   *
   * @param parameter_name the name of the parameter
   * @param parameter_value the value to add
   *
   * @since 0.3.5
   */
void folks_field_details_add_parameter (FolksFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	g_return_if_fail (parameter_value != NULL);
	gee_multi_map_set (self->priv->_parameters, parameter_name, parameter_value);
}


/**
   * Set the value of a parameter.
   *
   * Sets the parameter called `parameter_name` to be `parameter_value`.
   * If there were already parameters with the same name they are replaced.
   *
   * @param parameter_name the name of the parameter
   * @param parameter_value the value to add
   *
   * @since 0.3.5
   */
void folks_field_details_set_parameter (FolksFieldDetails* self, const gchar* parameter_name, const gchar* parameter_value) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	g_return_if_fail (parameter_value != NULL);
	gee_multi_map_remove_all (self->priv->_parameters, parameter_name);
	gee_multi_map_set (self->priv->_parameters, parameter_name, parameter_value);
}


/**
   * Extend the existing parameters.
   *
   * Merge the parameters from `additional` into the existing ones.
   *
   * @param additional the parameters to add
   *
   * @since 0.5.1
   */
void folks_field_details_extend_parameters (FolksFieldDetails* self, GeeMultiMap* additional) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (additional != NULL);
	{
		GeeSet* _tmp0_ = NULL;
		GeeSet* _tmp1_;
		GeeIterator* _tmp2_ = NULL;
		GeeIterator* _tmp3_;
		GeeIterator* _name_it;
		_tmp0_ = gee_multi_map_get_keys (additional);
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_name_it = _tmp3_;
		while (TRUE) {
			gboolean _tmp4_;
			gpointer _tmp5_ = NULL;
			gchar* name;
			GeeCollection* _tmp6_ = NULL;
			GeeCollection* values;
			_tmp4_ = gee_iterator_next (_name_it);
			if (!_tmp4_) {
				break;
			}
			_tmp5_ = gee_iterator_get (_name_it);
			name = (gchar*) _tmp5_;
			_tmp6_ = gee_multi_map_get (additional, name);
			values = _tmp6_;
			{
				GeeIterator* _tmp7_ = NULL;
				GeeIterator* _val_it;
				_tmp7_ = gee_iterable_iterator ((GeeIterable*) values);
				_val_it = _tmp7_;
				while (TRUE) {
					gboolean _tmp8_;
					gpointer _tmp9_ = NULL;
					gchar* val;
					_tmp8_ = gee_iterator_next (_val_it);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = gee_iterator_get (_val_it);
					val = (gchar*) _tmp9_;
					folks_field_details_add_parameter (self, name, val);
					_g_free0 (val);
				}
				_g_object_unref0 (_val_it);
			}
			_g_object_unref0 (values);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_it);
	}
}


/**
   * Remove all instances of a parameter.
   *
   * @param parameter_name the name of the parameter
   *
   * @since 0.3.5
   */
void folks_field_details_remove_parameter_all (FolksFieldDetails* self, const gchar* parameter_name) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (parameter_name != NULL);
	gee_multi_map_remove_all (self->priv->_parameters, parameter_name);
}


const gchar* folks_field_details_get_value (FolksFieldDetails* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_value;
	return result;
}


void folks_field_details_set_value (FolksFieldDetails* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_value);
	self->priv->_value = _tmp0_;
	g_object_notify ((GObject *) self, "value");
}


GeeMultiMap* folks_field_details_get_parameters (FolksFieldDetails* self) {
	GeeMultiMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_parameters;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void folks_field_details_set_parameters (FolksFieldDetails* self, GeeMultiMap* value) {
	GeeMultiMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_parameters);
	self->priv->_parameters = _tmp0_;
	g_object_notify ((GObject *) self, "parameters");
}


static void folks_field_details_class_init (FolksFieldDetailsClass * klass) {
	folks_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksFieldDetailsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_field_details_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_field_details_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_FIELD_DETAILS_VALUE, g_param_spec_string ("value", "value", "value", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * The parameters associated with the value.
	   *
	   * A hash table of the parameters associated with
	   * {@link Folks.FieldDetails.value}. The keys are the names of the
	   * parameters, while the values are a list of strings.
	   *
	   * @since 0.5.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_FIELD_DETAILS_PARAMETERS, g_param_spec_object ("parameters", "parameters", "parameters", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void folks_field_details_instance_init (FolksFieldDetails * self) {
	self->priv = FOLKS_FIELD_DETAILS_GET_PRIVATE (self);
}


static void folks_field_details_finalize (GObject* obj) {
	FolksFieldDetails * self;
	self = FOLKS_FIELD_DETAILS (obj);
	_g_free0 (self->priv->_value);
	_g_object_unref0 (self->priv->_parameters);
	G_OBJECT_CLASS (folks_field_details_parent_class)->finalize (obj);
}


/**
 * Object representing a string value that can have some parameters
 * associated with it.
 *
 * Some contact details, like phone numbers or URLs, can have some
 * extra details associated with them.
 * For instance, a phone number expressed in vcard notation as
 * `tel;type=work,voice:(111) 555-1234` would be represented as
 * a FieldDetails with value "(111) 555-1234" and with parameters
 * `['type': ('work', 'voice')]`.
 *
 * @since 0.3.5
 */
GType folks_field_details_get_type (void) {
	static volatile gsize folks_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksFieldDetails), 0, (GInstanceInitFunc) folks_field_details_instance_init, NULL };
		GType folks_field_details_type_id;
		folks_field_details_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksFieldDetails", &g_define_type_info, 0);
		g_once_init_leave (&folks_field_details_type_id__volatile, folks_field_details_type_id);
	}
	return folks_field_details_type_id__volatile;
}


static void _vala_folks_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksFieldDetails * self;
	self = FOLKS_FIELD_DETAILS (object);
	switch (property_id) {
		case FOLKS_FIELD_DETAILS_VALUE:
		g_value_set_string (value, folks_field_details_get_value (self));
		break;
		case FOLKS_FIELD_DETAILS_PARAMETERS:
		g_value_set_object (value, folks_field_details_get_parameters (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksFieldDetails * self;
	self = FOLKS_FIELD_DETAILS (object);
	switch (property_id) {
		case FOLKS_FIELD_DETAILS_VALUE:
		folks_field_details_set_value (self, g_value_get_string (value));
		break;
		case FOLKS_FIELD_DETAILS_PARAMETERS:
		folks_field_details_set_parameters (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



