/* tpf-logger.c generated by valac 0.11.6, the Vala compiler
 * generated from tpf-logger.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <gio/gio.h>
#include <dbus/dbus.h>


#define TYPE_ACCOUNT_FAVOURITES (account_favourites_get_type ())
typedef struct _AccountFavourites AccountFavourites;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_LOGGER_IFACE (logger_iface_get_type ())
#define LOGGER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER_IFACE, LoggerIface))
#define IS_LOGGER_IFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER_IFACE))
#define LOGGER_IFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_LOGGER_IFACE, LoggerIfaceIface))

typedef struct _LoggerIface LoggerIface;
typedef struct _LoggerIfaceIface LoggerIfaceIface;
typedef struct _DBusObjectVTable _DBusObjectVTable;
typedef struct _LoggerIfaceDBusProxy LoggerIfaceDBusProxy;
typedef DBusGProxyClass LoggerIfaceDBusProxyClass;
typedef struct _LoggerIfaceDBusProxyGetFavouriteContactsData LoggerIfaceDBusProxyGetFavouriteContactsData;
typedef struct _LoggerIfaceDBusProxyAddFavouriteContactData LoggerIfaceDBusProxyAddFavouriteContactData;
typedef struct _LoggerIfaceDBusProxyRemoveFavouriteContactData LoggerIfaceDBusProxyRemoveFavouriteContactData;

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;
typedef struct _LoggerPrivate LoggerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
typedef struct _LoggerGetFavouriteContactsData LoggerGetFavouriteContactsData;
typedef struct _LoggerAddFavouriteContactData LoggerAddFavouriteContactData;
typedef struct _LoggerRemoveFavouriteContactData LoggerRemoveFavouriteContactData;

struct _AccountFavourites {
	char* account_path;
	gchar** ids;
	gint ids_length1;
	gint _ids_size_;
};

struct _LoggerIfaceIface {
	GTypeInterface parent_iface;
	void (*get_favourite_contacts) (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	AccountFavourites* (*get_favourite_contacts_finish) (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
	void (*add_favourite_contact) (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_favourite_contact_finish) (LoggerIface* self, GAsyncResult* _res_, GError** error);
	void (*remove_favourite_contact) (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_favourite_contact_finish) (LoggerIface* self, GAsyncResult* _res_, GError** error);
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};

struct _LoggerIfaceDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _LoggerIfaceDBusProxyGetFavouriteContactsData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _LoggerIfaceDBusProxyAddFavouriteContactData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _LoggerIfaceDBusProxyRemoveFavouriteContactData {
	GAsyncReadyCallback _callback_;
	gpointer _user_data_;
	DBusPendingCall* pending;
};

struct _Logger {
	GObject parent_instance;
	LoggerPrivate * priv;
};

struct _LoggerClass {
	GObjectClass parent_class;
};

struct _LoggerPrivate {
	gchar* _account_path;
};

struct _LoggerGetFavouriteContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Logger* self;
	gchar** result;
	gint result_length1;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint _tmp2_;
	AccountFavourites* _tmp3_;
	AccountFavourites* favs;
	gint favs_length1;
	gint _favs_size_;
	AccountFavourites* account_collection;
	int account_collection_length1;
	int account_it;
	AccountFavourites _tmp4_;
	AccountFavourites _tmp5_;
	AccountFavourites account;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	GError * _inner_error_;
};

struct _LoggerAddFavouriteContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Logger* self;
	gchar* id;
	char* _tmp0_;
	char* _tmp1_;
	GError * _inner_error_;
};

struct _LoggerRemoveFavouriteContactData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Logger* self;
	gchar* id;
	char* _tmp0_;
	char* _tmp1_;
	GError * _inner_error_;
};


static gpointer logger_parent_class = NULL;
static LoggerIface* logger__logger;
static LoggerIface* logger__logger = NULL;

GType account_favourites_get_type (void) G_GNUC_CONST;
AccountFavourites* account_favourites_dup (const AccountFavourites* self);
void account_favourites_free (AccountFavourites* self);
void account_favourites_copy (const AccountFavourites* self, AccountFavourites* dest);
void account_favourites_destroy (AccountFavourites* self);
static gchar** _vala_array_dup2 (gchar** self, int length);
LoggerIface* logger_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
GType logger_iface_get_type (void) G_GNUC_CONST;
void logger_iface_get_favourite_contacts (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
AccountFavourites* logger_iface_get_favourite_contacts_finish (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
void logger_iface_add_favourite_contact (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_iface_add_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error);
void logger_iface_remove_favourite_contact (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_iface_remove_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error);
static void g_cclosure_user_marshal_VOID__BOXED_BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);
void logger_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _logger_iface_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult logger_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_logger_iface_introspect (LoggerIface* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_logger_iface_property_get_all (LoggerIface* self, DBusConnection* connection, DBusMessage* message);
static void _vala_AccountFavourites_array_free (AccountFavourites* array, gint array_length);
static DBusHandlerResult _dbus_logger_iface_get_favourite_contacts (LoggerIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_logger_iface_get_favourite_contacts_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_logger_iface_add_favourite_contact (LoggerIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_logger_iface_add_favourite_contact_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static DBusHandlerResult _dbus_logger_iface_remove_favourite_contact (LoggerIface* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_logger_iface_remove_favourite_contact_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_);
static void _dbus_logger_iface_favourite_contacts_changed (GObject* _sender, const char* account_path, gchar** added, int added_length1, gchar** removed, int removed_length1, DBusConnection* _connection);
GType logger_iface_dbus_proxy_get_type (void) G_GNUC_CONST;
static void _dbus_handle_logger_iface_favourite_contacts_changed (LoggerIface* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult logger_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	LOGGER_IFACE_DBUS_PROXY_DUMMY_PROPERTY
};
static void logger_iface_dbus_proxy_get_favourite_contacts_async (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void logger_iface_dbus_proxy_get_favourite_contacts_ready (DBusPendingCall* pending, void* user_data);
static AccountFavourites* logger_iface_dbus_proxy_get_favourite_contacts_finish (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void logger_iface_dbus_proxy_add_favourite_contact_async (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void logger_iface_dbus_proxy_add_favourite_contact_ready (DBusPendingCall* pending, void* user_data);
static void logger_iface_dbus_proxy_add_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error);
static void logger_iface_dbus_proxy_remove_favourite_contact_async (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void logger_iface_dbus_proxy_remove_favourite_contact_ready (DBusPendingCall* pending, void* user_data);
static void logger_iface_dbus_proxy_remove_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error);
static void logger_iface_dbus_proxy_logger_iface__interface_init (LoggerIfaceIface* iface);
static void _vala_logger_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_logger_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType logger_get_type (void) G_GNUC_CONST;
#define LOGGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_LOGGER, LoggerPrivate))
enum  {
	LOGGER_DUMMY_PROPERTY
};
Logger* logger_new (const gchar* account_path, GError** error);
Logger* logger_construct (GType object_type, const gchar* account_path, GError** error);
static void _lambda0_ (Logger* self);
static void __lambda0__dbus_g_proxy_destroy (DBusGProxy* _sender, gpointer self);
static void _lambda1_ (const char* ap, gchar** a, int a_length1, gchar** r, int r_length1, Logger* self);
static void __lambda1__logger_iface_favourite_contacts_changed (LoggerIface* _sender, const char* account_path, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self);
static void logger_get_favourite_contacts_data_free (gpointer _data);
void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean logger_get_favourite_contacts_co (LoggerGetFavouriteContactsData* data);
static void logger_get_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar** _vala_array_dup3 (gchar** self, int length);
static void logger_add_favourite_contact_data_free (gpointer _data);
void logger_add_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static gboolean logger_add_favourite_contact_co (LoggerAddFavouriteContactData* data);
static void logger_add_favourite_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void logger_remove_favourite_contact_data_free (gpointer _data);
void logger_remove_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static gboolean logger_remove_favourite_contact_co (LoggerRemoveFavouriteContactData* data);
static void logger_remove_favourite_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void g_cclosure_user_marshal_VOID__BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void logger_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const DBusObjectPathVTable _logger_iface_dbus_path_vtable = {_logger_iface_dbus_unregister, logger_iface_dbus_message};
static const _DBusObjectVTable _logger_iface_dbus_vtable = {logger_iface_dbus_register_object};

static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void account_favourites_copy (const AccountFavourites* self, AccountFavourites* dest) {
	gchar** _tmp0_;
	dest->account_path = g_strdup (self->account_path);
	dest->ids = (_tmp0_ = self->ids, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup2 (_tmp0_, (*self).ids_length1));
	dest->ids_length1 = self->ids_length1;
}


void account_favourites_destroy (AccountFavourites* self) {
	_g_free0 (self->account_path);
	self->ids = (_vala_array_free (self->ids, (*self).ids_length1, (GDestroyNotify) g_free), NULL);
}


AccountFavourites* account_favourites_dup (const AccountFavourites* self) {
	AccountFavourites* dup;
	dup = g_new0 (AccountFavourites, 1);
	account_favourites_copy (self, dup);
	return dup;
}


void account_favourites_free (AccountFavourites* self) {
	account_favourites_destroy (self);
	g_free (self);
}


GType account_favourites_get_type (void) {
	static volatile gsize account_favourites_type_id__volatile = 0;
	if (g_once_init_enter (&account_favourites_type_id__volatile)) {
		GType account_favourites_type_id;
		account_favourites_type_id = g_boxed_type_register_static ("AccountFavourites", (GBoxedCopyFunc) account_favourites_dup, (GBoxedFreeFunc) account_favourites_free);
		g_once_init_leave (&account_favourites_type_id__volatile, account_favourites_type_id);
	}
	return account_favourites_type_id__volatile;
}


void logger_iface_get_favourite_contacts (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LOGGER_IFACE_GET_INTERFACE (self)->get_favourite_contacts (self, _callback_, _user_data_);
}


AccountFavourites* logger_iface_get_favourite_contacts_finish (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	return LOGGER_IFACE_GET_INTERFACE (self)->get_favourite_contacts_finish (self, _res_, result_length1, error);
}


void logger_iface_add_favourite_contact (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LOGGER_IFACE_GET_INTERFACE (self)->add_favourite_contact (self, account_path, id, _callback_, _user_data_);
}


void logger_iface_add_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error) {
	LOGGER_IFACE_GET_INTERFACE (self)->add_favourite_contact_finish (self, _res_, error);
}


void logger_iface_remove_favourite_contact (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LOGGER_IFACE_GET_INTERFACE (self)->remove_favourite_contact (self, account_path, id, _callback_, _user_data_);
}


void logger_iface_remove_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error) {
	LOGGER_IFACE_GET_INTERFACE (self)->remove_favourite_contact_finish (self, _res_, error);
}


static void g_cclosure_user_marshal_VOID__BOXED_BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_BOXED_INT_BOXED_INT) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer arg_4, gint arg_5, gpointer data2);
	register GMarshalFunc_VOID__BOXED_BOXED_INT_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_BOXED_INT_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_int (param_values + 3), g_value_get_boxed (param_values + 4), g_value_get_int (param_values + 5), data2);
}


static void logger_iface_base_init (LoggerIfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("favourite_contacts_changed", TYPE_LOGGER_IFACE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_BOXED_INT_BOXED_INT, G_TYPE_NONE, 5, DBUS_TYPE_G_OBJECT_PATH, G_TYPE_STRV, G_TYPE_INT, G_TYPE_STRV, G_TYPE_INT);
	}
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}


void _logger_iface_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_logger_iface_introspect (LoggerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Telepathy.Logger.DRAFT\">\n  <method name=\"GetFavouriteContacts\">\n    <arg name=\"result\" type=\"a(oas)\" direction=\"out\"/>\n  </method>\n  <method name=\"AddFavouriteContact\">\n    <arg name=\"account_path\" type=\"o\" direction=\"in\"/>\n    <arg name=\"id\" type=\"s\" direction=\"in\"/>\n  </method>\n  <method name=\"RemoveFavouriteContact\">\n    <arg name=\"account_path\" type=\"o\" direction=\"in\"/>\n    <arg name=\"id\" type=\"s\" direction=\"in\"/>\n  </method>\n  <signal name=\"FavouriteContactsChanged\">\n    <arg name=\"account_path\" type=\"o\"/>\n    <arg name=\"added\" type=\"as\"/>\n    <arg name=\"removed\" type=\"as\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_logger_iface_property_get_all (LoggerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Telepathy.Logger.DRAFT") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _vala_AccountFavourites_array_free (AccountFavourites* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			account_favourites_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DBusHandlerResult _dbus_logger_iface_get_favourite_contacts (LoggerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	logger_iface_get_favourite_contacts (self, (GAsyncReadyCallback) _dbus_logger_iface_get_favourite_contacts_ready, _user_data_);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_logger_iface_get_favourite_contacts_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	AccountFavourites* result;
	int result_length1;
	DBusMessage* reply;
	AccountFavourites* _tmp1_;
	DBusMessageIter _tmp2_;
	int _tmp3_;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	result_length1 = 0;
	result = logger_iface_get_favourite_contacts_finish ((LoggerIface*) source_object, _res_, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "(oas)", &_tmp2_);
	for (_tmp3_ = 0; _tmp3_ < result_length1; _tmp3_++) {
		DBusMessageIter _tmp4_;
		const char* _tmp5_;
		gchar** _tmp6_;
		DBusMessageIter _tmp7_;
		int _tmp8_;
		dbus_message_iter_open_container (&_tmp2_, DBUS_TYPE_STRUCT, NULL, &_tmp4_);
		_tmp5_ = (*_tmp1_).account_path;
		dbus_message_iter_append_basic (&_tmp4_, DBUS_TYPE_OBJECT_PATH, &_tmp5_);
		_tmp6_ = (*_tmp1_).ids;
		dbus_message_iter_open_container (&_tmp4_, DBUS_TYPE_ARRAY, "s", &_tmp7_);
		for (_tmp8_ = 0; _tmp8_ < (*_tmp1_).ids_length1; _tmp8_++) {
			const char* _tmp9_;
			_tmp9_ = *_tmp6_;
			dbus_message_iter_append_basic (&_tmp7_, DBUS_TYPE_STRING, &_tmp9_);
			_tmp6_++;
		}
		dbus_message_iter_close_container (&_tmp4_, &_tmp7_);
		dbus_message_iter_close_container (&_tmp2_, &_tmp4_);
		_tmp1_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp2_);
	 result = (_vala_AccountFavourites_array_free ( result,  result_length1), NULL);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_logger_iface_add_favourite_contact (LoggerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* account_path = NULL;
	const char* _tmp10_;
	gchar* id = NULL;
	const char* _tmp11_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "os")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp10_);
	dbus_message_iter_next (&iter);
	account_path = g_strdup (_tmp10_);
	dbus_message_iter_get_basic (&iter, &_tmp11_);
	dbus_message_iter_next (&iter);
	id = g_strdup (_tmp11_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	logger_iface_add_favourite_contact (self, account_path, id, (GAsyncReadyCallback) _dbus_logger_iface_add_favourite_contact_ready, _user_data_);
	_g_free0 (account_path);
	_g_free0 (id);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_logger_iface_add_favourite_contact_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	logger_iface_add_favourite_contact_finish ((LoggerIface*) source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


static DBusHandlerResult _dbus_logger_iface_remove_favourite_contact (LoggerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* account_path = NULL;
	const char* _tmp12_;
	gchar* id = NULL;
	const char* _tmp13_;
	gpointer * _user_data_;
	if (strcmp (dbus_message_get_signature (message), "os")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp12_);
	dbus_message_iter_next (&iter);
	account_path = g_strdup (_tmp12_);
	dbus_message_iter_get_basic (&iter, &_tmp13_);
	dbus_message_iter_next (&iter);
	id = g_strdup (_tmp13_);
	_user_data_ = g_new0 (gpointer, 2);
	_user_data_[0] = dbus_connection_ref (connection);
	_user_data_[1] = dbus_message_ref (message);
	logger_iface_remove_favourite_contact (self, account_path, id, (GAsyncReadyCallback) _dbus_logger_iface_remove_favourite_contact_ready, _user_data_);
	_g_free0 (account_path);
	_g_free0 (id);
	return DBUS_HANDLER_RESULT_HANDLED;
}


static void _dbus_logger_iface_remove_favourite_contact_ready (GObject * source_object, GAsyncResult * _res_, gpointer * _user_data_) {
	DBusConnection * connection;
	DBusMessage * message;
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	connection = _user_data_[0];
	message = _user_data_[1];
	error = NULL;
	logger_iface_remove_favourite_contact_finish ((LoggerIface*) source_object, _res_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	dbus_connection_send (connection, reply, NULL);
	dbus_message_unref (reply);
	dbus_connection_unref (connection);
	dbus_message_unref (message);
	g_free (_user_data_);
}


DBusHandlerResult logger_iface_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_logger_iface_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_logger_iface_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Telepathy.Logger.DRAFT", "GetFavouriteContacts")) {
		result = _dbus_logger_iface_get_favourite_contacts (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Telepathy.Logger.DRAFT", "AddFavouriteContact")) {
		result = _dbus_logger_iface_add_favourite_contact (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Telepathy.Logger.DRAFT", "RemoveFavouriteContact")) {
		result = _dbus_logger_iface_remove_favourite_contact (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_logger_iface_favourite_contacts_changed (GObject* _sender, const char* account_path, gchar** added, int added_length1, gchar** removed, int removed_length1, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp14_;
	gchar** _tmp15_;
	DBusMessageIter _tmp16_;
	int _tmp17_;
	gchar** _tmp19_;
	DBusMessageIter _tmp20_;
	int _tmp21_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.Telepathy.Logger.DRAFT", "FavouriteContactsChanged");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp14_ = account_path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp14_);
	_tmp15_ = added;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp16_);
	for (_tmp17_ = 0; _tmp17_ < added_length1; _tmp17_++) {
		const char* _tmp18_;
		_tmp18_ = *_tmp15_;
		dbus_message_iter_append_basic (&_tmp16_, DBUS_TYPE_STRING, &_tmp18_);
		_tmp15_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp16_);
	_tmp19_ = removed;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp20_);
	for (_tmp21_ = 0; _tmp21_ < removed_length1; _tmp21_++) {
		const char* _tmp22_;
		_tmp22_ = *_tmp19_;
		dbus_message_iter_append_basic (&_tmp20_, DBUS_TYPE_STRING, &_tmp22_);
		_tmp19_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp20_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void logger_iface_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_logger_iface_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "favourite-contacts-changed", (GCallback) _dbus_logger_iface_favourite_contacts_changed, connection);
}


GType logger_iface_get_type (void) {
	static volatile gsize logger_iface_type_id__volatile = 0;
	if (g_once_init_enter (&logger_iface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LoggerIfaceIface), (GBaseInitFunc) logger_iface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType logger_iface_type_id;
		logger_iface_type_id = g_type_register_static (G_TYPE_INTERFACE, "LoggerIface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (logger_iface_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (logger_iface_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &logger_iface_dbus_proxy_get_type);
		g_type_set_qdata (logger_iface_type_id, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_logger_iface_dbus_vtable));
		g_once_init_leave (&logger_iface_type_id__volatile, logger_iface_type_id);
	}
	return logger_iface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (LoggerIfaceDBusProxy, logger_iface_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_LOGGER_IFACE, logger_iface_dbus_proxy_logger_iface__interface_init) );
LoggerIface* logger_iface_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	LoggerIface* self;
	self = g_object_new (logger_iface_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Telepathy.Logger.DRAFT", NULL);
	return self;
}


static GObject* logger_iface_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (logger_iface_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), logger_iface_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s',interface='org.freedesktop.Telepathy.Logger.DRAFT'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_logger_iface_favourite_contacts_changed (LoggerIface* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* account_path = NULL;
	const char* _tmp0_;
	gchar** added = NULL;
	int added_length1;
	gchar** _tmp1_;
	int _tmp1__length;
	int _tmp1__size;
	int _tmp1__length1;
	DBusMessageIter _tmp2_;
	gchar** removed = NULL;
	int removed_length1;
	gchar** _tmp4_;
	int _tmp4__length;
	int _tmp4__size;
	int _tmp4__length1;
	DBusMessageIter _tmp5_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "oasas")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	account_path = g_strdup (_tmp0_);
	added_length1 = 0;
	_tmp1_ = g_new (gchar*, 5);
	_tmp1__length = 0;
	_tmp1__size = 4;
	_tmp1__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp2_);
	for (; dbus_message_iter_get_arg_type (&_tmp2_); _tmp1__length1++) {
		const char* _tmp3_;
		if (_tmp1__size == _tmp1__length) {
			_tmp1__size = 2 * _tmp1__size;
			_tmp1_ = g_renew (gchar*, _tmp1_, _tmp1__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp2_, &_tmp3_);
		dbus_message_iter_next (&_tmp2_);
		_tmp1_[_tmp1__length++] = g_strdup (_tmp3_);
	}
	added_length1 = _tmp1__length1;
	_tmp1_[_tmp1__length] = NULL;
	dbus_message_iter_next (&iter);
	added = _tmp1_;
	removed_length1 = 0;
	_tmp4_ = g_new (gchar*, 5);
	_tmp4__length = 0;
	_tmp4__size = 4;
	_tmp4__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp5_);
	for (; dbus_message_iter_get_arg_type (&_tmp5_); _tmp4__length1++) {
		const char* _tmp6_;
		if (_tmp4__size == _tmp4__length) {
			_tmp4__size = 2 * _tmp4__size;
			_tmp4_ = g_renew (gchar*, _tmp4_, _tmp4__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp5_, &_tmp6_);
		dbus_message_iter_next (&_tmp5_);
		_tmp4_[_tmp4__length++] = g_strdup (_tmp6_);
	}
	removed_length1 = _tmp4__length1;
	_tmp4_[_tmp4__length] = NULL;
	dbus_message_iter_next (&iter);
	removed = _tmp4_;
	g_signal_emit_by_name (self, "favourite-contacts-changed", account_path, added, added_length1, removed, removed_length1);
	_g_free0 (account_path);
	added = (_vala_array_free (added, added_length1, (GDestroyNotify) g_free), NULL);
	removed = (_vala_array_free (removed, removed_length1, (GDestroyNotify) g_free), NULL);
}


DBusHandlerResult logger_iface_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.Telepathy.Logger.DRAFT", "FavouriteContactsChanged")) {
			_dbus_handle_logger_iface_favourite_contacts_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void logger_iface_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((LoggerIfaceDBusProxy*) self)->disposed) {
		return;
	}
	((LoggerIfaceDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), logger_iface_dbus_proxy_filter, self);
	G_OBJECT_CLASS (logger_iface_dbus_proxy_parent_class)->dispose (self);
}


static void logger_iface_dbus_proxy_class_init (LoggerIfaceDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = logger_iface_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = logger_iface_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_logger_iface_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_logger_iface_dbus_proxy_set_property;
}


static void logger_iface_dbus_proxy_init (LoggerIfaceDBusProxy* self) {
}


static void logger_iface_dbus_proxy_get_favourite_contacts_async (LoggerIface* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	LoggerIfaceDBusProxyGetFavouriteContactsData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Telepathy.Logger.DRAFT", "GetFavouriteContacts");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (LoggerIfaceDBusProxyGetFavouriteContactsData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, logger_iface_dbus_proxy_get_favourite_contacts_ready, _data_, NULL);
}


static void logger_iface_dbus_proxy_get_favourite_contacts_ready (DBusPendingCall* pending, void* user_data) {
	LoggerIfaceDBusProxyGetFavouriteContactsData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (LoggerIfaceDBusProxyGetFavouriteContactsData, _data_);
	dbus_pending_call_unref (pending);
}


static AccountFavourites* logger_iface_dbus_proxy_get_favourite_contacts_finish (LoggerIface* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	LoggerIfaceDBusProxyGetFavouriteContactsData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	AccountFavourites* _result;
	int _result_length1;
	AccountFavourites* _tmp16_;
	int _tmp16__length;
	int _tmp16__size;
	int _tmp16__length1;
	DBusMessageIter _tmp17_;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp15_;
			_edomain = DBUS_GERROR;
			_tmp15_ = _dbus_error.name + 27;
			if (strcmp (_tmp15_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp15_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp15_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp15_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp15_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp15_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp15_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp15_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp15_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp15_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp15_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp15_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp15_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp15_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp15_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp15_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp15_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp15_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp15_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp15_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp15_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp15_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp15_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp15_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp15_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp15_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp15_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp15_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp15_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp15_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp15_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp15_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp15_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "a(oas)")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "a(oas)", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp16_ = g_new (AccountFavourites, 5);
	_tmp16__length = 0;
	_tmp16__size = 4;
	_tmp16__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp17_);
	for (; dbus_message_iter_get_arg_type (&_tmp17_); _tmp16__length1++) {
		AccountFavourites _tmp18_;
		DBusMessageIter _tmp19_;
		const char* _tmp20_;
		gchar** _tmp21_;
		int _tmp21__length;
		int _tmp21__size;
		int _tmp21__length1;
		DBusMessageIter _tmp22_;
		if (_tmp16__size == _tmp16__length) {
			_tmp16__size = 2 * _tmp16__size;
			_tmp16_ = g_renew (AccountFavourites, _tmp16_, _tmp16__size + 1);
		}
		dbus_message_iter_recurse (&_tmp17_, &_tmp19_);
		dbus_message_iter_get_basic (&_tmp19_, &_tmp20_);
		dbus_message_iter_next (&_tmp19_);
		_tmp18_.account_path = g_strdup (_tmp20_);
		_tmp21_ = g_new (gchar*, 5);
		_tmp21__length = 0;
		_tmp21__size = 4;
		_tmp21__length1 = 0;
		dbus_message_iter_recurse (&_tmp19_, &_tmp22_);
		for (; dbus_message_iter_get_arg_type (&_tmp22_); _tmp21__length1++) {
			const char* _tmp23_;
			if (_tmp21__size == _tmp21__length) {
				_tmp21__size = 2 * _tmp21__size;
				_tmp21_ = g_renew (gchar*, _tmp21_, _tmp21__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp22_, &_tmp23_);
			dbus_message_iter_next (&_tmp22_);
			_tmp21_[_tmp21__length++] = g_strdup (_tmp23_);
		}
		_tmp18_.ids_length1 = _tmp21__length1;
		_tmp21_[_tmp21__length] = NULL;
		dbus_message_iter_next (&_tmp19_);
		_tmp18_.ids = _tmp21_;
		dbus_message_iter_next (&_tmp17_);
		_tmp16_[_tmp16__length++] = _tmp18_;
	}
	_result_length1 = _tmp16__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp16_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void logger_iface_dbus_proxy_add_favourite_contact_async (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp24_;
	const char* _tmp25_;
	LoggerIfaceDBusProxyAddFavouriteContactData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Telepathy.Logger.DRAFT", "AddFavouriteContact");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp24_ = account_path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp24_);
	_tmp25_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp25_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (LoggerIfaceDBusProxyAddFavouriteContactData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, logger_iface_dbus_proxy_add_favourite_contact_ready, _data_, NULL);
}


static void logger_iface_dbus_proxy_add_favourite_contact_ready (DBusPendingCall* pending, void* user_data) {
	LoggerIfaceDBusProxyAddFavouriteContactData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (LoggerIfaceDBusProxyAddFavouriteContactData, _data_);
	dbus_pending_call_unref (pending);
}


static void logger_iface_dbus_proxy_add_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error) {
	LoggerIfaceDBusProxyAddFavouriteContactData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp26_;
			_edomain = DBUS_GERROR;
			_tmp26_ = _dbus_error.name + 27;
			if (strcmp (_tmp26_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp26_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp26_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp26_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp26_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp26_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp26_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp26_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp26_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp26_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp26_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp26_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp26_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp26_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp26_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp26_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp26_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp26_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp26_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp26_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp26_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp26_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp26_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp26_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp26_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp26_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp26_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp26_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp26_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp26_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp26_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp26_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp26_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void logger_iface_dbus_proxy_remove_favourite_contact_async (LoggerIface* self, const char* account_path, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DBusGConnection *_connection;
	DBusMessage *_message;
	DBusPendingCall *_pending;
	DBusMessageIter _iter;
	const char* _tmp29_;
	const char* _tmp30_;
	LoggerIfaceDBusProxyRemoveFavouriteContactData* _data_;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Telepathy.Logger.DRAFT", "RemoveFavouriteContact");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp29_ = account_path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp29_);
	_tmp30_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp30_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_connection_send_with_reply (dbus_g_connection_get_connection (_connection), _message, &_pending, -1);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	_data_ = g_slice_new0 (LoggerIfaceDBusProxyRemoveFavouriteContactData);
	_data_->_callback_ = _callback_;
	_data_->_user_data_ = _user_data_;
	_data_->pending = _pending;
	dbus_pending_call_set_notify (_pending, logger_iface_dbus_proxy_remove_favourite_contact_ready, _data_, NULL);
}


static void logger_iface_dbus_proxy_remove_favourite_contact_ready (DBusPendingCall* pending, void* user_data) {
	LoggerIfaceDBusProxyRemoveFavouriteContactData* _data_;
	GObject * _obj_;
	GSimpleAsyncResult * _res_;
	_data_ = user_data;
	_obj_ = g_object_newv (G_TYPE_OBJECT, 0, NULL);
	_res_ = g_simple_async_result_new (_obj_, _data_->_callback_, _data_->_user_data_, _data_);
	g_simple_async_result_complete (_res_);
	g_object_unref (_obj_);
	g_object_unref (_res_);
	g_slice_free (LoggerIfaceDBusProxyRemoveFavouriteContactData, _data_);
	dbus_pending_call_unref (pending);
}


static void logger_iface_dbus_proxy_remove_favourite_contact_finish (LoggerIface* self, GAsyncResult* _res_, GError** error) {
	LoggerIfaceDBusProxyRemoveFavouriteContactData* _data_;
	DBusError _dbus_error;
	DBusMessage *_reply;
	DBusMessageIter _iter;
	_data_ = g_simple_async_result_get_source_tag ((GSimpleAsyncResult *) _res_);
	dbus_error_init (&_dbus_error);
	_reply = dbus_pending_call_steal_reply (_data_->pending);
	dbus_set_error_from_message (&_dbus_error, _reply);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain = 0;
		gint _ecode = 0;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp31_;
			_edomain = DBUS_GERROR;
			_tmp31_ = _dbus_error.name + 27;
			if (strcmp (_tmp31_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp31_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp31_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp31_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp31_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp31_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp31_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp31_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp31_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp31_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp31_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp31_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp31_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp31_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp31_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp31_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp31_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp31_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp31_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp31_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp31_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp31_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp31_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp31_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp31_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp31_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp31_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp31_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp31_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp31_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp31_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp31_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp31_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void logger_iface_dbus_proxy_logger_iface__interface_init (LoggerIfaceIface* iface) {
	iface->get_favourite_contacts = logger_iface_dbus_proxy_get_favourite_contacts_async;
	iface->get_favourite_contacts_finish = logger_iface_dbus_proxy_get_favourite_contacts_finish;
	iface->add_favourite_contact = logger_iface_dbus_proxy_add_favourite_contact_async;
	iface->add_favourite_contact_finish = logger_iface_dbus_proxy_add_favourite_contact_finish;
	iface->remove_favourite_contact = logger_iface_dbus_proxy_remove_favourite_contact_async;
	iface->remove_favourite_contact_finish = logger_iface_dbus_proxy_remove_favourite_contact_finish;
}


static void _vala_logger_iface_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void _vala_logger_iface_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _lambda0_ (Logger* self) {
	LoggerIface* _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (logger__logger);
	logger__logger = _tmp0_;
	g_signal_emit_by_name (self, "invalidated");
}


static void __lambda0__dbus_g_proxy_destroy (DBusGProxy* _sender, gpointer self) {
	_lambda0_ (self);
}


static void _lambda1_ (const char* ap, gchar** a, int a_length1, gchar** r, int r_length1, Logger* self) {
	g_return_if_fail (ap != NULL);
	if (g_strcmp0 (ap, self->priv->_account_path) != 0) {
		return;
	}
	g_signal_emit_by_name (self, "favourite-contacts-changed", a, a_length1, r, r_length1);
}


static void __lambda1__logger_iface_favourite_contacts_changed (LoggerIface* _sender, const char* account_path, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self) {
	_lambda1_ (account_path, added, added_length1, removed, removed_length1, self);
}


Logger* logger_construct (GType object_type, const gchar* account_path, GError** error) {
	Logger * self = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (account_path != NULL, NULL);
	self = (Logger*) g_object_new (object_type, NULL);
	if (logger__logger == NULL) {
		DBusGConnection* _tmp0_ = NULL;
		DBusGConnection* dbus_conn;
		LoggerIface* _tmp1_;
		_tmp0_ = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		dbus_conn = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (self);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_tmp1_ = logger_iface_dbus_proxy_new (dbus_conn, "org.freedesktop.Telepathy.Logger", "/org/freedesktop/Telepathy/Logger");
		_g_object_unref0 (logger__logger);
		logger__logger = _tmp1_;
		g_signal_connect_object ((DBusGProxy*) logger__logger, "destroy", (GCallback) __lambda0__dbus_g_proxy_destroy, self, 0);
		_dbus_g_connection_unref0 (dbus_conn);
	}
	_tmp2_ = g_strdup (account_path);
	_tmp3_ = _tmp2_;
	_g_free0 (self->priv->_account_path);
	self->priv->_account_path = _tmp3_;
	g_signal_connect_object (logger__logger, "favourite-contacts-changed", (GCallback) __lambda1__logger_iface_favourite_contacts_changed, self, 0);
	return self;
}


Logger* logger_new (const gchar* account_path, GError** error) {
	return logger_construct (TYPE_LOGGER, account_path, error);
}


static void logger_get_favourite_contacts_data_free (gpointer _data) {
	LoggerGetFavouriteContactsData* data;
	data = _data;
	data->result = (_vala_array_free (data->result, data->result_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data->self);
	g_slice_free (LoggerGetFavouriteContactsData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LoggerGetFavouriteContactsData* _data_;
	_data_ = g_slice_new0 (LoggerGetFavouriteContactsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, logger_get_favourite_contacts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, logger_get_favourite_contacts_data_free);
	_data_->self = _g_object_ref0 (self);
	logger_get_favourite_contacts_co (_data_);
}


gchar** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	gchar** result;
	LoggerGetFavouriteContactsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void logger_get_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LoggerGetFavouriteContactsData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	logger_get_favourite_contacts_co (data);
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


static gboolean logger_get_favourite_contacts_co (LoggerGetFavouriteContactsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (logger__logger == NULL) {
		data->_tmp0_ = NULL;
		data->_tmp0_ = g_new0 (gchar*, 0 + 1);
		data->_tmp1_ = data->_tmp0_;
		data->result_length1 = 0;
		data->result = data->_tmp1_;
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_state_ = 1;
	logger_iface_get_favourite_contacts (logger__logger, logger_get_favourite_contacts_ready, data);
	return FALSE;
	_state_1:
	data->_tmp3_ = NULL;
	data->_tmp3_ = logger_iface_get_favourite_contacts_finish (logger__logger, data->_res_, &data->_tmp2_, &data->_inner_error_);
	data->favs = data->_tmp3_;
	data->favs_length1 = data->_tmp2_;
	data->_favs_size_ = data->_tmp2_;
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	{
		data->account_collection = data->favs;
		data->account_collection_length1 = data->favs_length1;
		for (data->account_it = 0; data->account_it < data->favs_length1; data->account_it = data->account_it + 1) {
			memset (&data->_tmp5_, 0, sizeof (AccountFavourites));
			data->_tmp4_ = (account_favourites_copy (&data->account_collection[data->account_it], &data->_tmp5_), data->_tmp5_);
			data->account = data->_tmp4_;
			{
				if (g_strcmp0 (data->account.account_path, data->self->priv->_account_path) == 0) {
					data->_tmp6_ = (data->_tmp7_ = data->account.ids, (data->_tmp7_ == NULL) ? ((gpointer) data->_tmp7_) : _vala_array_dup3 (data->_tmp7_, data->account.ids_length1));
					data->_tmp8_ = data->_tmp6_;
					data->result_length1 = data->account.ids_length1;
					data->result = data->_tmp8_;
					account_favourites_destroy (&data->account);
					data->favs = (_vala_AccountFavourites_array_free (data->favs, data->favs_length1), NULL);
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
				account_favourites_destroy (&data->account);
			}
		}
	}
	data->_tmp9_ = NULL;
	data->_tmp9_ = g_new0 (gchar*, 0 + 1);
	data->_tmp10_ = data->_tmp9_;
	data->result_length1 = 0;
	data->result = data->_tmp10_;
	data->favs = (_vala_AccountFavourites_array_free (data->favs, data->favs_length1), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
	data->favs = (_vala_AccountFavourites_array_free (data->favs, data->favs_length1), NULL);
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void logger_add_favourite_contact_data_free (gpointer _data) {
	LoggerAddFavouriteContactData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->self);
	g_slice_free (LoggerAddFavouriteContactData, data);
}


void logger_add_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LoggerAddFavouriteContactData* _data_;
	_data_ = g_slice_new0 (LoggerAddFavouriteContactData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, logger_add_favourite_contact);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, logger_add_favourite_contact_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = g_strdup (id);
	logger_add_favourite_contact_co (_data_);
}


void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error) {
	LoggerAddFavouriteContactData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void logger_add_favourite_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LoggerAddFavouriteContactData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	logger_add_favourite_contact_co (data);
}


static gboolean logger_add_favourite_contact_co (LoggerAddFavouriteContactData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (logger__logger == NULL) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_strdup (data->self->priv->_account_path);
	data->_tmp1_ = data->_tmp0_;
	data->_state_ = 1;
	logger_iface_add_favourite_contact (logger__logger, data->_tmp1_, data->id, logger_add_favourite_contact_ready, data);
	return FALSE;
	_state_1:
	logger_iface_add_favourite_contact_finish (logger__logger, data->_res_, &data->_inner_error_);
	_g_free0 (data->_tmp1_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void logger_remove_favourite_contact_data_free (gpointer _data) {
	LoggerRemoveFavouriteContactData* data;
	data = _data;
	_g_free0 (data->id);
	_g_object_unref0 (data->self);
	g_slice_free (LoggerRemoveFavouriteContactData, data);
}


void logger_remove_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LoggerRemoveFavouriteContactData* _data_;
	_data_ = g_slice_new0 (LoggerRemoveFavouriteContactData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, logger_remove_favourite_contact);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, logger_remove_favourite_contact_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->id = g_strdup (id);
	logger_remove_favourite_contact_co (_data_);
}


void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error) {
	LoggerRemoveFavouriteContactData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void logger_remove_favourite_contact_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LoggerRemoveFavouriteContactData* data;
	data = _user_data_;
	data->_source_object_ = source_object;
	data->_res_ = _res_;
	logger_remove_favourite_contact_co (data);
}


static gboolean logger_remove_favourite_contact_co (LoggerRemoveFavouriteContactData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	if (logger__logger == NULL) {
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_strdup (data->self->priv->_account_path);
	data->_tmp1_ = data->_tmp0_;
	data->_state_ = 1;
	logger_iface_remove_favourite_contact (logger__logger, data->_tmp1_, data->id, logger_remove_favourite_contact_ready, data);
	return FALSE;
	_state_1:
	logger_iface_remove_favourite_contact_finish (logger__logger, data->_res_, &data->_inner_error_);
	_g_free0 (data->_tmp1_);
	if (data->_inner_error_ != NULL) {
		if (data->_inner_error_->domain == DBUS_GERROR) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void g_cclosure_user_marshal_VOID__BOXED_INT_BOXED_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT_BOXED_INT) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_boxed (param_values + 3), g_value_get_int (param_values + 4), data2);
}


static void logger_class_init (LoggerClass * klass) {
	logger_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (LoggerPrivate));
	G_OBJECT_CLASS (klass)->finalize = logger_finalize;
	g_signal_new ("invalidated", TYPE_LOGGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("favourite_contacts_changed", TYPE_LOGGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_BOXED_INT, G_TYPE_NONE, 4, G_TYPE_STRV, G_TYPE_INT, G_TYPE_STRV, G_TYPE_INT);
}


static void logger_instance_init (Logger * self) {
	self->priv = LOGGER_GET_PRIVATE (self);
}


static void logger_finalize (GObject* obj) {
	Logger * self;
	self = LOGGER (obj);
	_g_free0 (self->priv->_account_path);
	G_OBJECT_CLASS (logger_parent_class)->finalize (obj);
}


GType logger_get_type (void) {
	static volatile gsize logger_type_id__volatile = 0;
	if (g_once_init_enter (&logger_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LoggerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) logger_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Logger), 0, (GInstanceInitFunc) logger_instance_init, NULL };
		GType logger_type_id;
		logger_type_id = g_type_register_static (G_TYPE_OBJECT, "Logger", &g_define_type_info, 0);
		g_once_init_leave (&logger_type_id__volatile, logger_type_id);
	}
	return logger_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



