/* kf-persona.c generated by valac 0.11.6, the Vala compiler
 * generated from kf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>


#define FOLKS_BACKENDS_KF_TYPE_PERSONA (folks_backends_kf_persona_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersona))
#define FOLKS_BACKENDS_KF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))

typedef struct _FolksBackendsKfPersona FolksBackendsKfPersona;
typedef struct _FolksBackendsKfPersonaClass FolksBackendsKfPersonaClass;
typedef struct _FolksBackendsKfPersonaPrivate FolksBackendsKfPersonaPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;

#define FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE (folks_backends_kf_persona_store_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))

typedef struct _FolksBackendsKfPersonaStore FolksBackendsKfPersonaStore;
typedef struct _FolksBackendsKfPersonaStoreClass FolksBackendsKfPersonaStoreClass;
typedef struct _Block2Data Block2Data;

struct _FolksBackendsKfPersona {
	FolksPersona parent_instance;
	FolksBackendsKfPersonaPrivate * priv;
};

struct _FolksBackendsKfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _FolksBackendsKfPersonaPrivate {
	GKeyFile* _key_file;
	GHashTable* _im_addresses;
	gchar* _alias;
};

struct _Block1Data {
	int _ref_count_;
	FolksBackendsKfPersona * self;
	FolksPersonaLinkablePropertyCallback callback;
	gpointer callback_target;
};

struct _Block2Data {
	int _ref_count_;
	FolksBackendsKfPersona * self;
	GHashTable* im_addresses;
};


static gpointer folks_backends_kf_persona_parent_class = NULL;
static FolksAliasDetailsIface* folks_backends_kf_persona_folks_alias_details_parent_iface = NULL;
static FolksImDetailsIface* folks_backends_kf_persona_folks_im_details_parent_iface = NULL;

GType folks_backends_kf_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_KF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaPrivate))
enum  {
	FOLKS_BACKENDS_KF_PERSONA_DUMMY_PROPERTY,
	FOLKS_BACKENDS_KF_PERSONA_LINKABLE_PROPERTIES,
	FOLKS_BACKENDS_KF_PERSONA_ALIAS,
	FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES
};
FolksBackendsKfPersona* folks_backends_kf_persona_new (GKeyFile* key_file, const gchar* id, FolksPersonaStore* store);
FolksBackendsKfPersona* folks_backends_kf_persona_construct (GType object_type, GKeyFile* key_file, const gchar* id, FolksPersonaStore* store);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void folks_backends_kf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda2_ (const gchar* k, FolksLinkedHashSet* v, Block1Data* _data1_);
static void __lambda2__gh_func (gconstpointer key, gconstpointer value, gpointer self);
GType folks_backends_kf_persona_store_get_type (void) G_GNUC_CONST;
void folks_backends_kf_persona_store_save_key_file (FolksBackendsKfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backends_kf_persona_store_save_key_file_finish (FolksBackendsKfPersonaStore* self, GAsyncResult* _res_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static void _lambda0_ (const gchar* protocol, FolksLinkedHashSet* v, FolksBackendsKfPersona* self);
static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void _lambda1_ (const gchar* k, FolksLinkedHashSet* v, Block2Data* _data2_);
static void __lambda1__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void folks_backends_kf_persona_finalize (GObject* obj);
static void _vala_folks_backends_kf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backends_kf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* FOLKS_BACKENDS_KF_PERSONA__linkable_properties[1] = {"im-addresses"};

/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the Persona given by the group `uid` in the key file `key_file`.
   */
static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksBackendsKfPersona* folks_backends_kf_persona_construct (GType object_type, GKeyFile* key_file, const gchar* id, FolksPersonaStore* store) {
	FolksBackendsKfPersona * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* iid;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* uid;
	GHashTable* _tmp5_ = NULL;
	GHashTable* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gsize _tmp8_;
	gchar** _tmp9_ = NULL;
	gchar** keys;
	gint keys_length1;
	gint _keys_size_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (key_file != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (store != NULL, NULL);
	_tmp0_ = folks_persona_store_get_id (store);
	_tmp1_ = g_strconcat (_tmp0_, ":", NULL);
	iid = (_tmp2_ = g_strconcat (_tmp1_, id, NULL), _g_free0 (_tmp1_), _tmp2_);
	_tmp3_ = folks_persona_store_get_id (store);
	_tmp4_ = folks_persona_build_uid ("key-file", _tmp3_, id);
	uid = _tmp4_;
	self = (FolksBackendsKfPersona*) g_object_new (object_type, "display-id", id, "iid", iid, "uid", uid, "store", store, "is-user", FALSE, NULL);
	g_debug ("kf-persona.vala:162: Adding key-file Persona '%s' (IID '%s', group '%s" \
"')", uid, iid, id);
	self->priv->_key_file = key_file;
	_tmp5_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_tmp6_ = _tmp5_;
	_g_hash_table_unref0 (self->priv->_im_addresses);
	self->priv->_im_addresses = _tmp6_;
	_tmp7_ = folks_persona_get_display_id ((FolksPersona*) self);
	_tmp9_ = g_key_file_get_keys (self->priv->_key_file, _tmp7_, &_tmp8_, &_inner_error_);
	keys = _tmp9_;
	keys_length1 = _tmp8_;
	_keys_size_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch1_g_key_file_error;
		}
		_g_free0 (uid);
		_g_free0 (iid);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		gchar** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = keys;
		key_collection_length1 = keys_length1;
		for (key_it = 0; key_it < keys_length1; key_it = key_it + 1) {
			const gchar* key;
			key = key_collection[key_it];
			{
				const gchar* protocol;
				const gchar* _tmp14_ = NULL;
				gsize _tmp15_;
				gchar** _tmp16_ = NULL;
				gchar** im_addresses;
				gint im_addresses_length1;
				gint _im_addresses_size_;
				FolksLinkedHashSet* _tmp17_ = NULL;
				FolksLinkedHashSet* address_set;
				gchar* _tmp22_;
				FolksLinkedHashSet* _tmp23_;
				if (g_strcmp0 (key, "__alias") == 0) {
					const gchar* _tmp10_ = NULL;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp10_ = folks_persona_get_display_id ((FolksPersona*) self);
					_tmp11_ = g_key_file_get_string (self->priv->_key_file, _tmp10_, key, &_inner_error_);
					_tmp12_ = _tmp11_;
					if (_inner_error_ != NULL) {
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						if (_inner_error_->domain == G_KEY_FILE_ERROR) {
							goto __catch1_g_key_file_error;
						}
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (uid);
						_g_free0 (iid);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp13_ = _tmp12_;
					_g_free0 (self->priv->_alias);
					self->priv->_alias = _tmp13_;
					g_debug ("kf-persona.vala:180:     Loaded alias '%s'.", self->priv->_alias);
					continue;
				}
				protocol = key;
				_tmp14_ = folks_persona_get_display_id ((FolksPersona*) self);
				_tmp16_ = g_key_file_get_string_list (self->priv->_key_file, _tmp14_, protocol, &_tmp15_, &_inner_error_);
				im_addresses = _tmp16_;
				im_addresses_length1 = _tmp15_;
				_im_addresses_size_ = _tmp15_;
				if (_inner_error_ != NULL) {
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
					if (_inner_error_->domain == G_KEY_FILE_ERROR) {
						goto __catch1_g_key_file_error;
					}
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (uid);
					_g_free0 (iid);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp17_ = folks_linked_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
				address_set = _tmp17_;
				{
					gchar** im_address_collection;
					int im_address_collection_length1;
					int im_address_it;
					im_address_collection = im_addresses;
					im_address_collection_length1 = im_addresses_length1;
					for (im_address_it = 0; im_address_it < im_addresses_length1; im_address_it = im_address_it + 1) {
						gchar* _tmp18_;
						gchar* im_address;
						_tmp18_ = g_strdup (im_address_collection[im_address_it]);
						im_address = _tmp18_;
						{
							gchar* address = NULL;
							gchar* _tmp19_ = NULL;
							gchar* _tmp20_;
							gchar* _tmp21_;
							_tmp19_ = folks_im_details_normalise_im_address (im_address, protocol, &_inner_error_);
							_tmp20_ = _tmp19_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
									goto __catch2_folks_im_details_error;
								}
								_g_free0 (address);
								_g_free0 (im_address);
								_g_object_unref0 (address_set);
								im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
								keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (uid);
								_g_free0 (iid);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
							_tmp21_ = _tmp20_;
							_g_free0 (address);
							address = _tmp21_;
							goto __finally2;
							__catch2_folks_im_details_error:
							{
								GError * e;
								e = _inner_error_;
								_inner_error_ = NULL;
								g_warning ("kf-persona.vala:202: %s", e->message);
								_g_error_free0 (e);
								_g_free0 (address);
								_g_free0 (im_address);
								continue;
							}
							__finally2:
							if (_inner_error_ != NULL) {
								_g_free0 (address);
								_g_free0 (im_address);
								_g_object_unref0 (address_set);
								im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
								keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
								if (_inner_error_->domain == G_KEY_FILE_ERROR) {
									goto __catch1_g_key_file_error;
								}
								_g_free0 (address);
								_g_free0 (im_address);
								_g_object_unref0 (address_set);
								im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
								keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (uid);
								_g_free0 (iid);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
							gee_abstract_collection_add ((GeeAbstractCollection*) address_set, address);
							_g_free0 (address);
							_g_free0 (im_address);
						}
					}
				}
				_tmp22_ = g_strdup (protocol);
				_tmp23_ = _g_object_ref0 (address_set);
				g_hash_table_insert (self->priv->_im_addresses, _tmp22_, _tmp23_);
				_g_object_unref0 (address_set);
				im_addresses = (_vala_array_free (im_addresses, im_addresses_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		if (!g_error_matches (e, G_KEY_FILE_ERROR, G_KEY_FILE_ERROR_GROUP_NOT_FOUND)) {
			const gchar* _tmp24_ = NULL;
			_tmp24_ = _ ("Couldn't load data from key file: %s");
			g_warning (_tmp24_, e->message);
		}
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (uid);
		_g_free0 (iid);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_free0 (uid);
	_g_free0 (iid);
	return self;
}


FolksBackendsKfPersona* folks_backends_kf_persona_new (GKeyFile* key_file, const gchar* id, FolksPersonaStore* store) {
	return folks_backends_kf_persona_construct (FOLKS_BACKENDS_KF_TYPE_PERSONA, key_file, id, store);
}


/**
   * {@inheritDoc}
   */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda2_ (const gchar* k, FolksLinkedHashSet* v, Block1Data* _data1_) {
	FolksBackendsKfPersona * self;
	const gchar* protocol;
	FolksLinkedHashSet* im_addresses;
	self = _data1_->self;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	protocol = (const gchar*) k;
	im_addresses = FOLKS_LINKED_HASH_SET (v);
	{
		FolksLinkedHashSet* _tmp0_;
		FolksLinkedHashSet* _address_list;
		gint _tmp1_;
		gint _address_size;
		gint _address_index;
		_tmp0_ = _g_object_ref0 (im_addresses);
		_address_list = _tmp0_;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _address_list);
		_address_size = _tmp1_;
		_address_index = -1;
		while (TRUE) {
			gpointer _tmp2_ = NULL;
			gchar* address;
			gchar* _tmp3_;
			gchar* _tmp4_;
			_address_index = _address_index + 1;
			if (!(_address_index < _address_size)) {
				break;
			}
			_tmp2_ = gee_abstract_list_get ((GeeAbstractList*) _address_list, _address_index);
			address = (gchar*) _tmp2_;
			_tmp3_ = g_strconcat (protocol, ":", NULL);
			_tmp4_ = g_strconcat (_tmp3_, address, NULL);
			_data1_->callback (_tmp4_, _data1_->callback_target);
			_g_free0 (_tmp4_);
			_g_free0 (_tmp3_);
			_g_free0 (address);
		}
		_g_object_unref0 (_address_list);
	}
}


static void __lambda2__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda2_ (key, value, self);
}


static void folks_backends_kf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	FolksBackendsKfPersona * self;
	Block1Data* _data1_;
	self = (FolksBackendsKfPersona*) base;
	g_return_if_fail (prop_name != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->callback = callback;
	_data1_->callback_target = callback_target;
	if (g_strcmp0 (prop_name, "im-addresses") == 0) {
		GHashTable* _tmp0_ = NULL;
		_tmp0_ = folks_im_details_get_im_addresses ((FolksImDetails*) self);
		g_hash_table_foreach (_tmp0_, __lambda2__gh_func, _data1_);
	} else {
		FOLKS_PERSONA_CLASS (folks_backends_kf_persona_parent_class)->linkable_property_to_links (FOLKS_PERSONA (self), prop_name, _data1_->callback, _data1_->callback_target);
	}
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static gchar** folks_backends_kf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	FolksBackendsKfPersona* self;
	const gchar** _tmp0_;
	self = (FolksBackendsKfPersona*) base;
	_tmp0_ = FOLKS_BACKENDS_KF_PERSONA__linkable_properties;
	*result_length1 = G_N_ELEMENTS (FOLKS_BACKENDS_KF_PERSONA__linkable_properties);
	result = _tmp0_;
	return result;
}


static const gchar* folks_backends_kf_persona_real_get_alias (FolksAliasDetails* base) {
	const gchar* result;
	FolksBackendsKfPersona* self;
	self = (FolksBackendsKfPersona*) base;
	result = self->priv->_alias;
	return result;
}


static void folks_backends_kf_persona_real_set_alias (FolksAliasDetails* base, const gchar* value) {
	FolksBackendsKfPersona* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	FolksPersonaStore* _tmp4_ = NULL;
	self = (FolksBackendsKfPersona*) base;
	if (g_strcmp0 (self->priv->_alias, value) == 0) {
		return;
	}
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	g_debug ("kf-persona.vala:65: Setting alias of Kf.Persona '%s' to '%s'.", _tmp0_, value);
	_tmp1_ = g_strdup (value);
	_tmp2_ = _tmp1_;
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp2_;
	_tmp3_ = folks_persona_get_display_id ((FolksPersona*) self);
	g_key_file_set_string (self->priv->_key_file, _tmp3_, "__alias", value);
	_tmp4_ = folks_persona_get_store ((FolksPersona*) self);
	folks_backends_kf_persona_store_save_key_file (FOLKS_BACKENDS_KF_PERSONA_STORE (_tmp4_), NULL, NULL);
	g_object_notify ((GObject *) self, "alias");
}


static GHashTable* folks_backends_kf_persona_real_get_im_addresses (FolksImDetails* base) {
	GHashTable* result;
	FolksBackendsKfPersona* self;
	self = (FolksBackendsKfPersona*) base;
	result = self->priv->_im_addresses;
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_hash_table_unref0 (_data2_->im_addresses);
		g_slice_free (Block2Data, _data2_);
	}
}


static void _lambda0_ (const gchar* protocol, FolksLinkedHashSet* v, FolksBackendsKfPersona* self) {
	const gchar* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (protocol != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = folks_persona_get_display_id ((FolksPersona*) self);
	g_key_file_remove_key (self->priv->_key_file, _tmp0_, protocol, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_KEY_FILE_ERROR) {
			goto __catch3_g_key_file_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally3;
	__catch3_g_key_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda0_ (key, value, self);
}


static void _lambda1_ (const gchar* k, FolksLinkedHashSet* v, Block2Data* _data2_) {
	FolksBackendsKfPersona * self;
	const gchar* protocol;
	FolksLinkedHashSet* addresses;
	FolksLinkedHashSet* _tmp0_ = NULL;
	FolksLinkedHashSet* normalized_addresses;
	gint _tmp7_;
	gpointer* _tmp8_ = NULL;
	gchar** addrs;
	gint addrs_length1;
	gint _addrs_size_;
	gint _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	FolksLinkedHashSet* _tmp12_;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	protocol = (const gchar*) k;
	addresses = FOLKS_LINKED_HASH_SET (v);
	_tmp0_ = folks_linked_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	normalized_addresses = _tmp0_;
	{
		FolksLinkedHashSet* _tmp1_;
		FolksLinkedHashSet* _address_list;
		gint _tmp2_;
		gint _address_size;
		gint _address_index;
		_tmp1_ = _g_object_ref0 (addresses);
		_address_list = _tmp1_;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _address_list);
		_address_size = _tmp2_;
		_address_index = -1;
		while (TRUE) {
			gpointer _tmp3_ = NULL;
			gchar* address;
			gchar* normalized_address = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_;
			_address_index = _address_index + 1;
			if (!(_address_index < _address_size)) {
				break;
			}
			_tmp3_ = gee_abstract_list_get ((GeeAbstractList*) _address_list, _address_index);
			address = (gchar*) _tmp3_;
			_tmp4_ = folks_im_details_normalise_im_address (address, protocol, &_inner_error_);
			_tmp5_ = _tmp4_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
					goto __catch4_folks_im_details_error;
				}
				_g_free0 (normalized_address);
				_g_free0 (address);
				_g_object_unref0 (_address_list);
				_g_object_unref0 (normalized_addresses);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp6_ = _tmp5_;
			_g_free0 (normalized_address);
			normalized_address = _tmp6_;
			goto __finally4;
			__catch4_folks_im_details_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				g_warning ("kf-persona.vala:124: %s", e->message);
				_g_error_free0 (e);
				_g_free0 (normalized_address);
				_g_free0 (address);
				continue;
			}
			__finally4:
			if (_inner_error_ != NULL) {
				_g_free0 (normalized_address);
				_g_free0 (address);
				_g_object_unref0 (_address_list);
				_g_object_unref0 (normalized_addresses);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			gee_abstract_collection_add ((GeeAbstractCollection*) normalized_addresses, normalized_address);
			_g_free0 (normalized_address);
			_g_free0 (address);
		}
		_g_object_unref0 (_address_list);
	}
	_tmp8_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) normalized_addresses, &_tmp7_);
	addrs = (gchar**) _tmp8_;
	addrs_length1 = _tmp7_;
	_addrs_size_ = _tmp7_;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) normalized_addresses);
	addrs_length1 = _tmp9_;
	_tmp10_ = folks_persona_get_display_id ((FolksPersona*) self);
	g_key_file_set_string_list (self->priv->_key_file, _tmp10_, protocol, (const gchar* const*) addrs, addrs_length1);
	_tmp11_ = g_strdup (protocol);
	_tmp12_ = _g_object_ref0 (normalized_addresses);
	g_hash_table_insert (_data2_->im_addresses, _tmp11_, _tmp12_);
	addrs = (_vala_array_free (addrs, addrs_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (normalized_addresses);
}


static void __lambda1__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda1_ (key, value, self);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void folks_backends_kf_persona_real_set_im_addresses (FolksImDetails* base, GHashTable* value) {
	FolksBackendsKfPersona* self;
	Block2Data* _data2_;
	GHashTable* _tmp0_ = NULL;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	FolksPersonaStore* _tmp3_ = NULL;
	self = (FolksBackendsKfPersona*) base;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	g_hash_table_foreach (self->priv->_im_addresses, __lambda0__gh_func, self);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_data2_->im_addresses = _tmp0_;
	g_hash_table_foreach (value, __lambda1__gh_func, _data2_);
	_tmp1_ = _g_hash_table_ref0 (_data2_->im_addresses);
	_tmp2_ = _tmp1_;
	_g_hash_table_unref0 (self->priv->_im_addresses);
	self->priv->_im_addresses = _tmp2_;
	_tmp3_ = folks_persona_get_store ((FolksPersona*) self);
	folks_backends_kf_persona_store_save_key_file (FOLKS_BACKENDS_KF_PERSONA_STORE (_tmp3_), NULL, NULL);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	g_object_notify ((GObject *) self, "im-addresses");
}


static void folks_backends_kf_persona_class_init (FolksBackendsKfPersonaClass * klass) {
	folks_backends_kf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsKfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = folks_backends_kf_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = folks_backends_kf_persona_real_get_linkable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_kf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_kf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_kf_persona_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.1.15
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_ALIAS, "alias");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES, "im-addresses");
}


static void folks_backends_kf_persona_folks_alias_details_interface_init (FolksAliasDetailsIface * iface) {
	folks_backends_kf_persona_folks_alias_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_alias = folks_backends_kf_persona_real_get_alias;
	iface->set_alias = folks_backends_kf_persona_real_set_alias;
}


static void folks_backends_kf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	folks_backends_kf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = folks_backends_kf_persona_real_get_im_addresses;
	iface->set_im_addresses = folks_backends_kf_persona_real_set_im_addresses;
}


static void folks_backends_kf_persona_instance_init (FolksBackendsKfPersona * self) {
	self->priv = FOLKS_BACKENDS_KF_PERSONA_GET_PRIVATE (self);
}


static void folks_backends_kf_persona_finalize (GObject* obj) {
	FolksBackendsKfPersona * self;
	self = FOLKS_BACKENDS_KF_PERSONA (obj);
	_g_hash_table_unref0 (self->priv->_im_addresses);
	_g_free0 (self->priv->_alias);
	G_OBJECT_CLASS (folks_backends_kf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single persona from a simple key file.
 *
 * @since 0.1.13
 */
GType folks_backends_kf_persona_get_type (void) {
	static volatile gsize folks_backends_kf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_kf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsKfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_kf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsKfPersona), 0, (GInstanceInitFunc) folks_backends_kf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_alias_details_info = { (GInterfaceInitFunc) folks_backends_kf_persona_folks_alias_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) folks_backends_kf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_backends_kf_persona_type_id;
		folks_backends_kf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "FolksBackendsKfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (folks_backends_kf_persona_type_id, FOLKS_TYPE_ALIAS_DETAILS, &folks_alias_details_info);
		g_type_add_interface_static (folks_backends_kf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_once_init_leave (&folks_backends_kf_persona_type_id__volatile, folks_backends_kf_persona_type_id);
	}
	return folks_backends_kf_persona_type_id__volatile;
}


static void _vala_folks_backends_kf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersona * self;
	int length;
	self = FOLKS_BACKENDS_KF_PERSONA (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_LINKABLE_PROPERTIES:
		g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_ALIAS:
		g_value_set_string (value, folks_alias_details_get_alias ((FolksAliasDetails*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES:
		g_value_set_boxed (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backends_kf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersona * self;
	self = FOLKS_BACKENDS_KF_PERSONA (object);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_ALIAS:
		folks_alias_details_set_alias ((FolksAliasDetails*) self, g_value_get_string (value));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



