/* imable.c generated by valac 0.11.2.11-bbde6, the Vala compiler
 * generated from imable.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_IMABLE (folks_imable_get_type ())
#define FOLKS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IMABLE, FolksIMable))
#define FOLKS_IS_IMABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IMABLE))
#define FOLKS_IMABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IMABLE, FolksIMableIface))

typedef struct _FolksIMable FolksIMable;
typedef struct _FolksIMableIface FolksIMableIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _FolksIMableIface {
	GTypeInterface parent_iface;
	GHashTable* (*get_im_addresses) (FolksIMable* self);
	void (*set_im_addresses) (FolksIMable* self, GHashTable* value);
};



GType folks_imable_get_type (void) G_GNUC_CONST;
gchar* folks_imable_normalise_im_address (const gchar* im_address, const gchar* protocol);
GHashTable* folks_imable_get_im_addresses (FolksIMable* self);
void folks_imable_set_im_addresses (FolksIMable* self, GHashTable* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
   * Normalise an IM address so that it's suitable for string comparison.
   *
   * IM addresses for various protocols can be represented in different ways,
   * only one of which is canonical. In order to allow simple string comparisons
   * of IM addresses to work, the IM addresses must be normalised beforehand.
   *
   * @param im_address the address to normalise
   * @param protocol the protocol of this im_address
   *
   * @since 0.2.0
   */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	regex = (_tmp3_ = _tmp2_, _g_free0 (_tmp1_), _tmp3_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch7_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch7_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* folks_imable_normalise_im_address (const gchar* im_address, const gchar* protocol) {
	gchar* result = NULL;
	gchar* normalised;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp41_ = NULL;
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	normalised = NULL;
	if (g_strcmp0 (protocol, "aim") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (protocol, "myspace") == 0;
	}
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp1_ = string_replace (im_address, " ", "");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) (-1));
		_tmp4_ = _tmp3_;
		_g_free0 (normalised);
		normalised = _tmp4_;
		_g_free0 (_tmp2_);
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		if (g_strcmp0 (protocol, "irc") == 0) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = g_strcmp0 (protocol, "yahoo") == 0;
		}
		if (_tmp7_) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = g_strcmp0 (protocol, "yahoojp") == 0;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = g_strcmp0 (protocol, "groupwise") == 0;
		}
		if (_tmp5_) {
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = g_utf8_strdown (im_address, (gssize) (-1));
			_tmp9_ = _tmp8_;
			_g_free0 (normalised);
			normalised = _tmp9_;
		} else {
			if (g_strcmp0 (protocol, "jabber") == 0) {
				gchar** _tmp10_;
				gchar** _tmp11_ = NULL;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp12_;
				gchar** parts;
				gchar* resource;
				gchar** _tmp15_;
				gchar** _tmp16_ = NULL;
				gchar** _tmp17_;
				gchar* node;
				gchar* domain;
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				gboolean _tmp32_ = FALSE;
				_tmp11_ = _tmp10_ = g_strsplit (im_address, "/", 2);
				_tmp12_ = _tmp11_;
				parts_length1 = _vala_array_length (_tmp10_);
				_parts_size_ = parts_length1;
				parts = _tmp12_;
				g_return_val_if_fail (parts_length1 >= 1, NULL);
				resource = NULL;
				if (parts_length1 == 2) {
					gchar* _tmp13_;
					gchar* _tmp14_;
					_tmp13_ = g_strdup (parts[1]);
					_tmp14_ = _tmp13_;
					_g_free0 (resource);
					resource = _tmp14_;
				}
				_tmp16_ = _tmp15_ = g_strsplit (parts[0], "@", 2);
				_tmp17_ = _tmp16_;
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				parts_length1 = _vala_array_length (_tmp15_);
				_parts_size_ = parts_length1;
				parts = _tmp17_;
				g_return_val_if_fail (parts_length1 >= 1, NULL);
				node = NULL;
				domain = NULL;
				if (parts_length1 == 2) {
					gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					_tmp18_ = g_strdup (parts[0]);
					_tmp19_ = _tmp18_;
					_g_free0 (node);
					node = _tmp19_;
					_tmp20_ = g_strdup (parts[1]);
					_tmp21_ = _tmp20_;
					_g_free0 (domain);
					domain = _tmp21_;
				} else {
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp22_ = NULL;
					_g_free0 (node);
					node = _tmp22_;
					_tmp23_ = g_strdup (parts[0]);
					_tmp24_ = _tmp23_;
					_g_free0 (domain);
					domain = _tmp24_;
				}
				if (node == NULL) {
					_tmp25_ = TRUE;
				} else {
					_tmp25_ = g_strcmp0 (node, "") != 0;
				}
				g_return_val_if_fail (_tmp25_, NULL);
				if (domain != NULL) {
					_tmp26_ = g_strcmp0 (domain, "") != 0;
				} else {
					_tmp26_ = FALSE;
				}
				g_return_val_if_fail (_tmp26_, NULL);
				if (resource == NULL) {
					_tmp27_ = TRUE;
				} else {
					_tmp27_ = g_strcmp0 (resource, "") != 0;
				}
				g_return_val_if_fail (_tmp27_, NULL);
				_tmp28_ = g_utf8_strdown (domain, (gssize) (-1));
				_tmp29_ = _tmp28_;
				_g_free0 (domain);
				domain = _tmp29_;
				if (node != NULL) {
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					_tmp30_ = g_utf8_strdown (node, (gssize) (-1));
					_tmp31_ = _tmp30_;
					_g_free0 (node);
					node = _tmp31_;
				}
				if (node != NULL) {
					_tmp32_ = resource != NULL;
				} else {
					_tmp32_ = FALSE;
				}
				if (_tmp32_) {
					gchar* _tmp33_ = NULL;
					gchar* _tmp34_;
					_tmp33_ = g_strdup_printf ("%s@%s/%s", node, domain, resource);
					_tmp34_ = _tmp33_;
					_g_free0 (normalised);
					normalised = _tmp34_;
				} else {
					if (node != NULL) {
						gchar* _tmp35_ = NULL;
						gchar* _tmp36_;
						_tmp35_ = g_strdup_printf ("%s@%s", node, domain);
						_tmp36_ = _tmp35_;
						_g_free0 (normalised);
						normalised = _tmp36_;
					} else {
						if (resource != NULL) {
							gchar* _tmp37_ = NULL;
							gchar* _tmp38_;
							_tmp37_ = g_strdup_printf ("%s/%s", domain, resource);
							_tmp38_ = _tmp37_;
							_g_free0 (normalised);
							normalised = _tmp38_;
						} else {
							g_assert_not_reached ();
						}
					}
				}
				_g_free0 (domain);
				_g_free0 (node);
				_g_free0 (resource);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
			} else {
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp39_ = g_strdup (im_address);
				_tmp40_ = _tmp39_;
				_g_free0 (normalised);
				normalised = _tmp40_;
			}
		}
	}
	_tmp41_ = g_utf8_normalize (normalised, (gssize) (-1), G_NORMALIZE_DEFAULT);
	result = _tmp41_;
	_g_free0 (normalised);
	return result;
}


GHashTable* folks_imable_get_im_addresses (FolksIMable* self) {
	return FOLKS_IMABLE_GET_INTERFACE (self)->get_im_addresses (self);
}


void folks_imable_set_im_addresses (FolksIMable* self, GHashTable* value) {
	FOLKS_IMABLE_GET_INTERFACE (self)->set_im_addresses (self, value);
}


static void folks_imable_base_init (FolksIMableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * A mapping of IM protocol to an ordered set of IM addresses.
		   *
		   * Each mapping is from an arbitrary protocol identifier to a set of IM
		   * addresses on that protocol for the contact, listed in preference order.
		   * The most-preferred IM address for each protocol comes first in that
		   * protocol's list.
		   *
		   * There must be no duplicate IM addresses in each ordered set, though a given
		   * IM address may be present in the sets for different protocols.
		   *
		   * All the IM addresses must be normalised using
		   * {@link IMable.normalise_im_address} before being added to this property.
		   *
		   * @since 0.1.13
		   */
		g_object_interface_install_property (iface, g_param_spec_boxed ("im-addresses", "im-addresses", "im-addresses", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * IM addresses exposed by an object implementing {@link Presence}.
 *
 * @since 0.1.13
 */
GType folks_imable_get_type (void) {
	static volatile gsize folks_imable_type_id__volatile = 0;
	if (g_once_init_enter (&folks_imable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIMableIface), (GBaseInitFunc) folks_imable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_imable_type_id;
		folks_imable_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksIMable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_imable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_imable_type_id__volatile, folks_imable_type_id);
	}
	return folks_imable_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



