/* AbiSource Program Utilities
 * 
 * Copyright (C) 2002 Dom Lachowicz <cinamod@hotmail.com>
 * Copyright (C) 2005 Daniel d'Andrada T. de Carvalho
 * <daniel.carvalho@indt.org.br>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  
 * 02111-1307, USA.
 */

#ifndef _OO_PAGESTYLE_H_
#define _OO_PAGESTYLE_H_

#include "ut_xml.h"
#include "ut_string_class.h"


/**
 * Class representing OOo page setup properties.
 * Imported values are separated for use within Abi's
 * <pagesize> and <section> tags.
 */
class OO_PageStyle
{
public:

    OO_PageStyle() : m_name("") {}

    ~OO_PageStyle() {}

    void appendPageMaster(const XML_Char* pName, const XML_Char** ppAtts);

    /**
     * Returns the name of the current page setup style.
     */
    const XML_Char* getName() const;

    /**
     * Returns attribute array for the <pagesize> tag.
     */
    const XML_Char** getAbiPageAtts(const XML_Char* pMasterName);
  
    /**
     * Returns props string for the <section> tag.
     */
    const XML_Char* getAbiSectionProps() const;
  
private:
    
    void parse (const XML_Char** pProps);
  
    UT_String m_name;

    UT_String m_width;
    UT_String m_height;
  
    UT_String m_marginLeft;
    UT_String m_marginTop;
    UT_String m_marginRight;
    UT_String m_marginBottom;
  
    static const int MAX_PAGE_ATTS = 13; // 2*(width height orientation pagetype units page-scale) 0 
    const XML_Char* m_pageAtts[MAX_PAGE_ATTS];
    UT_String m_sectionProps;
}; // class OO_PageStyle




#endif //_OO_PAGESTYLE_H_
