from main import USERHOME
from datatypes import *
import pwstore


#
# This class contains functions to convert strings to types and vice-versa.
#
class TypeConverter:

    def __init__(self):

        self.__types = {}



    #
    # Adds a new type
    #
    def add_type(self, key, dtype):

        self.__types[key] = dtype



    #
    # The conversion methods must be idem-potent.
    #
    def str2type(self, key, v):

        dtype = self.__types.get(key, TYPE_STRING)

        if (dtype == TYPE_STRING): return v

        elif (dtype == TYPE_SECRET_STRING):
            return pwstore.retrieve(USERHOME, v)

        elif (dtype == TYPE_BOOL):
            return (v == "true" or v == 1)

        elif (dtype == TYPE_INT): return int(v)

        elif (dtype == TYPE_FLOAT): return float(v)

        elif (dtype == TYPE_LIST):
            v = v.replace("\\,", "@@COMMA@@")
            parts = v.split(",")
            ret = []
            for p in parts: ret.append(p.strip().replace("@@COMMA@@", ","))
            return ret

        elif (dtype == TYPE_COORD_SIZE):
            v = str(v)
            if (v[-1] == "%"):
                value = int(float(v[:-1]))
                is_percent = 1
            else:
                value = int(float(v))
                is_percent = 0
            return (value, is_percent)

        else:
            return v




    #
    # The conversion methods must be idem-potent.
    #
    def type2str(self, key, v):

        dtype = self.__types.get(key, TYPE_STRING)

        if (dtype == TYPE_LIST): return ",".join(v)
        elif (dtype == TYPE_SECRET_STRING):
            return pwstore.store(USERHOME, v)
        elif (dtype == TYPE_BOOL): return v and "true" or "false"

        elif (dtype == TYPE_COORD_SIZE):
            value, is_percent = v
            if (is_percent): return str(value) + "%"
            else: return str(value)

        else: return str(v)
