from ContainerTarget import ContainerTarget
from utils.datatypes import *

import gtk



#
# Class for putting frames around targets.
#
class TargetFrame(ContainerTarget):

    def __init__(self, parent, display):

        self.__shadow_type = gtk.SHADOW_NONE

        ContainerTarget.__init__(self, parent, display)
        self.__frame = gtk.Frame()
        #self.__frame.set_shadow_type(self.__shadow_type)
        self.__frame.show()
        self.add(self.__frame)

        self._set_property_type("border", TYPE_STRING)
        self._set_property_type("color", TYPE_STRING)

        #self.set_config("width", "100%")
        #self.set_config("height", "100%")


    def add_children(self, childrendata):

        ContainerTarget.add_children(self, childrendata)
        self.__frame.add(self._get_child())
        self._init_children()




    #
    # TODO: properties
    #
    def set_config(self, key, value):

        value = self._convert_type(key, value)

        if (key == "shadow"):
            if (value == "in"):
                self.__shadow_type = gtk.SHADOW_IN
            elif (value == "out"):
                self.__shadow_type = gtk.SHADOW_OUT
            elif (value == "etched-in"):
                self.__shadow_type = gtk.SHADOW_ETCHED_IN
            elif (value == "etched-out"):
                self.__shadow_type = gtk.SHADOW_ETCHED_OUT
            else:
                self.__shadow_type = gtk.SHADOW_NONE

            self.__frame.set_shadow_type(self.__shadow_type)

        else:
            ContainerTarget.set_config(self, key, value)



    #
    # Returns the target at the given position and its path.
    #
    def get_target_at(self, px, py, path):

        x, y, w, h = self.get_geometry()

        if (x <= px <= x + w and y <= py <= y + h):
            child = self._get_child()
            if (not child): return ([], [])
            ctargets = child.get_target_at(px - x , py - y, path)

            ret = [(self, path)] + ctargets
            return ret

        else:
            return []

        #end if
