/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-
 *
 * Copyright (C) 2005 Jaap Haitsma <jaap@haitsma.org>
 * Copyright (C) 2005 William Jon McCann <mccann@jhu.edu>
 * Copyright (C) 2005-2008 Richard Hughes <richard@hughsie.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <glib.h>
#include <glib/gi18n.h>
#include <gtk/gtk.h>

#include "egg-debug.h"

#include "gpm-common.h"
#include "gpm-prefs-core.h"

/**
 * gpm_prefs_help_cb
 **/
static void
gpm_prefs_help_cb (GpmPrefs *prefs, GtkApplication *application)
{
	gpm_help_display ("preferences");
}

/**
 * gpm_prefs_close_cb
 **/
static void
gpm_prefs_close_cb (GpmPrefs *prefs, GtkApplication *application)
{
	gtk_application_quit (application);
}

/**
 * gpm_prefs_application_prepare_action_cb:
 **/
static void
gpm_prefs_application_prepare_action_cb (GtkApplication *application, GVariant *arguments,
					 GVariant *platform_data, GpmPrefs *prefs)
{
	gpm_prefs_activate_window (prefs);
}

/**
 * main:
 **/
int
main (int argc, char **argv)
{
	gboolean verbose = FALSE;
	GOptionContext *context;
	GpmPrefs *prefs = NULL;
	GtkApplication *application;

	const GOptionEntry options[] = {
		{ "verbose", '\0', 0, G_OPTION_ARG_NONE, &verbose,
		  N_("Show extra debugging information"), NULL },
		{ NULL}
	};

	context = g_option_context_new (N_("GNOME Power Preferences"));

	bindtextdomain (GETTEXT_PACKAGE, GNOMELOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	g_option_context_set_translation_domain(context, GETTEXT_PACKAGE);
	g_option_context_add_main_entries (context, options, GETTEXT_PACKAGE);
	g_option_context_add_group (context, gtk_get_option_group (FALSE));
	g_option_context_parse (context, &argc, &argv, NULL);

	gtk_init (&argc, &argv);
	egg_debug_init (verbose);

	prefs = gpm_prefs_new ();

	/* ensure single instance */
	application = gtk_application_new ("org.gnome.PowerManager.Preferences", &argc, &argv);
	g_signal_connect (application, "prepare-activation",
			  G_CALLBACK (gpm_prefs_application_prepare_action_cb), prefs);
	g_signal_connect (prefs, "action-help",
			  G_CALLBACK (gpm_prefs_help_cb), application);
	g_signal_connect (prefs, "action-close",
			  G_CALLBACK (gpm_prefs_close_cb), application);

	/* run */
	gtk_application_run (application);

	g_object_unref (prefs);
	g_object_unref (application);

/* seems to not work...
	g_option_context_free (context); */

	return 0;
}
