/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* 
 * Copyright (C) 2004 James Bowes <bowes@cs.dal.ca>
 *
 * test_blank.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: James Bowes <bowes@cs.dal.ca>
 */

#include <glib.h>
#include <glib/gprintf.h>
#include "nautilus-burn-drive.h"
#include "nautilus-burn-recorder.h"

static void
blank_disc (const char                   *device,
	    NautilusBurnRecorderBlankType type,
	    gboolean                      debug)
{
	GList                *cdroms, *cdrom;
	NautilusBurnRecorder *recorder;
	NautilusBurnDrive    *drive;

	cdroms = nautilus_burn_drive_get_list (TRUE, FALSE);

	cdrom = cdroms;

	while (cdrom != NULL) {
		drive = (NautilusBurnDrive *) cdrom->data;

		if (g_str_equal (device, drive->device)) {
			break;
		}
		cdrom = cdroms->next;
	}

	if (cdrom == NULL) {
		g_printf ("Device %s is not a cd-r drive, or was not found\n",
			  device);
		return;
	}

	g_type_init ();
	g_thread_init (NULL);

       	recorder = nautilus_burn_recorder_new ();

	nautilus_burn_recorder_blank_disc (recorder,
					   drive,
					   type, 
					   debug);
}

int main (int argc, char **argv)
{
	char                         *device;
	NautilusBurnRecorderBlankType type;
	gboolean                      debug;
	       
	type = NAUTILUS_BURN_RECORDER_BLANK_FAST;
	debug = FALSE;

	if (argc >= 2) {
		device = argv[1];
		
		if (argc >= 3) {
			type = (g_str_equal (argv[2], "fast")) 
				? NAUTILUS_BURN_RECORDER_BLANK_FAST 
				: NAUTILUS_BURN_RECORDER_BLANK_FULL;
		}

		if (argc >= 4) {
			debug = g_str_equal (argv[3], "debug");
		}

		blank_disc (device, type, debug);
	}

	return 0;
}
