/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.PixbufLoader
 * Method:    gdk_pixbuf_loader_get_type
 */
JNIEXPORT jint JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1get_1type (JNIEnv 
    *env, jclass cls) 
{
    return (jint)gdk_pixbuf_loader_get_type ();
}

/*
 * Class:     org.gnu.gdk.PixbufLoader
 * Method:    gdk_pixbuf_loader_new
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1new (JNIEnv *env, 
    jclass cls) 
{
    return getHandleFromPointer(env, gdk_pixbuf_loader_new ());
}

/*
 * Class:     org.gnu.gdk.PixbufLoader
 * Method:    gdk_pixbuf_loader_new_with_type
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1new_1with_1type (
    JNIEnv *env, jclass cls, jstring imageType, jint error) 
{
    const gchar* imageType_g = (*env)->GetStringUTFChars(env, imageType, 0);
    jobject result = getHandleFromPointer(env, 
    		gdk_pixbuf_loader_new_with_type (imageType_g, (GError**)error));
    (*env)->ReleaseStringUTFChars(env, imageType, imageType_g);
    return result;
}

/*
 * Class:     org.gnu.gdk.PixbufLoader
 * Method:    gdk_pixbuf_loader_write
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1write (JNIEnv 
    *env, jclass cls, jobject loader, jbyteArray buf, jint count, jint error) 
{
    GdkPixbufLoader *loader_g = (GdkPixbufLoader *)getPointerFromHandle(env, loader);
    jint buf_len = (*env)->GetArrayLength(env, buf);
    gchar* buf_g = (gchar*)g_malloc(buf_len + 1);
    gint32 count_g = (gint32) count;
    GError **error_g = (GError **)error;
    (*env)->GetByteArrayRegion(env, buf, 0, buf_len, (jbyte*)buf_g);
    buf_g[buf_len] = 0;
    return (jboolean) (gdk_pixbuf_loader_write (loader_g, buf_g, count_g, error_g));
}

/*
 * Class:     org.gnu.gdk.PixbufLoader
 * Method:    gdk_pixbuf_loader_get_pixbuf
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1get_1pixbuf (JNIEnv 
    *env, jclass cls, jobject loader) 
{
    GdkPixbufLoader *loader_g = (GdkPixbufLoader *)getPointerFromHandle(env, loader);
    return getHandleFromPointer(env, gdk_pixbuf_loader_get_pixbuf (loader_g));
}

/*
 * Class:     org.gnu.gdk.PixbufLoader
 * Method:    gdk_pixbuf_loader_get_animation
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1get_1animation (
    JNIEnv *env, jclass cls, jobject loader) 
{
    GdkPixbufLoader *loader_g = (GdkPixbufLoader *)getPointerFromHandle(env, loader);
    return getHandleFromPointer(env, gdk_pixbuf_loader_get_animation (loader_g));
}

/*
 * Class:     org.gnu.gdk.PixbufLoader
 * Method:    gdk_pixbuf_loader_close
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_PixbufLoader_gdk_1pixbuf_1loader_1close (JNIEnv 
    *env, jclass cls, jobject loader, jint error) 
{
    GdkPixbufLoader *loader_g = (GdkPixbufLoader *)getPointerFromHandle(env, loader);
    GError *error_g = (GError *)error;
    return (jboolean) (gdk_pixbuf_loader_close (loader_g, &error_g));
}


#ifdef __cplusplus
}

#endif
