/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gconf/gconf.h>

#ifndef _Included_org_gnu_gconf_ConfEntry
#define _Included_org_gnu_gconf_ConfEntry
#ifdef __cplusplus
extern "C" {
#endif
/*
 * Class:     org_gnu_gconf_ConfEntry
 * Method:    gconf_entry_new_nocopy
 * Signature: (Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfEntry_gconf_1entry_1new_1nocopy
  (JNIEnv *env, jclass cls, jstring key, jint val)
{
	gchar* str = (gchar*)(*env)->GetStringUTFChars(env, key, NULL);
	jint ret = (jint)gconf_entry_new_nocopy(str, (GConfValue*)val);
	(*env)->ReleaseStringUTFChars(env, key, str);
	return ret;
}

/*
 * Class:     org_gnu_gconf_ConfEntry
 * Method:    gconf_entry_get_key
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gconf_ConfEntry_gconf_1entry_1get_1key
  (JNIEnv *env, jclass cls, jint entry)
{
	return (*env)->NewStringUTF(env, gconf_entry_get_key((GConfEntry*)entry));
}

/*
 * Class:     org_gnu_gconf_ConfEntry
 * Method:    gconf_entry_get_value
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfEntry_gconf_1entry_1get_1value
  (JNIEnv *env, jclass cls, jint entry)
{
	return (jint)gconf_entry_get_value((GConfEntry*)entry);
}

/*
 * Class:     org_gnu_gconf_ConfEntry
 * Method:    gconf_entry_steal_value
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gconf_ConfEntry_gconf_1entry_1steal_1value
  (JNIEnv *env, jclass cls, jint entry)
{
	return (jint)gconf_entry_steal_value((GConfEntry*)entry);
}

/*
 * Class:     org_gnu_gconf_ConfEntry
 * Method:    gconf_entry_get_is_default
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gconf_ConfEntry_gconf_1entry_1get_1is_1default
  (JNIEnv *env, jclass cls, jint entry)
{
	return (jboolean)gconf_entry_get_is_default((GConfEntry*)entry);
}

/*
 * Class:     org_gnu_gconf_ConfEntry
 * Method:    gconf_entry_get_schema_name
 * Signature: (I)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_org_gnu_gconf_ConfEntry_gconf_1entry_1get_1schema_1name
  (JNIEnv *env, jclass cls, jint entry)
{
	return (*env)->NewStringUTF(env, gconf_entry_get_schema_name((GConfEntry*)entry));
}

/*
 * Class:     org_gnu_gconf_ConfEntry
 * Method:    gconf_entry_set_is_default
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfEntry_gconf_1entry_1set_1is_1default
  (JNIEnv *env, jclass cls, jint entry, jboolean isDefault)
{
	gconf_entry_set_is_default((GConfEntry*)entry, (gboolean)isDefault);
}

/*
 * Class:     org_gnu_gconf_ConfEntry
 * Method:    gconf_entry_set_schema_name
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfEntry_gconf_1entry_1set_1schema_1name
  (JNIEnv *env, jclass cls, jint entry, jstring name)
{
	gchar *str = (gchar*)(*env)->GetStringUTFChars(env, name, NULL);
	gconf_entry_set_schema_name((GConfEntry*)entry, str);
	(*env)->ReleaseStringUTFChars(env, name, str);
}

/*
 * Class:     org_gnu_gconf_ConfEntry
 * Method:    gconf_entry_set_value_nocopy
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gconf_ConfEntry_gconf_1entry_1set_1value_1nocopy
  (JNIEnv *env, jclass cls, jint entry, jint val)
{
	gconf_entry_set_value_nocopy((GConfEntry*)entry, (GConfValue*)val);
}

#ifdef __cplusplus
}
#endif
#endif
