/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <sys/types.h>
#include <gtk/gtk.h>


#ifndef _Included_org_gnu_gtk_ToggleActionEntry
#define _Included_org_gnu_gtk_ToggleActionEntry
#ifdef __cplusplus
extern "C" {
#endif


void handleCallback(GtkAction* action, gpointer userData);

/*
 * Class:     org_gnu_gtk_ToggleActionEntry
 * Method:    allocate
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtk_ToggleActionEntry_allocate
  (JNIEnv *env, jclass cls)
{
	GtkToggleActionEntry* entry = (GtkToggleActionEntry*)g_malloc(sizeof(GtkToggleActionEntry));
	entry->callback = G_CALLBACK(handleCallback);
	return (jint)entry;
}

/*
 * Class:     org_gnu_gtk_ToggleActionEntry
 * Method:    free
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleActionEntry_free
  (JNIEnv *env, jclass cls, jint entry)
{
	GtkToggleActionEntry* e = (GtkToggleActionEntry*)entry;
	g_free(e);
}

/*
 * Class:     org_gnu_gtk_ToggleActionEntry
 * Method:    setName
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleActionEntry_setName
  (JNIEnv *env, jclass cls, jint entry, jstring name)
{
	if (NULL == name) {
		((GtkActionEntry*)entry)->name = NULL;
	} else {
		gchar* n = (gchar*)(*env)->GetStringUTFChars(env, name, NULL);
		((GtkToggleActionEntry*)entry)->name = n;
	}
}

/*
 * Class:     org_gnu_gtk_ToggleActionEntry
 * Method:    setStockId
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleActionEntry_setStockId
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkActionEntry*)entry)->stock_id = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkToggleActionEntry*)entry)->stock_id = v;
	}
}

/*
 * Class:     org_gnu_gtk_ToggleActionEntry
 * Method:    setLabel
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleActionEntry_setLabel
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkActionEntry*)entry)->label = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkToggleActionEntry*)entry)->label = v;
	}
}

/*
 * Class:     org_gnu_gtk_ToggleActionEntry
 * Method:    setAccelerator
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleActionEntry_setAccelerator
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkActionEntry*)entry)->accelerator = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkToggleActionEntry*)entry)->accelerator = v;
	}
}

/*
 * Class:     org_gnu_gtk_ToggleActionEntry
 * Method:    setTooltip
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleActionEntry_setTooltip
  (JNIEnv *env, jclass cls, jint entry, jstring value)
{
	if (NULL == value) {
		((GtkActionEntry*)entry)->tooltip = NULL;
	} else {
		gchar* v = (gchar*)(*env)->GetStringUTFChars(env, value, NULL);
		((GtkToggleActionEntry*)entry)->tooltip = v;
	}
}

/*
 * Class:     org_gnu_gtk_ToggleActionEntry
 * Method:    setActive
 * Signature: (IZ)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtk_ToggleActionEntry_setActive
  (JNIEnv *env, jclass cls, jint entry, jboolean active)
{
	((GtkToggleActionEntry*)entry)->is_active = (gboolean)active;
}

/*
 * Class:     org_gnu_gtk_ToggleActionEntry
 * Method:    getActive
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtk_ToggleActionEntry_getActive
  (JNIEnv *env, jclass cls, jint entry)
{
	return (jboolean)((GtkToggleActionEntry*)entry)->is_active;
}

#ifdef __cplusplus
}
#endif
#endif
