/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2002 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 *
 * Generation date: 2002-08-01 07:00:35 EDT
 */

#include <jni.h>
#include <sys/types.h>
#include <gdk/gdk.h>
#ifdef __cplusplus
extern "C" 
{
#endif

JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_allocHandle (JNIEnv *env, jclass cls) 
{
    GdkColor* handle = g_malloc(sizeof(GdkColor));
    return (jint)handle;
}

JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_freeHandle(JNIEnv *env, jclass cls, jint handle) 
{
    g_free((void*)handle);
}
    

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    /*
     * Class:     org.gnu.gdk.Color
     * Method:    getPixel
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_getPixel (JNIEnv *env, jclass cls, jint obj) 
    {
        GdkColor *obj_g = (GdkColor *)obj;
        return (jint)obj_g->pixel;
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    getRed
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_getRed (JNIEnv *env, jclass cls, jint obj) 
    {
        GdkColor *obj_g = (GdkColor *)obj;
        return (jint)obj_g->red;
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    setRed
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_setRed (JNIEnv *env, jclass cls, jint obj, jint red) 
    {
        GdkColor *obj_g = (GdkColor *)obj;
        obj_g->red = (guint16)red;
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    getGreen
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_getGreen (JNIEnv *env, jclass cls, jint obj) 
    {
        GdkColor *obj_g = (GdkColor *)obj;
        return (jint)obj_g->green;
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    setGreen
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_setGreen (JNIEnv *env, jclass cls, jint obj, jint green) 
    {
        GdkColor *obj_g = (GdkColor *)obj;
        obj_g->green = (guint16)green;
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    getBlue
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_getBlue (JNIEnv *env, jclass cls, jint obj) 
    {
        GdkColor *obj_g = (GdkColor *)obj;
        return (jint)obj_g->blue;
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    setBlue
     * Signature: (II)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_setBlue (JNIEnv *env, jclass cls, jint obj, jint blue) 
    {
        GdkColor *obj_g = (GdkColor *)obj;
        obj_g->blue = (guint16)blue;
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    gdk_color_get_type
     * Signature: ()I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_gdk_1color_1get_1type (JNIEnv *env, jclass cls) 
    {
        return (jint)gdk_color_get_type ();
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    gdk_color_copy
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_gdk_1color_1copy (JNIEnv *env, jclass cls, jint 
        color) 
    {
        GdkColor *color_g = (GdkColor *)color;
        return (jint)gdk_color_copy (color_g);
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    gdk_color_free
     * Signature: (I)V
     */
    JNIEXPORT void JNICALL Java_org_gnu_gdk_Color_gdk_1color_1free (JNIEnv *env, jclass cls, jint 
        color) 
    {
        GdkColor *color_g = (GdkColor *)color;
        gdk_color_free (color_g);
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    gdk_color_parse
     * Signature: (java.lang.String;I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_gdk_1color_1parse (JNIEnv *env, jclass cls, 
        jstring spec, jint color) 
    {
        const gchar* spec_g = (*env)->GetStringUTFChars(env, spec, 0);
        GdkColor *color_g = (GdkColor *)color;
        jint result_j = (jint) (gdk_color_parse (spec_g, color_g));
        (*env)->ReleaseStringUTFChars(env, spec, spec_g);
        return result_j;
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    gdk_color_hash
     * Signature: (I)I
     */
    JNIEXPORT jint JNICALL Java_org_gnu_gdk_Color_gdk_1color_1hash (JNIEnv *env, jclass cls, jint 
        colora) 
    {
        GdkColor *colora_g = (GdkColor *)colora;
        jint result_j = (jint) (gdk_color_hash (colora_g));
        return result_j;
    }

    /*
     * Class:     org.gnu.gdk.Color
     * Method:    gdk_color_equal
     * Signature: (II)Z
     */
    JNIEXPORT jboolean JNICALL Java_org_gnu_gdk_Color_gdk_1color_1equal (JNIEnv *env, jclass cls, 
        jint colora, jint colorb) 
    {
        GdkColor *colora_g = (GdkColor *)colora;
        GdkColor *colorb_g = (GdkColor *)colorb;
        jboolean result_j = (jboolean) (gdk_color_equal (colora_g, colorb_g));
        return result_j;
    }

    /****************************************
     * END OF GENERATED CODE
     ****************************************/
#ifdef __cplusplus
}

#endif
