/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <gdk/gdk.h>
#include "jg_jnu.h"

#ifdef __cplusplus
extern "C" 
{
#endif

/*
 * Class:     org.gnu.gdk.Pango
 * Method:    gdk_pango_context_get
 */
JNIEXPORT jobject JNICALL Java_org_gnu_gdk_Pango_gdk_1pango_1context_1get (JNIEnv *env, jclass cls)
{
    return getHandleFromPointer(env, gdk_pango_context_get ());
}

/*
 * Class:     org.gnu.gdk.Pango
 * Method:    gdk_pango_context_set_colormap
 */
JNIEXPORT void JNICALL Java_org_gnu_gdk_Pango_gdk_1pango_1context_1set_1colormap (JNIEnv *env, 
    jclass cls, jobject context, jobject colormap) 
{
    PangoContext *context_g = (PangoContext *)getPointerFromHandle(env, context);
    GdkColormap *colormap_g = (GdkColormap *)getPointerFromHandle(env, colormap);
    gdk_pango_context_set_colormap (context_g, colormap_g);
}


#ifdef __cplusplus
}

#endif
