/* rygel-wma-transcoder.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-wma-transcoder.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gst/gst.h>
#include <libgupnp-av/gupnp-av.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_TRANSCODER (rygel_transcoder_get_type ())
#define RYGEL_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoder))
#define RYGEL_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))
#define RYGEL_IS_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODER))
#define RYGEL_IS_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODER))
#define RYGEL_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODER, RygelTranscoderClass))

typedef struct _RygelTranscoder RygelTranscoder;
typedef struct _RygelTranscoderClass RygelTranscoderClass;
typedef struct _RygelTranscoderPrivate RygelTranscoderPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_WMA_TRANSCODER (rygel_wma_transcoder_get_type ())
#define RYGEL_WMA_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMA_TRANSCODER, RygelWMATranscoder))
#define RYGEL_WMA_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMA_TRANSCODER, RygelWMATranscoderClass))
#define RYGEL_IS_WMA_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMA_TRANSCODER))
#define RYGEL_IS_WMA_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMA_TRANSCODER))
#define RYGEL_WMA_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMA_TRANSCODER, RygelWMATranscoderClass))

typedef struct _RygelWMATranscoder RygelWMATranscoder;
typedef struct _RygelWMATranscoderClass RygelWMATranscoderClass;
typedef struct _RygelWMATranscoderPrivate RygelWMATranscoderPrivate;

#define RYGEL_TYPE_WMA_TRANSCODER_BIN (rygel_wma_transcoder_bin_get_type ())
#define RYGEL_WMA_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_WMA_TRANSCODER_BIN, RygelWMATranscoderBin))
#define RYGEL_WMA_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_WMA_TRANSCODER_BIN, RygelWMATranscoderBinClass))
#define RYGEL_IS_WMA_TRANSCODER_BIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_WMA_TRANSCODER_BIN))
#define RYGEL_IS_WMA_TRANSCODER_BIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_WMA_TRANSCODER_BIN))
#define RYGEL_WMA_TRANSCODER_BIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_WMA_TRANSCODER_BIN, RygelWMATranscoderBinClass))

typedef struct _RygelWMATranscoderBin RygelWMATranscoderBin;
typedef struct _RygelWMATranscoderBinClass RygelWMATranscoderBinClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;
typedef struct _RygelAudioItemPrivate RygelAudioItemPrivate;

#define TYPE_ENDIANNESS (endianness_get_type ())

#define RYGEL_TYPE_L16_TRANSCODER (rygel_l16_transcoder_get_type ())
#define RYGEL_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16Transcoder))
#define RYGEL_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))
#define RYGEL_IS_L16_TRANSCODER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_IS_L16_TRANSCODER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_L16_TRANSCODER))
#define RYGEL_L16_TRANSCODER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_L16_TRANSCODER, RygelL16TranscoderClass))

typedef struct _RygelL16Transcoder RygelL16Transcoder;
typedef struct _RygelL16TranscoderClass RygelL16TranscoderClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))

struct _RygelTranscoder {
	GObject parent_instance;
	RygelTranscoderPrivate * priv;
};

struct _RygelTranscoderClass {
	GObjectClass parent_class;
	GstElement* (*create_source) (RygelTranscoder* self, RygelMediaItem* item, GstElement* src, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
	guint (*get_distance) (RygelTranscoder* self, RygelMediaItem* item);
};

struct _RygelWMATranscoder {
	RygelTranscoder parent_instance;
	RygelWMATranscoderPrivate * priv;
};

struct _RygelWMATranscoderClass {
	RygelTranscoderClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	gchar* date;
	gchar* mime_type;
	gchar* dlna_profile;
	GRegex* address_regex;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*streamable) (RygelMediaItem* self);
	void (*add_uri) (RygelMediaItem* self, const gchar* uri);
	GUPnPDIDLLiteResource* (*add_resource) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
	void (*add_proxy_resources) (RygelMediaItem* self, RygelHTTPServer* server, GUPnPDIDLLiteItem* didl_item, GError** error);
	GUPnPProtocolInfo* (*get_protocol_info) (RygelMediaItem* self, const gchar* uri, const gchar* protocol);
	void (*add_resources) (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, gboolean allow_internal, GError** error);
};

struct _RygelAudioItem {
	RygelMediaItem parent_instance;
	RygelAudioItemPrivate * priv;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint channels;
};

struct _RygelAudioItemClass {
	RygelMediaItemClass parent_class;
};

typedef enum  {
	ENDIANNESS_LITTLE = G_LITTLE_ENDIAN,
	ENDIANNESS_BIG = G_BIG_ENDIAN
} Endianness;


static gpointer rygel_wma_transcoder_parent_class = NULL;

GType rygel_transcoder_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_wma_transcoder_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_WMA_TRANSCODER_DUMMY_PROPERTY
};
#define RYGEL_WMA_TRANSCODER_BITRATE 64
#define RYGEL_WMA_TRANSCODER_CONVERT_SINK_PAD "convert-sink-pad"
RygelWMATranscoder* rygel_wma_transcoder_new (void);
RygelWMATranscoder* rygel_wma_transcoder_construct (GType object_type);
#define RYGEL_AUDIO_ITEM_UPNP_CLASS "object.item.audioItem"
RygelTranscoder* rygel_transcoder_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* upnp_class);
static GstElement* rygel_wma_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error);
RygelWMATranscoderBin* rygel_wma_transcoder_bin_new (RygelMediaItem* item, GstElement* src, RygelWMATranscoder* transcoder, GError** error);
RygelWMATranscoderBin* rygel_wma_transcoder_bin_construct (GType object_type, RygelMediaItem* item, GstElement* src, RygelWMATranscoder* transcoder, GError** error);
GType rygel_wma_transcoder_bin_get_type (void) G_GNUC_CONST;
static GUPnPDIDLLiteResource* rygel_wma_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
GUPnPDIDLLiteResource* rygel_transcoder_add_resource (RygelTranscoder* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error);
static guint rygel_wma_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item);
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GstElement* rygel_wma_transcoder_create_encoder (RygelWMATranscoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error);
GType endianness_get_type (void) G_GNUC_CONST;
RygelL16Transcoder* rygel_l16_transcoder_new (Endianness endianness);
RygelL16Transcoder* rygel_l16_transcoder_construct (GType object_type, Endianness endianness);
GType rygel_l16_transcoder_get_type (void) G_GNUC_CONST;
GstElement* rygel_l16_transcoder_create_encoder (RygelL16Transcoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error);
GstElement* rygel_gst_utils_create_element (const gchar* factoryname, const gchar* name, GError** error);
static inline void _dynamic_set_bitrate4 (GstElement* obj, gint value);


RygelWMATranscoder* rygel_wma_transcoder_construct (GType object_type) {
	RygelWMATranscoder * self = NULL;
#line 31 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	self = (RygelWMATranscoder*) rygel_transcoder_construct (object_type, "audio/x-wma", "WMA", RYGEL_AUDIO_ITEM_UPNP_CLASS);
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	return self;
#line 266 "rygel-wma-transcoder.c"
}


RygelWMATranscoder* rygel_wma_transcoder_new (void) {
#line 30 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	return rygel_wma_transcoder_construct (RYGEL_TYPE_WMA_TRANSCODER);
#line 273 "rygel-wma-transcoder.c"
}


static GstElement* rygel_wma_transcoder_real_create_source (RygelTranscoder* base, RygelMediaItem* item, GstElement* src, GError** error) {
	RygelWMATranscoder * self;
	GstElement* result = NULL;
	RygelMediaItem* _tmp0_;
	GstElement* _tmp1_;
	RygelWMATranscoderBin* _tmp2_;
	RygelWMATranscoderBin* _tmp3_;
	GError * _inner_error_ = NULL;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	self = (RygelWMATranscoder*) base;
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 34 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp0_ = item;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp1_ = src;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp2_ = rygel_wma_transcoder_bin_new (_tmp0_, _tmp1_, self, &_inner_error_);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gst_object_ref_sink (_tmp2_);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp3_ = _tmp2_;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		return NULL;
#line 307 "rygel-wma-transcoder.c"
	}
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gst_object_ref_sink (_tmp3_);
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	result = (GstElement*) _tmp3_;
#line 37 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	return result;
#line 315 "rygel-wma-transcoder.c"
}


static GUPnPDIDLLiteResource* rygel_wma_transcoder_real_add_resource (RygelTranscoder* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, RygelTranscodeManager* manager, GError** error) {
	RygelWMATranscoder * self;
	GUPnPDIDLLiteResource* result = NULL;
	GUPnPDIDLLiteItem* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelTranscodeManager* _tmp2_;
	GUPnPDIDLLiteResource* _tmp3_ = NULL;
	GUPnPDIDLLiteResource* resource;
	GError * _inner_error_ = NULL;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	self = (RygelWMATranscoder*) base;
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	g_return_val_if_fail (didl_item != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 40 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	g_return_val_if_fail (manager != NULL, NULL);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp0_ = didl_item;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp1_ = item;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp2_ = manager;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp3_ = RYGEL_TRANSCODER_CLASS (rygel_wma_transcoder_parent_class)->add_resource (RYGEL_TRANSCODER (self), _tmp0_, _tmp1_, _tmp2_, &_inner_error_);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	resource = _tmp3_;
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 44 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		return NULL;
#line 352 "rygel-wma-transcoder.c"
	}
#line 45 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	if (resource == NULL) {
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		result = NULL;
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		_g_object_unref0 (resource);
#line 46 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		return result;
#line 362 "rygel-wma-transcoder.c"
	}
#line 49 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gupnp_didl_lite_resource_set_bitrate (resource, (RYGEL_WMA_TRANSCODER_BITRATE * 1000) / 8);
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	result = resource;
#line 51 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	return result;
#line 370 "rygel-wma-transcoder.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	return self ? g_object_ref (self) : NULL;
#line 377 "rygel-wma-transcoder.c"
}


static guint rygel_wma_transcoder_real_get_distance (RygelTranscoder* base, RygelMediaItem* item) {
	RygelWMATranscoder * self;
	guint result = 0U;
	RygelMediaItem* _tmp0_;
	RygelMediaItem* _tmp2_;
	RygelAudioItem* _tmp3_;
	RygelAudioItem* audio_item;
	guint _tmp4_;
	guint distance;
	RygelAudioItem* _tmp5_;
	gint _tmp6_;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	self = (RygelWMATranscoder*) base;
#line 54 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, 0U);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp0_ = item;
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	if (!RYGEL_IS_AUDIO_ITEM (_tmp0_)) {
#line 400 "rygel-wma-transcoder.c"
		guint _tmp1_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		_tmp1_ = G_MAXUINT;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		result = _tmp1_;
#line 56 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		return result;
#line 408 "rygel-wma-transcoder.c"
	}
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp2_ = item;
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp3_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp2_) ? ((RygelAudioItem*) _tmp2_) : NULL);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	audio_item = _tmp3_;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp4_ = 0;
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	distance = _tmp4_;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp5_ = audio_item;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp6_ = _tmp5_->bitrate;
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	if (_tmp6_ > 0) {
#line 426 "rygel-wma-transcoder.c"
		guint _tmp7_;
		RygelAudioItem* _tmp8_;
		gint _tmp9_;
		gint _tmp10_ = 0;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		_tmp7_ = distance;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		_tmp8_ = audio_item;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		_tmp9_ = _tmp8_->bitrate;
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		_tmp10_ = abs (_tmp9_ - RYGEL_WMA_TRANSCODER_BITRATE);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		distance = _tmp7_ + _tmp10_;
#line 441 "rygel-wma-transcoder.c"
	}
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	result = distance;
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_g_object_unref0 (audio_item);
#line 66 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	return result;
#line 449 "rygel-wma-transcoder.c"
}


static inline void _dynamic_set_bitrate4 (GstElement* obj, gint value) {
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	g_object_set (obj, "bitrate", value, NULL);
#line 456 "rygel-wma-transcoder.c"
}


static gpointer _gst_object_ref0 (gpointer self) {
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	return self ? gst_object_ref (self) : NULL;
#line 463 "rygel-wma-transcoder.c"
}


GstElement* rygel_wma_transcoder_create_encoder (RygelWMATranscoder* self, RygelMediaItem* item, const gchar* src_pad_name, const gchar* sink_pad_name, GError** error) {
	GstElement* result = NULL;
	RygelL16Transcoder* _tmp0_;
	RygelL16Transcoder* l16_transcoder;
	RygelL16Transcoder* _tmp1_;
	RygelMediaItem* _tmp2_;
	GstElement* _tmp3_ = NULL;
	GstElement* convert;
	GstElement* _tmp4_ = NULL;
	GstElement* encoder;
	GstElement* _tmp5_;
	GstBin* _tmp6_;
	GstBin* bin;
	GstBin* _tmp7_;
	GstElement* _tmp8_;
	GstElement* _tmp9_;
	GstElement* _tmp10_;
	GstElement* _tmp11_;
	GstElement* _tmp12_;
	GstElement* _tmp13_;
	GstElement* _tmp14_;
	GstPad* _tmp15_ = NULL;
	GstPad* pad;
	const gchar* _tmp16_;
	GstPad* _tmp17_;
	GstGhostPad* _tmp18_;
	GstGhostPad* ghost;
	GstBin* _tmp19_;
	GstGhostPad* _tmp20_;
	GstPad* _tmp21_;
	GstElement* _tmp22_;
	GstPad* _tmp23_ = NULL;
	const gchar* _tmp24_;
	GstPad* _tmp25_;
	GstGhostPad* _tmp26_;
	GstBin* _tmp27_;
	GstGhostPad* _tmp28_;
	GstPad* _tmp29_;
	GError * _inner_error_ = NULL;
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 69 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp0_ = rygel_l16_transcoder_new (ENDIANNESS_LITTLE);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	l16_transcoder = _tmp0_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp1_ = l16_transcoder;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp2_ = item;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp3_ = rygel_l16_transcoder_create_encoder (_tmp1_, _tmp2_, NULL, RYGEL_WMA_TRANSCODER_CONVERT_SINK_PAD, &_inner_error_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	convert = _tmp3_;
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		_g_object_unref0 (l16_transcoder);
#line 74 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		return NULL;
#line 530 "rygel-wma-transcoder.c"
	}
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp4_ = rygel_gst_utils_create_element ("ffenc_wmav2", "ffenc_wmav2", &_inner_error_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	encoder = _tmp4_;
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	if (_inner_error_ != NULL) {
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		g_propagate_error (error, _inner_error_);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		_gst_object_unref0 (convert);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		_g_object_unref0 (l16_transcoder);
#line 79 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
		return NULL;
#line 546 "rygel-wma-transcoder.c"
	}
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp5_ = encoder;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_dynamic_set_bitrate4 (_tmp5_, RYGEL_WMA_TRANSCODER_BITRATE * 1000);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp6_ = (GstBin*) gst_bin_new ("wma-encoder-bin");
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gst_object_ref_sink (_tmp6_);
#line 83 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	bin = _tmp6_;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp7_ = bin;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp8_ = convert;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp9_ = _gst_object_ref0 (_tmp8_);
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp10_ = encoder;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp11_ = _gst_object_ref0 (_tmp10_);
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gst_bin_add_many (_tmp7_, _tmp9_, _tmp11_, NULL);
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp12_ = convert;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp13_ = encoder;
#line 85 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gst_element_link (_tmp12_, _tmp13_);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp14_ = convert;
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp15_ = gst_element_get_static_pad (_tmp14_, RYGEL_WMA_TRANSCODER_CONVERT_SINK_PAD);
#line 87 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	pad = _tmp15_;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp16_ = sink_pad_name;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp17_ = pad;
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp18_ = (GstGhostPad*) gst_ghost_pad_new (_tmp16_, _tmp17_);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gst_object_ref_sink (_tmp18_);
#line 88 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	ghost = _tmp18_;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp19_ = bin;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp20_ = ghost;
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp21_ = _gst_object_ref0 ((GstPad*) _tmp20_);
#line 89 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp19_, _tmp21_);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp22_ = encoder;
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp23_ = gst_element_get_static_pad (_tmp22_, "src");
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_gst_object_unref0 (pad);
#line 91 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	pad = _tmp23_;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp24_ = src_pad_name;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp25_ = pad;
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp26_ = (GstGhostPad*) gst_ghost_pad_new (_tmp24_, _tmp25_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gst_object_ref_sink (_tmp26_);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 92 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	ghost = _tmp26_;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp27_ = bin;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp28_ = ghost;
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_tmp29_ = _gst_object_ref0 ((GstPad*) _tmp28_);
#line 93 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	gst_element_add_pad ((GstElement*) _tmp27_, _tmp29_);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	result = (GstElement*) bin;
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_gst_object_unref0 (ghost);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_gst_object_unref0 (pad);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_gst_object_unref0 (encoder);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_gst_object_unref0 (convert);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	_g_object_unref0 (l16_transcoder);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	return result;
#line 642 "rygel-wma-transcoder.c"
}


static void rygel_wma_transcoder_class_init (RygelWMATranscoderClass * klass) {
#line 25 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	rygel_wma_transcoder_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->create_source = rygel_wma_transcoder_real_create_source;
#line 25 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->add_resource = rygel_wma_transcoder_real_add_resource;
#line 25 "/home/jens/Source/rygel/src/rygel/rygel-wma-transcoder.vala"
	RYGEL_TRANSCODER_CLASS (klass)->get_distance = rygel_wma_transcoder_real_get_distance;
#line 655 "rygel-wma-transcoder.c"
}


static void rygel_wma_transcoder_instance_init (RygelWMATranscoder * self) {
}


GType rygel_wma_transcoder_get_type (void) {
	static volatile gsize rygel_wma_transcoder_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_wma_transcoder_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelWMATranscoderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_wma_transcoder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelWMATranscoder), 0, (GInstanceInitFunc) rygel_wma_transcoder_instance_init, NULL };
		GType rygel_wma_transcoder_type_id;
		rygel_wma_transcoder_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODER, "RygelWMATranscoder", &g_define_type_info, 0);
		g_once_init_leave (&rygel_wma_transcoder_type_id__volatile, rygel_wma_transcoder_type_id);
	}
	return rygel_wma_transcoder_type_id__volatile;
}



