/* rygel-content-directory.c generated by valac 0.14.0, the Vala compiler
 * generated from rygel-content-directory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *         Jorn Baayen <jorn@openedhand.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_IMPORT_RESOURCE (rygel_import_resource_get_type ())
#define RYGEL_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResource))
#define RYGEL_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))
#define RYGEL_IS_IMPORT_RESOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IS_IMPORT_RESOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_IMPORT_RESOURCE))
#define RYGEL_IMPORT_RESOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_IMPORT_RESOURCE, RygelImportResourceClass))

typedef struct _RygelImportResource RygelImportResource;
typedef struct _RygelImportResourceClass RygelImportResourceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_PLUGIN (rygel_plugin_get_type ())
#define RYGEL_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLUGIN, RygelPlugin))
#define RYGEL_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLUGIN, RygelPluginClass))
#define RYGEL_IS_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLUGIN))
#define RYGEL_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLUGIN))
#define RYGEL_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLUGIN, RygelPluginClass))

typedef struct _RygelPlugin RygelPlugin;
typedef struct _RygelPluginClass RygelPluginClass;

#define RYGEL_TYPE_MEDIA_SERVER_PLUGIN (rygel_media_server_plugin_get_type ())
#define RYGEL_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPlugin))
#define RYGEL_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_IS_MEDIA_SERVER_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER_PLUGIN))
#define RYGEL_MEDIA_SERVER_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER_PLUGIN, RygelMediaServerPluginClass))

typedef struct _RygelMediaServerPlugin RygelMediaServerPlugin;
typedef struct _RygelMediaServerPluginClass RygelMediaServerPluginClass;
typedef struct _RygelPluginPrivate RygelPluginPrivate;

#define RYGEL_TYPE_RESOURCE_INFO (rygel_resource_info_get_type ())
#define RYGEL_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfo))
#define RYGEL_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))
#define RYGEL_IS_RESOURCE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_IS_RESOURCE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RESOURCE_INFO))
#define RYGEL_RESOURCE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RESOURCE_INFO, RygelResourceInfoClass))

typedef struct _RygelResourceInfo RygelResourceInfo;
typedef struct _RygelResourceInfoClass RygelResourceInfoClass;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;
typedef struct _RygelMediaServerPluginPrivate RygelMediaServerPluginPrivate;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_MEDIA_QUERY_ACTION (rygel_media_query_action_get_type ())
#define RYGEL_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryAction))
#define RYGEL_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))
#define RYGEL_IS_MEDIA_QUERY_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_IS_MEDIA_QUERY_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_QUERY_ACTION))
#define RYGEL_MEDIA_QUERY_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_QUERY_ACTION, RygelMediaQueryActionClass))

typedef struct _RygelMediaQueryAction RygelMediaQueryAction;
typedef struct _RygelMediaQueryActionClass RygelMediaQueryActionClass;

#define RYGEL_TYPE_BROWSE (rygel_browse_get_type ())
#define RYGEL_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_BROWSE, RygelBrowse))
#define RYGEL_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_BROWSE, RygelBrowseClass))
#define RYGEL_IS_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_BROWSE))
#define RYGEL_IS_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_BROWSE))
#define RYGEL_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_BROWSE, RygelBrowseClass))

typedef struct _RygelBrowse RygelBrowse;
typedef struct _RygelBrowseClass RygelBrowseClass;

#define RYGEL_TYPE_SEARCH (rygel_search_get_type ())
#define RYGEL_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH, RygelSearch))
#define RYGEL_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH, RygelSearchClass))
#define RYGEL_IS_SEARCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH))
#define RYGEL_IS_SEARCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH))
#define RYGEL_SEARCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH, RygelSearchClass))

typedef struct _RygelSearch RygelSearch;
typedef struct _RygelSearchClass RygelSearchClass;

#define RYGEL_TYPE_ITEM_CREATOR (rygel_item_creator_get_type ())
#define RYGEL_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreator))
#define RYGEL_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))
#define RYGEL_IS_ITEM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_IS_ITEM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_CREATOR))
#define RYGEL_ITEM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_CREATOR, RygelItemCreatorClass))

typedef struct _RygelItemCreator RygelItemCreator;
typedef struct _RygelItemCreatorClass RygelItemCreatorClass;

#define RYGEL_TYPE_ITEM_DESTROYER (rygel_item_destroyer_get_type ())
#define RYGEL_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyer))
#define RYGEL_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))
#define RYGEL_IS_ITEM_DESTROYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_IS_ITEM_DESTROYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ITEM_DESTROYER))
#define RYGEL_ITEM_DESTROYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ITEM_DESTROYER, RygelItemDestroyerClass))

typedef struct _RygelItemDestroyer RygelItemDestroyer;
typedef struct _RygelItemDestroyerClass RygelItemDestroyerClass;
typedef struct _RygelImportResourcePrivate RygelImportResourcePrivate;

#define RYGEL_TYPE_TRANSFER_STATUS (rygel_transfer_status_get_type ())
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
typedef struct _Block1Data Block1Data;

/**
 * Errors used by ContentDirectory and deriving classes.
 */
typedef enum  {
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_OBJECT = 701,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_SORT_CRITERIA = 709,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_OBJECT = 711,
	RYGEL_CONTENT_DIRECTORY_ERROR_BAD_METADATA = 712,
	RYGEL_CONTENT_DIRECTORY_ERROR_RESTRICTED_PARENT = 713,
	RYGEL_CONTENT_DIRECTORY_ERROR_NO_SUCH_DESTINATION_RESOURCE = 718,
	RYGEL_CONTENT_DIRECTORY_ERROR_CANT_PROCESS = 720,
	RYGEL_CONTENT_DIRECTORY_ERROR_INVALID_ARGS = 402
} RygelContentDirectoryError;
#define RYGEL_CONTENT_DIRECTORY_ERROR rygel_content_directory_error_quark ()
struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	gchar* feature_list;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
};

struct _RygelContentDirectoryPrivate {
	GeeArrayList* updated_containers;
	GeeArrayList* active_imports;
	GeeArrayList* finished_imports;
	gboolean clear_updated_containers;
	guint update_notify_id;
};

struct _RygelPlugin {
	GUPnPResourceFactory parent_instance;
	RygelPluginPrivate * priv;
	gchar* name;
	gchar* title;
	gchar* description;
	gchar* desc_path;
	GeeArrayList* resource_infos;
	GeeArrayList* icon_infos;
	GeeArrayList* default_icons;
};

struct _RygelPluginClass {
	GUPnPResourceFactoryClass parent_class;
};

struct _RygelMediaServerPlugin {
	RygelPlugin parent_instance;
	RygelMediaServerPluginPrivate * priv;
	RygelMediaContainer* root_container;
};

struct _RygelMediaServerPluginClass {
	RygelPluginClass parent_class;
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

typedef enum  {
	RYGEL_TRANSFER_STATUS_COMPLETED,
	RYGEL_TRANSFER_STATUS_ERROR,
	RYGEL_TRANSFER_STATUS_IN_PROGRESS,
	RYGEL_TRANSFER_STATUS_STOPPED
} RygelTransferStatus;

struct _RygelImportResource {
	GObject parent_instance;
	RygelImportResourcePrivate * priv;
	gchar* source_uri;
	gchar* destination_uri;
	guint32 transfer_id;
	RygelTransferStatus status;
	gint64 bytes_copied;
	gint64 bytes_total;
};

struct _RygelImportResourceClass {
	GObjectClass parent_class;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	gchar* id;
	gchar* ref_id;
	gchar* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
	GUPnPDIDLLiteObject* (*serialize) (RygelMediaObject* self, GUPnPDIDLLiteWriter* writer, RygelHTTPServer* http_server, GError** error);
	gint (*compare_by_property) (RygelMediaObject* self, RygelMediaObject* media_object, const gchar* property);
	GUPnPOCMFlags (*get_ocm_flags) (RygelMediaObject* self);
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	gint child_count;
	guint32 update_id;
	gint64 storage_used;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObjects* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*find_object) (RygelMediaContainer* self, const gchar* id, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	RygelMediaObject* (*find_object_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _Block1Data {
	int _ref_count_;
	RygelContentDirectory * self;
	RygelImportResource* import;
};


static gpointer rygel_content_directory_parent_class = NULL;

GQuark rygel_content_directory_error_quark (void);
GType rygel_content_directory_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_import_resource_get_type (void) G_GNUC_CONST;
#define RYGEL_CONTENT_DIRECTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryPrivate))
enum  {
	RYGEL_CONTENT_DIRECTORY_DUMMY_PROPERTY
};
#define RYGEL_CONTENT_DIRECTORY_UPNP_ID "urn:upnp-org:serviceId:ContentDirectory"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE "urn:schemas-upnp-org:service:ContentDirectory:2"
#define RYGEL_CONTENT_DIRECTORY_UPNP_TYPE_V1 "urn:schemas-upnp-org:service:ContentDirectory:1"
#define RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH "xml/ContentDirectory.xml"
static void rygel_content_directory_real_constructed (GObject* base);
GType rygel_plugin_get_type (void) G_GNUC_CONST;
GType rygel_media_server_plugin_get_type (void) G_GNUC_CONST;
gpointer rygel_resource_info_ref (gpointer instance);
void rygel_resource_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_resource_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_resource_info (GValue* value, gpointer v_object);
void rygel_value_take_resource_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_resource_info (const GValue* value);
GType rygel_resource_info_get_type (void) G_GNUC_CONST;
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
void rygel_value_take_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void) G_GNUC_CONST;
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const gchar* name);
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const gchar* name);
static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container);
static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action);
static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self);
static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value);
static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self);
GType rygel_state_machine_get_type (void) G_GNUC_CONST;
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
RygelBrowse* rygel_browse_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelBrowse* rygel_browse_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_media_query_action_get_type (void) G_GNUC_CONST;
GType rygel_browse_get_type (void) G_GNUC_CONST;
RygelSearch* rygel_search_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelSearch* rygel_search_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_search_get_type (void) G_GNUC_CONST;
RygelItemCreator* rygel_item_creator_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemCreator* rygel_item_creator_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_creator_get_type (void) G_GNUC_CONST;
RygelItemDestroyer* rygel_item_destroyer_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelItemDestroyer* rygel_item_destroyer_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
GType rygel_item_destroyer_get_type (void) G_GNUC_CONST;
RygelImportResource* rygel_import_resource_new (RygelContentDirectory* content_dir, GUPnPServiceAction* action);
RygelImportResource* rygel_import_resource_construct (GType object_type, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine);
static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self);
static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self);
static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action);
const gchar* rygel_import_resource_get_status_as_string (RygelImportResource* self);
GType rygel_transfer_status_get_type (void) G_GNUC_CONST;
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self);
#define RYGEL_RELATIONAL_EXPRESSION_CAPS "@id,@parentID,@refID,upnp:class," "dc:title,upnp:artist,upnp:album," "dc:creator,upnp:createClass,@childCount"
#define RYGEL_MEDIA_OBJECTS_SORT_CAPS "@id,@parentID,dc:title,upnp:class," "dc:artist,dc:author,upnp:album," "dc:date,upnp:originalTrackNumber"
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self);
static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static gboolean __lambda12_ (Block1Data* _data1_);
static gboolean ___lambda12__gsource_func (gpointer self);
RygelContentDirectory* rygel_content_directory_new (void);
RygelContentDirectory* rygel_content_directory_construct (GType object_type);
static void rygel_content_directory_finalize (GObject* obj);


GQuark rygel_content_directory_error_quark (void) {
	return g_quark_from_static_string ("rygel_content_directory_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return self ? g_object_ref (self) : NULL;
#line 472 "rygel-content-directory.c"
}


static void _rygel_content_directory_on_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_on_container_updated (self, _sender, container);
#line 479 "rygel-content-directory.c"
}


static void _rygel_content_directory_browse_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_browse_cb (self, _sender, action);
#line 486 "rygel-content-directory.c"
}


static void _rygel_content_directory_search_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_search_cb (self, _sender, action);
#line 493 "rygel-content-directory.c"
}


static void _rygel_content_directory_create_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_create_object_cb (self, _sender, action);
#line 500 "rygel-content-directory.c"
}


static void _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_destroy_object_cb (self, _sender, action);
#line 507 "rygel-content-directory.c"
}


static void _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_import_resource_cb (self, _sender, action);
#line 514 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_get_transfer_progress_cb (self, _sender, action);
#line 521 "rygel-content-directory.c"
}


static void _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_stop_transfer_resource_cb (self, _sender, action);
#line 528 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_query_transfer_ids (self, _sender, variable, value);
#line 535 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_get_system_update_id_cb (self, _sender, action);
#line 542 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_system_update_id_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_query_system_update_id (self, _sender, variable, value);
#line 549 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_query_container_update_ids (self, _sender, variable, value);
#line 556 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_get_search_capabilities_cb (self, _sender, action);
#line 563 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_query_search_capabilities (self, _sender, variable, value);
#line 570 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_get_sort_capabilities_cb (self, _sender, action);
#line 577 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_query_sort_capabilities (self, _sender, variable, value);
#line 584 "rygel-content-directory.c"
}


static void _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked (GUPnPService* _sender, GUPnPServiceAction* action, gpointer self) {
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_get_feature_list_cb (self, _sender, action);
#line 591 "rygel-content-directory.c"
}


static void _rygel_content_directory_query_feature_list_gupnp_service_query_variable (GUPnPService* _sender, const gchar* variable, GValue* value, gpointer self) {
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_query_feature_list (self, _sender, variable, value);
#line 598 "rygel-content-directory.c"
}


static void rygel_content_directory_real_constructed (GObject* base) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_;
	GUPnPRootDevice* _tmp1_ = NULL;
	GUPnPRootDevice* _tmp2_;
	GUPnPRootDevice* _tmp3_;
	GUPnPResourceFactory* _tmp4_;
	GUPnPResourceFactory* _tmp5_;
	RygelMediaServerPlugin* _tmp6_;
	RygelMediaServerPlugin* _tmp7_;
	RygelMediaServerPlugin* plugin;
	RygelMediaContainer* _tmp8_;
	RygelMediaContainer* _tmp9_;
	const gchar* _tmp10_;
	RygelHTTPServer* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	RygelMediaContainer* _tmp15_;
	gchar* _tmp16_;
	RygelHTTPServer* _tmp17_;
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self = (RygelContentDirectory*) base;
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = g_cancellable_new ();
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->cancellable);
#line 73 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->cancellable = _tmp0_;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_object_get ((GUPnPService*) self, "root-device", &_tmp1_, NULL);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp2_ = _tmp1_;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp3_ = _tmp2_;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = gupnp_device_info_get_resource_factory ((GUPnPDeviceInfo*) _tmp3_);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp6_ = _g_object_ref0 (RYGEL_IS_MEDIA_SERVER_PLUGIN (_tmp5_) ? ((RygelMediaServerPlugin*) _tmp5_) : NULL);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp7_ = _tmp6_;
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (_tmp3_);
#line 75 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	plugin = _tmp7_;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp8_ = plugin->root_container;
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->root_container);
#line 77 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->root_container = _tmp9_;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp10_ = ((RygelPlugin*) plugin)->name;
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp11_ = rygel_http_server_new (self, _tmp10_);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->http_server);
#line 78 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->http_server = _tmp11_;
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp12_ = gee_array_list_new (RYGEL_TYPE_MEDIA_CONTAINER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->updated_containers);
#line 80 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->priv->updated_containers = _tmp12_;
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp13_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->active_imports);
#line 81 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->priv->active_imports = _tmp13_;
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp14_ = gee_array_list_new (RYGEL_TYPE_IMPORT_RESOURCE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->finished_imports);
#line 82 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->priv->finished_imports = _tmp14_;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp15_ = self->root_container;
#line 84 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object (_tmp15_, "container-updated", (GCallback) _rygel_content_directory_on_container_updated_rygel_media_container_container_updated, self, 0);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp16_ = g_strdup ("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" "<Features xmlns=\"urn:schemas-upnp-org:av:avs\" " "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" " "xsi:schemaLocation=\"urn:schemas-upnp-org:av:avs" "http://www.upnp.org/schemas/av/avs-v1-20060531.xsd\">" "</Features>");
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_free0 (self->feature_list);
#line 86 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->feature_list = _tmp16_;
#line 94 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Browse", (GCallback) _rygel_content_directory_browse_cb_gupnp_service_action_invoked, self, 0);
#line 95 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::Search", (GCallback) _rygel_content_directory_search_cb_gupnp_service_action_invoked, self, 0);
#line 96 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::CreateObject", (GCallback) _rygel_content_directory_create_object_cb_gupnp_service_action_invoked, self, 0);
#line 97 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::DestroyObject", (GCallback) _rygel_content_directory_destroy_object_cb_gupnp_service_action_invoked, self, 0);
#line 98 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::ImportResource", (GCallback) _rygel_content_directory_import_resource_cb_gupnp_service_action_invoked, self, 0);
#line 99 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetTransferProgress", (GCallback) _rygel_content_directory_get_transfer_progress_cb_gupnp_service_action_invoked, self, 0);
#line 101 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::StopTransferResource", (GCallback) _rygel_content_directory_stop_transfer_resource_cb_gupnp_service_action_invoked, self, 0);
#line 104 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::TransferIDs", (GCallback) _rygel_content_directory_query_transfer_ids_gupnp_service_query_variable, self, 0);
#line 107 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSystemUpdateID", (GCallback) _rygel_content_directory_get_system_update_id_cb_gupnp_service_action_invoked, self, 0);
#line 109 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SystemUpdateID", (GCallback) _rygel_content_directory_query_system_update_id_gupnp_service_query_variable, self, 0);
#line 111 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::ContainerUpdateIDs", (GCallback) _rygel_content_directory_query_container_update_ids_gupnp_service_query_variable, self, 0);
#line 115 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSearchCapabilities", (GCallback) _rygel_content_directory_get_search_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 117 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SearchCapabilities", (GCallback) _rygel_content_directory_query_search_capabilities_gupnp_service_query_variable, self, 0);
#line 121 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetSortCapabilities", (GCallback) _rygel_content_directory_get_sort_capabilities_cb_gupnp_service_action_invoked, self, 0);
#line 123 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::SortCapabilities", (GCallback) _rygel_content_directory_query_sort_capabilities_gupnp_service_query_variable, self, 0);
#line 127 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "action-invoked::GetFeatureList", (GCallback) _rygel_content_directory_get_feature_list_cb_gupnp_service_action_invoked, self, 0);
#line 129 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((GUPnPService*) self, "query-variable::FeatureList", (GCallback) _rygel_content_directory_query_feature_list_gupnp_service_query_variable, self, 0);
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp17_ = self->http_server;
#line 131 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) _tmp17_, NULL, NULL);
#line 72 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (plugin);
#line 733 "rygel-content-directory.c"
}


static void rygel_content_directory_browse_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	RygelBrowse* _tmp1_;
	RygelBrowse* browse;
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = rygel_browse_new (self, _tmp0_);
#line 142 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	browse = _tmp1_;
#line 144 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) browse, NULL, NULL);
#line 140 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (browse);
#line 757 "rygel-content-directory.c"
}


static void rygel_content_directory_search_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	RygelSearch* _tmp1_;
	RygelSearch* search;
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = rygel_search_new (self, _tmp0_);
#line 150 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	search = _tmp1_;
#line 152 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) search, NULL, NULL);
#line 148 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (search);
#line 781 "rygel-content-directory.c"
}


static void rygel_content_directory_create_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	RygelItemCreator* _tmp1_;
	RygelItemCreator* creator;
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = rygel_item_creator_new (self, _tmp0_);
#line 158 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	creator = _tmp1_;
#line 160 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) creator, NULL, NULL);
#line 156 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (creator);
#line 805 "rygel-content-directory.c"
}


static void rygel_content_directory_destroy_object_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	RygelItemDestroyer* _tmp1_;
	RygelItemDestroyer* destroyer;
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = rygel_item_destroyer_new (self, _tmp0_);
#line 166 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	destroyer = _tmp1_;
#line 168 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) destroyer, NULL, NULL);
#line 164 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (destroyer);
#line 829 "rygel-content-directory.c"
}


static void _rygel_content_directory_on_import_completed_rygel_state_machine_completed (RygelStateMachine* _sender, gpointer self) {
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_on_import_completed (self, _sender);
#line 836 "rygel-content-directory.c"
}


static void rygel_content_directory_import_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	RygelImportResource* _tmp1_;
	RygelImportResource* import;
	GeeArrayList* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = rygel_import_resource_new (self, _tmp0_);
#line 174 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	import = _tmp1_;
#line 176 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_signal_connect_object ((RygelStateMachine*) import, "completed", (GCallback) _rygel_content_directory_on_import_completed_rygel_state_machine_completed, self, 0);
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp2_ = self->priv->active_imports;
#line 177 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, import);
#line 179 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_state_machine_run ((RygelStateMachine*) import, NULL, NULL);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp3_ = rygel_content_directory_create_transfer_ids (self);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = _tmp3_;
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp4_, NULL);
#line 181 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_free0 (_tmp4_);
#line 172 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (import);
#line 877 "rygel-content-directory.c"
}


static void rygel_content_directory_query_transfer_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 187 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 190 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_create_transfer_ids (self);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = _tmp0_;
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_set_string (value, _tmp1_);
#line 191 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_free0 (_tmp1_);
#line 902 "rygel-content-directory.c"
}


static void rygel_content_directory_get_transfer_progress_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	RygelImportResource* _tmp5_ = NULL;
	RygelImportResource* import;
	RygelImportResource* _tmp6_;
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 197 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 925 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = action;
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 198 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 200 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		return;
#line 936 "rygel-content-directory.c"
	}
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = action;
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_);
#line 203 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	import = _tmp5_;
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp6_ = import;
#line 204 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp6_ != NULL) {
#line 948 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp7_;
		RygelImportResource* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		RygelImportResource* _tmp11_;
		gint64 _tmp12_;
		RygelImportResource* _tmp13_;
		gint64 _tmp14_;
		GUPnPServiceAction* _tmp15_;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp7_ = action;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp8_ = import;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp9_ = rygel_import_resource_get_status_as_string (_tmp8_);
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp10_ = _tmp9_;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp11_ = import;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp12_ = _tmp11_->bytes_copied;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp13_ = import;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp14_ = _tmp13_->bytes_total;
#line 205 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_set (_tmp7_, "TransferStatus", G_TYPE_STRING, _tmp10_, "TransferLength", G_TYPE_INT64, _tmp12_, "TransferTotal", G_TYPE_INT64, _tmp14_, NULL);
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp15_ = action;
#line 215 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return (_tmp15_);
#line 980 "rygel-content-directory.c"
	} else {
		GUPnPServiceAction* _tmp16_;
		const gchar* _tmp17_ = NULL;
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp16_ = action;
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp17_ = _ ("No such file transfer");
#line 217 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp16_, (guint) 717, _tmp17_);
#line 990 "rygel-content-directory.c"
	}
#line 195 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (import);
#line 994 "rygel-content-directory.c"
}


static void rygel_content_directory_stop_transfer_resource_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	RygelImportResource* _tmp5_ = NULL;
	RygelImportResource* import;
	RygelImportResource* _tmp6_;
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 224 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 1)) {
#line 1017 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = action;
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 225 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 227 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		return;
#line 1028 "rygel-content-directory.c"
	}
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = action;
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp5_ = rygel_content_directory_find_import_for_action (self, _tmp4_);
#line 230 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	import = _tmp5_;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp6_ = import;
#line 231 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp6_ != NULL) {
#line 1040 "rygel-content-directory.c"
		RygelImportResource* _tmp7_;
		GCancellable* _tmp8_;
		GCancellable* _tmp9_;
		GUPnPServiceAction* _tmp10_;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp7_ = import;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp8_ = rygel_state_machine_get_cancellable ((RygelStateMachine*) _tmp7_);
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp9_ = _tmp8_;
#line 232 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		g_cancellable_cancel (_tmp9_);
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp10_ = action;
#line 234 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return (_tmp10_);
#line 1057 "rygel-content-directory.c"
	} else {
		GUPnPServiceAction* _tmp11_;
		const gchar* _tmp12_ = NULL;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp11_ = action;
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp12_ = _ ("No such file transfer");
#line 236 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp11_, (guint) 717, _tmp12_);
#line 1067 "rygel-content-directory.c"
	}
#line 222 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (import);
#line 1071 "rygel-content-directory.c"
}


static void rygel_content_directory_get_system_update_id_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	guint32 _tmp5_;
	GUPnPServiceAction* _tmp6_;
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 241 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 243 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 243 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 243 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1093 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = action;
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 244 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 246 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		return;
#line 1104 "rygel-content-directory.c"
	}
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = action;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp5_ = self->system_update_id;
#line 250 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "Id", G_TYPE_UINT, _tmp5_, NULL);
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp6_ = action;
#line 252 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp6_);
#line 1116 "rygel-content-directory.c"
}


static void rygel_content_directory_query_system_update_id (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	guint32 _tmp0_;
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 256 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 260 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_UINT);
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = self->system_update_id;
#line 261 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_set_uint (value, (guint) _tmp0_);
#line 1136 "rygel-content-directory.c"
}


static void rygel_content_directory_query_container_update_ids (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	gchar* _tmp0_ = NULL;
	gchar* update_ids;
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
#line 268 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	update_ids = _tmp0_;
#line 271 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 272 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_set_string (value, update_ids);
#line 265 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_free0 (update_ids);
#line 1161 "rygel-content-directory.c"
}


static void rygel_content_directory_get_search_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	GUPnPServiceAction* _tmp5_;
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 276 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 278 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1182 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = action;
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 279 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 281 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		return;
#line 1193 "rygel-content-directory.c"
	}
#line 285 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = action;
#line 285 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "SearchCaps", G_TYPE_STRING, RYGEL_RELATIONAL_EXPRESSION_CAPS, NULL);
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp5_ = action;
#line 287 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp5_);
#line 1203 "rygel-content-directory.c"
}


static void rygel_content_directory_query_search_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 291 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 295 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 296 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_set_string (value, RYGEL_RELATIONAL_EXPRESSION_CAPS);
#line 1220 "rygel-content-directory.c"
}


static void rygel_content_directory_get_sort_capabilities_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	GUPnPServiceAction* _tmp5_;
#line 300 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 300 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 303 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1241 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = action;
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 304 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 306 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		return;
#line 1252 "rygel-content-directory.c"
	}
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = action;
#line 310 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "SortCaps", G_TYPE_STRING, RYGEL_MEDIA_OBJECTS_SORT_CAPS, NULL);
#line 312 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp5_ = action;
#line 312 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp5_);
#line 1262 "rygel-content-directory.c"
}


static void rygel_content_directory_query_sort_capabilities (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 316 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 320 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 321 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_set_string (value, RYGEL_MEDIA_OBJECTS_SORT_CAPS);
#line 1279 "rygel-content-directory.c"
}


static void rygel_content_directory_get_feature_list_cb (RygelContentDirectory* self, GUPnPService* content_dir, GUPnPServiceAction* action) {
	GUPnPServiceAction* _tmp0_;
	guint _tmp1_ = 0U;
	GUPnPServiceAction* _tmp4_;
	const gchar* _tmp5_;
	GUPnPServiceAction* _tmp6_;
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 325 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (action != NULL);
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = gupnp_service_action_get_argument_count (_tmp0_);
#line 328 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp1_ != ((guint) 0)) {
#line 1301 "rygel-content-directory.c"
		GUPnPServiceAction* _tmp2_;
		const gchar* _tmp3_ = NULL;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = action;
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp3_ = _ ("Invalid argument");
#line 329 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gupnp_service_action_return_error (_tmp2_, (guint) 402, _tmp3_);
#line 331 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		return;
#line 1312 "rygel-content-directory.c"
	}
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = action;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp5_ = self->feature_list;
#line 335 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_action_set (_tmp4_, "FeatureList", G_TYPE_STRING, _tmp5_, NULL);
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp6_ = action;
#line 337 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_action_return (_tmp6_);
#line 1324 "rygel-content-directory.c"
}


static void rygel_content_directory_query_feature_list (RygelContentDirectory* self, GUPnPService* content_dir, const gchar* variable, GValue* value) {
	const gchar* _tmp0_;
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (content_dir != NULL);
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (variable != NULL);
#line 341 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (value != NULL);
#line 345 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_init (value, G_TYPE_STRING);
#line 346 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = self->feature_list;
#line 346 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_value_set_string (value, _tmp0_);
#line 1344 "rygel-content-directory.c"
}


static gchar* rygel_content_directory_create_container_update_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* update_ids;
#line 349 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 350 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = g_strdup ("");
#line 350 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	update_ids = _tmp0_;
#line 1358 "rygel-content-directory.c"
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _container_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _container_size;
		gint _container_index;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp1_ = self->priv->updated_containers;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_container_list = _tmp2_;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp3_ = _container_list;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp5_ = _tmp4_;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_container_size = _tmp5_;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_container_index = -1;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		while (TRUE) {
#line 1386 "rygel-content-directory.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			RygelMediaContainer* container;
			const gchar* _tmp12_;
			const gchar* _tmp15_;
			RygelMediaContainer* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			RygelMediaContainer* _tmp20_;
			guint32 _tmp21_;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp6_ = _container_index;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_container_index = _tmp6_ + 1;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp7_ = _container_index;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp8_ = _container_size;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				break;
#line 1419 "rygel-content-directory.c"
			}
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp9_ = _container_list;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp10_ = _container_index;
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			container = (RygelMediaContainer*) _tmp11_;
#line 353 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp12_ = update_ids;
#line 353 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			if (g_strcmp0 (_tmp12_, "") != 0) {
#line 1433 "rygel-content-directory.c"
				const gchar* _tmp13_;
				gchar* _tmp14_;
#line 354 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_tmp13_ = update_ids;
#line 354 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
#line 354 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_g_free0 (update_ids);
#line 354 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				update_ids = _tmp14_;
#line 1444 "rygel-content-directory.c"
			}
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp15_ = update_ids;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp16_ = container;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp17_ = ((RygelMediaObject*) _tmp16_)->id;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp18_ = g_strconcat (_tmp17_, ",", NULL);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp19_ = _tmp18_;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp20_ = container;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp21_ = _tmp20_->update_id;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp22_ = g_strdup_printf ("%u", _tmp21_);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp23_ = _tmp22_;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp24_ = g_strconcat (_tmp19_, _tmp23_, NULL);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp25_ = _tmp24_;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp26_ = g_strconcat (_tmp15_, _tmp25_, NULL);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_free0 (update_ids);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			update_ids = _tmp26_;
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_free0 (_tmp25_);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_free0 (_tmp23_);
#line 357 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_free0 (_tmp19_);
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_object_unref0 (container);
#line 1482 "rygel-content-directory.c"
		}
#line 352 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_g_object_unref0 (_container_list);
#line 1486 "rygel-content-directory.c"
	}
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	result = update_ids;
#line 360 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return result;
#line 1492 "rygel-content-directory.c"
}


/**
     * handler for container_updated signal on root_container. We don't
     * immediately send the notification for changes but schedule the
     * notification after 0.2 seconds. Also we don't clear the updated
     * container list immediately after notification but rather in this
     * function. Please refer to ContentDirectory version 2 specs for details
     * on why we do all this the way we do.
     *
     * @param root_container the root_container
     * @param updated_container the container that just got updated
     */
static gboolean _rygel_content_directory_update_notify_gsource_func (gpointer self) {
	gboolean result;
	result = rygel_content_directory_update_notify (self);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return result;
#line 1512 "rygel-content-directory.c"
}


static void rygel_content_directory_on_container_updated (RygelContentDirectory* self, RygelMediaContainer* root_container, RygelMediaContainer* updated_container) {
	guint32 _tmp0_;
	gboolean _tmp1_;
	GeeArrayList* _tmp3_;
	RygelMediaContainer* _tmp4_;
	GeeArrayList* _tmp5_;
	RygelMediaContainer* _tmp6_;
	guint _tmp7_;
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (root_container != NULL);
#line 374 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (updated_container != NULL);
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = self->system_update_id;
#line 376 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->system_update_id = _tmp0_ + 1;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = self->priv->clear_updated_containers;
#line 378 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp1_) {
#line 1538 "rygel-content-directory.c"
		GeeArrayList* _tmp2_;
#line 379 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = self->priv->updated_containers;
#line 379 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp2_);
#line 380 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		self->priv->clear_updated_containers = FALSE;
#line 1546 "rygel-content-directory.c"
	}
#line 384 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp3_ = self->priv->updated_containers;
#line 384 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = updated_container;
#line 384 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _tmp4_);
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp5_ = self->priv->updated_containers;
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp6_ = updated_container;
#line 385 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp6_);
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp7_ = self->priv->update_notify_id;
#line 387 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (_tmp7_ == ((guint) 0)) {
#line 1564 "rygel-content-directory.c"
		guint _tmp8_ = 0U;
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp8_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _rygel_content_directory_update_notify_gsource_func, g_object_ref (self), g_object_unref);
#line 388 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		self->priv->update_notify_id = _tmp8_;
#line 1570 "rygel-content-directory.c"
	}
}


static gboolean rygel_content_directory_update_notify (RygelContentDirectory* self) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* update_ids;
	guint32 _tmp1_;
#line 392 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 393 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = rygel_content_directory_create_container_update_ids (self);
#line 393 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	update_ids = _tmp0_;
#line 395 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "ContainerUpdateIDs", G_TYPE_STRING, update_ids, NULL);
#line 396 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = self->system_update_id;
#line 396 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "SystemUpdateID", G_TYPE_UINT, _tmp1_, NULL);
#line 398 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->priv->clear_updated_containers = TRUE;
#line 399 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->priv->update_notify_id = (guint) 0;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	result = FALSE;
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_free0 (update_ids);
#line 401 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return result;
#line 1602 "rygel-content-directory.c"
}


static gchar* rygel_content_directory_create_transfer_ids (RygelContentDirectory* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ids;
#line 404 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = g_strdup ("");
#line 405 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	ids = _tmp0_;
#line 1616 "rygel-content-directory.c"
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _import_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _import_size;
		gint _import_index;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp1_ = self->priv->active_imports;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_import_list = _tmp2_;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp3_ = _import_list;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp5_ = _tmp4_;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_import_size = _tmp5_;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_import_index = -1;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		while (TRUE) {
#line 1644 "rygel-content-directory.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			RygelImportResource* import;
			const gchar* _tmp12_;
			const gchar* _tmp15_;
			RygelImportResource* _tmp16_;
			guint32 _tmp17_;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			gchar* _tmp20_;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp6_ = _import_index;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_import_index = _tmp6_ + 1;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp7_ = _import_index;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp8_ = _import_size;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				break;
#line 1671 "rygel-content-directory.c"
			}
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp9_ = _import_list;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp10_ = _import_index;
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			import = (RygelImportResource*) _tmp11_;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp12_ = ids;
#line 408 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			if (g_strcmp0 (_tmp12_, "") != 0) {
#line 1685 "rygel-content-directory.c"
				const gchar* _tmp13_;
				gchar* _tmp14_;
#line 409 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_tmp13_ = ids;
#line 409 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_tmp14_ = g_strconcat (_tmp13_, ",", NULL);
#line 409 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_g_free0 (ids);
#line 409 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				ids = _tmp14_;
#line 1696 "rygel-content-directory.c"
			}
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp15_ = ids;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp16_ = import;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp17_ = _tmp16_->transfer_id;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp18_ = g_strdup_printf ("%u", _tmp17_);
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp19_ = _tmp18_;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_free0 (ids);
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			ids = _tmp20_;
#line 412 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_free0 (_tmp19_);
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_object_unref0 (import);
#line 1718 "rygel-content-directory.c"
		}
#line 407 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_g_object_unref0 (_import_list);
#line 1722 "rygel-content-directory.c"
	}
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	result = ids;
#line 415 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return result;
#line 1728 "rygel-content-directory.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return _data1_;
#line 1737 "rygel-content-directory.c"
}


static void block1_data_unref (Block1Data* _data1_) {
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_g_object_unref0 (_data1_->self);
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_g_object_unref0 (_data1_->import);
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		g_slice_free (Block1Data, _data1_);
#line 1750 "rygel-content-directory.c"
	}
}


static gboolean __lambda12_ (Block1Data* _data1_) {
	RygelContentDirectory * self;
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
#line 431 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self = _data1_->self;
#line 432 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = self->priv->finished_imports;
#line 432 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _data1_->import);
#line 434 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	result = FALSE;
#line 434 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return result;
#line 1769 "rygel-content-directory.c"
}


static gboolean ___lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda12_ (self);
#line 431 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return result;
#line 1778 "rygel-content-directory.c"
}


static void rygel_content_directory_on_import_completed (RygelContentDirectory* self, RygelStateMachine* machine) {
	Block1Data* _data1_;
	RygelStateMachine* _tmp0_;
	RygelImportResource* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (self != NULL);
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_if_fail (machine != NULL);
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_data1_->_ref_count_ = 1;
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_data1_->self = g_object_ref (self);
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = machine;
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp1_ = _g_object_ref0 (RYGEL_IS_IMPORT_RESOURCE (_tmp0_) ? ((RygelImportResource*) _tmp0_) : NULL);
#line 419 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_data1_->import = _tmp1_;
#line 421 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp2_ = self->priv->finished_imports;
#line 421 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, _data1_->import);
#line 422 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp3_ = self->priv->active_imports;
#line 422 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp3_, _data1_->import);
#line 425 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp4_ = rygel_content_directory_create_transfer_ids (self);
#line 425 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp5_ = _tmp4_;
#line 425 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_notify ((GUPnPService*) self, "TransferIDs", G_TYPE_STRING, _tmp5_, NULL);
#line 425 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_free0 (_tmp5_);
#line 431 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 30, ___lambda12__gsource_func, block1_data_ref (_data1_), block1_data_unref);
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	block1_data_unref (_data1_);
#line 418 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_data1_ = NULL;
#line 1828 "rygel-content-directory.c"
}


static RygelImportResource* rygel_content_directory_find_import_for_action (RygelContentDirectory* self, GUPnPServiceAction* action) {
	RygelImportResource* result = NULL;
	RygelImportResource* ret;
	guint32 transfer_id = 0U;
	GUPnPServiceAction* _tmp0_;
#line 438 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 438 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_return_val_if_fail (action != NULL, NULL);
#line 439 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	ret = NULL;
#line 442 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = action;
#line 442 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	gupnp_service_action_get (_tmp0_, "TransferID", G_TYPE_UINT, &transfer_id, NULL);
#line 1847 "rygel-content-directory.c"
	{
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _import_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _import_size;
		gint _import_index;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp1_ = self->priv->active_imports;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_import_list = _tmp2_;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp3_ = _import_list;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp5_ = _tmp4_;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_import_size = _tmp5_;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_import_index = -1;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		while (TRUE) {
#line 1875 "rygel-content-directory.c"
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			RygelImportResource* import;
			RygelImportResource* _tmp12_;
			guint32 _tmp13_;
			guint32 _tmp14_;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp6_ = _import_index;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_import_index = _tmp6_ + 1;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp7_ = _import_index;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp8_ = _import_size;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				break;
#line 1898 "rygel-content-directory.c"
			}
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp9_ = _import_list;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp10_ = _import_index;
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			import = (RygelImportResource*) _tmp11_;
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp12_ = import;
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp13_ = _tmp12_->transfer_id;
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp14_ = transfer_id;
#line 447 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			if (_tmp13_ == _tmp14_) {
#line 1916 "rygel-content-directory.c"
				RygelImportResource* _tmp15_;
				RygelImportResource* _tmp16_;
#line 448 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_tmp15_ = import;
#line 448 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_tmp16_ = _g_object_ref0 (_tmp15_);
#line 448 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_g_object_unref0 (ret);
#line 448 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				ret = _tmp16_;
#line 450 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_g_object_unref0 (import);
#line 450 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				break;
#line 1931 "rygel-content-directory.c"
			}
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_object_unref0 (import);
#line 1935 "rygel-content-directory.c"
		}
#line 446 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_g_object_unref0 (_import_list);
#line 1939 "rygel-content-directory.c"
	}
	{
		GeeArrayList* _tmp17_;
		GeeArrayList* _tmp18_;
		GeeArrayList* _import_list;
		GeeArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _import_size;
		gint _import_index;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp17_ = self->priv->finished_imports;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp18_ = _g_object_ref0 (_tmp17_);
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_import_list = _tmp18_;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp19_ = _import_list;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp20_ = gee_collection_get_size ((GeeCollection*) _tmp19_);
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_tmp21_ = _tmp20_;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_import_size = _tmp21_;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_import_index = -1;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		while (TRUE) {
#line 1968 "rygel-content-directory.c"
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			GeeArrayList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_ = NULL;
			RygelImportResource* import;
			RygelImportResource* _tmp28_;
			guint32 _tmp29_;
			guint32 _tmp30_;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp22_ = _import_index;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_import_index = _tmp22_ + 1;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp23_ = _import_index;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp24_ = _import_size;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			if (!(_tmp23_ < _tmp24_)) {
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				break;
#line 1991 "rygel-content-directory.c"
			}
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp25_ = _import_list;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp26_ = _import_index;
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _tmp26_);
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			import = (RygelImportResource*) _tmp27_;
#line 455 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp28_ = import;
#line 455 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp29_ = _tmp28_->transfer_id;
#line 455 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_tmp30_ = transfer_id;
#line 455 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			if (_tmp29_ == _tmp30_) {
#line 2009 "rygel-content-directory.c"
				RygelImportResource* _tmp31_;
				RygelImportResource* _tmp32_;
#line 456 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_tmp31_ = import;
#line 456 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_tmp32_ = _g_object_ref0 (_tmp31_);
#line 456 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_g_object_unref0 (ret);
#line 456 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				ret = _tmp32_;
#line 458 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				_g_object_unref0 (import);
#line 458 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
				break;
#line 2024 "rygel-content-directory.c"
			}
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
			_g_object_unref0 (import);
#line 2028 "rygel-content-directory.c"
		}
#line 454 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
		_g_object_unref0 (_import_list);
#line 2032 "rygel-content-directory.c"
	}
#line 462 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	result = ret;
#line 462 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return result;
#line 2038 "rygel-content-directory.c"
}


RygelContentDirectory* rygel_content_directory_construct (GType object_type) {
	RygelContentDirectory * self = NULL;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self = (RygelContentDirectory*) g_object_new (object_type, NULL);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return self;
#line 2048 "rygel-content-directory.c"
}


RygelContentDirectory* rygel_content_directory_new (void) {
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	return rygel_content_directory_construct (RYGEL_TYPE_CONTENT_DIRECTORY);
#line 2055 "rygel-content-directory.c"
}


static void rygel_content_directory_class_init (RygelContentDirectoryClass * klass) {
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	rygel_content_directory_parent_class = g_type_class_peek_parent (klass);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_type_class_add_private (klass, sizeof (RygelContentDirectoryPrivate));
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_content_directory_real_constructed;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_content_directory_finalize;
#line 2068 "rygel-content-directory.c"
}


static void rygel_content_directory_instance_init (RygelContentDirectory * self) {
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self->priv = RYGEL_CONTENT_DIRECTORY_GET_PRIVATE (self);
#line 2075 "rygel-content-directory.c"
}


static void rygel_content_directory_finalize (GObject* obj) {
	RygelContentDirectory * self;
	GCancellable* _tmp0_;
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	self = RYGEL_CONTENT_DIRECTORY (obj);
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_tmp0_ = self->cancellable;
#line 136 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	g_cancellable_cancel (_tmp0_);
#line 55 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_free0 (self->feature_list);
#line 57 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->http_server);
#line 59 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->root_container);
#line 60 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->updated_containers);
#line 62 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->active_imports);
#line 63 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->priv->finished_imports);
#line 68 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	_g_object_unref0 (self->cancellable);
#line 47 "/home/jens/Source/rygel/src/rygel/rygel-content-directory.vala"
	G_OBJECT_CLASS (rygel_content_directory_parent_class)->finalize (obj);
#line 2104 "rygel-content-directory.c"
}


/**
 * Basic implementation of UPnP ContentDirectory service version 2. Most often
 * plugins will provide a child of this class. The inheriting classes should
 * override create_root_container method.
 */
GType rygel_content_directory_get_type (void) {
	static volatile gsize rygel_content_directory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_content_directory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelContentDirectoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_content_directory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelContentDirectory), 0, (GInstanceInitFunc) rygel_content_directory_instance_init, NULL };
		GType rygel_content_directory_type_id;
		rygel_content_directory_type_id = g_type_register_static (GUPNP_TYPE_SERVICE, "RygelContentDirectory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_content_directory_type_id__volatile, rygel_content_directory_type_id);
	}
	return rygel_content_directory_type_id__volatile;
}



