/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.ITransparentableFigure;
import org.xmind.gef.draw2d.ReferencedFigure;
import org.xmind.gef.draw2d.graphics.Path;

public class PointFigure
extends ReferencedFigure
implements ITransparentableFigure {
    public static final int SHAPE_SQUARE = 1;
    public static final int SHAPE_DOT = 2;
    public static final int SHAPE_DIAMOND = 3;
    private int borderAlpha = 255;
    private int fillAlpha = 255;
    private int shapeType;

    public PointFigure(int shapeType) {
        this.shapeType = shapeType;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public int getMainAlpha() {
        return this.borderAlpha;
    }

    public void setMainAlpha(int alpha) {
        if (alpha == this.borderAlpha) {
            return;
        }
        this.borderAlpha = alpha;
        this.repaint();
    }

    public int getSubAlpha() {
        return this.fillAlpha;
    }

    public void setSubAlpha(int alpha) {
        if (alpha == this.fillAlpha) {
            return;
        }
        this.fillAlpha = alpha;
        this.repaint();
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        graphics.setLineWidth(1);
        graphics.setLineStyle(1);
        graphics.setLineJoin(3);
        Path shape = this.createShape(this.shapeType);
        if (shape != null) {
            Color borderColor;
            Color fillColor = this.getLocalBackgroundColor();
            if (fillColor != null) {
                graphics.setAlpha(this.getSubAlpha());
                graphics.setBackgroundColor(fillColor);
                graphics.fillPath((org.eclipse.swt.graphics.Path)shape);
            }
            if ((borderColor = this.getLocalForegroundColor()) != null) {
                graphics.setAlpha(this.getMainAlpha());
                graphics.setForegroundColor(borderColor);
                graphics.drawPath((org.eclipse.swt.graphics.Path)shape);
            }
            shape.dispose();
        }
    }

    private Path createShape(int shapeType) {
        if (shapeType != 1 && shapeType != 2 && shapeType != 3) {
            return null;
        }
        Point ref = this.getReference();
        int x = ref.x;
        int y = ref.y;
        Dimension size = this.getSize();
        int w = size.width;
        int h = size.height;
        Path shape = new Path((Device)Display.getCurrent());
        switch (shapeType) {
            case 1: {
                shape.addRectangle(x - w / 2, y - h / 2, w - 1, h - 1);
                return shape;
            }
            case 2: {
                shape.addArc(x - w / 2, y - h / 2, w - 1, h - 1, 0.0f, 360.0f);
                break;
            }
            case 3: {
                shape.moveTo(x - w / 2, y);
                shape.lineTo(x, y - h / 2);
                shape.lineTo(x + w / 2, y);
                shape.lineTo(x, y + h / 2);
                shape.close();
            }
        }
        return shape;
    }
}

