/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.wizards;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.xmind.core.util.FileUtils;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.gef.image.ImageWriter;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.DialogUtils;
import org.xmind.ui.internal.wizards.WizardMessages;
import org.xmind.ui.io.MonitoredOutputStream;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.viewers.ImagePreviewViewer;
import org.xmind.ui.wizards.AbstractMindMapExportPage;
import org.xmind.ui.wizards.AbstractMindMapExportWizard;

public class ImageExportWizard
extends AbstractMindMapExportWizard {
    private static final String IMAGE_EXPORT_PAGE_NAME = "imageExportPage";
    private static final String DIALOG_SETTINGS_SECTION_ID = "org.xmind.ui.export.image";
    private static final String PROP_FORMAT = "FORMAT";
    private static final int LARGE_SIZE = 0x140000;
    private ImageFormat format;
    private ImageExportPage page;
    private MindMapImageExporter exporter = null;
    private GhostShellProvider shell = null;

    public ImageExportWizard() {
        this.setWindowTitle(WizardMessages.ImageExportWizard_windowTitle);
        this.setDefaultPageImageDescriptor(MindMapUI.getImages().getWizBan("export_wiz.png"));
        this.setDialogSettings(MindMapUIPlugin.getDefault().getDialogSettings(DIALOG_SETTINGS_SECTION_ID));
        this.setNeedsProgressMonitor(true);
    }

    @Override
    protected void loadDialogSettings(IDialogSettings settings) {
        String mediaType = settings.get(PROP_FORMAT);
        ImageFormat lastFormat = ImageFormat.findByMediaType((String)mediaType, (ImageFormat)ImageFormat.PNG);
        this.setFormat(lastFormat);
        super.loadDialogSettings(settings);
    }

    @Override
    protected void saveDialogSettings(IDialogSettings settings) {
        super.saveDialogSettings(settings);
        if (this.format != null) {
            settings.put(PROP_FORMAT, this.format.getMediaType());
        }
    }

    @Override
    protected void addValidPages() {
        this.page = new ImageExportPage();
        this.addPage((IWizardPage)this.page);
    }

    public void setFormat(ImageFormat format) {
        this.format = format;
    }

    public ImageFormat getFormat() {
        return this.format;
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    @Override
    public boolean performFinish() {
        if (this.page.getPreviewState() == PreviewState.Error && !MessageDialog.openConfirm((Shell)this.getShell(), (String)WizardMessages.ImageExport_ConfirmProceedWithError_title, (String)WizardMessages.ImageExport_ConfirmProceedWithError_message)) {
            return false;
        }
        if (this.page != null) {
            this.page.cancel();
        }
        return super.performFinish();
    }

    @Override
    protected String getFormatName() {
        return this.hasFormat() ? "'" + this.getFormat().getName() + "'" : "";
    }

    @Override
    protected boolean isExtensionCompatible(String path, String extension) {
        return super.isExtensionCompatible(path, extension) && this.hasFormat() && this.getFormat().getExtensions().contains(extension.toLowerCase());
    }

    private boolean isImageLarge(Image image) {
        Rectangle r = image.getBounds();
        return r.width * r.height > 0x140000;
    }

    protected MindMapImageExporter getImageExporter(Display display) {
        if (this.exporter == null) {
            this.exporter = this.createImageExporter(display);
        }
        return this.exporter;
    }

    private MindMapImageExporter createImageExporter(Display display) {
        MindMapImageExporter exporter = new MindMapImageExporter(display);
        Properties properties = new Properties();
        boolean plusVisible = this.getBoolean(this.getDialogSettings(), "plusVisible", true);
        boolean minusVisible = this.getBoolean(this.getDialogSettings(), "minusVisible", true);
        properties.set("plusVisible", plusVisible);
        properties.set("minusVisible", minusVisible);
        exporter.setSource(this.getSourceMindMap(), this.getShellProvider(display), properties, null);
        return exporter;
    }

    private boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (settings.get(key) != null) {
            value = settings.getBoolean(key);
        }
        return value;
    }

    protected GhostShellProvider getShellProvider(Display display) {
        if (this.shell == null) {
            this.shell = new GhostShellProvider(display);
        }
        return this.shell;
    }

    @Override
    public void dispose() {
        if (this.shell != null) {
            this.shell.dispose();
            this.shell = null;
        }
        this.exporter = null;
        super.dispose();
    }

    protected void writeImage(Image image, String destPath, IProgressMonitor monitor) throws IOException {
        MonitoredOutputStream output = new MonitoredOutputStream((OutputStream)new FileOutputStream(destPath), monitor);
        ImageWriter writer = this.createImageWriter(image, (OutputStream)output);
        try {
            writer.write();
        }
        finally {
            output.close();
        }
    }

    protected ImageWriter createImageWriter(Image image, OutputStream output) {
        return ImageExportUtils.createImageWriter((Image)image, (int)this.getFormat().getSWTFormat(), (OutputStream)output);
    }

    @Override
    protected void doExport(IProgressMonitor monitor, Display display, Shell parentShell) throws InvocationTargetException, InterruptedException {
        Image image;
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("ExportToImageCount");
        monitor.beginTask(null, 100);
        monitor.subTask(WizardMessages.ImageExport_CreatingSourceImage);
        MindMapImageExporter exporter = this.getImageExporter(display);
        try {
            image = exporter.createImage();
        }
        catch (Throwable e) {
            monitor.setCanceled(true);
            throw new InvocationTargetException(e);
        }
        try {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            monitor.worked(50);
            String path = this.getTargetPath();
            monitor.subTask(NLS.bind((String)WizardMessages.ImageExport_WritingTargetFile, (Object)path));
            try {
                this.writeImage(image, path, monitor);
            }
            catch (IOException e) {
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                throw new InvocationTargetException(e);
            }
        }
        finally {
            image.dispose();
        }
        monitor.worked(49);
        this.launchTargetFile(true, monitor, display, parentShell);
        monitor.done();
    }

    private static String makeErrorMessage(String originalMessage, boolean largeImage) {
        if (largeImage) {
            return String.valueOf(originalMessage) + " " + WizardMessages.ImageExportPage_ImageTooLarge;
        }
        return originalMessage;
    }

    @Override
    protected void handleExportException(Throwable e) {
        super.handleExportException(e);
        this.page.setErrorMessage(e.getLocalizedMessage());
    }

    @Override
    protected String getSuggestedFileName() {
        return String.valueOf(super.getSuggestedFileName()) + (String)this.getFormat().getExtensions().get(0);
    }

    private class ImageExportPage
    extends AbstractMindMapExportPage {
        private Combo formatCombo;
        private ImagePreviewViewer viewer;
        private Image previewImage;
        private String previewPath;
        private GeneratePreviewJob generatePreviewJob;
        private PreviewState previewState;
        private Button showPlusCheck;
        private Button showMinusCheck;

        protected ImageExportPage() {
            super(ImageExportWizard.IMAGE_EXPORT_PAGE_NAME, WizardMessages.ImageExportPage_title);
            this.setDescription(WizardMessages.ImageExportPage_description);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 15;
            composite.setLayout((Layout)layout);
            this.setControl((Control)composite);
            this.createFormatControls(composite);
            this.createShowPlusMinusControls(composite);
            this.createPreviewControl(composite);
            Control fileGroup = this.createFileControls(composite);
            fileGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.generatePreview(ImageExportWizard.this.getFormat());
        }

        private void createPreviewControl(Composite parent) {
            this.viewer = new ImagePreviewViewer(true);
            this.viewer.setPrefWidth(400);
            this.viewer.createControl(parent);
            this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.viewer.getControl().setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)8));
            this.hookWidget((Widget)this.viewer.getControl(), 11);
            parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ImageExportPage.this.updateViewerSize();
                }
            });
        }

        private void createFormatControls(Composite parent) {
            Group group = new Group(parent, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, false));
            group.setLayout((Layout)new GridLayout());
            group.setText(WizardMessages.ImageExportPage_FormatGroup_title);
            Label label = new Label((Composite)group, 64);
            GridData gd = new GridData(4, 4, true, false);
            label.setLayoutData((Object)gd);
            label.setText(WizardMessages.ImageExportPage_FormatGroup_description);
            this.formatCombo = new Combo((Composite)group, 2124);
            this.formatCombo.setLayoutData((Object)new GridData(4, 4, true, false));
            ImageFormat[] imageFormatArray = ImageFormat.values();
            int n = imageFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImageFormat format = imageFormatArray[n2];
                this.formatCombo.add(format.getDescription());
                ++n2;
            }
            if (ImageExportWizard.this.getFormat() != null) {
                this.formatCombo.select(ImageExportWizard.this.getFormat().ordinal());
            }
            this.hookWidget((Widget)this.formatCombo, 13);
        }

        private void createShowPlusMinusControls(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 15;
            gridLayout.horizontalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            label.setText(WizardMessages.ImageExportWizard_showPlusMinus_groupTitle);
            Composite rightGroup = new Composite(composite, 0);
            GridLayout gridLayout2 = new GridLayout(2, false);
            gridLayout2.marginWidth = 14;
            gridLayout2.marginHeight = 3;
            gridLayout2.verticalSpacing = 0;
            gridLayout2.horizontalSpacing = 70;
            rightGroup.setLayout((Layout)gridLayout2);
            GridData gridData = new GridData(4, 4, true, false);
            rightGroup.setLayoutData((Object)gridData);
            this.createShowPlusCheck(rightGroup);
            this.createShowMinusCheck(rightGroup);
            this.initPlusMinusCheckState();
        }

        private void createShowPlusCheck(Composite parent) {
            this.showPlusCheck = this.createPlusMinusCheck(parent, WizardMessages.ImageExportWizard_showPlusCheck_text, MindMapUI.getImages().get("plus.png", true).createImage());
        }

        private void createShowMinusCheck(Composite parent) {
            this.showMinusCheck = this.createPlusMinusCheck(parent, WizardMessages.ImageExportWizard_showMinusCheck_text, MindMapUI.getImages().get("minus.png", true).createImage());
        }

        private Button createPlusMinusCheck(Composite parent, String text, Image image) {
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 5;
            composite.setLayout((Layout)gridLayout);
            Button check = new Button(composite, 32);
            check.setBackground(composite.getBackground());
            check.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            check.setText(text);
            Label imageLabel = new Label(composite, 0);
            imageLabel.setBackground(composite.getBackground());
            imageLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
            imageLabel.setImage(image);
            this.hookWidget((Widget)check, 13);
            return check;
        }

        private void initPlusMinusCheckState() {
            boolean plusVisible = ImageExportWizard.this.getBoolean(this.getDialogSettings(), "plusVisible", true);
            boolean minusVisible = ImageExportWizard.this.getBoolean(this.getDialogSettings(), "minusVisible", true);
            this.showPlusCheck.setSelection(plusVisible);
            this.showMinusCheck.setSelection(minusVisible);
        }

        private void setProperty(String key, boolean value) {
            this.getDialogSettings().put(key, value);
            this.updatePreview();
        }

        private void updatePreview() {
            Display display = this.getControl().getDisplay();
            MindMapImageExporter exporter = ImageExportWizard.this.getImageExporter(display);
            Properties properties = exporter.getProperties();
            if (properties != null) {
                boolean plusVisible = ImageExportWizard.this.getBoolean(this.getDialogSettings(), "plusVisible", true);
                boolean minusVisible = ImageExportWizard.this.getBoolean(this.getDialogSettings(), "minusVisible", true);
                properties.set("plusVisible", plusVisible);
                properties.set("minusVisible", minusVisible);
            }
            this.generatePreview(ImageExportWizard.this.getFormat());
        }

        @Override
        public void dispose() {
            super.dispose();
            this.viewer = null;
            this.disposePreview();
        }

        private void disposePreview() {
            this.cancel();
            if (this.previewImage != null) {
                this.previewImage.dispose();
                this.previewImage = null;
            }
            if (this.previewPath != null) {
                ImageExportWizard.this.deleteTemporaryPath(this.previewPath);
                this.previewPath = null;
            }
        }

        @Override
        protected void handleWidgetEvent(Event event) {
            if (event.widget == this.formatCombo) {
                int selection = this.formatCombo.getSelectionIndex();
                ImageFormat oldFormat = ImageExportWizard.this.getFormat();
                if (selection < 0) {
                    ImageExportWizard.this.setFormat(null);
                } else {
                    ImageExportWizard.this.setFormat(ImageFormat.values()[selection]);
                }
                if (oldFormat != ImageExportWizard.this.getFormat()) {
                    this.formatChanged();
                }
            } else if (event.widget == this.showPlusCheck) {
                this.setProperty("plusVisible", this.showPlusCheck.getSelection());
            } else if (event.widget == this.showMinusCheck) {
                this.setProperty("minusVisible", this.showMinusCheck.getSelection());
            } else if (this.viewer != null && event.widget == this.viewer.getControl()) {
                this.updateViewerSize();
            } else {
                super.handleWidgetEvent(event);
            }
        }

        private void updateViewerSize() {
            if (this.viewer == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            Canvas canvas = this.viewer.getCanvas();
            if (canvas == null || canvas.isDisposed()) {
                return;
            }
            Rectangle bounds = canvas.getBounds();
            this.viewer.setPrefWidth(bounds.width);
            this.viewer.setPrefHeight(bounds.height);
        }

        @Override
        protected boolean isPageCompletable() {
            return super.isPageCompletable() && ImageExportWizard.this.hasFormat();
        }

        @Override
        protected String generateWarningMessage() {
            if (this.previewState == PreviewState.Error && this.viewer != null) {
                return this.viewer.getTitle();
            }
            return super.generateWarningMessage();
        }

        public PreviewState getPreviewState() {
            return this.previewState;
        }

        @Override
        protected FileDialog createBrowseDialog() {
            FileDialog dialog = super.createBrowseDialog();
            DialogUtils.makeImageSelectorDialog(dialog, false, ImageExportWizard.this.getFormat());
            return dialog;
        }

        private void formatChanged() {
            String ext;
            List exts;
            if (this.hasTargetPath() && ImageExportWizard.this.hasFormat() && !(exts = ImageExportWizard.this.getFormat().getExtensions()).contains(ext = FileUtils.getExtension((String)this.getTargetPath()))) {
                this.setTargetPath(this.replaceExtension(this.getTargetPath(), ext, (String)exts.get(0)));
            }
            this.updateStatus();
            this.generatePreview(ImageExportWizard.this.getFormat());
        }

        private String replaceExtension(String path, String oldExt, String newExt) {
            return String.valueOf(path.substring(0, path.length() - oldExt.length())) + newExt;
        }

        private void generatePreview(ImageFormat format) {
            if (format == null) {
                return;
            }
            if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                this.updateViewer(null, PreviewState.Generating, false, null);
            }
            this.disposePreview();
            this.previewPath = ImageExportWizard.this.requestTemporaryPath(null, (String)format.getExtensions().get(0), true);
            if (this.previewPath == null) {
                this.updateViewer(null, PreviewState.Error, false, null);
                return;
            }
            Display display = Display.getCurrent();
            this.generatePreviewJob = new GeneratePreviewJob(this.previewPath, format, display);
            this.generatePreviewJob.schedule();
        }

        private void asyncUpdateViewer(Display display, final Image image, final PreviewState state, final boolean largeImage, final Point origin) {
            if (Thread.currentThread() != display.getThread()) {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageExportPage.this.updateViewer(image, state, largeImage, origin);
                    }
                });
            } else {
                this.updateViewer(image, state, largeImage, origin);
            }
        }

        private void updateViewer(Image image, PreviewState state, boolean largeImage, Point origin) {
            this.previewState = state;
            if (this.viewer == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            if (image != null && origin != null) {
                this.viewer.setImage(image, (double)origin.x, (double)origin.y);
            } else {
                this.viewer.setImage(image);
            }
            if (this.viewer.getRatio() > 1.0) {
                this.viewer.changeRatio(1.0);
            }
            this.viewer.setTitle(state.getTitle(image, largeImage));
            this.viewer.setTitlePlacement(state.getTitlePlacement());
            state.setColor(this.viewer.getControl());
            this.updateStatus();
        }

        public void cancel() {
            if (this.generatePreviewJob != null) {
                this.generatePreviewJob.cancel();
                this.generatePreviewJob = null;
            }
        }

        private class GeneratePreviewJob
        extends Job {
            private String destPath;
            private Display display;

            public GeneratePreviewJob(String destPath, ImageFormat format, Display display) {
                super(NLS.bind((String)WizardMessages.ImageExportPage_GeneratePreview_jobName, (Object)format.getName()));
                this.destPath = destPath;
                this.display = display;
            }

            /*
             * Loose catch block
             */
            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(null, 100);
                monitor.subTask(WizardMessages.ImageExportPage_GeneratePreview_CreatingSourceImage);
                final MindMapImageExporter exporter = ImageExportWizard.this.getImageExporter(this.display);
                final Image[] _image = new Image[1];
                final Throwable[] _error = new Throwable[1];
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            _image[0] = exporter.createImage();
                        }
                        catch (Throwable e) {
                            _error[0] = e;
                        }
                    }
                });
                if (_error[0] != null) {
                    if (ImageExportPage.this.generatePreviewJob == this) {
                        ImageExportPage.this.generatePreviewJob = null;
                    }
                    ImageExportPage.this.asyncUpdateViewer(this.display, null, PreviewState.Error, false, null);
                    return new Status(4, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_CouldNotCreateSourceImage, _error[0]);
                }
                Image image = _image[0];
                try {
                    if (monitor.isCanceled()) {
                        if (ImageExportPage.this.generatePreviewJob == this) {
                            ImageExportPage.this.generatePreviewJob = null;
                        }
                        Status status = new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Canceled);
                        return status;
                    }
                    monitor.worked(40);
                    boolean largeImage = ImageExportWizard.this.isImageLarge(image);
                    Point origin = null;
                    monitor.subTask(WizardMessages.ImageExportPage_GeneratePreview_SavingTempFile);
                    try {
                        ImageExportWizard.this.writeImage(image, this.destPath, monitor);
                        origin = exporter.calcRelativeOrigin();
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        ImageExportWizard.this.deleteTemporaryPath(this.destPath);
                        if (ImageExportPage.this.generatePreviewJob == this) {
                            ImageExportPage.this.generatePreviewJob = null;
                        }
                        Status status = new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Canceled);
                        image.dispose();
                        return status;
                    }
                    catch (Throwable e) {
                        block27: {
                            ImageExportWizard.this.deleteTemporaryPath(this.destPath);
                            if (!monitor.isCanceled()) break block27;
                            if (ImageExportPage.this.generatePreviewJob == this) {
                                ImageExportPage.this.generatePreviewJob = null;
                            }
                            Status status = new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Canceled);
                            image.dispose();
                            return status;
                        }
                        ImageExportPage.this.asyncUpdateViewer(this.display, null, PreviewState.Error, largeImage, origin);
                        Status status = new Status(8, "org.xmind.ui.mindmap", ImageExportWizard.makeErrorMessage(WizardMessages.ImageExportPage_GeneratePreview_CouldNotSavePreviewImage, largeImage), e);
                        image.dispose();
                        return status;
                    }
                    if (monitor.isCanceled()) {
                        ImageExportWizard.this.deleteTemporaryPath(this.destPath);
                        if (ImageExportPage.this.generatePreviewJob == this) {
                            ImageExportPage.this.generatePreviewJob = null;
                        }
                        Status status = new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Canceled);
                        return status;
                    }
                    monitor.worked(40);
                    monitor.subTask(WizardMessages.ImageExportPage_GeneratePreview_LoadingTempFile);
                    File previewFile = new File(this.destPath);
                    if (!previewFile.exists() || !previewFile.canRead()) {
                        if (ImageExportPage.this.generatePreviewJob == this) {
                            ImageExportPage.this.generatePreviewJob = null;
                        }
                        ImageExportPage.this.asyncUpdateViewer(this.display, null, PreviewState.Error, largeImage, origin);
                        Status status = new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_CouldNotLoadPreviewImage);
                        return status;
                    }
                    try {
                        ImageExportPage.this.previewImage = new Image((Device)Display.getCurrent(), this.destPath);
                    }
                    catch (Throwable e) {
                        if (ImageExportPage.this.generatePreviewJob == this) {
                            ImageExportPage.this.generatePreviewJob = null;
                        }
                        ImageExportPage.this.asyncUpdateViewer(this.display, null, PreviewState.Error, largeImage, origin);
                        Status status = new Status(8, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_CouldNotLoadPreviewImage, e);
                        image.dispose();
                        return status;
                    }
                    ImageExportPage.this.asyncUpdateViewer(this.display, ImageExportPage.this.previewImage, PreviewState.Showing, false, origin);
                    if (ImageExportPage.this.generatePreviewJob == this) {
                        ImageExportPage.this.generatePreviewJob = null;
                    }
                    monitor.done();
                    Status status = new Status(0, "org.xmind.ui.mindmap", WizardMessages.ImageExportPage_GeneratePreview_Completed);
                    return status;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    image.dispose();
                }
            }
        }
    }

    private static enum PreviewState {
        Showing(null, 16, 132096){

            @Override
            public String getTitle(Image image, boolean largeImage) {
                if (image == null) {
                    return super.getTitle(image, largeImage);
                }
                Rectangle r = image.getBounds();
                return String.format("%d x %d", r.width, r.height);
            }
        }
        ,
        Generating(WizardMessages.ImageExportPage_GeneratingPreview, 16, 0),
        Error(WizardMessages.ImageExportPage_FailedToGeneratePreview, 4, 0){

            @Override
            public String getTitle(Image image, boolean largeImage) {
                return ImageExportWizard.makeErrorMessage(super.getTitle(image, largeImage), largeImage);
            }
        };

        private int colorId;
        private String title;
        private int titlePlacement;

        private PreviewState(String title, int colorId, int titlePlacement) {
            this.title = title;
            this.colorId = colorId;
            this.titlePlacement = titlePlacement;
        }

        public String getTitle(Image image, boolean largeImage) {
            return this.title;
        }

        public void setColor(Control control) {
            control.setForeground(control.getDisplay().getSystemColor(this.colorId));
        }

        public int getTitlePlacement() {
            return this.titlePlacement;
        }
    }
}

