/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.swt.widgets.Display;
import org.xmind.gef.part.IGraphicalEditPart;
import org.xmind.gef.part.IPartStatus;
import org.xmind.gef.service.IFeedback;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.gef.status.IStatusListener;
import org.xmind.gef.status.StatusEvent;
import org.xmind.gef.status.StatusMachine2;
import org.xmind.ui.mindmap.ISelectionFeedbackHelper;

public class SelectionFeedbackHelper
implements ISelectionFeedbackHelper,
IStatusListener {
    private IGraphicalEditPart host;
    private IFeedbackService feedbackService = null;
    private IFeedback currentFeedback = null;
    private int lastStatus = 0;
    private boolean updating = false;
    private int overrideStatus = -1;
    private int overrideMask = -1;

    @Override
    public void setHost(IGraphicalEditPart host) {
        if (host == this.host) {
            return;
        }
        if (this.host != null) {
            this.host.getStatus().removeStatusListener((IStatusListener)this);
        }
        this.host = host;
        if (host != null) {
            host.getStatus().addStatusListener((IStatusListener)this);
        }
    }

    protected IGraphicalEditPart getHost() {
        return this.host;
    }

    @Override
    public void setFeedbackService(IFeedbackService feedbackService) {
        if (feedbackService == this.feedbackService) {
            return;
        }
        if (this.feedbackService != null) {
            this.removeAllFeedback(this.feedbackService);
        }
        this.feedbackService = feedbackService;
        if (feedbackService != null) {
            this.update(feedbackService);
        }
    }

    protected IFeedbackService getFeedbackService() {
        return this.feedbackService;
    }

    protected int getCalculatedSelectionStatus() {
        if (this.overrideMask >= 0) {
            return this.overrideStatus & this.overrideMask | this.getRealSelectionStatus() & ~this.overrideMask;
        }
        return this.getRealSelectionStatus();
    }

    protected int getRealSelectionStatus() {
        if (this.getHost() == null) {
            return 0;
        }
        IPartStatus status = this.getHost().getStatus();
        if (status instanceof StatusMachine2) {
            return ((StatusMachine2)status).getStatus() & 0xE;
        }
        return SelectionFeedbackHelper.calcSelectionStatus(status.isPreSelected(), status.isSelected(), status.isFocused());
    }

    @Override
    public void forceFeedback(int key, boolean value) {
        if (this.overrideMask < 0) {
            this.overrideMask = 0;
        }
        this.overrideMask |= key;
        if (this.overrideStatus < 0) {
            this.overrideStatus = 0;
        }
        this.overrideStatus = value ? (this.overrideStatus |= key) : (this.overrideStatus &= ~key);
        this.updateFeedback(false);
    }

    @Override
    public void resetFeedback(int key) {
        this.overrideMask &= ~key;
        this.updateFeedback(false);
    }

    @Override
    public void resetAllFeedback() {
        this.overrideMask = -1;
        this.overrideStatus = -1;
        this.updateFeedback(false);
    }

    @Override
    public void updateFeedback(boolean async) {
        if (async) {
            this.asyncUpdate();
        } else {
            this.update();
        }
    }

    protected void asyncUpdate() {
        if (this.updating) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                SelectionFeedbackHelper.this.update();
                SelectionFeedbackHelper.this.updating = false;
            }
        });
    }

    private void update() {
        if (this.getHost() == null || !this.getHost().getStatus().isActive()) {
            return;
        }
        if (this.feedbackService != null && !this.feedbackService.isDisposed()) {
            this.update(this.feedbackService);
        }
    }

    private void update(IFeedbackService feedbackService) {
        int newStatus;
        IFeedback newFeedback = (IFeedback)this.getHost().getAdapter(IFeedback.class);
        if (newFeedback != this.currentFeedback) {
            if (this.currentFeedback != null) {
                feedbackService.removeFeedback(this.currentFeedback);
            }
            this.currentFeedback = newFeedback;
        }
        if ((newStatus = this.getCalculatedSelectionStatus()) != this.lastStatus) {
            if (this.currentFeedback != null) {
                if (this.lastStatus == 0 && newStatus > 0) {
                    feedbackService.addFeedback(this.currentFeedback);
                } else if (this.lastStatus > 0 && newStatus == 0) {
                    feedbackService.removeFeedback(this.currentFeedback);
                }
            }
            this.lastStatus = newStatus;
        }
        if (this.currentFeedback != null) {
            this.updateFeedback(this.currentFeedback, newStatus);
            this.currentFeedback.update();
        }
        this.updateOtherFeedback(feedbackService, newStatus);
    }

    protected void updateFeedback(IFeedback feedback, int newStatus) {
    }

    protected void updateOtherFeedback(IFeedbackService feedbackService, int newStatus) {
    }

    private void removeAllFeedback(IFeedbackService feedbackService) {
        if (this.currentFeedback != null) {
            feedbackService.removeFeedback(this.currentFeedback);
        }
        this.removeOtherFeedback(feedbackService);
    }

    protected void removeOtherFeedback(IFeedbackService feedbackService) {
    }

    public void statusChanged(StatusEvent event) {
        if ((event.key & 0xE) != 0) {
            this.updateFeedback(false);
        }
    }

    private static int calcSelectionStatus(boolean preselected, boolean selected, boolean focused) {
        int s = 0;
        if (preselected) {
            s |= 4;
        }
        if (selected) {
            s |= 2;
        }
        if (focused) {
            s |= 8;
        }
        return s;
    }
}

