/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.core.marker.IMarker;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gantt.GanttPlugin;
import org.xmind.ui.gantt2.gefext.BackgroundFigureManager;
import org.xmind.ui.gantt2.gefext.BackgroundLineManager;
import org.xmind.ui.gantt2.gefext.GraphicalEditPart;
import org.xmind.ui.gantt2.gefext.IBackgroundManager;
import org.xmind.ui.gantt2.viewer.ChevronFigure;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.GanttEditDomain;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.IHostFigureProvider;
import org.xmind.ui.gantt2.viewer.TaskTreeItemEditableFeedback;
import org.xmind.ui.gantt2.viewer.TaskTreeItemSelectablePolicy;
import org.xmind.ui.gantt2.viewer.TaskTreeItemSelectionFeedback;
import org.xmind.ui.gantt2.viewer.TaskTreeRootPart;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeWidthsSupport;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.resources.FontUtils;

public class TaskTreeItemPart
extends GraphicalEditPart
implements ICoreEventListener,
IHostFigureProvider,
PropertyChangeListener {
    public static final Object ROLE_EDITABLE = "task tree item editable role";
    public static final int FONT_SIZE = 10;
    public static int HEIGHT = (int)(0.1388889f * (float)Display.getCurrent().getDPI().y) + 2;
    private IFigure titleLayer = null;
    private RotatableWrapLabel[] items;
    private IFigure chevron = null;
    private IFigure childContainer = null;
    private ICoreEventRegister eventRegister = null;
    private Control activeEditor;
    private boolean shouldChevronVisible;
    private IPart context;
    private GanttViewer ganttViewer;
    private List<IBackgroundManager> backgroundManagers = new ArrayList<IBackgroundManager>();

    public TaskTreeItemPart(IPart context, Object model) {
        this.context = context;
        this.setModel(model);
        this.setFigure(this.createFigure());
        this.installFeedback("selectable role", new TaskTreeItemSelectionFeedback());
        this.installFeedback(ROLE_EDITABLE, new TaskTreeItemEditableFeedback());
        this.installBackgroundManager(new BackgroundLineManager());
        this.installBackgroundManager(new BackgroundFigureManager());
    }

    public TaskTreeItemPart(IPart context, Object model, GanttViewer ganttViewer) {
        this(context, model);
        this.ganttViewer = ganttViewer;
    }

    public ITopic getTask() {
        return (ITopic)this.getModel();
    }

    public IFigure getTitleLayer() {
        return this.titleLayer;
    }

    public IFigure getTitle() {
        TaskTreeWidthsSupport widthsSupport = this.getWidthsSupport();
        if (widthsSupport.indexOf("Task") != -1) {
            return this.items[widthsSupport.indexOf("Task")];
        }
        return null;
    }

    public IFigure getChevron() {
        return this.chevron;
    }

    public IFigure getContentPane() {
        return this.childContainer;
    }

    protected IFigure createFigure() {
        Layer figure = new Layer();
        figure.setLayoutManager((LayoutManager)new TaskTreeLayout());
        this.titleLayer = new Layer();
        this.titleLayer.setLayoutManager((LayoutManager)new TaskTreeTitleLayout());
        figure.add(this.titleLayer);
        this.chevron = this.createChevronFigure();
        this.titleLayer.add(this.chevron);
        this.createItems(this.titleLayer);
        this.childContainer = this.createChildContainerFigure();
        this.childContainer.setLayoutManager((LayoutManager)new SubTaskContainerLayout());
        figure.add(this.childContainer);
        String viewerMode = this.getViewerMode();
        if ("allTopics".equals(viewerMode) || TaskInfoUtils.hasCascadeTaskInfo((ITopic)this.getTask())) {
            figure.setVisible(true);
            if ("flat".equals(viewerMode) && !TaskInfoUtils.hasTaskInfo((ITopic)this.getTask())) {
                this.titleLayer.setVisible(false);
            } else {
                this.titleLayer.setVisible(true);
            }
        } else {
            figure.setVisible(false);
        }
        return figure;
    }

    public TaskTreeWidthsSupport getWidthsSupport() {
        return this.getTaskTreeViewer().getWidthsSupport();
    }

    public TaskTreeViewer getTaskTreeViewer() {
        IPart parent = this.context;
        while (!(parent instanceof TaskTreeRootPart)) {
            parent = parent.getParent();
        }
        return (TaskTreeViewer)((TaskTreeRootPart)parent).getViewer();
    }

    private void createItems(IFigure parent) {
        TaskTreeWidthsSupport widthsSupport = this.getWidthsSupport();
        this.items = new RotatableWrapLabel[widthsSupport.getSize()];
        int i = 0;
        while (i < widthsSupport.getSize()) {
            String key = widthsSupport.getKey(i);
            if ("Task".equals(key)) {
                this.items[i] = this.createTitleFigure();
            } else if ("Start".equals(key)) {
                this.items[i] = this.createStartFigure();
            } else if ("End".equals(key)) {
                this.items[i] = this.createEndFigure();
            } else if ("Assignee".equals(key)) {
                this.items[i] = this.createAssigneeFigure();
            } else if ("Priority".equals(key)) {
                this.items[i] = this.createPriorityFigure();
            } else if ("Progress".equals(key)) {
                this.items[i] = this.createProgressFigure();
            }
            parent.add((IFigure)this.items[i], (Object)key);
            ++i;
        }
    }

    private RotatableWrapLabel createTitleFigure() {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setText(this.getTask().getTitleText());
        label.setTextAlignment(1);
        label.setAbbreviated(true);
        label.setSingleLine(true);
        label.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)10));
        label.setForegroundColor(Colors.taskTreeItemTitle());
        return label;
    }

    private IFigure createChevronFigure() {
        return new ChevronFigure();
    }

    private RotatableWrapLabel createStartFigure() {
        RotatableWrapLabel start = this.createLabel(1);
        start.setText(this.getStartDate(this.getTask()));
        return start;
    }

    private RotatableWrapLabel createEndFigure() {
        RotatableWrapLabel end = this.createLabel(1);
        end.setText(this.getEndDate(this.getTask()));
        return end;
    }

    private RotatableWrapLabel createAssigneeFigure() {
        RotatableWrapLabel assignee = this.createLabel();
        assignee.setText(this.getAssignee(this.getTask()));
        return assignee;
    }

    private RotatableWrapLabel createPriorityFigure() {
        RotatableWrapLabel priority = this.createLabel();
        priority.setText(this.getPriority(this.getTask()));
        return priority;
    }

    private RotatableWrapLabel createProgressFigure() {
        RotatableWrapLabel progress = this.createLabel();
        progress.setText(this.getProgress(this.getTask()));
        return progress;
    }

    private RotatableWrapLabel createLabel() {
        return this.createLabel(2);
    }

    private RotatableWrapLabel createLabel(int textAlign) {
        RotatableWrapLabel label = new RotatableWrapLabel();
        label.setTextAlignment(textAlign);
        label.setAbbreviated(true);
        label.setSingleLine(true);
        label.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)9));
        label.setForegroundColor(ColorConstants.gray);
        return label;
    }

    private String getStartDate(ITopic topic) {
        DateInfo start = TaskInfoUtils.calculateStartDateInfo((ITopic)topic);
        DateFormat formatter = DateFormat.getDateInstance(2, Locale.getDefault());
        return start == null || start.date == null ? null : formatter.format(start.date.getTime());
    }

    private String getEndDate(ITopic topic) {
        DateInfo end = TaskInfoUtils.calculateEndDateInfo((ITopic)topic);
        DateFormat formatter = DateFormat.getDateInstance(2, Locale.getDefault());
        return end == null || end.date == null ? null : formatter.format(end.date.getTime());
    }

    private String getAssignee(ITopic topic) {
        return TaskInfoUtils.getContent((ITopic)topic, (String)"assigned-to");
    }

    private String getPriority(ITopic topic) {
        IMarker marker = TaskInfoUtils.findMarker((ITopic)topic, (String)"priorityMarkers");
        return marker == null ? null : marker.getName().substring(marker.getName().length() - 1);
    }

    private String getProgress(ITopic topic) {
        int progress = TaskInfoUtils.calculateProgress((ITopic)topic);
        return progress >= 0 && progress <= 100 ? String.valueOf(progress) + "%" : null;
    }

    private IFigure createChildContainerFigure() {
        return new Layer();
    }

    public boolean isFolded() {
        return ((GanttEditDomain)this.getSite().getDomain()).getConfigurations().isFolded(this.getTask());
    }

    protected void register() {
        super.register();
        this.registerModel(this.getModel());
        this.registerFigure(this.getMainFigure());
    }

    protected void unregister() {
        this.unregisterFigure(this.getMainFigure());
        this.unregisterModel(this.getModel());
        this.uninstallBackgroundManagers();
        super.unregister();
    }

    protected Object[] getModelChildren(Object model) {
        ITopic task = (ITopic)model;
        return task.getAllChildren().toArray();
    }

    protected void installModelListeners() {
        super.installModelListeners();
        Object m = this.getModel();
        this.eventRegister = new CoreEventRegister(m, (ICoreEventListener)this);
        this.registerCoreEvents(m, this.eventRegister);
    }

    protected void registerCoreEvents(Object source, ICoreEventRegister register) {
        register.register("topicAdd");
        register.register("topicRemove");
        register.register("titleText");
        register.register("taskInfoChange");
        register.register("markerRefAdd");
        register.register("markerRefRemove");
    }

    protected void uninstallModelListeners() {
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
            this.eventRegister = null;
        }
        super.uninstallModelListeners();
    }

    public void handleCoreEvent(final CoreEvent event) {
        Control control = this.getSite().getViewerControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        control.getDisplay().syncExec(new Runnable(){

            public void run() {
                String type = event.getType();
                if ("topicAdd".equals(type) || "topicRemove".equals(type)) {
                    TaskTreeItemPart.this.refresh();
                    TaskTreeItemPart.this.updateParent(event.getTarget());
                } else if ("titleText".equals(type)) {
                    TaskTreeItemPart.this.update("titleText");
                } else if ("taskInfoChange".equals(type)) {
                    TaskTreeItemPart.this.update(event.getTarget());
                    TaskTreeItemPart.this.updateParent(event.getTarget());
                } else if ("markerRefAdd".equals(type) || "markerRefRemove".equals(type)) {
                    TaskTreeItemPart.this.update(event.getTarget());
                }
            }
        });
    }

    private void updateParent(Object target) {
        if (this.getParent() instanceof TaskTreeItemPart) {
            TaskTreeItemPart parent = (TaskTreeItemPart)this.getParent();
            parent.updateView(target);
            parent.updateParent(target);
        }
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)TaskTreeItemSelectablePolicy.getInstance());
        reqHandler.installEditPolicy("extendable role", (IEditPolicy)NullEditPolicy.getInstance());
    }

    protected void updateView(Object property) {
        ITopic task = this.getTask();
        String viewerMode = this.getViewerMode();
        TaskTreeWidthsSupport widthsSupport = this.getWidthsSupport();
        if (property == null) {
            this.getChevron().setVisible("allTopics".equals(viewerMode) && (task.hasChildren("attached") || task.hasChildren("detached") || task.hasChildren("summary")) || "hierarchical".equals(viewerMode) && TaskInfoUtils.hasTaskInfo((ITopic)task) && TaskInfoUtils.hasCascadeTaskInfo2((ITopic)task));
            this.shouldChevronVisible = this.getChevron().isVisible();
        }
        if (property == null || "titleText".equals(property)) {
            ((ITextFigure)this.getTitle()).setText(this.getTitleText(task));
        }
        if (property == null || "topicFolded".equals(property)) {
            boolean folded = ((GanttEditDomain)this.getSite().getDomain()).getConfigurations().isFolded(task);
            ((ChevronFigure)this.getChevron()).setFolded(folded);
            this.getContentPane().setVisible(!folded);
        }
        if (property == null || "start-date".equals(property) || "duration".equals(property) || "end-date".equals(property) || "predecessors".equals(property) || "check-point".equals(property)) {
            if (widthsSupport.indexOf("Start") != -1) {
                this.items[widthsSupport.indexOf("Start")].setText(this.getStartDate(task));
            }
            if (widthsSupport.indexOf("End") != -1) {
                this.items[widthsSupport.indexOf("End")].setText(this.getEndDate(task));
            }
        }
        if (property == null || "assigned-to".equals(property) || property instanceof String && ((String)property).startsWith("priority")) {
            if (widthsSupport.indexOf("Assignee") != -1) {
                this.items[widthsSupport.indexOf("Assignee")].setText(this.getAssignee(task));
            }
            if (widthsSupport.indexOf("Priority") != -1) {
                this.items[widthsSupport.indexOf("Priority")].setText(this.getPriority(task));
            }
        }
        if ((property == null || property instanceof String && ((String)property).startsWith("task-")) && widthsSupport.indexOf("Progress") != -1) {
            this.items[widthsSupport.indexOf("Progress")].setText(this.getProgress(task));
        }
        ITopic topic = this.getTask();
        if ("allTopics".equals(viewerMode) || TaskInfoUtils.hasCascadeTaskInfo((ITopic)topic)) {
            this.getFigure().setVisible(true);
            if (("flat".equals(viewerMode) || "hierarchical".equals(viewerMode)) && !TaskInfoUtils.hasTaskInfo((ITopic)topic)) {
                this.titleLayer.setVisible(false);
            } else {
                this.titleLayer.setVisible(true);
            }
        } else {
            this.getFigure().setVisible(false);
        }
        this.titleLayer.revalidate();
    }

    public void setActiveEditor(Control activeEditor) {
        this.activeEditor = activeEditor;
    }

    public void closeEditor() {
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (TaskTreeItemPart.this.activeEditor != null && !TaskTreeItemPart.this.activeEditor.isDisposed()) {
                    TaskTreeItemPart.this.activeEditor.dispose();
                    TaskTreeItemPart.this.activeEditor = null;
                }
            }
        });
    }

    protected String getTitleText(ITopic task) {
        return task.getTitleText().replaceAll("\r\n|\r|\n", " ");
    }

    private String getViewerMode() {
        String viewerMode = GanttPlugin.getDefault().getPreferenceStore().getString("org.xmind.ui.gantt.radioState.viewerMode");
        return viewerMode == null || "".equals(viewerMode) ? "allTopics" : viewerMode;
    }

    public IFigure getHostFigure() {
        return this.getTitleLayer();
    }

    public boolean isHostFigureVisible() {
        IFigure layer = this.getFigure();
        IFigure hostFigure = this.getHostFigure();
        return layer.isVisible() && hostFigure.isVisible();
    }

    public void update(Object property) {
        super.update(property);
        this.updateBackground();
    }

    public void refresh() {
        super.refresh();
        this.updateBackground();
    }

    protected void updateChildren(Object property) {
        super.updateChildren(property);
        List parts = this.getChildren();
        for (IPart part : parts) {
            if (!(part instanceof TaskTreeItemPart)) continue;
            ((TaskTreeItemPart)part).updateBackground();
            ((TaskTreeItemPart)part).updateChildren(property);
        }
    }

    private void installBackgroundManager(IBackgroundManager backgroundManager) {
        if (backgroundManager == null) {
            return;
        }
        backgroundManager.setHost(this);
        this.backgroundManagers.add(backgroundManager);
    }

    private void uninstallBackgroundManagers() {
        IBackgroundManager[] managerArray = this.backgroundManagers.toArray(new IBackgroundManager[2]);
        int i = 0;
        while (i < managerArray.length) {
            this.uninstallBackgroundManager(managerArray[i]);
            ++i;
        }
    }

    private void uninstallBackgroundManager(IBackgroundManager backgroundManager) {
        if (backgroundManager == null) {
            return;
        }
        this.backgroundManagers.remove(backgroundManager);
        backgroundManager.dispose();
        backgroundManager = null;
    }

    private void updateBackground() {
        for (IBackgroundManager backgroundManager : this.backgroundManagers) {
            backgroundManager.update();
        }
    }

    public boolean isChevronVisible() {
        return this.getChevron().isVisible() && this.shouldChevronVisible;
    }

    protected void onActivated() {
        super.onActivated();
        if (this.getProperties() != null) {
            this.getProperties().addPropertyChangeListener("renderTextAsPath", (PropertyChangeListener)this);
        }
    }

    protected void onDeactivated() {
        if (this.getProperties() != null) {
            this.getProperties().removePropertyChangeListener("renderTextAsPath", (PropertyChangeListener)this);
        }
        super.onDeactivated();
    }

    private Properties getProperties() {
        if (this.ganttViewer != null) {
            return this.ganttViewer.getProperties();
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getProperties() != null) {
            boolean useAdvancedRenderer = this.getProperties().getBoolean("renderTextAsPath", false);
            RotatableWrapLabel[] rotatableWrapLabelArray = this.items;
            int n = this.items.length;
            int n2 = 0;
            while (n2 < n) {
                RotatableWrapLabel item = rotatableWrapLabelArray[n2];
                item.setRenderStyle(useAdvancedRenderer ? 1 : 0);
                ++n2;
            }
        }
    }

    private static class SubTaskContainerLayout
    extends AbstractHintLayout {
        private SubTaskContainerLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            Dimension s = new Dimension(0, 0);
            List children = container.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                if (child.isVisible()) {
                    Dimension size = child.getPreferredSize(wHint, -1);
                    s.width = Math.max(s.width, size.width);
                    s.height += size.height;
                }
                ++i;
            }
            return s;
        }

        public void layout(IFigure container) {
            Rectangle r = container.getClientArea();
            int x = r.x;
            int y = r.y;
            List children = container.getChildren();
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                if (child.isVisible()) {
                    Dimension size = child.getPreferredSize(r.width, -1);
                    child.setBounds(new Rectangle(x, y, size.width, size.height));
                    y += size.height;
                }
                ++i;
            }
        }
    }

    private class TaskTreeLayout
    extends AbstractHintLayout {
        private TaskTreeLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            Dimension s = new Dimension();
            if (container.isVisible()) {
                int sum;
                if (TaskTreeItemPart.this.titleLayer.isVisible()) {
                    Dimension s1 = TaskTreeItemPart.this.titleLayer.getPreferredSize();
                    s.width += s1.width;
                    s.height += s1.height;
                }
                if (TaskTreeItemPart.this.childContainer.isVisible()) {
                    Dimension s2 = TaskTreeItemPart.this.childContainer.getPreferredSize();
                    s.width = "flat".equals(TaskTreeItemPart.this.getViewerMode()) || !TaskTreeItemPart.this.titleLayer.isVisible() ? Math.max(s.width, s2.width) : Math.max(s.width, s2.width + 17);
                    s.height += s2.height;
                }
                s.width = s.width > (sum = TaskTreeItemPart.this.getWidthsSupport().sum()) ? sum : s.width;
            }
            return s;
        }

        public void layout(IFigure container) {
            Rectangle r = container.getClientArea();
            Dimension s1 = TaskTreeItemPart.this.titleLayer.getPreferredSize();
            int x = r.x;
            int y = r.y;
            TaskTreeItemPart.this.titleLayer.setBounds(new Rectangle(x, y, TaskTreeItemPart.this.getWidthsSupport().sum() - x, s1.height));
            if (TaskTreeItemPart.this.childContainer.isVisible()) {
                Dimension s2 = TaskTreeItemPart.this.childContainer.getPreferredSize();
                if (TaskTreeItemPart.this.titleLayer.isVisible()) {
                    y += s1.height;
                }
                if ("flat".equals(TaskTreeItemPart.this.getViewerMode())) {
                    TaskTreeItemPart.this.childContainer.setBounds(new Rectangle(0, y, s2.width, s2.height));
                } else if (!TaskTreeItemPart.this.titleLayer.isVisible()) {
                    TaskTreeItemPart.this.childContainer.setBounds(new Rectangle(x, y, s2.width, s2.height));
                } else {
                    TaskTreeItemPart.this.childContainer.setBounds(new Rectangle(x + 17, y, s2.width, s2.height));
                }
            }
        }
    }

    private class TaskTreeTitleLayout
    extends AbstractHintLayout {
        private Map<IFigure, Object> constraints = new HashMap<IFigure, Object>();

        private TaskTreeTitleLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            Dimension s = new Dimension(Math.max(wHint, 0), HEIGHT + 7);
            s.width = TaskTreeItemPart.this.getWidthsSupport().sum();
            return s;
        }

        public void layout(IFigure container) {
            Rectangle r = container.getClientArea();
            Dimension s1 = TaskTreeItemPart.this.chevron.getPreferredSize();
            int x = r.x;
            int y = r.y + 3;
            TaskTreeItemPart.this.chevron.setBounds(new Rectangle(x, (HEIGHT - 12) / 2 + y + 1, s1.width, s1.height));
            TaskTreeWidthsSupport widthsSupport = TaskTreeItemPart.this.getWidthsSupport();
            if (TaskTreeItemPart.this.shouldChevronVisible) {
                if (x + s1.width >= widthsSupport.getWidth(0)) {
                    TaskTreeItemPart.this.chevron.setVisible(false);
                } else {
                    TaskTreeItemPart.this.chevron.setVisible(true);
                }
            }
            x += s1.width + 3;
            int y1 = y - 2;
            int height1 = s1.height + 4;
            if ("flat".equals(TaskTreeItemPart.this.getViewerMode())) {
                TaskTreeItemPart.this.items[0].setBounds(new Rectangle(5, y1, widthsSupport.getWidth(0) - 5 - 1, height1));
            } else {
                TaskTreeItemPart.this.items[0].setBounds(new Rectangle(x, y1, widthsSupport.getWidth(0) - x - 1, height1));
            }
            int i = 1;
            while (i < TaskTreeItemPart.this.items.length) {
                TaskTreeItemPart.this.items[i].setBounds(new Rectangle(widthsSupport.sum(i - 1) + 1, y1 - 1, widthsSupport.getWidth(i) - 1, height1 + 2));
                ++i;
            }
        }

        public void setConstraint(IFigure child, Object constraint) {
            super.setConstraint(child, constraint);
            this.constraints.put(child, constraint);
        }

        public Object getConstraint(IFigure child) {
            return this.constraints.get(child);
        }
    }
}

