/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.IAdaptable;
import org.xmind.core.internal.dom.IDKey;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.INodeAdaptableProvider;

public class NodeAdaptableRegistry
implements INodeAdaptableProvider {
    private Document defaultDocument;
    private INodeAdaptableFactory factory;
    private Map<IDKey, IAdaptable> idMap = new HashMap<IDKey, IAdaptable>();
    private Map<Node, IAdaptable> nodeMap = new HashMap<Node, IAdaptable>();
    private IDKey key = new IDKey(null, null);

    public NodeAdaptableRegistry(Document defaultDocument, INodeAdaptableFactory factory) {
        this.defaultDocument = defaultDocument;
        this.factory = factory;
    }

    public IAdaptable getAdaptable(String id) {
        return this.getAdaptable(id, this.defaultDocument);
    }

    public IAdaptable getAdaptable(String id, Document document) {
        Element element;
        IAdaptable a = this.getAdaptableById(id, document);
        if (a == null && (element = document.getElementById(id)) != null) {
            a = this.getAdaptableByNode(element);
            if (a == null) {
                a = this.createAdaptable(element);
            }
            if (a != null) {
                this.registerByNode(a, element);
                this.registerById(a, id, document);
            }
        }
        return a;
    }

    public IAdaptable getAdaptable(Node node) {
        IAdaptable a = this.nodeMap.get(node);
        if (a == null && (a = this.createAdaptable(node)) != null) {
            this.registerByNode(a, node);
            String id = this.getId(node);
            if (id != null) {
                this.registerById(a, id, node.getOwnerDocument());
            }
        }
        return a;
    }

    public void register(IAdaptable adaptable, String id) {
        this.register(adaptable, id, this.defaultDocument);
    }

    public void register(IAdaptable adaptable, String id, Document document) {
        this.registerById(adaptable, id, document);
        Element element = document.getElementById(id);
        if (element != null) {
            this.registerByNode(adaptable, element);
        }
    }

    public void register(IAdaptable adaptable, Node node) {
        this.registerByNode(adaptable, node);
        String id = this.getId(node);
        if (id != null) {
            this.registerById(adaptable, id, node.getOwnerDocument());
        }
    }

    public void unregister(IAdaptable adaptable, String id) {
        this.unregister(adaptable, id, this.defaultDocument);
    }

    public void unregister(IAdaptable adaptable, String id, Document document) {
        this.unregisterById(adaptable, id, document);
        Element element = document.getElementById(id);
        if (element != null) {
            this.unregisterByNode(adaptable, element);
        }
    }

    public void unregister(IAdaptable adaptable, Node node) {
        this.unregisterByNode(adaptable, node);
        String id = this.getId(node);
        if (id != null) {
            this.unregisterById(adaptable, id, node.getOwnerDocument());
        }
    }

    private String getId(Node node) {
        String id;
        Node v;
        if (node.getNodeType() == 1 && (v = node.getAttributes().getNamedItem("id")) != null && (id = v.getNodeValue()) != null && !"".equals(id)) {
            return id;
        }
        return null;
    }

    private IDKey getIDKey(String id, Document document) {
        this.key.id = id;
        this.key.document = document;
        return this.key;
    }

    private IDKey createIDKey(String id, Document document) {
        return new IDKey(document, id);
    }

    public IAdaptable getAdaptableById(String id, Document document) {
        return this.idMap.get(this.getIDKey(id, document));
    }

    public IAdaptable getAdaptableByNode(Node node) {
        return this.nodeMap.get(node);
    }

    public void registerById(IAdaptable adaptable, String id, Document document) {
        this.idMap.put(this.createIDKey(id, document), adaptable);
    }

    public void registerByNode(IAdaptable adaptable, Node node) {
        this.nodeMap.put(node, adaptable);
    }

    public void unregisterById(IAdaptable adaptable, String id, Document document) {
        IDKey key = this.getIDKey(id, document);
        IAdaptable a = this.idMap.get(key);
        if (a == adaptable || a != null && a.equals(adaptable)) {
            this.idMap.remove(key);
        }
    }

    public void unregisterByNode(IAdaptable adaptable, Node node) {
        IAdaptable a = this.nodeMap.get(node);
        if (a == adaptable || a != null && a.equals(adaptable)) {
            this.nodeMap.remove(node);
        }
    }

    private IAdaptable createAdaptable(Node element) {
        return this.factory == null ? null : this.factory.createAdaptable(element);
    }
}

