pub const ext = @import("ext.zig");
const gstvulkanwayland = @This();

const std = @import("std");
const compat = @import("compat");
const vulkan = @import("vulkan1");
const gstvulkan = @import("gstvulkan1");
const gstvideo = @import("gstvideo1");
const gstbase = @import("gstbase1");
const gst = @import("gst1");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
/// the contents of a `gstvulkanwayland.VulkanDisplayWayland` are private and should only be accessed
/// through the provided API
pub const VulkanDisplayWayland = extern struct {
    pub const Parent = gstvulkan.VulkanDisplay;
    pub const Implements = [_]type{};
    pub const Class = gstvulkanwayland.VulkanDisplayWaylandClass;
    f_parent: gstvulkan.VulkanDisplay,
    f_display: ?*anyopaque,
    f_registry: ?*anyopaque,
    f_compositor: ?*anyopaque,
    f_subcompositor: ?*anyopaque,
    f_shell: ?*anyopaque,
    f_foreign_display: c_int,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Create a new `gstvulkanwayland.VulkanDisplayWayland` from the wayland display name.  See `wl_display_connect`()
    /// for details on what is a valid name.
    extern fn gst_vulkan_display_wayland_new(p_name: ?[*:0]const u8) ?*gstvulkanwayland.VulkanDisplayWayland;
    pub const new = gst_vulkan_display_wayland_new;

    /// Creates a new display connection from a wl_display Display.
    extern fn gst_vulkan_display_wayland_new_with_display(p_display: ?*anyopaque) *gstvulkanwayland.VulkanDisplayWayland;
    pub const newWithDisplay = gst_vulkan_display_wayland_new_with_display;

    extern fn gst_vulkan_display_wayland_get_type() usize;
    pub const getGObjectType = gst_vulkan_display_wayland_get_type;

    extern fn g_object_ref(p_self: *gstvulkanwayland.VulkanDisplayWayland) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *gstvulkanwayland.VulkanDisplayWayland) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *VulkanDisplayWayland, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VulkanDisplayWaylandClass = extern struct {
    pub const Instance = gstvulkanwayland.VulkanDisplayWayland;

    f_object_class: gstvulkan.VulkanDisplayClass,

    pub fn as(p_instance: *VulkanDisplayWaylandClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};
