/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import net.yura.swing.Collapsible;

public class CollapsiblePanel
extends JPanel
implements Collapsible,
ActionListener {
    private JButton collapseButton;
    private boolean collapsed = false;
    private Component curComponent;

    public CollapsiblePanel(Component comp, String text) {
        this.setLayout(new BorderLayout());
        this.collapsed = true;
        this.curComponent = comp;
        this.removeAll();
        this.collapseButton = new JButton(text);
        this.collapseButton.setRolloverEnabled(true);
        this.collapseButton.setFocusPainted(false);
        this.collapseButton.setDefaultCapable(false);
        this.collapseButton.setBorder(null);
        this.collapseButton.setBorderPainted(false);
        this.collapseButton.setMargin(new Insets(0, 0, 0, 0));
        this.collapseButton.setToolTipText("Collapses/Expands the ToolBar");
        this.collapseButton.addActionListener(this);
        this.add((Component)this.collapseButton, "North");
        Dimension dim = this.collapseButton.getSize();
        this.collapseButton.setBounds(0, 0, dim.width, dim.height);
        this.setBackground(comp.getBackground());
        this.revalidate();
    }

    public Component getComponent() {
        return this.curComponent;
    }

    public void collapse() {
        this.removeAll();
        this.add((Component)this.collapseButton, "North");
        Dimension dim2 = this.getSize();
        this.setSize(new Dimension(dim2.width, 5));
        this.remove(this.curComponent);
        this.revalidate();
        this.collapsed = true;
    }

    public void expand() {
        this.removeAll();
        this.add((Component)this.collapseButton, "North");
        this.add(this.curComponent, "Center");
        this.revalidate();
        this.collapsed = false;
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.isCollapsed()) {
            this.expand();
        } else {
            this.collapse();
        }
    }
}

