/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.stats;

import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;

@ServiceScope(value={Scope.Global.class})
public class DaemonRunningStats {
    private final long startTime = System.currentTimeMillis();
    private final Timer daemonTimer = Time.startTimer();
    private final Timer currentBuildTimer = Time.startTimer();
    private int buildCount;
    private long allBuildsTime;

    public int getBuildCount() {
        return this.buildCount;
    }

    public String getPrettyUpTime() {
        return this.daemonTimer.getElapsed();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getAllBuildsTime() {
        return this.allBuildsTime;
    }

    public void buildStarted() {
        ++this.buildCount;
        this.currentBuildTimer.reset();
    }

    public void buildFinished() {
        long buildTime = Math.max(this.currentBuildTimer.getElapsedMillis(), 1L);
        this.allBuildsTime += buildTime;
    }
}

