/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "MainMenu.h"
#include "Globals.h"
#include "Stuff.h"

namespace MainMenu {

MainMenu_State::MainMenu_State() {
	genPictures[GENPIC_TITLE] = JSDL.BitmapHDtoSurface(globalSettings.bdp + "graphics/title.png", 0, 0, 990, 204);

	myWindows.push_back(GenWindow(0, 0, MM_MainSM, 0, 0, 0));

	if (globalErrorString != "No error right now") {
		string error = '\n' + globalErrorString;
		CreateInfoString(error.c_str());
		globalErrorString = "No error right now";
	}

	if (JSDL.musicName != globalSettings.bdp + "music/fission.ogg") {
		JSDL.LoadMusic(globalSettings.bdp + "music/fission.ogg");
		JSDL.PlayMusic();
	}
}

MainMenu_State::~MainMenu_State() {
	SDL_FreeSurface(genPictures[GENPIC_TITLE]);
	genPictures[GENPIC_TITLE] = 0;

	KillAllWindows();
}

void MainMenu_State::Main() {
	DrawWorld();
}

void MainMenu_State::Keyboard(SDL_keysym& keysym) {
	switch (keysym.sym) {
	case SDLK_s:
		gsTo = GST_SetupBattle;
		break;
	case SDLK_f:
		gsTo = GST_ForceSelect;
		break;
	case SDLK_ESCAPE:
	case SDLK_q:
		gsTo = GST_TheOS;
		break;
	}
}

void DrawWorld() {
	JSDL.BltFill(screenRect, 0);

	SDL_Rect tempRect = {globalSettings.screenWidth / 2 - 495, globalSettings.screenHeight / 8, 0, 0};
	JSDL.Blt(genPictures[GENPIC_TITLE], tempRect);
	string output = "Version " + myVersionNumber;
	normalFonts.BlitString(globalSettings.screenWidth - 120, globalSettings.screenHeight - 20, 0, output);

	DrawAllWindows();
}

MainSM::MainSM():
Menu_Base(0, 0, none_constant, 0) {
	MenuItem tempItem;

	tempItem.desc = "Setup battle";
	tempItem.choice = MM_SetupBattle;
	AddItem(tempItem);

	tempItem.desc = "Fleet editor";
	tempItem.choice = MM_ForceSelect;
	AddItem(tempItem);

	tempItem.desc = "Options";
	tempItem.choice = MM_Options;
	AddItem(tempItem);

	tempItem.desc = "Help";
	tempItem.choice = WC_InfoString;
	AddItem(tempItem);

	tempItem.desc = "Quit";
	tempItem.choice = WC_Quit;
	AddItem(tempItem);

	InitRects();

	CentreWindow();
}

bool MainSM::SwitchOnChoice(Uint16 x, Uint16 y) {
	if (currentSelection.choiceType == MCT_LeftCursor) {
		switch (currentSelection.choice) {
		case MM_SetupBattle:
			gsTo = GST_SetupBattle;
			break;

		case MM_ForceSelect:
			gsTo = GST_ForceSelect;
			break;

		case MM_Options:
			myWindows.push_back(GenWindow(rect.x, rect.y, MM_Options, 0, 0, WFLAG_STATIC | WFLAG_CANTCLOSE));
			closed = true;
			break;

		case WC_InfoString:
			CreateHelpWindow();
			break;

		case WC_Quit:
			gsTo = GST_TheOS;
			break;
		}
	}

	return false;
}

void MainSM::CreateHelpWindow() {
	string tempString =
	"Welcome to GalaxyHack.\n\n"

	"This game allows you to design a fleet of spaceships which can then\n"
	"be tested in AI script based battles against fleets designed by other\n"
	"players.\n\n"

	"Though battles take place in real time, the strategy comes before\n"
	"hand, both in writing short AI scripts in a simple\n"
	"proprietary scripting language, and also in the set up and\n"
	"selection of your fleet.\n\n"

	"The documentation for the game - on the user interface, on fleet\n"
	"selection and on writing AI scripts - is only available on the\n"
	"internet. Please visit\n\n"

	"http://galaxyhack.sourceforge.net\n\n"

	"for more information.\n\n"

	"To close this window, click the cross in the top right hand corner.";

	CreateInfoString(tempString);
}

MainOptions::MainOptions(int ix, int iy):
StandardOptions(ix, iy, none_constant, WFLAG_STATIC | WFLAG_CANTCLOSE) {
	Update();
}
	
void MainOptions::Update() {
	ClearItems();

	MenuItem tempItem;
	
	PushBackSharedItems();
	
	AddBlankItem();
	
	tempItem.desc = "Return to main menu";
	tempItem.choice = WC_Quit;
	AddItem(tempItem);
	
	InitRects();
}

} //end namespace

