/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.mimepull;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jvnet.mimepull.DataFile;
import org.jvnet.mimepull.MIMEParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WeakDataFile
extends WeakReference<DataFile> {
    private static final Logger LOGGER = Logger.getLogger(WeakDataFile.class.getName());
    private static final int MAX_ITERATIONS = 2;
    private static ReferenceQueue<DataFile> refQueue = new ReferenceQueue();
    private static List<WeakDataFile> refList = new ArrayList<WeakDataFile>();
    private final File file;
    private final RandomAccessFile raf;

    WeakDataFile(DataFile df, File file) {
        super(df, refQueue);
        refList.add(this);
        this.file = file;
        try {
            this.raf = new RandomAccessFile(file, "rw");
        }
        catch (IOException ioe) {
            throw new MIMEParsingException(ioe);
        }
        WeakDataFile.drainRefQueueBounded();
    }

    synchronized void read(long pointer, byte[] buf, int offset, int length) {
        try {
            this.raf.seek(pointer);
            this.raf.readFully(buf, offset, length);
        }
        catch (IOException ioe) {
            throw new MIMEParsingException(ioe);
        }
    }

    synchronized long writeTo(long pointer, byte[] data, int offset, int length) {
        try {
            this.raf.seek(pointer);
            this.raf.write(data, offset, length);
            return this.raf.getFilePointer();
        }
        catch (IOException ioe) {
            throw new MIMEParsingException(ioe);
        }
    }

    void close() {
        LOGGER.fine("Deleting file = " + this.file.getName());
        refList.remove(this);
        try {
            this.raf.close();
            this.file.delete();
        }
        catch (IOException ioe) {
            throw new MIMEParsingException(ioe);
        }
    }

    void renameTo(File f) {
        LOGGER.fine("Moving file=" + this.file + " to=" + f);
        refList.remove(this);
        try {
            this.raf.close();
            this.file.renameTo(f);
        }
        catch (IOException ioe) {
            throw new MIMEParsingException(ioe);
        }
    }

    static void drainRefQueueBounded() {
        WeakDataFile weak = (WeakDataFile)refQueue.poll();
        for (int iterations = 0; weak != null && iterations < 2; ++iterations) {
            LOGGER.fine("Cleaning file = " + weak.file + " from reference queue.");
            weak.close();
            weak = (WeakDataFile)refQueue.poll();
        }
    }
}

