/*
 *    WMAcpiLoad - A dockapp to monitor ACPI status
 *    Copyright (C) 2002  Thomas Nemeth <tnemeth@free.fr>
 *
 *    Patch by Alan Carriou <cariou_alan@yahoo.fr> (C) 2004-2005
 *
 *    Based on work by Seiichi SATO <ssato@sh.rim.or.jp>
 *    Copyright (C) 2001,2002  Seiichi SATO <ssato@sh.rim.or.jp>
 *    and on work by Mark Staggs <me@markstaggs.net>
 *    Copyright (C) 2002  Mark Staggs <me@markstaggs.net>

 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.

 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.

 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef H_BATTERY
#  define H_BATTERY

/************************************************************************
 * Constants
 ************************************************************************/

/*
 * Name of the subdirectory of /proc/acpi which contains the battery
 * information.
 * Must contain "/" as first and last characters.
 */
extern const char *const battery_dir;

/* 
 * Name of the file in the device directory which contains its status, i.e.
 * charging state and so on.
 * Must contain "/" as first character.
 */
extern const char *const battery_status_file;

/* 
 * Name of the file in the device directory which contains its static information,
 * i.e. capacity and so on.
 * Must contain "/" as first character.
 */
extern const char *const battery_info_file;

/************************************************************************
 * Function prototypes for battery.c
 ************************************************************************/

/*
 * Allocates memory for a Battery structure, and initializes it
 * with the static data found in the directory provided, which must be
 * one such as /proc/acpi/battery/BAT1/.
 *
 * If the dirent* is NULL, or if any malloc() fails, then it returns NULL.
 */
void *battery_init(struct dirent *);

/*
 * Sets the selected battery to the next, or the first if the battery
 * selected before calling battery_next() is the last.
 *
 * If the AcpiInfos is NULL, or if there is no battery, then
 * battery_next() does nothing.
 */
void battery_next(AcpiInfos *);

/*
 * Cleanly frees the Battery from memory.
 *
 * Accepts a NULL Battery*, but does nothing with it.
 */
void battery_free(Battery *);

/*
 * Sets the "plugged" attribute of the given Battery.
 *
 * If the Battery* is NULL, the function does nothing but returns.
 * If unconsitent data is met, "plugged" is set to zero.
 */
void battery_check_plugged(Battery *);

/*
 * Sets the "capacity" attribute of the given Battery.
 * In case of error, the capacity is set to 0.
 *
 * If the Battery* is NULL, the function does nothing but returns.
 */
void battery_get_capacity(Battery *);


/*
 * Updates the status and percentage fields of the Battery.
 * If the parameter is NULL, or if it is a valid _unplugged_ Battery,
 * Then it does nothing and returns.
 */
void battery_update_status(Battery *);

/*
 * Updates the plugged field of the Battery, and call battery_get_capacity
 * if the battery is plugged.
 * If the parameter is NULL, then it does nothing.
 */
void battery_update_plugged(Battery *);

#endif                          /* H_BATTERY */
