/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.util.IoHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class VariableSubstitutor
implements Serializable {
    private static final long serialVersionUID = 3907213762447685687L;
    protected transient Properties variables;
    protected boolean bracesRequired = false;
    protected static final int TYPE_PLAIN = 0;
    protected static final int TYPE_JAVA_PROPERTIES = 1;
    protected static final int TYPE_XML = 2;
    protected static final int TYPE_SHELL = 3;
    protected static final int TYPE_AT = 4;
    protected static final int TYPE_JAVA = 5;
    protected static final int TYPE_ANT = 6;
    public static final String PLAIN = "plain";
    protected static final Map<String, Integer> typeNameToConstantMap = new HashMap<String, Integer>();

    public VariableSubstitutor(Properties properties) {
        this.variables = properties;
    }

    public boolean areBracesRequired() {
        return this.bracesRequired;
    }

    public void setBracesRequired(boolean bl) {
        this.bracesRequired = bl;
    }

    public String substitute(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            return null;
        }
        StringReader stringReader = new StringReader(string);
        StringWriter stringWriter = new StringWriter();
        try {
            this.substitute(stringReader, stringWriter, string2);
        }
        catch (IOException iOException) {
            throw new Error("Unexpected I/O exception when reading/writing memory buffer; nested exception is: " + iOException);
        }
        return stringWriter.getBuffer().toString();
    }

    public int substitute(InputStream inputStream, OutputStream outputStream, String string, String string2) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        if (string2 == null) {
            int n = this.getTypeConstant(string);
            switch (n) {
                case 1: {
                    string2 = "ISO-8859-1";
                    break;
                }
                case 2: {
                    string2 = "UTF-8";
                }
            }
        }
        InputStreamReader inputStreamReader = string2 != null ? new InputStreamReader(inputStream, string2) : new InputStreamReader(inputStream);
        OutputStreamWriter outputStreamWriter = string2 != null ? new OutputStreamWriter(outputStream, string2) : new OutputStreamWriter(outputStream);
        int n = this.substitute(inputStreamReader, outputStreamWriter, string);
        outputStreamWriter.flush();
        return n;
    }

    public String substitute(InputStream inputStream, String string) throws IllegalArgumentException, UnsupportedEncodingException, IOException {
        String string2 = PLAIN;
        int n = this.getTypeConstant(string);
        switch (n) {
            case 1: {
                string2 = "ISO-8859-1";
                break;
            }
            case 2: {
                string2 = "UTF-8";
            }
        }
        InputStreamReader inputStreamReader = string2 != null ? new InputStreamReader(inputStream, string2) : new InputStreamReader(inputStream);
        StringWriter stringWriter = new StringWriter();
        this.substitute(inputStreamReader, stringWriter, string);
        stringWriter.flush();
        return stringWriter.getBuffer().toString();
    }

    public int substitute(Reader reader, Writer writer, String string) throws IllegalArgumentException, IOException {
        int n = this.getTypeConstant(string);
        int n2 = 36;
        int n3 = 0;
        if (n == 3) {
            n2 = 37;
        } else if (n == 4) {
            n2 = 64;
        } else if (n == 6) {
            n2 = 64;
            n3 = 64;
        }
        int n4 = 0;
        int n5 = reader.read();
        while (true) {
            if (n5 != -1 && n5 != n2) {
                writer.write(n5);
                n5 = reader.read();
                continue;
            }
            if (n5 == -1) {
                return n4;
            }
            boolean bl = false;
            n5 = reader.read();
            if (n5 == 123) {
                bl = true;
                n5 = reader.read();
            } else {
                if (this.bracesRequired) {
                    writer.write(n2);
                    continue;
                }
                if (n5 == -1) {
                    writer.write(n2);
                    return n4;
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            while (n5 != -1 && bl && n5 != 125 || n5 >= 97 && n5 <= 122 || n5 >= 65 && n5 <= 90 || bl && (n5 == 91 || n5 == 93) || (n5 >= 48 && n5 <= 57 || n5 == 95 || n5 == 46 || n5 == 45) && stringBuffer.length() > 0) {
                stringBuffer.append((char)n5);
                n5 = reader.read();
            }
            String string2 = stringBuffer.toString();
            String string3 = null;
            if (!(bl && n5 != 125 || bl && n3 != 0 && n3 != n5 || string2.length() <= 0)) {
                if (bl && string2.startsWith("ENV[") && string2.lastIndexOf(93) == string2.length() - 1) {
                    string3 = IoHelper.getenv(string2.substring(4, string2.length() - 1));
                    if (string3 == null) {
                        string3 = "";
                    }
                } else {
                    string3 = this.variables.getProperty(string2);
                }
                ++n4;
            }
            if (string3 != null) {
                writer.write(this.escapeSpecialChars(string3, n));
                if (!bl && n3 == 0) continue;
                n5 = reader.read();
                continue;
            }
            writer.write(n2);
            if (bl) {
                writer.write(123);
            }
            writer.write(string2);
        }
    }

    protected int getTypeConstant(String string) {
        if (string == null) {
            return 0;
        }
        Integer n = typeNameToConstantMap.get(string);
        if (n == null) {
            throw new IllegalArgumentException("Unknown file type " + string);
        }
        return n;
    }

    protected String escapeSpecialChars(String string, int n) {
        switch (n) {
            case 0: 
            case 4: 
            case 6: {
                return string;
            }
            case 3: {
                return string.replace("\r", "");
            }
            case 1: 
            case 5: {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n2 = string.length();
                for (int i = 0; i < n2; ++i) {
                    char c = stringBuffer.charAt(i);
                    if (n == 1) {
                        if (c == '\t' || c == '\n' || c == '\r') {
                            char c2 = c == '\t' ? (char)'t' : (c == '\n' ? (char)'n' : 'r');
                            stringBuffer.replace(i, i + 1, "\\" + c2);
                            ++n2;
                            ++i;
                        }
                        if (c != '\\' && c != '\"' && c != '\'' && c != ' ') continue;
                        stringBuffer.insert(i, '\\');
                        ++n2;
                        ++i;
                        continue;
                    }
                    if (c != '\\') continue;
                    stringBuffer.replace(i, i + 1, "\\\\");
                    ++n2;
                    ++i;
                }
                return stringBuffer.toString();
            }
            case 2: {
                StringBuffer stringBuffer = new StringBuffer(string);
                int n3 = string.length();
                for (int i = 0; i < n3; ++i) {
                    String string2 = null;
                    char c = stringBuffer.charAt(i);
                    switch (c) {
                        case '<': {
                            string2 = "&lt;";
                            break;
                        }
                        case '>': {
                            string2 = "&gt;";
                            break;
                        }
                        case '&': {
                            string2 = "&amp;";
                            break;
                        }
                        case '\'': {
                            string2 = "&apos;";
                            break;
                        }
                        case '\"': {
                            string2 = "&quot;";
                        }
                    }
                    if (string2 == null) continue;
                    stringBuffer.replace(i, i + 1, string2);
                    n3 = stringBuffer.length();
                    i += string2.length() - 1;
                }
                return stringBuffer.toString();
            }
        }
        throw new Error("Unknown file type constant " + n);
    }

    static {
        typeNameToConstantMap.put(PLAIN, 0);
        typeNameToConstantMap.put("javaprop", 1);
        typeNameToConstantMap.put("java", 5);
        typeNameToConstantMap.put("xml", 2);
        typeNameToConstantMap.put("shell", 3);
        typeNameToConstantMap.put("at", 4);
        typeNameToConstantMap.put("ant", 6);
    }
}

