/*
 * wxCHTDecoder
 * Copyright (C) 2004,2008 emuWorks
 * http://games.technoplaza.net/
 *
 * This file is part of wxCHTDecoder.
 *
 * wxCHTDecoder is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wxCHTDecoder is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with wxCHTDecoder; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// $Id: chtframe.cc,v 1.6 2008/12/15 04:02:56 jdratlif Exp $

#ifdef HAVE_CONFIG_H
    #include <config.h>
#endif
 
#include <wx/wxprec.h>

#ifndef WX_PRECOMP
   #include <wx/wx.h>
#endif
 
#include "chtdecoder.hh"
#include "datastructures/chtcode.hh"
#include "view/chtframe.hh"
#include "view/chttextcontrol.hh"

using namespace wxCHTDecoder;

BEGIN_EVENT_TABLE(CHTFrame, wxFrame)
    EVT_MENU(wxID_OPEN, CHTFrame::OnOpen)
    EVT_MENU(wxID_SAVE, CHTFrame::OnSave)
    EVT_MENU(wxID_EXIT, CHTFrame::OnExit)
    EVT_MENU(wxID_ABOUT, CHTFrame::OnAbout)
END_EVENT_TABLE()

CHTFrame::CHTFrame(const wxString& title, const wxPoint& pos,
                   const wxSize& size) : wxFrame(0, -1, title, pos, size) {
    // build the main menu
    menuBar = new wxMenuBar();
    fileMenu = new wxMenu();
    helpMenu = new wxMenu();
    
    fileMenu->Append(wxID_OPEN, 
                     wxT("&Open"), 
                     wxT("Open .CHT File for Decoding"));
    fileMenu->Append(wxID_SAVE, 
                     wxT("&Save"), 
                     wxT("Save decode .CHT codes to file"));
    fileMenu->AppendSeparator();
    fileMenu->Append(wxID_EXIT, 
                     wxT("E&xit"),
                     (wxT("Exit ") + *CHTDecoder::APP_NAME));
    
    // disable saving till one is loaded
    fileMenu->Enable(wxID_SAVE, false);
    
    helpMenu->Append(wxID_ABOUT, 
                     wxT("&About ") + *CHTDecoder::APP_NAME + wxT("..."),
                     wxT("Display Copyright Information"));
    
    menuBar->Append(fileMenu, wxT("&File"));
    menuBar->Append(helpMenu, wxT("&Help"));
    
    SetMenuBar(menuBar);
    
    // build the status bar
    CreateStatusBar();
    SetStatusText(*CHTDecoder::APP_NAME + wxT(' ') + *CHTDecoder::APP_VERSION);
    
    // build the text control
    chtText = new CHTTextControl(this);
}

void CHTFrame::OnOpen(wxCommandEvent&) {
    static wxFileDialog *dlg = new wxFileDialog(this, 
        wxT("Choose a .CHT file to decode..."), wxT(""), wxT(""), 
        wxT("ZSNES .CHT Files (*.cht)|*.cht"), (wxFD_OPEN | wxFD_CHANGE_DIR));
    
    int value = dlg->ShowModal();
    
    if (value == wxID_OK) {
        wxString filename = dlg->GetPath();
        chtText->readCHTFile(filename);
    }
}

void CHTFrame::OnSave(wxCommandEvent&) {
    static wxFileDialog *dlg = new wxFileDialog(this, 
        wxT("Choose a .TXT file to save to..."), wxT(""), wxT(""), 
        wxT("Text Files (*.txt)|*.txt"), (wxFD_SAVE | wxFD_CHANGE_DIR));
    
    int value = dlg->ShowModal();
    
    if (value == wxID_OK) {
        wxString filename = dlg->GetPath();
        chtText->SaveFile(filename);
    }
}

void CHTFrame::OnExit(wxCommandEvent&) {
    Close(true);
}

void CHTFrame::OnAbout(wxCommandEvent &) {
    wxMessageDialog dlg(this, *CHTDecoder::APP_NAME + wxT(' ') + 
                        *CHTDecoder::APP_VERSION + wxT('\n') +
                        *CHTDecoder::APP_COPYRIGHT, wxT("About ") + 
                        *CHTDecoder::APP_NAME + wxT("..."),
                        wxOK | wxICON_INFORMATION);
    dlg.ShowModal();
}

