#include <u.h>
#include <libc.h>
#include <stdarg.h>

/*
 * $Id: print.c,v 1.2 1998/04/23 00:29:30 mhw Exp $
 */

int
print(char *format, ...)
{
	char buf[4096];
	va_list ap;
	char *ep;

	va_start(ap, format);
	ep = doprint(buf, buf+sizeof(buf), format, ap);
	va_end(ap);
	write(1, buf, ep-buf);
	return ep-buf;
}

int 
fprint(int fd, char *format, ...)
{
	char buf[4096];
	va_list ap;
	char *ep;

	va_start(ap, format);
	ep = doprint(buf, buf+sizeof(buf), format, ap);
	va_end(ap);
	write(fd, buf, ep-buf);
	return ep-buf;
}

int
sprint(char *s, char *format, ...)
{
	va_list ap;
	char *ep;

	va_start(ap, format);
	ep = doprint(s, s+4096 /*XXX*/, format, ap);
	va_end(ap);
	*ep = 0;
	return ep-s;
}

int
snprint(char *s, int len, char *format, ...)
{
	va_list ap;
	char *ep;

	va_start(ap, format);
	ep = doprint(s, s+len, format, ap);
	va_end(ap);
	if (ep < s+len)
		*ep++ = 0;
	return ep-s;
}
