/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench;

public class JXWCSVFieldBuffer
implements CharSequence,
Appendable {
    private StringBuffer internalStringBuffer;
    static char columnDelimeter = (char)44;
    static char quoteChar = '\u0000';
    static char multiValuedAttDelimeter = (char)59;
    static char escapeChar = (char)92;
    static boolean useMultipleColumns = false;
    static binaryHandlingEnum binaryHandling;

    public JXWCSVFieldBuffer() {
        this.internalStringBuffer = new StringBuffer();
    }

    public JXWCSVFieldBuffer(String s) {
        this.internalStringBuffer = s == null ? new StringBuffer() : new StringBuffer(s);
    }

    @Override
    public int length() {
        return this.internalStringBuffer.length();
    }

    @Override
    public char charAt(int i) {
        return this.internalStringBuffer.charAt(i);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        return this.internalStringBuffer.subSequence(i, i1);
    }

    @Override
    public Appendable append(CharSequence charSequence) {
        return this.internalStringBuffer.append(charSequence);
    }

    @Override
    public Appendable append(CharSequence charSequence, int i, int i1) {
        return this.internalStringBuffer.append(charSequence, i, i1);
    }

    @Override
    public Appendable append(char c) {
        return this.internalStringBuffer.append(c);
    }

    public JXWCSVFieldBuffer insert(int offset, char c) {
        this.internalStringBuffer.insert(offset, c);
        return this;
    }

    public boolean contains(char c) {
        int size = this.length();
        for (int i = 0; i < size; ++i) {
            if (this.internalStringBuffer.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    private void escape(char c) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.internalStringBuffer.charAt(i) != c) continue;
            this.internalStringBuffer.insert(i, escapeChar);
            ++i;
        }
    }

    public void escape() {
        if (quoteChar == '\u0000') {
            this.escape(escapeChar);
            this.escape(columnDelimeter);
            if (!useMultipleColumns) {
                this.escape(multiValuedAttDelimeter);
            }
        } else if (this.contains(columnDelimeter) || this.contains(quoteChar) || !useMultipleColumns && this.contains(multiValuedAttDelimeter)) {
            this.escape(quoteChar);
            this.insert(0, quoteChar);
            this.append(quoteChar);
        }
    }

    public static boolean useExcelHack() {
        return quoteChar == escapeChar;
    }

    public void unescape() {
        if (quoteChar == '\u0000') {
            this.removeEscapeCharacters();
        } else {
            boolean quoting = false;
            char lastChar = '\u0000';
            if (this.charAt(0) == quoteChar && this.charAt(this.length() - 1) == quoteChar) {
                this.internalStringBuffer.deleteCharAt(this.length() - 1);
                this.internalStringBuffer.deleteCharAt(0);
                quoting = true;
            }
            for (int i = 0; i < this.length(); ++i) {
                char c = this.internalStringBuffer.charAt(i);
                if (quoting) {
                    if (c == quoteChar) {
                        if (lastChar != escapeChar) {
                            if (JXWCSVFieldBuffer.useExcelHack() && i < this.length() - 1 && this.internalStringBuffer.charAt(i + 1) == quoteChar) {
                                ++i;
                            } else {
                                quoting = false;
                            }
                            this.internalStringBuffer.deleteCharAt(i);
                        } else {
                            this.internalStringBuffer.deleteCharAt(i - 1);
                        }
                    }
                } else if (c == quoteChar) {
                    if (JXWCSVFieldBuffer.useExcelHack() && i < this.length() - 1 && this.internalStringBuffer.charAt(i + 1) == quoteChar) {
                        ++i;
                    } else {
                        quoting = true;
                    }
                    this.internalStringBuffer.deleteCharAt(i);
                } else if (c == escapeChar) {
                    this.internalStringBuffer.deleteCharAt(i);
                    ++i;
                }
                lastChar = c;
            }
        }
    }

    private void removeEscapeCharacters() {
        for (int i = 0; i < this.length(); ++i) {
            if (this.internalStringBuffer.charAt(i) != escapeChar) continue;
            this.internalStringBuffer.deleteCharAt(i);
        }
    }

    @Override
    public String toString() {
        return this.internalStringBuffer.toString();
    }

    static enum binaryHandlingEnum {
        ignore,
        useHex,
        useBase64;

    }
}

