##############################################################################
#desc:       If the journal daemon is running, this perl script will delete 
#            filesystem names from JournaledFileSystems statement in
#            tsmjbbd.ini.
#parameters: filesystem names to be deleted
#example:    perl jbbdelete.pl /svt1 /svt2 
###############################################################################

if (-e "/usr/tivoli/tsm/client/ba/bin64/tsmjbbd") {
   $ini_file = "/usr/tivoli/tsm/client/ba/bin64/tsmjbbd.ini";
}
else {
   if (-e "/opt/tivoli/tsm/client/ba/bin/tsmjbbd") {
      $ini_file = "/opt/tivoli/tsm/client/ba/bin/tsmjbbd.ini";
   }
   else {
     die "Can't identify the location of ini file\n";
   }
}

# Check for at least one name
@ARGV > 0 or exit;

# Check if the journal is already running
$output = `ps -ae|grep tsmjbbd`;
chomp($output);
if ($output eq ""){
   exit 0;
}

# Read the .ini file
open(FILEHANDLE, $ini_file) or die "Unable to open $ini_file";
@content = <FILEHANDLE>;
close FILEHANDLE;

# Find the line with the file systems
foreach $line (@content) {
   if($line =~ /JournaledFileSystems=/){

# Make sure it is not a comment
      @temp = split /\s*JournaledFileSystems=/, $line, 2;
      if ($temp[0] eq "") {
# Substitute space for newline character
         $line =~ s/\n$/ /;

# Delete if filesystem name there
         foreach $fs (@ARGV) {
            $line =~ s/=$fs\s/= /;
            $line =~ s/\s$fs\s/ /;
         }

         chop $line;
         $line .= "\n";     
         last;
      }
   }
}

# Now write the file
open(FILEWRITE, ">$ini_file");
print FILEWRITE @content;
close FILEWRITE; 
