/***********************************************************************
* Name:
*        dapipw.c
*
* Function:
*        Update and change password function for the Tivoli Storage Manager
*        Sample API
*
* Environment:
*        This is a PLATFORM-INDEPENDENT source file. As such it may
*        contain no dependencies on any specific operating system
*        environment or hardware platform.
*
***********************************************************************/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "dsmapitd.h"     /* Standard Tivoli Storage Manager API header.*/
#include "dsmapifp.h"
#include "dapitype.h"     /* Sample API data types.                     */
#include "dsmrc.h"        /* Tivoli Storage Manager API return codes.   */
#include "dapiutil.h"
#include "dapiproc.h"

/*----------------------------------------------------------------------+
| Public routines
.----------------------------------------------------------------------*/

/*----------------------------------------------------------------------+
| Name:    smpaip_chgpw()
|
| Action:  This function is invoked from the sample program main menu.
|          Prompt the end user for current password and new passwords,
|          and if those match send the new password to the server.
|
| Input:   sel_dialog  - Pointer to dialog table to process or NULL if
|                        no dialog.
|
| Returns: RC_OK             - Successful
|          RC_NOT_IN_SESSION - Client is not in session with the server
|          RC_SESSION_FAILED - A tsm api call failed stopping execution
|
| Side
| Effects: None
|
| Notes:   None
+----------------------------------------------------------------------*/
dsInt16_t smpapi_chgpw(dialog *sel_dialog)
{

   dsBool_t   done = bFalse;
   dsBool_t   pw_match = bFalse;
   dsUint16_t   pw_trys;
   dsUint16_t   rc;
   char current_pw[DSM_MAX_VERIFIER_LENGTH + 10];
   char new_pw1   [DSM_MAX_VERIFIER_LENGTH + 10];
   char new_pw2   [DSM_MAX_VERIFIER_LENGTH + 10];

   pw_trys = 0;
   while (!done)
   {
      fflush(stdout);
      printf("\nChanging password for node %s:\n\n",dsmSessInfo.id);
      printf("Enter your current password:"); fflush(stdout);
      ourGetString(current_pw,DSM_MAX_VERIFIER_LENGTH + 2);
      if(strlen(current_pw) > DSM_MAX_VERIFIER_LENGTH)
      {
         fflush(stdout);
         printf("\nPassword too long.  Try again.\n");
         continue;
      }

      printf("Enter your new password:"); fflush(stdout);
      ourGetString(new_pw1,DSM_MAX_VERIFIER_LENGTH + 2);
      if(strlen(new_pw1) > DSM_MAX_VERIFIER_LENGTH)
      {
         fflush(stdout);
         printf("\nNew Password too long.  Try again.\n");
         continue;
      }

      printf("Enter your new password again:"); fflush(stdout);
      ourGetString(new_pw2,DSM_MAX_VERIFIER_LENGTH + 2);

      if(strlen(new_pw2) > DSM_MAX_VERIFIER_LENGTH)
      {
         fflush(stdout);
         printf("\nNew Password (2) too long.  Try again.\n");
         continue;
      }


      if ((strcmp(new_pw1,new_pw2)))
      {
         pw_trys++;
         if (pw_trys > 3)
         {
            printf("Password entry failed.  Exiting retry.\n");
            done = bTrue;
         }
         else
         {
            printf("Your new passwords do not match.  Try again.");
         }
      }
      else
      {
         done = bTrue;
         pw_match = bTrue;
      }
   }

   if (!pw_match) return 0;   /* Get out now since pw's did not match */

   rc = dsmChangePW(dsmHandle,current_pw,new_pw1);
   if (rc)
   {
      printf("*** Password change failed.  Rc = %i\n",rc);
   }
   else
   {
      printf("*** Your new password has been accepted and updated.\n");
   }

return 0;
}
