/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SHARED_H
#define SHARED_H        1

#include "common.h"
#include "image.h"

/* Runtime config data */
extern rc_data_t rc_data;

/* Global widgets */
extern GtkWidget
  *scope,
  *waterfall;

/* Scope signal display */
extern gint
  scope_width,
  scope_height;

/* Waterfall window pixbuf */
extern GdkPixbuf *wfall_pixbuf;
extern guchar *wfall_pixels;
extern gint
  wfall_rowstride,
  wfall_n_channels,
  wfall_width,
  wfall_height;

/* Pixel buffer */
extern guchar *pixel_buf;

extern int
  sat_type,   /* Weather satellite type number   */
  sync_ref,   /* Required position of sync train */
  sync_err,   /* Deviation from sync reference   */
  duration,   /* Processing duration */
  line_index; /* Index to signal samples buffer   */

/* List of required sync position references */
extern int sync_refs[];

/* Signal/DSP samples buffer */
extern short line_buffer[];

/* Pixel buffer for display */
extern GdkPixbuf *image_pixbuf;

/* Pixbuf rowstride and num of channels */
extern gint
  rowstride,
  n_channels;

extern GtkWidget
  *main_window,   /* xwxapt's top window   */
  *text_scroller, /* Text view scroller    */
  *level_pbar,    /* Signal level prog. bar */
  *sync_pbar,     /* Sync level prog. bar  */
  *status_table,  /* Status widgets' table */
  *sync_icon,     /* Sync status indicator */
  *apt_image;     /* Image to be displayed */

extern GtkBuilder
  *timer_dialog_builder,
  *startstop_builder,
  *main_window_builder,
  *popup_menu_builder;

/* Text buffer for text view */
extern GtkTextBuffer *text_buffer;

/* Pixel buffer for display */
extern GdkPixbuf *pixbuf;

/* Satellite type names */
extern char *sat_names[];

extern char
  samples_file[MAX_FILE_NAME], /* Samples file name */
  image_file[MAX_FILE_NAME];   /* Image files name  */

/* Pointer to samples file */
extern FILE *samples_fp;

/* Buffer for reading in Sound Card DSP data */
extern short *snd_buffer;
extern guint snd_buf_idx; /* Index for this buffer  */

extern int dsp_rate_err;  /* dsp sampling rate error*/

/* Common between callbacks.c and callback_func.c */
extern GtkWidget
  *quit_dialog,
  *error_dialog,
  *popup_menu,
  *filechooser,
  *startstop_timer,
  *timer_dialog;

/* Tag to wake-up timeout function */
extern guint cancel_timer_tag;

/* IFFT data buffer*/
extern int16_t
  *ifft_data,
  ifft_data_length;

/* Chebyshev filter data I/Q */
extern filter_data_t filter_data_i;
extern filter_data_t filter_data_q;

/* Playback control semaphore */
extern sem_t pback_semaphore;

#endif

