/* bdmg.c  1989 December 11 [gh]
+-----------------------------------------------------------------------------
| Abstract:
|    Functions that compensate some of the braindamage in various DUCOS.
|
| Authorship:
|    Copyright (c) 1987-1995 Gisle Hannemyr.
|    This program is free software;  you can redistribute it and/or modify
|    it under the terms of the GNU General Public License, as published by
|    the Free Software Foundation. See the file "copying.txt" for details.
|
|    If you intend to distribute changed versions of this module, please add
|    a comment below describing what you have changed/added and why, and email
|    the file to me.  I maintain the module, and shall appreciate copies of
|    bug fixes and improved versions.
|    My email address is: <gisle@hannemyr.no>.
|
| Access programs:
|    int stricmp()		   -- case insenitive compare
|    int rename()		   -- rename file
|    struct DIRLIST *expwildcard() -- ersatz shell wildcard expansion
|    void dispwildcard()	   -- dispose list created by expwildcard
|
| History:
|    1995-08-10 [gh] Added expwildcard based upon _findfirst, etc.
|    1989-12-11 [gh] Started
+---------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include "pep.h"
#include "bdmg.h"
#include <string.h>
#ifdef __MSDOS__
#include <dos.h>
#include <io.h>
#endif

/*---( types )--------------------------------------------------------------*/

#ifdef __MSDOS__
struct DTA {
   char bogus[21];
   char attri;
   int  ftime;
   int  fdate;
   int  fsize[2];
   char fname[64];
}; /* DTA */
#endif


/*---( braindamage compensation )-------------------------------------------*/

#ifdef STRICMP
int stricmp(char *ss, char *tt)
{
   while (*ss && (tolower(*ss) == tolower(*tt))) { ss++; tt++; }
   return(tolower(*ss) - tolower(*tt));
} /* stricmp */
#endif


#ifdef SYSV2
int rename(char *from, char *to)
{
   (void)unlink(to);
   if (link(from,to)) return(-1);
   return(unlink(from));
} /* rename */
#endif


#ifdef VMSV1
int rename(char *from, char *to)
{
  struct dsc$descriptor_s From={strlen(from),
				  DSC$K_DTYPE_T,DSC$K_CLASS_S,from};
  struct dsc$descriptor_s To={strlen(to),
				  DSC$K_DTYPE_T,DSC$K_CLASS_S,to};

  if (LIB$RENAME_FILE(&From, &To) == SS$_NORMAL) return(0);
  return(-1);
} /* rename */
#endif


#ifdef __MSDOS__
#ifdef FINDFIRST
/*
| Abs: Return list of malloc'ed filenames matching ambigious input list.
| Ret: Pointer to alloced list, or 0 if none found.
| Imp: System dependent: MS-C ver. 5 and beyond
*/
struct DIRLIST *expwildcard(char **ambig)
{
    struct DIRLIST *first, *last, *prev;
    char *endpath;
    int   lenpath, mask;
    struct _finddata_t fdata;
    long hfile;

    if (!*ambig) return(NULL);      /* Doing stdin */
    first = NULL;

    while (*ambig) {
        endpath = strrchr(*ambig,DIRCHAR);
        if (endpath) {
            endpath++;  /* Behind "\" */
            lenpath = (unsigned int)endpath - (unsigned int)*ambig;
	} else lenpath = 0;

        hfile = _findfirst(*ambig, &fdata);
        if (hfile == -1L) continue;
        else {
	    do {
		mask = fdata.attrib & _A_SUBDIR;
		if (!mask) {
		    if ((last = (struct DIRLIST *)malloc(sizeof(struct DIRLIST)))
			&& (last->fnam = (char *)malloc(strlen(fdata.name)+lenpath+1))) {
			if (!first) first = last; else prev->next = last;
			strncpy(last->fnam,*ambig,lenpath);
			last->fnam[lenpath] = '\0';
			strcat(last->fnam,fdata.name);
			last->next = NULL;
			prev = last;
		    } else mess(5); /* No more room */
		} /* if */
	    } while (!_findnext(hfile, &fdata));
	    _findclose(hfile);
	} /* if (none found) continue; else process; */
	ambig++;
    } /* while */
    return(first);
}  /* expwildcard */
#else
/*
| Abs: Return list of malloc'ed filenames matching ambigious input list.
| Ret: Pointer to alloced list, or 0 if none found.
| Imp: System dependent: MS-DOS 2.0, 3.2.
*/
struct DIRLIST *expwildcard(char **ambig)
{
   union  REGS  ireg;
   union  REGS  oreg;
   struct SREGS sreg;
   struct DTA   dta;

   char name[64];
   char *endpath;
   int   lenpath;
   struct DIRLIST *first, *last, *prev;

   if (!*ambig) return(NULL);      /* Doing stdin */

   ireg.h.ah = SETDTA;
   ireg.x.dx = (int)&dta;
   intdos(&ireg,&oreg);
   first = NULL;

   while (*ambig) {
      endpath = strrchr(*ambig,DIRCHAR);
      if (endpath) {
         endpath++;              /* Behind "\"                */
         lenpath = (unsigned int)endpath - (unsigned int)*ambig;
      } else lenpath = 0;
      ireg.h.ah = GETFRST;
      ireg.x.cx = _A_NORMAL;     /* Look up all normal files. */
      ireg.x.dx = (int)*ambig;
      for (;;) {
         intdos(&ireg,&oreg);
         /* printf("AX = 0x%x   CF = 0x%x\n",oreg.x.ax,oreg.x.cflag); */
         if (oreg.x.cflag) break;
         if ((last = (struct DIRLIST *)malloc(sizeof(struct DIRLIST)))
           && (last->fnam = (char *)malloc(strlen(dta.fname)+lenpath+1))) {
            if (!first) first = last; else prev->next = last;
            strncpy(last->fnam,*ambig,lenpath);
            last->fnam[lenpath] = '\0';
            strcat(last->fnam,dta.fname);
            last->next = NULL;
            prev = last;
            ireg.h.ah = GETNEXT;
         } else mess(5); /* No more room */
      } /* for */
      ambig++;
   } /* while */
   return(first);
}  /* expwildcard */
#endif

/*
| Abs: Dispose list of malloc'ed filenames.
*/
void dispwildcard(struct DIRLIST *first)
{
   struct DIRLIST *last, *prev;

   last = first;
   while (last)
   {
      prev = last;
      free(last->fnam);
      last = last->next;
      free(prev);
   }
} /* dispwildcard */
#endif

/* EOF */
