/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import java.text.MessageFormat;
import java.util.List;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.IDEUtil;
import net.miginfocom.layout.UnitValue;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ModelMessages;

public final class MigColumnInfo
extends MigDimensionInfo {
    public static final Alignment[] ALIGNMENTS_TO_SET = new Alignment[]{Alignment.DEFAULT, Alignment.LEFT, Alignment.CENTER, Alignment.RIGHT, Alignment.FILL, Alignment.LEADING, Alignment.TRAILING};

    public MigColumnInfo(MigLayoutInfo layout) {
        super(layout, true);
    }

    @Override
    public void delete() throws Exception {
        this.m_layout.deleteColumn(this.getIndex());
    }

    @Override
    public List<? extends MigDimensionInfo> getSiblings() {
        return this.m_layout.getColumns();
    }

    @Override
    protected DimConstraint fetchConstraint() {
        AC colSpecs;
        int index = this.getIndex();
        if (index < (colSpecs = (AC)ReflectionUtils.getFieldObject((Object)this.m_layout.getObject(), (String)"colSpecs")).getCount()) {
            return colSpecs.getConstaints()[index];
        }
        return this.createDefaultConstraint();
    }

    @Override
    protected DimConstraint createDefaultConstraint() {
        return ConstraintParser.parseColumnConstraints((String)"[]").getConstaints()[0];
    }

    public Alignment getAlignment(boolean resolveDefault) {
        return MigColumnInfo.getAlignment(this.m_constraint, true, resolveDefault);
    }

    public void setAlignment(Alignment alignment) {
        MigColumnInfo.setAlignment(this.m_constraint, alignment, true);
    }

    static Alignment getAlignment(DimConstraint constraint, boolean forColumn, boolean resolveDefault) {
        UnitValue alignment;
        if (forColumn && constraint.isFill()) {
            return Alignment.FILL;
        }
        if (!forColumn && constraint.getGrow() != null) {
            return Alignment.FILL;
        }
        UnitValue unitValue = alignment = resolveDefault ? constraint.getAlignOrDefault(true) : constraint.getAlign();
        if (alignment == null) {
            return Alignment.DEFAULT;
        }
        if (alignment == IDEUtil.LEFT) {
            return Alignment.LEFT;
        }
        if (alignment == IDEUtil.CENTER) {
            return Alignment.CENTER;
        }
        if (alignment == IDEUtil.RIGHT) {
            return Alignment.RIGHT;
        }
        if (alignment == IDEUtil.LEADING) {
            return Alignment.LEADING;
        }
        if (alignment == IDEUtil.TRAILING) {
            return Alignment.TRAILING;
        }
        return Alignment.UNKNOWN;
    }

    static void setAlignment(DimConstraint constraint, Alignment alignment, boolean forColumn) {
        UnitValue alignmentValue;
        Assert.isNotNull((Object)((Object)alignment));
        if (alignment == Alignment.DEFAULT) {
            constraint.setAlign(null);
            if (forColumn) {
                constraint.setFill(false);
            } else {
                constraint.setGrow(null);
            }
            return;
        }
        if (alignment == Alignment.FILL) {
            if (forColumn) {
                constraint.setFill(true);
            } else {
                constraint.setGrow(Float.valueOf(100.0f));
            }
            constraint.setAlign(null);
            return;
        }
        switch (alignment) {
            case LEFT: {
                alignmentValue = IDEUtil.LEFT;
                break;
            }
            case CENTER: {
                alignmentValue = IDEUtil.CENTER;
                break;
            }
            case RIGHT: {
                alignmentValue = IDEUtil.RIGHT;
                break;
            }
            case LEADING: {
                alignmentValue = IDEUtil.LEADING;
                break;
            }
            case TRAILING: {
                alignmentValue = IDEUtil.TRAILING;
                break;
            }
            default: {
                throw new IllegalArgumentException(MessageFormat.format(ModelMessages.MigColumnInfo_canNotSetAlignment, new Object[]{alignment}));
            }
        }
        constraint.setAlign(alignmentValue);
        if (!forColumn) {
            constraint.setGrow(null);
        } else {
            constraint.setFill(false);
        }
    }

    public static enum Alignment {
        UNKNOWN,
        DEFAULT,
        LEFT,
        CENTER,
        RIGHT,
        FILL,
        LEADING,
        TRAILING;


        public Image getSmallImage() {
            String pattern = "alignment/h/small/{0}.gif";
            String path = MessageFormat.format(pattern, this.name().toLowerCase());
            return Activator.getImage(path);
        }

        public ImageDescriptor getMenuImage() {
            String pattern = "alignment/h/menu/{0}.gif";
            String path = MessageFormat.format(pattern, this.name().toLowerCase());
            return Activator.getImageDescriptor(path);
        }

        public String getText() {
            return StringUtils.capitalize((String)this.name().toLowerCase());
        }
    }
}

