/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.internal;

import java.io.File;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.wst.server.preview.internal.ContextResourceHandler;
import org.eclipse.wst.server.preview.internal.Module;
import org.eclipse.wst.server.preview.internal.ServerConfig;
import org.eclipse.wst.server.preview.internal.WTPDefaultHandler;
import org.eclipse.wst.server.preview.internal.WTPErrorHandler;

public class PreviewStarter {
    protected String configPath;
    protected Server server;

    public PreviewStarter(String configPath) {
        this.configPath = configPath;
    }

    public static void main(String[] args) {
        PreviewStarter app = new PreviewStarter(args[0]);
        app.run();
    }

    protected void run() {
        try {
            System.setProperty("org.mortbay.log.class", "org.eclipse.wst.server.preview.internal.WTPLogger");
            ServerConfig config = new ServerConfig(this.configPath);
            System.out.println("Starting preview server on port " + config.getPort());
            System.out.println();
            Module[] m = config.getModules();
            int size = m.length;
            if (size > 0) {
                System.out.println("Modules:");
                Module[] moduleArray = m;
                int n = m.length;
                int n2 = 0;
                while (n2 < n) {
                    Module mm = moduleArray[n2];
                    System.out.println("  " + mm.getName() + " (" + mm.getContext() + ")");
                    ++n2;
                }
                System.out.println();
            }
            this.server = new Server(config.getPort());
            this.server.setStopAtShutdown(true);
            WTPErrorHandler errorHandler = new WTPErrorHandler();
            HandlerList handlers = new HandlerList();
            Module[] moduleArray = m;
            int n = m.length;
            int n3 = 0;
            while (n3 < n) {
                Module module = moduleArray[n3];
                if (module.isStaticWeb()) {
                    ContextResourceHandler resourceHandler = new ContextResourceHandler();
                    resourceHandler.setResourceBase(module.getPath());
                    resourceHandler.setContext(module.getContext());
                    handlers.addHandler((Handler)resourceHandler);
                } else {
                    WebAppContext wac = new WebAppContext();
                    wac.setContextPath(module.getContext());
                    wac.setWar(module.getPath());
                    wac.setErrorHandler((ErrorHandler)errorHandler);
                    handlers.addHandler((Handler)wac);
                }
                ++n3;
            }
            handlers.addHandler((Handler)new WTPDefaultHandler(config.getPort(), m));
            this.server.setHandler((Handler)handlers);
            try {
                this.server.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            System.out.println("Stop!");
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            File[] fileArray = files = directory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    PreviewStarter.deleteDirectory(file);
                } else {
                    file.delete();
                }
                ++n2;
            }
        }
        return directory.delete();
    }
}

