/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "../../languageservice/parser/yaml-documents", "../../languageservice/utils/schemaUrls", "../../requestTypes"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.JSONSchemaSelection = void 0;
    const yaml_documents_1 = require("../../languageservice/parser/yaml-documents");
    const schemaUrls_1 = require("../../languageservice/utils/schemaUrls");
    const requestTypes_1 = require("../../requestTypes");
    class JSONSchemaSelection {
        constructor(schemaService, yamlSettings, connection) {
            this.schemaService = schemaService;
            this.yamlSettings = yamlSettings;
            this.connection = connection;
            this.connection.onRequest(requestTypes_1.SchemaSelectionRequests.getSchema, (fileUri) => {
                return this.getSchemas(fileUri);
            });
            this.connection.onRequest(requestTypes_1.SchemaSelectionRequests.getAllSchemas, (fileUri) => {
                return this.getAllSchemas(fileUri);
            });
        }
        getSchemas(docUri) {
            return __awaiter(this, void 0, void 0, function* () {
                const schemas = yield this.getSchemasForFile(docUri);
                const result = Array.from(schemas).map((val) => {
                    return {
                        name: val[1].title,
                        uri: val[0],
                        description: val[1].description,
                        versions: val[1].versions,
                    };
                });
                return result;
            });
        }
        getSchemasForFile(docUri) {
            return __awaiter(this, void 0, void 0, function* () {
                const document = this.yamlSettings.documents.get(docUri);
                const schemas = new Map();
                if (!document) {
                    return schemas;
                }
                const yamlDoc = yaml_documents_1.yamlDocumentsCache.getYamlDocument(document);
                for (const currentYAMLDoc of yamlDoc.documents) {
                    const schema = yield this.schemaService.getSchemaForResource(document.uri, currentYAMLDoc);
                    if (schema === null || schema === void 0 ? void 0 : schema.schema) {
                        const schemaUrls = schemaUrls_1.getSchemaUrls(schema === null || schema === void 0 ? void 0 : schema.schema);
                        if (schemaUrls.size === 0) {
                            continue;
                        }
                        for (const urlToSchema of schemaUrls) {
                            schemas.set(urlToSchema[0], urlToSchema[1]);
                        }
                    }
                }
                return schemas;
            });
        }
        getAllSchemas(docUri) {
            return __awaiter(this, void 0, void 0, function* () {
                const fileSchemas = yield this.getSchemasForFile(docUri);
                const fileSchemasHandle = Array.from(fileSchemas.entries()).map((val) => {
                    return {
                        uri: val[0],
                        fromStore: false,
                        usedForCurrentFile: true,
                        name: val[1].title,
                        description: val[1].description,
                        versions: val[1].versions,
                    };
                });
                const result = [];
                let allSchemas = this.schemaService.getAllSchemas();
                allSchemas = allSchemas.filter((val) => !fileSchemas.has(val.uri));
                result.push(...fileSchemasHandle);
                result.push(...allSchemas);
                return result;
            });
        }
    }
    exports.JSONSchemaSelection = JSONSchemaSelection;
});
//# sourceMappingURL=schemaSelectionHandlers.js.map